/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.km.ejb.svc.idxsearch.index;

import com.sap.caf.km.ejb.svc.idxsearch.common.IIndex;
import com.sap.caf.km.ejb.svc.idxsearch.common.IIndexSearchIndexSvc;
import com.sap.caf.km.ejb.svc.idxsearch.common.IIndexSearchResourceKeys;
import com.sap.caf.km.ejb.svc.idxsearch.common.IndexException;
import com.sap.caf.km.ejb.svc.idxsearch.index.KMIndexStub;
import com.sap.caf.km.ejb.svc.idxsearch.kmproxy.IKMIndexSearchSvcProxy;
import com.sap.caf.km.ejb.svc.idxsearch.util.ConfigException;
import java.util.ArrayList;
import java.util.Date;

public class KMIndexSearchIndexSvcStub
implements IKMIndexSearchSvcProxy,
IIndexSearchIndexSvc,
IIndexSearchResourceKeys {
    protected static ArrayList m_indexes = new ArrayList();
    protected static ArrayList m_GlobalIndexes = new ArrayList();

    public boolean existsIndex(String indexId) throws IndexException {
        try {
            KMIndexStub item = null;
            for (int i = 0; i < m_indexes.size(); ++i) {
                item = (KMIndexStub)m_indexes.get(i);
                if (!indexId.equals(item.getName())) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new IndexException("ERR_IDX_CHECK", new Object[]{indexId}, (Throwable)e);
        }
    }

    public IIndex getIndex(String indexId) throws IndexException {
        try {
            KMIndexStub item = null;
            for (int i = 0; i < m_indexes.size(); ++i) {
                item = (KMIndexStub)m_indexes.get(i);
                if (!indexId.equals(item.getName())) continue;
                return item;
            }
            throw new IndexException("ERR_IDX_NOT_EXISTS", new Object[]{indexId});
        }
        catch (Exception e) {
            throw new IndexException("ERR_IDX_GET", new Object[]{indexId}, (Throwable)e);
        }
    }

    public void clearIndex(String indexId) throws IndexException {
    }

    public IIndex[] getAllIndexes() throws IndexException {
        try {
            return m_indexes.toArray(new IIndex[m_indexes.size()]);
        }
        catch (Exception e) {
            throw new IndexException("ERR_IDX_GET_ALL", null, (Throwable)e);
        }
    }

    public void createRelatedIndex(String indexId, String mofId) throws IndexException {
    }

    public void createFolderIndex(String indexId, String[] folderRids) throws IndexException {
    }

    public void deleteIndex(String indexId) throws IndexException {
        try {
            m_indexes.remove((KMIndexStub)this.getIndex(indexId));
        }
        catch (Exception e) {
            throw new IndexException("ERR_IDX_DELETE", new Object[]{indexId}, (Throwable)e);
        }
    }

    public void indexObjects(String indexId, String[] objectsRids) throws IndexException {
    }

    public void deindexObjects(String indexId, String[] objectsRids) throws IndexException {
        try {
            this.reindex(indexId);
        }
        catch (Exception e) {
            throw new IndexException("ERR_IDX_OBJ_DELETE", new Object[]{indexId}, (Throwable)e);
        }
    }

    public void reindex(String indexId) throws IndexException {
        try {
            KMIndexStub index = (KMIndexStub)this.getIndex(indexId);
            index.setCreationDate(new Date());
        }
        catch (Exception e) {
            throw new IndexException("ERR_IDX_REINDEX", new Object[]{indexId}, (Throwable)e);
        }
    }

    public void reindexRelatedIndex(String indexId, String mofId) throws IndexException {
        try {
            KMIndexStub index = (KMIndexStub)this.getIndex(indexId);
            index.setCreationDate(new Date());
        }
        catch (Exception e) {
            throw new IndexException("ERR_IDX_REINDEX", new Object[]{indexId}, (Throwable)e);
        }
    }

    public void reindexRelatedTasks(String indexId) throws IndexException {
        try {
            KMIndexStub index = (KMIndexStub)this.getIndex(indexId);
            index.setCreationDate(new Date());
        }
        catch (Exception e) {
            throw new IndexException("ERR_IDX_REINDEX", new Object[]{indexId}, (Throwable)e);
        }
    }

    public void reindexRelatedDocuments(String indexId) throws IndexException {
        try {
            KMIndexStub index = (KMIndexStub)this.getIndex(indexId);
            index.setCreationDate(new Date());
        }
        catch (Exception e) {
            throw new IndexException("ERR_IDX_REINDEX", new Object[]{indexId}, (Throwable)e);
        }
    }

    public void deltaReindex(String indexId) throws IndexException {
        try {
            this.reindex(indexId);
        }
        catch (Exception e) {
            throw new IndexException("ERR_IDX_REINDEX", new Object[]{indexId}, (Throwable)e);
        }
    }

    public IIndex[] getGlobalIndexesKMBO(String[] kmtypes) {
        return m_GlobalIndexes.toArray(new IIndex[2]);
    }

    public void setLookupName(String sUrl) throws ConfigException {
    }

    static {
        m_indexes.add(new KMIndexStub("Global-Task", new Date(), "", 3, 0));
        m_indexes.add(new KMIndexStub("Free index 1", new Date(), "", 3, 0));
        m_indexes.add(new KMIndexStub("Free index 2", new Date(), "", 3, 0));
        m_indexes.add(new KMIndexStub("Free index 3", new Date(), "", 3, 0));
        m_indexes.add(new KMIndexStub("Free index 4", new Date(), "", 3, 0));
    }
}

