/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.km.ejb.svc.idxsearch.common;

import com.sap.caf.km.ejb.svc.idxsearch.common.IClassifyFolder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ClassifyFolder
implements IClassifyFolder,
Serializable {
    protected String m_sName;
    protected String m_sDescr;
    protected String m_sRID;
    protected Date m_dCreated;
    protected List m_folderPath;
    protected static int INDEX_ID_POSITION = 1;
    protected static int TAXONOMY_NAME_POSITION = 2;
    protected static int REPOSITORY_PREFIX_POSITION = 0;

    public ClassifyFolder() {
    }

    public ClassifyFolder(String name, Date created) {
        this.m_sName = name;
        this.m_dCreated = created;
    }

    public ClassifyFolder(String sRid) {
        this.setRID(sRid);
    }

    public String getName() {
        if (this.m_sName == null && this.m_folderPath != null && this.m_folderPath.size() > TAXONOMY_NAME_POSITION) {
            this.m_sName = (String)this.m_folderPath.get(this.m_folderPath.size() - 1);
        }
        return this.m_sName;
    }

    public void setName(String name) {
        this.m_sName = name;
    }

    public String getRID() {
        return this.m_sRID;
    }

    public void setRID(String sRid) {
        this.m_sRID = sRid;
        this.m_folderPath = ClassifyFolder.split(sRid, '/');
    }

    public Date getCreationDate() {
        return this.m_dCreated;
    }

    public void setCreationDate(Date date) {
        this.m_dCreated = date;
    }

    public String getIndexId() {
        if (this.m_folderPath != null && this.m_folderPath.size() > INDEX_ID_POSITION) {
            return (String)this.m_folderPath.get(INDEX_ID_POSITION);
        }
        return null;
    }

    public static List split(String path, char separator) {
        int i;
        if (path == null || path.length() == 0) {
            return null;
        }
        int length = path.length();
        ArrayList<String> words = new ArrayList<String>();
        int last = i = path.charAt(0) == separator ? 1 : 0;
        while (i < length) {
            if (path.charAt(i) == separator) {
                words.add(path.substring(last, i));
                last = i + 1;
            }
            ++i;
        }
        if (last < i) {
            words.add(path.substring(last));
        }
        return words;
    }
}

