/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.km.ejb.svc.idxsearch.bo;

import com.sap.caf.km.ejb.svc.idxsearch.bo.BOAccessException;
import com.sap.caf.km.ejb.svc.idxsearch.bo.IBOAccessor;
import com.sap.caf.km.ejb.svc.idxsearch.util.ConfigException;
import com.sap.caf.km.ejb.svc.idxsearch.util.ConfigProps;
import com.sap.caf.km.ejb.svc.idxsearch.util.IConfigProps;
import com.sap.caf.metamodel.Application;
import com.sap.caf.metamodel.BaseObject;
import com.sap.caf.metamodel.BusinessEntityInterface;
import com.sap.caf.metamodel.DataObject;
import com.sap.caf.rt.exception.DataAccessException;
import com.sap.caf.rt.metamodel.MetaModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BOAccessor
implements IBOAccessor,
IConfigProps {
    protected static BOAccessor s_accessor;
    protected ConfigProps m_props;
    protected MetaModel m_model;
    protected Map m_bo;
    protected Map m_excludedBO;
    protected String[] m_names;
    protected String[] m_KMNames;
    protected List m_CAFNames;
    protected Collection m_classifables = null;
    protected Collection m_searchables = null;

    protected BOAccessor(ConfigProps props) {
        this.m_props = props;
    }

    public static synchronized BOAccessor getInstance() throws ConfigException, BOAccessException {
        if (s_accessor == null) {
            MetaModel mm;
            s_accessor = new BOAccessor(ConfigProps.getInstance());
            try {
                mm = new MetaModel();
            }
            catch (DataAccessException e) {
                throw new ConfigException("Could not get MetaModel, cause:[" + e.getMessage() + "]");
            }
            s_accessor.setMetaModel(mm);
            s_accessor.init();
        }
        return s_accessor;
    }

    private void setMetaModel(MetaModel model) {
        this.m_model = model;
    }

    public String[] getBONames() throws BOAccessException {
        return this.m_names;
    }

    public boolean isBOKM(String BOName) throws BOAccessException {
        return this.isBOKMDocument(BOName) || this.isBOKMTask(BOName);
    }

    public boolean isBOCAF(String BOName) throws BOAccessException {
        return !this.isBOKM(BOName);
    }

    public boolean isBOKMDocument(String BOName) throws BOAccessException {
        return this.isBOTypeOf("BO_KM_DOCUMENT_NAME", BOName);
    }

    public boolean isBOKMTask(String BOName) throws BOAccessException {
        return this.isBOTypeOf("BO_KM_TASK_NAME", BOName);
    }

    protected boolean isBOTypeOf(String propName, String BOName) throws BOAccessException {
        try {
            return this.m_props.getNotNullProperty(propName).equals(BOName);
        }
        catch (ConfigException e) {
            throw new BOAccessException("Could not compare BO Names:[" + propName + "," + BOName + "], cause:[" + e.toString() + "]");
        }
    }

    public String getGUID(String BOName) throws BOAccessException {
        try {
            BaseObject bo = (BaseObject)this.m_bo.get(BOName);
            return bo.getObjectId();
        }
        catch (Throwable e) {
            throw new BOAccessException("Could not get GUID for BO:[" + BOName + "], cause:[" + e.toString() + "]");
        }
    }

    public Collection getClassifables() throws BOAccessException {
        if (this.m_classifables == null) {
            ArrayList<String> classifables = new ArrayList<String>();
            int ln = this.m_names.length;
            for (int i = 0; i < ln; ++i) {
                DataObject bo = (DataObject)this.m_bo.get(this.m_names[i]);
                Boolean res = bo.getBusinessEntityInterface().isClassifiable();
                if (res == null || !res.booleanValue()) continue;
                classifables.add(this.m_names[i]);
            }
            this.m_classifables = classifables;
        }
        return this.m_classifables;
    }

    public Collection getSearchAndRetrieval() throws BOAccessException {
        if (this.m_searchables == null) {
            ArrayList<String> searchables = new ArrayList<String>();
            int ln = this.m_names.length;
            for (int i = 0; i < ln; ++i) {
                DataObject bo = (DataObject)this.m_bo.get(this.m_names[i]);
                Boolean res = bo.getBusinessEntityInterface().isSearchAndRetrieval();
                if (res == null || !res.booleanValue()) continue;
                searchables.add(this.m_names[i]);
            }
            this.m_searchables = searchables;
        }
        return this.m_searchables;
    }

    public String[] getKMBONames() throws BOAccessException {
        try {
            return this.m_KMNames;
        }
        catch (Throwable e) {
            throw new BOAccessException("Could not get KMBO names");
        }
    }

    public Collection getCAFBONames() {
        return this.m_CAFNames;
    }

    public String getKMBODocumentName() throws BOAccessException {
        return this.getKMBOName("BO_KM_DOCUMENT_NAME");
    }

    public String getKMBOTaskName() throws BOAccessException {
        return this.getKMBOName("BO_KM_TASK_NAME");
    }

    protected String getKMBOName(String propName) throws BOAccessException {
        try {
            String sName = this.m_props.getNotNullProperty(propName);
            return sName;
        }
        catch (ConfigException e) {
            throw new BOAccessException("Could not get BO Name, cause:[" + e.toString() + "]");
        }
    }

    protected void init() throws BOAccessException {
        try {
            String name;
            this.parseExcludedBOList();
            Collection coll = this.m_model.getAllBusinessEntityInterfaces();
            this.m_bo = new HashMap();
            ArrayList<String> names = new ArrayList<String>();
            int i = 0;
            Iterator iter = coll.iterator();
            while (iter.hasNext()) {
                BusinessEntityInterface service = (BusinessEntityInterface)iter.next();
                DataObject obj = service.getBusinessEntity();
                Application app = service.getApplication();
                if (app != null && this.isObjectKMExposed(service)) {
                    name = app.getProviderName() + "/" + app.getObjectName() + "/" + obj.getObjectName();
                    if (this.isBOExcluded(name)) {
                        this.m_excludedBO.put(name, obj);
                    } else {
                        names.add(name);
                        this.m_bo.put(name, obj);
                    }
                }
                ++i;
            }
            this.m_names = names.toArray(new String[names.size()]);
            this.m_KMNames = new String[2];
            this.m_KMNames[0] = this.m_props.getNotNullProperty("BO_KM_DOCUMENT_NAME");
            this.m_KMNames[1] = this.m_props.getNotNullProperty("BO_KM_TASK_NAME");
            this.m_CAFNames = new ArrayList();
            for (i = 0; i < this.m_names.length; ++i) {
                name = this.m_names[i];
                if (!this.isBOCAF(name)) continue;
                this.m_CAFNames.add(name);
            }
        }
        catch (Exception e) {
            throw new BOAccessException("Could not get BO types, cause:[" + e + "]");
        }
    }

    protected boolean isObjectKMExposed(BusinessEntityInterface obj) {
        int type = obj.getBackend();
        return type == 0 || type == 2;
    }

    protected boolean isBOExcluded(String BOName) {
        return this.m_excludedBO.get(BOName) != null;
    }

    protected void parseExcludedBOList() throws BOAccessException {
        this.m_excludedBO = new HashMap();
        try {
            String list = this.m_props.getNotNullProperty("BO_CAF_IDX_EXCLUDED_LIST");
            if (list != null && (list = list.trim()).length() > 0) {
                int j;
                int i = 0;
                int len = list.length();
                do {
                    String name;
                    if ((j = list.indexOf(44, i)) == -1) {
                        j = len;
                    }
                    if ((name = list.substring(i, j)) == null || (name = name.trim()).length() <= 0) continue;
                    this.m_excludedBO.put(name, name);
                } while ((i = j + 1) < len);
            }
        }
        catch (Throwable e) {
            throw new BOAccessException("Could not parse parameter:[BO_CAF_IDX_EXCLUDED_LIST], cause:[" + e + "]");
        }
    }
}

