/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.km.ejb.data.document;

import com.sap.caf.km.da.KMDataAccessBean;
import com.sap.caf.km.da.KMDataAccessException;
import com.sap.caf.km.da.KMDataAccessHelper;
import com.sap.caf.km.da.RidUtils;
import com.sap.caf.km.ejb.data.document.DocumentProxyEJBLocal;
import com.sap.caf.km.ejb.data.folder.FolderProxyEJBLocal;
import com.sap.caf.km.ejb.data.util.IKMNodeExceptionResourceKeys;
import com.sap.caf.km.ejb.data.util.INodeHeader;
import com.sap.caf.km.ejb.data.util.KMNodeException;
import com.sap.caf.km.ejb.data.util.NodeContent;
import com.sap.caf.km.ejb.data.util.NodeHeader;
import com.sap.caf.km.ejb.data.util.ProxyHelper;
import com.sap.caf.km.proxies.data.kmnode.KMNodeService;
import com.sap.caf.km.proxies.data.kmnode.KMNodeServiceService;
import com.sap.caf.km.proxies.data.kmnode.types.KMNodeAttribute;
import com.sap.caf.km.proxies.data.kmnode.types.KMNodeHeader;
import com.sap.caf.km.proxies.data.kmnode.types.KMNodePermission;
import com.sap.caf.km.proxies.data.kmnode.types.KMUserContext;
import com.sap.caf.km.proxies.data.kmnodecontent.NodeContentSvc;
import com.sap.caf.km.proxies.data.kmnodecontent.NodeContentSvcViRpcEnc;
import com.sap.caf.km.proxies.data.kmnodecontent.types.NodeContentStruct;
import com.sap.caf.km.proxies.svc.kmbasesvc.KMBasesvc;
import com.sap.caf.km.proxies.svc.kmbasesvc.KMBasesvcService;
import com.sap.caf.km.proxies.svc.kmrelation.KMRelationSvc;
import com.sap.caf.km.proxies.svc.kmrelation.KMRelationSvcService;
import com.sap.caf.rt.bol.context.CAFProperties;
import com.sap.caf.rt.exception.DataAccessException;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.security.api.IUser;
import com.sap.security.api.IUserFactory;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.tc.logging.Location;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.ejb.CreateException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.rpc.ServiceException;

public class DocumentProxyEJBBean
extends KMDataAccessBean
implements IKMNodeExceptionResourceKeys {
    private static final String APPLICATION = (class$com$sap$caf$km$ejb$data$document$DocumentProxyEJBBean == null ? (class$com$sap$caf$km$ejb$data$document$DocumentProxyEJBBean = DocumentProxyEJBBean.class$("com.sap.caf.km.ejb.data.document.DocumentProxyEJBBean")) : class$com$sap$caf$km$ejb$data$document$DocumentProxyEJBBean).getName();
    private static final String jARMReqPrefix = "CAF:RT:oal:";
    private static final String JARM_REQUEST = "CAF:RT:oal:" + APPLICATION;
    private static final Location location = Location.getLocation((String)APPLICATION);
    private final String separator = "/";
    transient InitialContext JNDIcontext = null;
    transient KMNodeService WS = null;
    transient KMNodeServiceService WSService = null;
    transient KMRelationSvc WSRelation = null;
    transient KMRelationSvcService WSRelationService = null;
    transient NodeContentSvcViRpcEnc WSNodeContentSvc = null;
    transient KMBasesvcService WSBaseService = null;
    transient KMBasesvc WSBase = null;
    KMUserContext userContext = null;
    String userId = null;
    IUser user = null;
    transient IUserFactory userFactory = UMFactory.getUserFactory();
    private static final Map m_props = new HashMap();
    private static final String CAF_PROPS_CLASS = "CAF_PROPS_CLASS";
    private static final String KM_URL_PREVIEW = "KM_URL_PREVIEW";
    private static final String KM_URL_EDIT = "KM_URL_EDIT";
    private static final String KM_URL_PREVIEW_DEF_VAL = "http://km_host:km_port/irj/servlet/prt/portal/prtroot/com.sap.km.cm.docs";
    private static final String KM_URL_EDIT_DEF_VAL = "http://km_host:km_port/irj/servlet/prt/portal/prtroot/com.sap.km.cm.service?StartPage=RemoteEditingPage&Uri=";
    private static final String STR_DIVIDER = "/";
    static /* synthetic */ Class class$com$sap$caf$km$ejb$data$document$DocumentProxyEJBBean;
    static /* synthetic */ Class class$com$sap$caf$km$proxies$data$kmnode$KMNodeService;
    static /* synthetic */ Class class$com$sap$caf$km$proxies$svc$kmrelation$KMRelationSvc;
    static /* synthetic */ Class class$com$sap$caf$km$proxies$svc$kmbasesvc$KMBasesvc;
    static /* synthetic */ Class class$com$sap$caf$rt$bol$context$CAFProperties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ejbCreate() throws CreateException {
        block8: {
            String method = JARM_REQUEST + ":ejbCreate()";
            this.enter(method, null);
            try {
                if (this.JNDIcontext != null) break block8;
                try {
                    this.JNDIcontext = new InitialContext();
                    this.WSService = (KMNodeServiceService)this.JNDIcontext.lookup("wsclients/proxies/sap.com/caf~km.proxies/KMNodeJNDI");
                    this.WS = (KMNodeService)this.WSService.getLogicalPort(class$com$sap$caf$km$proxies$data$kmnode$KMNodeService == null ? (class$com$sap$caf$km$proxies$data$kmnode$KMNodeService = DocumentProxyEJBBean.class$("com.sap.caf.km.proxies.data.kmnode.KMNodeService")) : class$com$sap$caf$km$proxies$data$kmnode$KMNodeService);
                    String url = ProxyHelper.getActualUrl((String)this.WS._getProperty("javax.xml.rpc.service.endpoint.address"));
                    if (!url.equals(this.WS._getProperty("javax.xml.rpc.service.endpoint.address"))) {
                        this.WS._setProperty("javax.xml.rpc.service.endpoint.address", (Object)url);
                        String str = (String)this.WS._getProperty("javax.xml.rpc.service.endpoint.address");
                        CAFPublicLogger.LOC_CAF.infoT("Portal KMNodeService URL=" + str);
                    }
                    this.WSRelationService = (KMRelationSvcService)this.JNDIcontext.lookup("wsclients/proxies/sap.com/caf~km.proxies/KMRelationJNDI");
                    this.WSRelation = (KMRelationSvc)this.WSRelationService.getLogicalPort(class$com$sap$caf$km$proxies$svc$kmrelation$KMRelationSvc == null ? (class$com$sap$caf$km$proxies$svc$kmrelation$KMRelationSvc = DocumentProxyEJBBean.class$("com.sap.caf.km.proxies.svc.kmrelation.KMRelationSvc")) : class$com$sap$caf$km$proxies$svc$kmrelation$KMRelationSvc);
                    url = ProxyHelper.getActualUrl((String)this.WSRelation._getProperty("javax.xml.rpc.service.endpoint.address"));
                    if (!url.equals(this.WSRelation._getProperty("javax.xml.rpc.service.endpoint.address"))) {
                        this.WSRelation._setProperty("javax.xml.rpc.service.endpoint.address", (Object)url);
                    }
                    this.WSBaseService = (KMBasesvcService)this.JNDIcontext.lookup("wsclients/proxies/sap.com/caf~km.proxies/KMBasesvcJNDI");
                    this.WSBase = (KMBasesvc)this.WSBaseService.getLogicalPort(class$com$sap$caf$km$proxies$svc$kmbasesvc$KMBasesvc == null ? (class$com$sap$caf$km$proxies$svc$kmbasesvc$KMBasesvc = DocumentProxyEJBBean.class$("com.sap.caf.km.proxies.svc.kmbasesvc.KMBasesvc")) : class$com$sap$caf$km$proxies$svc$kmbasesvc$KMBasesvc);
                    url = ProxyHelper.getActualUrl((String)this.WSBase._getProperty("javax.xml.rpc.service.endpoint.address"));
                    if (!url.equals(this.WSBase._getProperty("javax.xml.rpc.service.endpoint.address"))) {
                        this.WSBase._setProperty("javax.xml.rpc.service.endpoint.address", (Object)url);
                    }
                }
                catch (Throwable e) {
                    KMNodeException nodeEx = new KMNodeException("CANTCREATEEJB", e);
                    this.log((KMDataAccessException)nodeEx, method, null);
                    throw new CreateException(nodeEx.getLocalizedMessage());
                }
            }
            finally {
                this.exit(method, null);
            }
        }
    }

    public void move(String sourceRid, String targetRid) throws KMNodeException {
        String method = JARM_REQUEST + ":move(String, String)";
        Object[] args = new Object[]{sourceRid, targetRid};
        this.enter(method, args);
        try {
            if (sourceRid == null || targetRid == null) {
                throw new KMNodeException("NULLINPUT");
            }
            KMUserContext userContext = this.getUserContext();
            this.WS.moveNode(userContext, sourceRid, targetRid);
        }
        catch (Throwable e) {
            KMNodeException nodeEx = new KMNodeException("CANTMOVENODE", args, e);
            this.log((KMDataAccessException)nodeEx, method, args);
            throw nodeEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public String copyToFolder(String srcResRid, String dstDirRid) throws KMNodeException {
        String method = JARM_REQUEST + ":moveToFolder(String, String)";
        Object[] args = new Object[]{srcResRid, dstDirRid};
        this.enter(method, args);
        try {
            if (srcResRid == null || dstDirRid == null) {
                throw new KMNodeException("NULLINPUT");
            }
            String string = this.WS.copyNodeToFolder(this.getUserContext(), srcResRid, dstDirRid);
            return string;
        }
        catch (Throwable e) {
            KMNodeException nodeEx = new KMNodeException("CANTMOVENODETOFOLDER", args, e);
            this.log((KMDataAccessException)nodeEx, method, args);
            throw nodeEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public void copy(String sourceRid, String targetRid) throws KMNodeException {
        String method = JARM_REQUEST + ":copy(String, String)";
        Object[] args = new Object[]{sourceRid, targetRid};
        this.enter(method, args);
        try {
            if (sourceRid == null || targetRid == null) {
                throw new KMNodeException("NULLINPUT");
            }
            KMUserContext userContext = this.getUserContext();
            this.WS.copyNode(userContext, sourceRid, targetRid);
        }
        catch (Throwable e) {
            KMNodeException nodeEx = new KMNodeException("CANTCOPYNODE", args, e);
            this.log((KMDataAccessException)nodeEx, method, args);
            throw nodeEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public void link(String sourceRid, String targetRid) throws KMNodeException {
        String method = JARM_REQUEST + ":link(String, String)";
        Object[] args = new Object[]{sourceRid, targetRid};
        this.enter(method, args);
        try {
            if (sourceRid == null || targetRid == null) {
                throw new KMNodeException("NULLINPUT");
            }
            KMUserContext userContext = this.getUserContext();
            this.WS.linkNode(userContext, sourceRid, targetRid);
        }
        catch (Throwable e) {
            KMNodeException nodeEx = new KMNodeException("CANTLINKNODE", args, e);
            this.log((KMDataAccessException)nodeEx, method, args);
            throw nodeEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public boolean exists(String documentRid) throws KMNodeException {
        String method = JARM_REQUEST + ":exists(String)";
        Object[] args = new Object[]{documentRid};
        this.enter(method, args);
        try {
            if (documentRid == null) {
                throw new KMNodeException("NULLINPUT");
            }
            boolean bl = this.WS.exists(this.getUserContext(), documentRid);
            return bl;
        }
        catch (Throwable e) {
            KMNodeException nodeEx = new KMNodeException("CANTCHECKEXIST", args, e);
            this.log((KMDataAccessException)nodeEx, method, args);
            throw nodeEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public void createDocumentHeader(String name, String parentRid, String displayName, String description, String link, Collection relations) throws KMNodeException {
        String method = JARM_REQUEST + ":createDocumentHeader(String, String, String, String, String, Collection)";
        Object[] args = new Object[]{name, parentRid, displayName, description, link, relations};
        this.enter(method, args);
        try {
            if (parentRid == null || name == null) {
                throw new KMNodeException("NULLINPUT");
            }
            String userId = this.getContextUserId();
            KMUserContext userContext = this.getUserContext();
            if (displayName == null) {
                displayName = name;
            }
            if (description == null) {
                description = "";
            }
            KMNodeHeader header = new KMNodeHeader();
            boolean isFolder = false;
            KMNodeAttribute[] attributes = this.setAttributesCreateHeader(userId, displayName, description);
            KMNodePermission[] permissions = this.setPermissions(userId);
            String[] aRelations = relations != null ? relations.toArray(new String[relations.size()]) : new String[]{};
            this.WS.createNode(userContext, parentRid, name, isFolder, link, attributes, permissions, aRelations);
        }
        catch (Exception e) {
            KMNodeException nodeEx = new KMNodeException("CANTCREATEDOCHEADER", args, (Throwable)e);
            this.log((KMDataAccessException)nodeEx, method, args);
            throw nodeEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public NodeHeader readDocumentHeader(String name, String parentRid) throws KMNodeException {
        String method = JARM_REQUEST + ":readDocumentHeader(String, String)";
        Object[] args = new Object[]{name, parentRid};
        this.enter(method, args);
        try {
            if (parentRid == null || name == null) {
                throw new KMNodeException("NULLINPUT");
            }
            String Rid = this.getRid(name, parentRid);
            NodeHeader nodeHeader = this.createNodeHeader(this.WS.readNodeHeader(this.getUserContext(), Rid, true, true, true));
            return nodeHeader;
        }
        catch (Throwable e) {
            KMNodeException nodeEx = new KMNodeException("CANTREADDOCHEADER", args, e);
            this.log((KMDataAccessException)nodeEx, method, args);
            throw nodeEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public NodeHeader[] readDocumentHeaders(String[] rids) throws KMNodeException {
        String method = JARM_REQUEST + ":readDocumentHeaders(String[])";
        Object[] args = new Object[]{rids};
        this.enter(method, args);
        try {
            if (rids == null || rids.length == 0) {
                NodeHeader[] nodeHeaderArray = null;
                return nodeHeaderArray;
            }
            KMUserContext userContext = this.getUserContext();
            KMNodeHeader[] kmHeaders = this.WS.readNodeHeader(userContext, rids, true, true, true);
            NodeHeader[] cafHeaders = new NodeHeader[kmHeaders.length];
            for (int i = kmHeaders.length - 1; i >= 0; --i) {
                cafHeaders[i] = kmHeaders[i] != null ? this.createNodeHeader(kmHeaders[i]) : null;
            }
            NodeHeader[] nodeHeaderArray = cafHeaders;
            return nodeHeaderArray;
        }
        catch (Exception e) {
            KMNodeException nodeEx = new KMNodeException("CANTREADDOCHEADERBUNCH", args, (Throwable)e);
            this.log((KMDataAccessException)nodeEx, method, args);
            throw nodeEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    private NodeHeader createNodeHeader(KMNodeHeader kmHeader) throws KMNodeException {
        NodeHeader cafHeader = (NodeHeader)this.setExplicitAttributes(kmHeader);
        String[] relations = kmHeader.getRelations();
        cafHeader.setRelationRids(Arrays.asList(relations));
        return cafHeader;
    }

    public Collection getDocumentRelations(String docRid) throws KMNodeException {
        String method = JARM_REQUEST + ":getDocumentRelations(String)";
        Object[] args = new Object[]{docRid};
        this.enter(method, args);
        try {
            String[] resultRelations = this.WSRelation.getRelatedRIDs(docRid);
            List<String> list = Arrays.asList(resultRelations);
            return list;
        }
        catch (Throwable e) {
            KMNodeException nodeEx = new KMNodeException("CANTGETDOCRELATIONS", args, e);
            this.log((KMDataAccessException)nodeEx, method, args);
            throw nodeEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public void updateDocumentRelations(String docRid, Collection boRids) throws KMNodeException {
        String method = JARM_REQUEST + ":updateDocumentRelations(String, Collection)";
        Object[] args = new Object[]{docRid, boRids};
        this.enter(method, args);
        try {
            this.WSRelation.updateRelations(docRid, boRids.toArray(new String[boRids.size()]));
        }
        catch (Throwable e) {
            KMNodeException nodeEx = new KMNodeException("CANTUPDATEDOCRELATIONS", args, e);
            this.log((KMDataAccessException)nodeEx, method, args);
            throw nodeEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public NodeContent readDocumentContent(String name, String parentRid) throws KMNodeException {
        String method = JARM_REQUEST + ":readDocumentContent(String, String)";
        Object[] args = new Object[]{name, parentRid};
        this.enter(method, args);
        try {
            if (parentRid == null || name == null) {
                throw new KMNodeException("NULLINPUT");
            }
            String Rid = this.getRid(name, parentRid);
            KMUserContext userContext = this.getUserContext();
            NodeContent nodeContent = this.readNodeContent(userContext, name, parentRid, 1000000);
            return nodeContent;
        }
        catch (Throwable e) {
            KMNodeException nodeEx = new KMNodeException("CANTREADDOCCONTENT", args, e);
            this.log((KMDataAccessException)nodeEx, method, args);
            throw nodeEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public void deleteDocument(String name, String parentRid) throws KMNodeException {
        String method = JARM_REQUEST + ":deleteDocument(String, String)";
        Object[] args = new Object[]{name, parentRid};
        this.enter(method, args);
        try {
            if (parentRid == null || name == null) {
                throw new KMNodeException("NULLINPUT");
            }
            String Rid = this.getRid(name, parentRid);
            KMUserContext userContext = this.getUserContext();
            this.WS.deleteNode(userContext, Rid);
        }
        catch (Throwable e) {
            KMNodeException nodeEx = new KMNodeException("CANTDELETEDOC", args, e);
            this.log((KMDataAccessException)nodeEx, method, args);
            throw nodeEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public void saveDocumentHeader(String name, String parentRid, String displayName, String description, String link, Collection relations) throws KMNodeException {
        String method = JARM_REQUEST + ":saveDocumentHeader(String, String, String, String, String, Collection)";
        Object[] args = new Object[]{name, parentRid};
        this.enter(method, args);
        try {
            if (name == null || parentRid == null) {
                throw new KMNodeException("NULLINPUT");
            }
            String userId = this.getContextUserId();
            KMUserContext userContext = this.getUserContext();
            String rid = this.getRid(name, parentRid);
            KMNodeHeader header = new KMNodeHeader();
            KMNodeAttribute[] attributes = this.setAttributesSaveHeader(userId, displayName, description);
            KMNodePermission[] permissions = this.setPermissions(userId);
            String[] sRelations = null;
            sRelations = relations != null ? relations.toArray(new String[relations.size()]) : new String[]{};
            this.WS.saveNodeHeader(userContext, rid, link, attributes, permissions, sRelations);
        }
        catch (Throwable e) {
            KMNodeException nodeEx = new KMNodeException("CANTSAVEDOCHEADER", args, e);
            this.log((KMDataAccessException)nodeEx, method, args);
            throw nodeEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public void saveDocumentContent(String name, String parentRid, long contentLength, String contentType, String contentEncoding, byte[] content) throws KMNodeException {
        String method = JARM_REQUEST + ":saveDocumentContent(String, String, long, String, String, byte[])";
        Object[] args = new Object[]{name, parentRid, new Long(contentLength), contentType, contentEncoding, content};
        this.enter(method, args);
        try {
            if (name == null || parentRid == null || content == null) {
                throw new KMNodeException("NULLINPUT");
            }
            KMUserContext userContext = this.getUserContext();
            this.getNodeContentSvc().saveNodeContent(this.getRid(name, parentRid), content, contentType, contentEncoding, contentLength);
        }
        catch (Throwable e) {
            KMNodeException nodeEx = new KMNodeException("CANTSAVEDOCCONTENT", args, e);
            this.log((KMDataAccessException)nodeEx, method, args);
            throw nodeEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public Collection findDocument(String searchString, String startSearchRid) throws KMNodeException {
        String method = JARM_REQUEST + ":findDocument(String, String)";
        Object[] args = new Object[]{searchString, startSearchRid};
        this.enter(method, args);
        try {
            if (searchString == null || startSearchRid == null) {
                throw new KMNodeException("NULLINPUT");
            }
            KMUserContext userContext = this.getUserContext();
            KMNodeHeader[] resultArray = this.WS.findNodeByDisplayName(userContext, searchString, startSearchRid);
            LinkedList<KMNodeHeader> result = new LinkedList<KMNodeHeader>();
            if (resultArray != null) {
                for (int i = 0; i < resultArray.length; ++i) {
                    result.add(resultArray[i]);
                }
            }
            LinkedList<KMNodeHeader> linkedList = result;
            return linkedList;
        }
        catch (Throwable e) {
            KMNodeException nodeEx = new KMNodeException("CANTFINDDOC", args, e);
            this.log((KMDataAccessException)nodeEx, method, args);
            throw nodeEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    private KMNodeAttribute[] setAttributesCreateHeader(String userId, String displayName, String description) {
        KMNodeAttribute[] attributes = new KMNodeAttribute[2];
        Calendar currentDate = Calendar.getInstance();
        KMNodeAttribute attributeDescription = new KMNodeAttribute();
        attributeDescription.setNamespace("http://sapportals.com/xmlns/cm");
        attributeDescription.setName("description");
        attributeDescription.setStringValue(description);
        attributes[0] = attributeDescription;
        KMNodeAttribute attributeDisplayname = new KMNodeAttribute();
        attributeDisplayname.setNamespace("http://sapportals.com/xmlns/cm");
        attributeDisplayname.setName("displayname");
        attributeDisplayname.setStringValue(displayName);
        attributes[1] = attributeDisplayname;
        return attributes;
    }

    private KMNodeAttribute[] setAttributesSaveHeader(String userId, String displayName, String description) {
        ArrayList<KMNodeAttribute> attributes = new ArrayList<KMNodeAttribute>();
        if (description != null && description.length() > 0) {
            KMNodeAttribute attributeDescription = new KMNodeAttribute();
            attributeDescription.setNamespace("http://sapportals.com/xmlns/cm");
            attributeDescription.setName("description");
            attributeDescription.setStringValue(description);
            attributes.add(attributeDescription);
        }
        if (displayName != null && displayName.length() > 0) {
            KMNodeAttribute attributeDisplayname = new KMNodeAttribute();
            attributeDisplayname.setNamespace("http://sapportals.com/xmlns/cm");
            attributeDisplayname.setName("displayname");
            attributeDisplayname.setStringValue(displayName);
            attributes.add(attributeDisplayname);
        }
        return attributes.toArray(new KMNodeAttribute[attributes.size()]);
    }

    private KMNodeAttribute[] setAttributesSaveContent(String userId, long contentLength) {
        KMNodeAttribute[] attributes = new KMNodeAttribute[2];
        Calendar currentDate = Calendar.getInstance();
        KMNodeAttribute attributeContentType = new KMNodeAttribute();
        attributeContentType.setNamespace("http://sapportals.com/xmlns/cm");
        attributeContentType.setName("contenttype");
        attributeContentType.setStringValue("text/plain");
        attributes[0] = attributeContentType;
        KMNodeAttribute attributeContentLength = new KMNodeAttribute();
        attributeContentLength.setNamespace("http://sapportals.com/xmlns/cm");
        attributeContentLength.setName("contentlength");
        attributeContentLength.setLongIntValue(contentLength);
        attributes[1] = attributeContentLength;
        return attributes;
    }

    private KMNodePermission[] setPermissions(String userId) {
        KMNodePermission[] permissions = new KMNodePermission[1];
        KMNodePermission permission = new KMNodePermission();
        permission.setPrincipalId(userId);
        permission.setPrincipalType(0);
        permission.setPermission("fullcontrol");
        permissions[0] = permission;
        return permissions;
    }

    private KMNodeAttribute getAttribute(String attributeName, KMNodeAttribute[] attributes) {
        for (int i = 0; i < attributes.length; ++i) {
            if (!attributes[i].getName().equalsIgnoreCase(attributeName) || !attributes[i].getNamespace().equalsIgnoreCase("http://sapportals.com/xmlns/cm")) continue;
            return attributes[i];
        }
        return null;
    }

    private String getName(String Rid) {
        int keyLength = 0;
        int keyLastSeparator = 0;
        keyLength = Rid.length();
        if (keyLength == 0) {
            return null;
        }
        keyLastSeparator = Rid.lastIndexOf(STR_DIVIDER);
        if (keyLastSeparator == keyLength - 1) {
            keyLastSeparator = Rid.lastIndexOf(STR_DIVIDER, keyLength - 1);
        }
        return Rid.substring(keyLastSeparator + 1);
    }

    private String getRid(String name, String parentRid) {
        int keyLength = 0;
        int keyLastSeparator = 0;
        keyLength = parentRid.length();
        keyLastSeparator = parentRid.lastIndexOf(STR_DIVIDER);
        if (keyLastSeparator == keyLength - 1) {
            return parentRid + name;
        }
        return parentRid + STR_DIVIDER + name;
    }

    private String getParentRid(String Rid) {
        if (Rid == null) {
            return null;
        }
        int keyLength = 0;
        int keyLastSeparator = 0;
        keyLength = Rid.length();
        if (keyLength == 0) {
            return "";
        }
        keyLastSeparator = Rid.lastIndexOf(STR_DIVIDER);
        if (keyLastSeparator == keyLength - 1) {
            keyLastSeparator = Rid.lastIndexOf(STR_DIVIDER, keyLength - 1);
        }
        return Rid.substring(0, keyLastSeparator);
    }

    private INodeHeader setExplicitAttributes(KMNodeHeader listHeader) {
        String linkAttribute;
        NodeHeader attributeHeader = new NodeHeader();
        String rid = listHeader.getRid();
        KMNodeAttribute displayNameAttribute = null;
        KMNodeAttribute descriptionAttribute = null;
        Object permissionsAttribute = null;
        attributeHeader.setName(this.getName(rid));
        attributeHeader.setParentRid(this.getParentRid(rid));
        KMNodeAttribute attribute = this.getAttribute("created", listHeader.getAttributes());
        if (attribute != null) {
            attributeHeader.setCreationdate(attribute.getDateValue());
        }
        if ((attribute = this.getAttribute("createdby", listHeader.getAttributes())) != null) {
            attributeHeader.setCreatedBy(attribute.getStringValue());
        }
        if ((attribute = this.getAttribute("modified", listHeader.getAttributes())) != null) {
            attributeHeader.setLastmodifieddate(attribute.getDateValue());
        }
        if ((attribute = this.getAttribute("modifiedby", listHeader.getAttributes())) != null) {
            attributeHeader.setLastmodifiedBy(attribute.getStringValue());
        }
        attributeHeader.setLink((linkAttribute = listHeader.getLink()) == null ? "" : linkAttribute);
        displayNameAttribute = this.getAttribute("displayname", listHeader.getAttributes());
        if (displayNameAttribute == null) {
            attributeHeader.setDisplayName("");
        } else {
            attributeHeader.setDisplayName(displayNameAttribute.getStringValue());
        }
        descriptionAttribute = this.getAttribute("description", listHeader.getAttributes());
        if (descriptionAttribute == null) {
            attributeHeader.setDescription("");
        } else {
            attributeHeader.setDescription(descriptionAttribute.getStringValue());
        }
        attributeHeader.setSize(listHeader.getNodeSize());
        if (listHeader.getPermissions() == null) {
            attributeHeader.setPermissions(new KMNodePermission[0]);
        } else {
            attributeHeader.setPermissions(listHeader.getPermissions());
        }
        return attributeHeader;
    }

    private KMUserContext getUserContext() throws UMException {
        KMUserContext userContext = null;
        userContext = new KMUserContext();
        userContext.setCountryCode(Locale.US.getCountry());
        userContext.setLanguageCode(Locale.US.getLanguage());
        return userContext;
    }

    private String getContextUserId() throws UMException {
        return "admin";
    }

    private NodeContent readNodeContent(KMUserContext userContext, String name, String parentRid, int sizeLimit) throws KMNodeException, RemoteException, NamingException, ServiceException {
        String sRid = this.getRid(name, parentRid);
        NodeContentSvcViRpcEnc svc = this.getNodeContentSvc();
        byte[] contentBytes = svc.readContent(sRid, sizeLimit);
        NodeContentStruct contentParams = svc.readContentParams(sRid);
        NodeContent content = new NodeContent();
        content.setName(name);
        content.setParentRid(parentRid);
        content.setContentLength(contentParams.getContentLength());
        content.setContentType(contentParams.getContentType());
        content.setContentEncoding(contentParams.getContentEncoding());
        content.setContent(contentBytes);
        return content;
    }

    public String getDocumentURLforPreview(String rid) throws KMNodeException {
        return this.getNotNullProperty(KM_URL_PREVIEW) + rid;
    }

    public Collection getDocumentURLforPreview(Collection rids) throws KMNodeException {
        if (rids == null) {
            return null;
        }
        ArrayList<String> urls = new ArrayList<String>();
        Iterator i = rids.iterator();
        while (i.hasNext()) {
            urls.add(this.getDocumentURLforPreview((String)i.next()));
        }
        return urls;
    }

    public String getDocumentURLforEdit(String rid) throws KMNodeException {
        return this.getNotNullProperty(KM_URL_EDIT) + rid;
    }

    public Collection getDocumentURLforEdit(Collection rids) throws KMNodeException {
        if (rids == null) {
            return null;
        }
        ArrayList<String> urls = new ArrayList<String>();
        Iterator i = rids.iterator();
        while (i.hasNext()) {
            urls.add(this.getDocumentURLforEdit((String)i.next()));
        }
        return urls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getNotNullProperty(String name) throws KMNodeException {
        Map map = m_props;
        synchronized (map) {
            String value;
            if (!(class$com$sap$caf$rt$bol$context$CAFProperties == null ? (class$com$sap$caf$rt$bol$context$CAFProperties = DocumentProxyEJBBean.class$("com.sap.caf.rt.bol.context.CAFProperties")) : class$com$sap$caf$rt$bol$context$CAFProperties).equals(m_props.get(CAF_PROPS_CLASS))) {
                CAFProperties props = new CAFProperties();
                try {
                    props.loadApplicationProperties();
                }
                catch (DataAccessException e) {
                    throw new KMNodeException("CANTREADPROPS", (Throwable)e);
                }
                m_props.clear();
                m_props.put(CAF_PROPS_CLASS, props.getClass());
                m_props.put(KM_URL_PREVIEW, ProxyHelper.getActualUrl(props.getProperty(KM_URL_PREVIEW, KM_URL_PREVIEW_DEF_VAL)));
                m_props.put(KM_URL_EDIT, ProxyHelper.getActualUrl(props.getProperty(KM_URL_EDIT, KM_URL_EDIT_DEF_VAL)));
            }
            if ((value = (String)m_props.get(name)) == null) {
                throw new KMNodeException("NOPROPDEFINED", new Object[]{name});
            }
            return value;
        }
    }

    private NodeContentSvcViRpcEnc getNodeContentSvc() throws NamingException, ServiceException {
        if (this.WSNodeContentSvc == null) {
            NodeContentSvc svc = (NodeContentSvc)this.JNDIcontext.lookup("wsclients/proxies/sap.com/caf~km.proxies/KMNodeContentSvcProxy");
            this.WSNodeContentSvc = svc.getConfig1PortMime();
            String url = ProxyHelper.getActualUrl((String)this.WSNodeContentSvc._getProperty("javax.xml.rpc.service.endpoint.address"));
            this.WSNodeContentSvc._setProperty("javax.xml.rpc.service.endpoint.address", (Object)url);
        }
        return this.WSNodeContentSvc;
    }

    protected Location getLocation() {
        return location;
    }

    protected String getJARMRequest() {
        return JARM_REQUEST;
    }

    public boolean isDocumentLocked(String documentRid) throws KMNodeException {
        String method = JARM_REQUEST + ":isDocumentLocked(String)";
        Object[] args = new Object[]{documentRid};
        this.enter(method, args);
        try {
            boolean bl = this.WSBase.isDocumentLocked(documentRid);
            return bl;
        }
        catch (Exception e) {
            KMNodeException nodeEx = new KMNodeException("CANTCHECKLOCK", args, (Throwable)e);
            this.log((KMDataAccessException)nodeEx, method, args);
            throw nodeEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public boolean unlockDocument(String documentRid) throws KMNodeException {
        String method = JARM_REQUEST + ":unlockDocument(String)";
        Object[] args = new Object[]{documentRid};
        this.enter(method, args);
        try {
            boolean bl = this.WSBase.unlockDocument(documentRid);
            return bl;
        }
        catch (Exception e) {
            KMNodeException nodeEx = new KMNodeException("CANTUNLOCKDOCUMENT", args, (Throwable)e);
            this.log((KMDataAccessException)nodeEx, method, args);
            throw nodeEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public String getLockOwner(String documentRid) throws KMNodeException {
        String method = JARM_REQUEST + ":getLockOwner(String)";
        Object[] args = new Object[]{documentRid};
        this.enter(method, args);
        try {
            String string = this.WSBase.getLockOwner(documentRid);
            return string;
        }
        catch (Exception e) {
            KMNodeException nodeEx = new KMNodeException("CANTGETLOCKOWNER", args, (Throwable)e);
            this.log((KMDataAccessException)nodeEx, method, args);
            throw nodeEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public void enableDocumentVersioning(String rid) throws KMNodeException {
        String method = JARM_REQUEST + ":enableDocumentVersioning(String)";
        Object[] args = new Object[]{rid};
        this.enter(method, args);
        try {
            this.WSBase.enableDocumentVersioning(rid);
        }
        catch (Exception e) {
            KMNodeException nodeEx = new KMNodeException("CANTENABLEVERSIONING", args, (Throwable)e);
            this.log((KMDataAccessException)nodeEx, method, args);
            throw nodeEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public boolean isDocumentVersioned(String rid) throws KMNodeException {
        String method = JARM_REQUEST + ":isDocumentVersioned(String)";
        Object[] args = new Object[]{rid};
        this.enter(method, args);
        try {
            boolean bl = this.WSBase.isDocumentVersioned(rid);
            return bl;
        }
        catch (Exception e) {
            KMNodeException nodeEx = new KMNodeException("CANTCHECKDOCUMENTVERSIONING", args, (Throwable)e);
            this.log((KMDataAccessException)nodeEx, method, args);
            throw nodeEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public String[] getVersionHistory(String rid) throws KMNodeException {
        String method = JARM_REQUEST + ":getVersionHistory(String)";
        Object[] args = new Object[]{rid};
        this.enter(method, args);
        try {
            String[] stringArray = this.WSBase.getVersionHistory(rid);
            return stringArray;
        }
        catch (Exception e) {
            KMNodeException nodeEx = new KMNodeException("CANTGETVERSIONHISTORY", args, (Throwable)e);
            this.log((KMDataAccessException)nodeEx, method, args);
            throw nodeEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public void setAsCurrentVersion(String historyRid, String rid) throws KMNodeException {
        String method = JARM_REQUEST + ":setAsCurrentVersion(String, String)";
        Object[] args = new Object[]{historyRid, rid};
        this.enter(method, args);
        try {
            this.WSBase.setAsCurrentVersion(historyRid, rid);
        }
        catch (Exception e) {
            KMNodeException nodeEx = new KMNodeException("CANTSETCURRENTVERSION", args, (Throwable)e);
            this.log((KMDataAccessException)nodeEx, method, args);
            throw nodeEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public void deleteVersion(String historyRid) throws KMNodeException {
        String method = JARM_REQUEST + ":deleteVersion(String)";
        Object[] args = new Object[]{historyRid};
        this.enter(method, args);
        try {
            this.WSBase.deleteVersion(historyRid);
        }
        catch (Exception e) {
            KMNodeException nodeEx = new KMNodeException("CANTDELETEVERSION", args, (Throwable)e);
            this.log((KMDataAccessException)nodeEx, method, args);
            throw nodeEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public void disableDocumentVersioning(String rid) throws KMNodeException {
        String method = JARM_REQUEST + ":disableDocumentVersioning(String)";
        Object[] args = new Object[]{rid};
        this.enter(method, args);
        try {
            this.WSBase.disableDocumentVersioning(rid);
        }
        catch (Exception e) {
            KMNodeException nodeEx = new KMNodeException("CANTDISABLEVERSIONING", args, (Throwable)e);
            this.log((KMDataAccessException)nodeEx, method, args);
            throw nodeEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public String getCurrentVersion(String rid) throws KMNodeException {
        String method = JARM_REQUEST + ":getCurrentVersion(String)";
        Object[] args = new Object[]{rid};
        this.enter(method, args);
        try {
            String string = this.WSBase.getCurrentVersion(rid);
            return string;
        }
        catch (Exception e) {
            KMNodeException nodeEx = new KMNodeException("CANTGETVERSION", args, (Throwable)e);
            this.log((KMDataAccessException)nodeEx, method, args);
            throw nodeEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public boolean authorizationCheck(String documentRid) throws KMNodeException {
        String method = JARM_REQUEST + ":authorizationCheck(String)";
        Object[] args = new Object[]{documentRid};
        this.enter(method, args);
        try {
            boolean bl = this.WSBase.authorizationCheck(documentRid);
            return bl;
        }
        catch (Exception e) {
            KMNodeException nodeEx = new KMNodeException("CANTAUTHCHECK", args, (Throwable)e);
            this.log((KMDataAccessException)nodeEx, method, args);
            throw nodeEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public String relateKMDocument(String boID, String boGUID, String kmRID) throws KMNodeException {
        String method = JARM_REQUEST + ":relateKMDocument(String, String, String)";
        this.enter(method, new Object[]{boID, boGUID, kmRID});
        try {
            String string = kmRID;
            return string;
        }
        catch (Exception e) {
            KMNodeException uploadEx = new KMNodeException("", (Throwable)e);
            this.log((KMDataAccessException)uploadEx, method, null);
            throw uploadEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public String copyBODocument(String fullBOName, String boGuid, String kmRid) throws KMNodeException {
        String method = JARM_REQUEST + ":copyBODocument(String, String, String)";
        this.enter(method, new Object[]{fullBOName, boGuid, kmRid});
        try {
            String result = kmRid;
            String dstFolder = KMDataAccessHelper.getBORootFolderRid(fullBOName, boGuid);
            this.checkAndCreateFolder(dstFolder);
            String string = result = this.copyDocument(kmRid, dstFolder);
            return string;
        }
        catch (Exception e) {
            KMNodeException uploadEx = new KMNodeException("CANTCOPYBODOCUMENT", (Throwable)e);
            this.log((KMDataAccessException)uploadEx, method, null);
            throw uploadEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    private void checkAndCreateFolder(String folderRID) throws Exception {
        boolean bExists = false;
        FolderProxyEJBLocal folderProxy = KMDataAccessHelper.getFolderProxyService();
        bExists = folderProxy.exists(folderRID);
        if (!bExists) {
            ArrayList<String> coll = new ArrayList<String>();
            StringTokenizer tkz = new StringTokenizer(folderRID, STR_DIVIDER);
            while (tkz.hasMoreElements()) {
                String token = tkz.nextToken();
                if (token.length() <= 0) continue;
                coll.add(token);
            }
            Iterator iterator = coll.iterator();
            String parent = STR_DIVIDER + (String)iterator.next();
            while (iterator.hasNext()) {
                String folder = (String)iterator.next();
                String parentFolder = parent;
                boolean bool = folderProxy.exists(parent = parent + STR_DIVIDER + folder);
                if (bool) continue;
                folderProxy.createFolderHeader(folder, parentFolder, "", "", new ArrayList());
            }
        }
    }

    private String copyDocument(String rid, String dstFolder) throws KMNodeException {
        String method = JARM_REQUEST + ":copyDocument(String, String)";
        this.enter(method, new Object[]{rid, dstFolder});
        try {
            String newRid = rid;
            DocumentProxyEJBLocal documentProxy = KMDataAccessHelper.getDocumentProxyService();
            newRid = dstFolder + STR_DIVIDER + this.generateUniqueUploadName(dstFolder, RidUtils.getName(rid));
            documentProxy.copy(rid, newRid);
            String string = newRid;
            return string;
        }
        catch (Exception e) {
            KMNodeException uploadEx = new KMNodeException("CANTCOPYDOCUMENT", (Throwable)e);
            this.log((KMDataAccessException)uploadEx, method, null);
            throw uploadEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    private String generateUniqueUploadName(String folder, String uploadName) throws KMNodeException {
        String method = JARM_REQUEST + ":generateUniqueUploadName(String, String)";
        this.enter(method, new Object[]{folder, uploadName});
        try {
            folder = folder.endsWith(STR_DIVIDER) ? folder : folder + STR_DIVIDER;
            DocumentProxyEJBLocal documentProxy = KMDataAccessHelper.getDocumentProxyService();
            int dotIndex = uploadName.lastIndexOf(46);
            String name = dotIndex == -1 ? uploadName : uploadName.substring(0, dotIndex);
            String ext = dotIndex == -1 ? "" : uploadName.substring(dotIndex);
            int modifier = 0;
            while (documentProxy.exists(folder + uploadName)) {
                uploadName = name + "(" + ++modifier + ")" + ext;
            }
            String string = uploadName;
            return string;
        }
        catch (Exception e) {
            KMNodeException uploadEx = new KMNodeException("CANTGENERATEUNIQUENAME", (Throwable)e);
            this.log((KMDataAccessException)uploadEx, method, null);
            throw uploadEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public Collection copyAttachedKMDocuments(String fullBOName, String boGuid, Collection srcRids) throws KMNodeException {
        String method = JARM_REQUEST + ":copyAttachedKMDocuments(String, String, Collection)";
        this.enter(method, new Object[]{fullBOName, boGuid, srcRids});
        try {
            if (srcRids == null || srcRids.isEmpty()) {
                List list = Collections.EMPTY_LIST;
                return list;
            }
            String rootFolder = KMDataAccessHelper.getBORootFolderRid(fullBOName, boGuid);
            String tempFolder = KMDataAccessHelper.getTempFolderRid();
            DocumentProxyEJBLocal documentProxy = KMDataAccessHelper.getDocumentProxyService();
            ArrayList<String> dstRids = new ArrayList<String>(srcRids.size());
            Iterator i = srcRids.iterator();
            while (i.hasNext()) {
                String srcRidStr = (String)i.next();
                String[] dstRid = RidUtils.splitPathname(tempFolder, srcRidStr);
                if (dstRid == null || dstRid.length == 0) {
                    dstRids.add(srcRidStr);
                    continue;
                }
                dstRid[0] = rootFolder;
                String dstRootFolder = RidUtils.mergePathname(dstRid, 2);
                String dstRidStr = documentProxy.copyToFolder(srcRidStr, dstRootFolder);
                if (dstRid[1] != null) {
                    int k = dstRid[1].indexOf(47);
                    this.cleanupExtraFolders(k == -1 ? dstRid[1] : dstRid[1].substring(0, k));
                }
                dstRids.add(dstRidStr);
            }
            ArrayList<String> arrayList = dstRids;
            return arrayList;
        }
        catch (Exception e) {
            KMNodeException uploadEx = new KMNodeException("CANTCOPYATTACHEDDOCUMENTS", (Throwable)e);
            this.log((KMDataAccessException)uploadEx, method, null);
            throw uploadEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    private void cleanupExtraFolders(String folderRid) throws KMNodeException {
        String method = JARM_REQUEST + ":cleanupExtraFolders(String)";
        this.enter(method, new Object[]{folderRid});
        try {
            if (null != folderRid && folderRid.length() > 0) {
                FolderProxyEJBLocal folderProxy = KMDataAccessHelper.getFolderProxyService();
                int i = folderRid.lastIndexOf(STR_DIVIDER);
                String parentRid = folderRid.substring(0, i + 1);
                String name = folderRid.substring(i + 1);
                try {
                    folderProxy.deleteFolder(name, parentRid);
                }
                catch (KMNodeException ignore) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            KMNodeException uploadEx = new KMNodeException("CANTCLEANFOLDERS", (Throwable)e);
            this.log((KMDataAccessException)uploadEx, method, null);
            throw uploadEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

