/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.km.da;

import com.sap.caf.km.da.KMDataAccessHelper;
import com.sap.caf.km.da.RidUtils;
import com.sap.caf.km.ejb.data.util.KMNodeException;
import com.sap.caf.km.ejb.data.util.NodeContent;
import com.sap.caf.km.ejb.data.util.NodeHeader;
import com.sap.caf.km.proxies.data.kmnode.types.KMNodeHeader;
import com.sap.caf.rt.bol.IDependentObject;
import com.sap.caf.rt.bol.da.DataAccessFactory;
import com.sap.caf.rt.bol.da.IDataAccessService;
import com.sap.caf.rt.bol.pk.PrimaryKeyFactory;
import com.sap.caf.rt.bol.util.IntQueryFilter;
import com.sap.caf.rt.bol.util.QueryFilter;
import com.sap.caf.rt.bol.util.UserContext;
import com.sap.caf.rt.exception.CAFFindException;
import com.sap.caf.rt.exception.DataAccessException;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class DocumentDataAccessService
implements IDataAccessService {
    private UserContext userContext = null;
    private static DocumentDataAccessService service;
    private static final String APPLICATION;
    private static final String jARMReqPrefix = "CAF:RT:oal:";
    private static final String JARM_REQUEST;
    private static final Location location;
    private IDataAccessService jdoDataAccessService = null;
    private String m_sDocContentName = "sap.com/caf.core/DocumentContent";
    static /* synthetic */ Class class$com$sap$caf$km$da$DocumentDataAccessService;

    private DocumentDataAccessService() throws DataAccessException {
        String method = JARM_REQUEST + ":activate()";
        CAFPublicLogger.entering(null, (String)JARM_REQUEST, (String)method, (Location)location, (Object[])new Object[0], (int)1);
        try {
            try {
                this.jdoDataAccessService = DataAccessFactory.getDataAccessService((int)DataAccessFactory.DATASOURCE_LOCAL);
            }
            catch (Exception ex) {
                CAFPublicLogger.logThrowable((int)500, (Category)CAFPublicLogger.categoryCAF, (Location)location, (String)method, (String)"Cannot get instance of document proxy bean", (Throwable)ex);
                throw new DataAccessException("Cannot get instance of document proxy bean", new Object[0]);
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            CAFPublicLogger.exiting(null, (String)JARM_REQUEST, (String)method, (Location)location, (Object)new Object[0], (int)1);
            throw throwable;
        }
        CAFPublicLogger.exiting(null, (String)JARM_REQUEST, (String)method, (Location)location, (Object)new Object[0], (int)1);
    }

    public static DocumentDataAccessService getInstance() throws DataAccessException {
        String method = JARM_REQUEST + ":getInstance()";
        CAFPublicLogger.entering(null, (String)JARM_REQUEST, (String)method, (Location)location, (int)1);
        if (service == null) {
            service = new DocumentDataAccessService();
        }
        CAFPublicLogger.exiting(null, (String)JARM_REQUEST, (String)method, (Location)location, (Object)new Object[]{service}, (int)1);
        return service;
    }

    public void destroy() {
        String method = JARM_REQUEST + ":destroy()";
        CAFPublicLogger.entering(null, (String)JARM_REQUEST, (String)method, (Location)location, (Object[])new Object[0], (int)2);
        this.jdoDataAccessService = null;
        CAFPublicLogger.exiting(null, (String)JARM_REQUEST, (String)method, (Location)location, (int)2);
    }

    public String create(IDependentObject arg0) throws DataAccessException {
        String method = JARM_REQUEST + ":create(IDependentObject)";
        CAFPublicLogger.entering(null, (String)JARM_REQUEST, (String)method, (Location)location, (Object[])new Object[]{arg0.getKey()}, (int)1);
        try {
            this.jdoDataAccessService.create(arg0);
            KMDataAccessHelper.getDocumentProxyService().createDocumentHeader((String)arg0.getProperty("documentId"), (String)arg0.getProperty("parentFolder"), (String)arg0.getProperty("title"), (String)arg0.getProperty("description"), (String)arg0.getProperty("link"), (Collection)arg0.getProperty("relatedObjects"));
            if (this.m_sDocContentName.equals(arg0.getObjectType())) {
                this.uploadDocumentContent(arg0);
            }
            String string = arg0.getKey();
            return string;
        }
        catch (Exception ex) {
            CAFPublicLogger.LOC_CAF.catching((Throwable)ex);
            throw new DataAccessException((Throwable)ex);
        }
        finally {
            CAFPublicLogger.exiting(null, (String)JARM_REQUEST, (String)method, (Location)location, (int)1);
        }
    }

    public void remove(IDependentObject arg0) throws DataAccessException {
        String method = JARM_REQUEST + ":remove(IDependentObject)";
        CAFPublicLogger.entering(null, (String)JARM_REQUEST, (String)method, (Location)location, (Object[])new Object[]{arg0}, (int)1);
        try {
            String documentId = (String)arg0.getProperty("documentId");
            String parentFolder = (String)arg0.getProperty("parentFolder");
            if (documentId == null && parentFolder == null) {
                arg0 = (IDependentObject)this.load(arg0.getPK(), arg0.getClass());
                documentId = (String)arg0.getProperty("documentId");
                parentFolder = (String)arg0.getProperty("parentFolder");
            }
            KMDataAccessHelper.getDocumentProxyService().deleteDocument(documentId, parentFolder);
            this.jdoDataAccessService.remove(arg0);
        }
        catch (Exception ex) {
            location.catching((Throwable)ex);
            throw new DataAccessException((Throwable)ex);
        }
        finally {
            CAFPublicLogger.exiting(null, (String)JARM_REQUEST, (String)method, (Location)location, (int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object findByPrimaryKey(Object arg0, Class arg1) throws DataAccessException {
        String method = JARM_REQUEST + ":findByPrimaryKey(Object, Class)";
        CAFPublicLogger.entering(null, (String)JARM_REQUEST, (String)method, (Location)location, (Object[])new Object[]{arg0, arg1}, (int)1);
        try {
            IDependentObject obj = (IDependentObject)this.jdoDataAccessService.findByPrimaryKey(arg0, arg1);
            IDependentObject iDependentObject = this.loadObjectFromKM(obj);
            return iDependentObject;
        }
        catch (Exception ex) {
            location.catching((Throwable)ex);
        }
        finally {
            CAFPublicLogger.exiting(null, (String)JARM_REQUEST, (String)method, (Location)location, (int)1);
        }
        return null;
    }

    public Collection query(Class arg0, String operationName) throws DataAccessException {
        return this.loadObjectsFromKM(this.jdoDataAccessService.query(arg0, operationName));
    }

    public Collection query(Class arg0, String arg1, String arg2, Map arg3, String operationName) throws DataAccessException {
        return this.loadObjectsFromKM(this.jdoDataAccessService.query(arg0, arg1, arg2, arg3, operationName));
    }

    public Collection query(Class arg0, IntQueryFilter arg1, String operationName) throws DataAccessException {
        return this.loadObjectsFromKM(this.jdoDataAccessService.query(arg0, arg1, operationName));
    }

    public Collection query(Class arg0, IntQueryFilter[] arg1, String operationName) throws DataAccessException {
        if (arg1.length > 2) {
            return this.loadObjectsFromKM(this.jdoDataAccessService.query(arg0, arg1, operationName));
        }
        Collection<IDependentObject> result = null;
        String documentId = null;
        String parentFolder = null;
        String documentTitle = null;
        for (int i = 0; i < arg1.length; ++i) {
            arg1[i].getJdoMapFilter();
            String attr = arg1[i].attribute;
            if ("documentId".equals(attr)) {
                documentId = arg1[i].valueLow;
                continue;
            }
            if ("parentFolder".equals(attr)) {
                parentFolder = arg1[i].valueLow;
                continue;
            }
            if (!"title".equals(attr)) break;
            documentTitle = arg1[i].valueLow;
        }
        if (documentId != null && parentFolder != null) {
            result = this.loadObjectsFromKM(this.jdoDataAccessService.query(arg0, arg1, operationName));
            if (result.size() == 0) {
                try {
                    IDependentObject doc = this.createDependentObject(arg0, documentId, parentFolder, null);
                    doc = this.loadObjectFromKM(doc);
                    if (doc != null) {
                        this.createInJDO(doc);
                    }
                    result.add(doc);
                }
                catch (Exception ex) {
                    location.throwing((Throwable)ex);
                }
            }
        } else if (documentTitle != null && parentFolder != null) {
            try {
                result = new ArrayList();
                Collection km_result = KMDataAccessHelper.getDocumentProxyService().findDocument(parentFolder, documentTitle);
                Iterator i = km_result.iterator();
                while (i.hasNext()) {
                    IDependentObject doc = this.createDependentObjectFromHeader(arg0, (KMNodeHeader)i.next());
                    documentId = (String)doc.getProperty("documentId");
                    Collection jdo_result = this.jdoDataAccessService.query(arg0, DocumentDataAccessService.createQueryToJDOSearch(documentId, parentFolder), operationName);
                    if (jdo_result.size() > 0) {
                        result.add(this.loadObjectFromKM((IDependentObject)jdo_result.iterator().next()));
                        continue;
                    }
                    this.createInJDO(doc);
                    result.add(this.loadObjectFromKM(doc));
                }
            }
            catch (Exception ex) {
                location.throwing((Throwable)ex);
            }
        } else {
            result = this.loadObjectsFromKM(this.jdoDataAccessService.query(arg0, arg1, operationName));
        }
        return result;
    }

    public Collection query(String arg0, Class arg1, IntQueryFilter[] arg2, String operationName) throws DataAccessException {
        return this.loadObjectsFromKM(this.jdoDataAccessService.query(arg0, arg1, arg2, operationName));
    }

    public Object load(Object arg0, Class arg1) throws DataAccessException {
        String method = JARM_REQUEST + ":load(String, Class)";
        CAFPublicLogger.entering(null, (String)JARM_REQUEST, (String)method, (Location)location, (Object[])new Object[]{arg0}, (int)1);
        try {
            IDependentObject obj = (IDependentObject)this.jdoDataAccessService.load(arg0, arg1);
            IDependentObject newObj = this.createDependentObject(arg1, obj.getProperty("documentId"), obj.getProperty("parentFolder"), obj.getProperty("key"));
            IDependentObject iDependentObject = newObj = this.loadObjectFromKM(newObj);
            return iDependentObject;
        }
        catch (Exception ex) {
            location.throwing((Throwable)ex);
            throw new DataAccessException((Throwable)ex);
        }
        finally {
            CAFPublicLogger.exiting(null, (String)JARM_REQUEST, (String)method, (Location)location, (int)1);
        }
    }

    public Object loadFromJDO(Class arg0, String parentFolder, String documentId) throws DataAccessException {
        try {
            Collection jdo_result = this.jdoDataAccessService.query(arg0, DocumentDataAccessService.createQueryToJDOSearch(documentId, parentFolder), null);
            IDependentObject doc = null;
            if (jdo_result.size() > 0) {
                doc = (IDependentObject)jdo_result.iterator().next();
            }
            return doc;
        }
        catch (Exception ex) {
            location.throwing((Throwable)ex);
            throw new DataAccessException((Throwable)ex);
        }
    }

    public void store(IDependentObject arg0) throws DataAccessException {
        String method = JARM_REQUEST + ":store(IDependentObject)";
        CAFPublicLogger.entering(null, (String)JARM_REQUEST, (String)method, (Location)location, (Object[])new Object[]{arg0.getKey()}, (int)1);
        try {
            this.jdoDataAccessService.store(arg0);
            KMDataAccessHelper.getDocumentProxyService().saveDocumentHeader((String)arg0.getProperty("documentId"), (String)arg0.getProperty("parentFolder"), (String)arg0.getProperty("title"), (String)arg0.getProperty("description"), (String)arg0.getProperty("link"), (Collection)arg0.getProperty("relatedObjects"));
            if (this.m_sDocContentName.equals(arg0.getObjectType())) {
                this.uploadDocumentContent(arg0);
            }
        }
        catch (Exception ex) {
            location.throwing((Throwable)ex);
            throw new DataAccessException((Throwable)ex);
        }
        finally {
            CAFPublicLogger.exiting(null, (String)JARM_REQUEST, (String)method, (Location)location, (int)1);
        }
    }

    public void activate() {
    }

    public void passivate() throws DataAccessException {
    }

    public Object execute(String arg0, Class arg1, Object arg2, Object arg3) throws DataAccessException {
        return this.jdoDataAccessService.execute(arg0, arg1, arg2, arg3);
    }

    private Collection loadObjectsFromKM(Collection col) throws DataAccessException {
        Iterator i = col.iterator();
        ArrayList<IDependentObject> result = new ArrayList<IDependentObject>();
        while (i.hasNext()) {
            IDependentObject obj = this.loadObjectFromKM((IDependentObject)i.next());
            if (obj == null) continue;
            result.add(obj);
        }
        return result;
    }

    private IDependentObject loadObjectFromKM(IDependentObject obj) throws DataAccessException {
        String method = JARM_REQUEST + ":loadObjectFromKM(IDependentObject)";
        CAFPublicLogger.entering(null, (String)JARM_REQUEST, (String)method, (Location)location, (Object[])new Object[]{obj.getKey()}, (int)2);
        try {
            NodeHeader header = KMDataAccessHelper.getDocumentProxyService().readDocumentHeader((String)obj.getProperty("documentId"), (String)obj.getProperty("parentFolder"));
            obj.setProperty("title", (Object)header.getDisplayName());
            obj.setProperty("description", (Object)header.getDescription());
            obj.setProperty("createdBy", (Object)header.getCreatedBy());
            obj.setProperty("createdAt", (Object)header.getCreationdate().getTime());
            obj.setProperty("lastChangedBy", (Object)header.getLastmodifiedBy());
            obj.setProperty("lastChangedAt", (Object)header.getLastmodifieddate().getTime());
            obj.setProperty("link", (Object)header.getLink());
            obj.setProperty("relatedObjects", (Object)header.getRelationRids());
            if (this.m_sDocContentName.equals(obj.getObjectType())) {
                NodeContent data = KMDataAccessHelper.getDocumentProxyService().readDocumentContent((String)obj.getProperty("documentId"), (String)obj.getProperty("parentFolder"));
                obj.setProperty("contentEncoding", (Object)data.getContentEncoding());
                obj.setProperty("contentType", (Object)data.getContentType());
                obj.setProperty("contentLength", (Object)new Long(data.getContentLength()));
                obj.setProperty("content", (Object)data.getContent());
            }
            IDependentObject iDependentObject = obj;
            return iDependentObject;
        }
        catch (Exception ex) {
            location.throwing((Throwable)ex);
            throw new DataAccessException((Throwable)ex);
        }
        finally {
            CAFPublicLogger.exiting(null, (String)JARM_REQUEST, (String)method, (Location)location, (int)2);
        }
    }

    private void uploadDocumentContent(IDependentObject arg0) throws KMNodeException, CAFFindException {
        KMDataAccessHelper.getDocumentProxyService().saveDocumentContent((String)arg0.getProperty("documentId"), (String)arg0.getProperty("parentFolder"), ((Long)arg0.getProperty("contentLength")).longValue(), (String)arg0.getProperty("contentType"), (String)arg0.getProperty("contentEncoding"), (byte[])arg0.getProperty("content"));
    }

    private void createInJDOIfNotExists(IDependentObject arg0) throws DataAccessException {
        IDependentObject obj = null;
        try {
            obj = (IDependentObject)this.jdoDataAccessService.findByPrimaryKey((Object)arg0.getPK(), arg0.getClass());
        }
        catch (DataAccessException ex) {
            location.throwing((Throwable)ex);
        }
        if (obj == null) {
            this.jdoDataAccessService.create(arg0);
        }
    }

    private void createInJDO(IDependentObject arg0) throws DataAccessException {
        arg0.setProperty("key", (Object)PrimaryKeyFactory.getInstance().getPrimaryKey());
        this.jdoDataAccessService.create(arg0);
    }

    private IDependentObject createDependentObject(Class arg0, Object documentId, Object parentFolder, Object key) throws InstantiationException, IllegalAccessException {
        IDependentObject obj = (IDependentObject)arg0.newInstance();
        obj.setProperty("documentId", (Object)((String)documentId));
        obj.setProperty("parentFolder", (Object)((String)parentFolder));
        obj.setProperty("key", (Object)((String)key));
        return obj;
    }

    private static IntQueryFilter[] createQueryToJDOSearch(String documentId, String parentFolder) {
        IntQueryFilter fParentFolder = new IntQueryFilter(QueryFilter.createStringFilter((String)"exact", (String)parentFolder, (String)"parentFolder", (boolean)true));
        fParentFolder.setAttribute("parentFolder");
        fParentFolder.condition = "==";
        IntQueryFilter fDocumentId = new IntQueryFilter(QueryFilter.createStringFilter((String)"exact", (String)documentId, (String)"documentId", (boolean)true));
        fDocumentId.setAttribute("documentId");
        fDocumentId.condition = "==";
        return new IntQueryFilter[]{fParentFolder, fDocumentId};
    }

    private IDependentObject createDependentObjectFromHeader(Class arg0, KMNodeHeader header) throws IllegalAccessException, InstantiationException {
        IDependentObject obj = (IDependentObject)arg0.newInstance();
        String rid = header.getRid();
        obj.setProperty("documentId", (Object)RidUtils.getName(rid));
        obj.setProperty("parentFolder", (Object)RidUtils.getPath(rid));
        return obj;
    }

    public void setUserContext(UserContext userCtx) {
        this.userContext = userCtx;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        APPLICATION = (class$com$sap$caf$km$da$DocumentDataAccessService == null ? (class$com$sap$caf$km$da$DocumentDataAccessService = DocumentDataAccessService.class$("com.sap.caf.km.da.DocumentDataAccessService")) : class$com$sap$caf$km$da$DocumentDataAccessService).getName();
        JARM_REQUEST = jARMReqPrefix + APPLICATION;
        location = Location.getLocation((String)APPLICATION);
    }
}

