/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp_mmr_bridge.rt.impl;

import com.sap.caf.metamodel.Attribute;
import com.sap.caf.metamodel.BusinessEntityInterface;
import com.sap.caf.metamodel.Operation;
import com.sap.caf.mp.base.exception.EngineException;
import com.sap.caf.mp.base.exception.InvocationException;
import com.sap.caf.mp.core.data.mapping.api.IMappingService;
import com.sap.caf.mp.core.data.types.api.IMessage;
import com.sap.caf.mp_mmr_bridge.MpMmrBridgeFactory;
import com.sap.caf.mp_mmr_bridge.impl.MpHelper;
import com.sap.caf.mp_mmr_bridge.mapping.IOperationMapper;
import com.sap.caf.mp_mmr_bridge.mapping.MpOperation;
import com.sap.caf.mp_mmr_bridge.mapping.NotFoundException;
import com.sap.caf.mp_mmr_bridge.rt.IExternalOperationConfig;
import com.sap.caf.mp_mmr_bridge.rt.IRuntimeHelper;
import com.sap.caf.mp_mmr_bridge.rt.impl.ExternalOperationConfig;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.naming.NamingException;
import javax.resource.ResourceException;

public class RuntimeHelper
extends IRuntimeHelper {
    private IOperationMapper operationMapper = MpMmrBridgeFactory.getOperationMapper();
    private static Hashtable simpleTypeMapping = new Hashtable();
    private static String typePrfix = "com.sap.caf.base.";

    private static boolean checkAttributeNames(Operation beOp, Set attributeNames) {
        if (beOp.getInput() == null) {
            return attributeNames.isEmpty();
        }
        HashSet<String> actualAttributeNames = new HashSet<String>();
        Iterator actualAttrIterator = beOp.getInput().getMessageParts().iterator();
        while (actualAttrIterator.hasNext()) {
            Attribute attribute = (Attribute)actualAttrIterator.next();
            actualAttributeNames.add(attribute.getObjectName());
        }
        return ((Object)attributeNames).equals(actualAttributeNames);
    }

    public IExternalOperationConfig getExternalOperationConfig(BusinessEntityInterface be, int operationPattern, String operationName, Set attributeNames) throws ResourceException, NotFoundException, InvocationException, EngineException, SQLException {
        Vector mappingRuleIds;
        IMessage inputMessage;
        String inputSourceMessageId;
        Iterator i = be.getOperations().iterator();
        Operation beOp = null;
        while (i.hasNext()) {
            beOp = (Operation)i.next();
            if (operationPattern == 5) {
                if (beOp.getPatternType() != 5 && beOp.getPatternType() != 8) {
                    beOp = null;
                    continue;
                }
            } else if (beOp.getPatternType() != operationPattern) {
                beOp = null;
                continue;
            }
            if ((operationName == null || operationName.equals(beOp.getObjectName())) && (attributeNames == null || RuntimeHelper.checkAttributeNames(beOp, attributeNames))) break;
            beOp = null;
        }
        if (beOp == null) {
            throw new NotFoundException();
        }
        MpOperation mpOp = this.operationMapper.getMapping(beOp);
        if (mpOp == null) {
            return null;
        }
        IMappingService mappingService = MpHelper.getMappingService();
        if (beOp.getInput() != null) {
            inputSourceMessageId = beOp.getInput().getObjectId();
            inputMessage = MpHelper.readMessage(inputSourceMessageId);
        } else {
            inputSourceMessageId = null;
            inputMessage = null;
        }
        String inputTargetMessageId = mpOp.getOperation().getInputOperationpart() != null ? mpOp.getOperation().getInputOperationpart().getMessage().getUuid() : null;
        String outputSourceMessageId = mpOp.getOperation().getOutputOperationpart() != null ? mpOp.getOperation().getOutputOperationpart().getMessage().getUuid() : null;
        String outputTargetMessageId = beOp.getOutput() != null ? beOp.getOutput().getObjectId() : null;
        String inputMappingRuleId = null;
        if (inputSourceMessageId != null && inputTargetMessageId != null && (mappingRuleIds = mappingService.getMappingRuleIds(inputSourceMessageId, inputTargetMessageId)) != null && !mappingRuleIds.isEmpty()) {
            inputMappingRuleId = (String)mappingRuleIds.firstElement();
        }
        String outputMappingRuleId = null;
        if (outputSourceMessageId != null && outputTargetMessageId != null && (mappingRuleIds = mappingService.getMappingRuleIds(outputSourceMessageId, outputTargetMessageId)) != null && !mappingRuleIds.isEmpty()) {
            outputMappingRuleId = (String)mappingRuleIds.firstElement();
        }
        return new ExternalOperationConfig(inputMessage, mpOp.getServiceDefinition().getId(), mpOp.getOperation().getName(), inputMappingRuleId, outputMappingRuleId, beOp.getPatternType() == 8);
    }

    static {
        simpleTypeMapping.put(new String(typePrfix + "base64Binary"), new Integer(1));
        simpleTypeMapping.put(new String(typePrfix + "boolean"), new Integer(2));
        simpleTypeMapping.put(new String(typePrfix + "byte"), new Integer(3));
        simpleTypeMapping.put(new String(typePrfix + "date"), new Integer(4));
        simpleTypeMapping.put(new String(typePrfix + "decimal"), new Integer(5));
        simpleTypeMapping.put(new String(typePrfix + "double"), new Integer(6));
        simpleTypeMapping.put(new String(typePrfix + "float"), new Integer(7));
        simpleTypeMapping.put(new String(typePrfix + "int"), new Integer(8));
        simpleTypeMapping.put(new String(typePrfix + "integer"), new Integer(9));
        simpleTypeMapping.put(new String(typePrfix + "long"), new Integer(10));
        simpleTypeMapping.put(new String(typePrfix + "short"), new Integer(11));
        simpleTypeMapping.put(new String(typePrfix + "string"), new Integer(12));
        simpleTypeMapping.put(new String(typePrfix + "time"), new Integer(13));
        simpleTypeMapping.put(new String(typePrfix + "timestamp"), new Integer(14));
        simpleTypeMapping.put(new String(typePrfix + "unsignedByte"), new Integer(15));
        simpleTypeMapping.put(new String(typePrfix + "unsignedInt"), new Integer(16));
        simpleTypeMapping.put(new String(typePrfix + "unsignedLong"), new Integer(17));
        simpleTypeMapping.put(new String(typePrfix + "unsignedShort"), new Integer(18));
    }
}

