/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp_mmr_bridge.mapping.impl;

import com.sap.caf.metamodel.BusinessEntityInterface;
import com.sap.caf.metamodel.Operation;
import com.sap.caf.metamodel.OperationMapping;
import com.sap.caf.mp_mmr_bridge.mapping.IOperationMapper;
import com.sap.caf.mp_mmr_bridge.mapping.MpOperation;
import com.sap.caf.mp_mmr_bridge.mapping.NotFoundException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class OperationMapper
implements IOperationMapper {
    private DataSource dataSource;

    public OperationMapper() throws NamingException {
        InitialContext ctx = new InitialContext();
        this.dataSource = (DataSource)ctx.lookup("jdbc/SAP/CAF_RT");
    }

    public void map(Operation beOperation, MpOperation mpOperation) throws SQLException {
        this.map(beOperation.getObjectId(), mpOperation);
    }

    public void unmap(Operation beOperation) throws SQLException {
        this.map(beOperation, null);
    }

    public MpOperation getMapping(Operation beOperation) throws SQLException {
        return this.getMapping(beOperation.getObjectId(), beOperation);
    }

    public void map(String beOperationId, MpOperation mpOperation) throws SQLException {
        Connection conn = this.dataSource.getConnection();
        conn.setAutoCommit(false);
        try {
            PreparedStatement stmtDelete = conn.prepareStatement("DELETE FROM caf_core_opmap WHERE be_op_id = ?");
            stmtDelete.setString(1, beOperationId);
            stmtDelete.executeUpdate();
            PreparedStatement stmtInsert = conn.prepareStatement("INSERT INTO caf_core_opmap (be_op_id, srv_def_id, mp_op_name) VALUES (?, ?, ?)");
            stmtInsert.setString(1, beOperationId);
            if (mpOperation != null) {
                stmtInsert.setString(2, mpOperation.getServiceDefinition().getId());
                stmtInsert.setString(3, mpOperation.getOperation().getName());
            } else {
                stmtInsert.setString(2, null);
                stmtInsert.setString(3, null);
            }
            stmtInsert.executeUpdate();
            conn.commit();
        }
        catch (SQLException e) {
            try {
                conn.rollback();
            }
            catch (SQLException f) {
                // empty catch block
            }
            throw e;
        }
        finally {
            try {
                conn.setAutoCommit(true);
                conn.close();
            }
            catch (SQLException e) {}
        }
    }

    public void unmap(String beOperationId) throws SQLException {
        this.map(beOperationId, null);
    }

    public MpOperation getMapping(String beOperationId) throws SQLException {
        return this.getMapping(beOperationId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MpOperation getMapping(String beOperationId, Operation beOperation) throws SQLException {
        Connection conn = this.dataSource.getConnection();
        try {
            PreparedStatement stmt = conn.prepareStatement("SELECT srv_def_id, mp_op_name FROM caf_core_opmap WHERE be_op_id = ?");
            stmt.setString(1, beOperationId);
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                String serviceDefinitionId = rs.getString("srv_def_id");
                String operationName = rs.getString("mp_op_name");
                if (rs.wasNull()) {
                    MpOperation mpOperation = null;
                    return mpOperation;
                }
                MpOperation mpOperation = new MpOperation(serviceDefinitionId, operationName);
                return mpOperation;
            }
        }
        finally {
            conn.close();
        }
        List operationMappings = ((BusinessEntityInterface)beOperation.getMOFInterface()).getOperationMappings();
        Iterator i = operationMappings.iterator();
        OperationMapping operationMapping = null;
        while (i.hasNext()) {
            operationMapping = (OperationMapping)i.next();
            if (operationMapping.getSource() == null) continue;
            if (operationMapping.getSource().getObjectId().equals(beOperation.getObjectId())) break;
            operationMapping = null;
        }
        if (operationMapping != null) {
            try {
                return new MpOperation(operationMapping.getTarget().getMOFInterface().getObjectId(), operationMapping.getTarget().getObjectName());
            }
            catch (NotFoundException e) {
                return null;
            }
        }
        return null;
    }
}

