/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp_mmr_bridge.mapping;

import com.sap.caf.mp.base.exception.EngineException;
import com.sap.caf.mp.core.data.service.interfce.api.IOperation;
import com.sap.caf.mp.core.data.service.interfce.api.IPorttype;
import com.sap.caf.mp.core.data.service.registry.IServiceDefinition;
import com.sap.caf.mp.core.data.service.registry.IServiceDefinitionInfo;
import com.sap.caf.mp_mmr_bridge.impl.MpHelper;
import com.sap.caf.mp_mmr_bridge.mapping.NotFoundException;

public class MpOperation
implements Comparable {
    private IServiceDefinition serviceDefinition;
    private IOperation operation;

    private static boolean isOperationValid(IServiceDefinition serviceDefinition, IOperation operation) {
        try {
            int i;
            IPorttype porttype = serviceDefinition.getPortType();
            for (i = 0; i < porttype.getOperationCount() && porttype.getOperation(i) != operation; ++i) {
            }
            if (i == porttype.getOperationCount()) {
                return false;
            }
        }
        catch (EngineException e) {
            return false;
        }
        return true;
    }

    public MpOperation(IServiceDefinition serviceDefinition, String operationName) throws NotFoundException {
        this.serviceDefinition = serviceDefinition;
        this.operation = MpHelper.readOperation(this.serviceDefinition, operationName);
        if (this.operation == null) {
            throw new NotFoundException();
        }
    }

    public MpOperation(IServiceDefinitionInfo serviceDefinitionInfo, String operationName) throws NotFoundException {
        this.serviceDefinition = MpHelper.readServiceDefintion(serviceDefinitionInfo.getId());
        if (this.serviceDefinition == null) {
            throw new NotFoundException();
        }
        this.operation = MpHelper.readOperation(this.serviceDefinition, operationName);
        if (this.operation == null) {
            throw new NotFoundException();
        }
    }

    public MpOperation(String serviceId, String operationName) throws NotFoundException {
        this.serviceDefinition = MpHelper.readServiceDefintion(serviceId);
        if (this.serviceDefinition == null) {
            throw new NotFoundException();
        }
        this.operation = MpHelper.readOperation(this.serviceDefinition, operationName);
        if (this.operation == null) {
            throw new NotFoundException();
        }
    }

    public MpOperation(IServiceDefinition serviceDefinition, int operationIndex) throws NotFoundException {
        this.serviceDefinition = serviceDefinition;
        this.operation = MpHelper.readOperation(this.serviceDefinition, operationIndex);
        if (this.operation == null) {
            throw new NotFoundException();
        }
    }

    public MpOperation(IServiceDefinitionInfo serviceDefinitionInfo, int operationIndex) throws NotFoundException {
        this.serviceDefinition = MpHelper.readServiceDefintion(serviceDefinitionInfo.getId());
        if (this.serviceDefinition == null) {
            throw new NotFoundException();
        }
        this.operation = MpHelper.readOperation(this.serviceDefinition, operationIndex);
        if (this.operation == null) {
            throw new NotFoundException();
        }
    }

    public MpOperation(String serviceId, int operationIndex) throws NotFoundException {
        this.serviceDefinition = MpHelper.readServiceDefintion(serviceId);
        if (this.serviceDefinition == null) {
            throw new NotFoundException();
        }
        this.operation = MpHelper.readOperation(this.serviceDefinition, operationIndex);
        if (this.operation == null) {
            throw new NotFoundException();
        }
    }

    public MpOperation(IServiceDefinition serviceDefinition, IOperation operation) throws NotFoundException {
        this.serviceDefinition = serviceDefinition;
        this.operation = operation;
        if (!MpOperation.isOperationValid(this.serviceDefinition, this.operation)) {
            throw new NotFoundException();
        }
    }

    public MpOperation(IServiceDefinitionInfo serviceDefinitionInfo, IOperation operation) throws NotFoundException {
        this.serviceDefinition = MpHelper.readServiceDefintion(serviceDefinitionInfo.getId());
        if (this.serviceDefinition == null) {
            throw new NotFoundException();
        }
        this.operation = operation;
        if (!MpOperation.isOperationValid(this.serviceDefinition, this.operation)) {
            throw new NotFoundException();
        }
    }

    public MpOperation(String serviceId, IOperation operation) throws NotFoundException {
        this.serviceDefinition = MpHelper.readServiceDefintion(serviceId);
        if (this.serviceDefinition == null) {
            throw new NotFoundException();
        }
        this.operation = operation;
        if (!MpOperation.isOperationValid(this.serviceDefinition, this.operation)) {
            throw new NotFoundException();
        }
    }

    public IServiceDefinition getServiceDefinition() {
        return this.serviceDefinition;
    }

    public IOperation getOperation() {
        return this.operation;
    }

    public boolean equals(Object o) {
        MpOperation other = (MpOperation)o;
        return this.serviceDefinition.getId().equals(other.getServiceDefinition().getId()) && this.operation.getName().equals(other.getOperation().getName());
    }

    public int hashCode() {
        return this.serviceDefinition.getId().hashCode() + this.operation.getName().hashCode();
    }

    public int compareTo(Object o) {
        MpOperation other = (MpOperation)o;
        int tempResult = this.serviceDefinition.getId().compareTo(other.getServiceDefinition().getId());
        if (tempResult != 0) {
            return tempResult;
        }
        return this.operation.getName().compareTo(other.getOperation().getName());
    }
}

