/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp_mmr_bridge.impl;

import com.sap.caf.mp.base.exception.EngineException;
import com.sap.caf.mp.base.exception.InvocationException;
import com.sap.caf.mp.core.ICoreFactory;
import com.sap.caf.mp.core.data.mapping.api.IMappingService;
import com.sap.caf.mp.core.data.persistence.api.IServiceDescriptionPersistence;
import com.sap.caf.mp.core.data.service.IDataServiceFactory;
import com.sap.caf.mp.core.data.service.interfce.api.IOperation;
import com.sap.caf.mp.core.data.service.registry.IServiceDefinition;
import com.sap.caf.mp.core.data.service.registry.IServicesRegistry;
import com.sap.caf.mp.core.data.types.api.IMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class MpHelper {
    private static ICoreFactory coreFactory;
    private static IDataServiceFactory dataServiceFactory;
    private static IServicesRegistry servicesRegistry;
    private static IServiceDescriptionPersistence serviceDescriptionPersistence;
    private static IMappingService mappingService;

    public static IServicesRegistry getServicesRegistry() {
        return servicesRegistry;
    }

    public static IServiceDescriptionPersistence getServiceDescriptionPersistence() {
        return serviceDescriptionPersistence;
    }

    public static IMappingService getMappingService() {
        return mappingService;
    }

    public static IServiceDefinition readServiceDefintion(String id) {
        try {
            return servicesRegistry.readServiceDefinition(id);
        }
        catch (EngineException e) {
            return null;
        }
        catch (InvocationException e) {
            return null;
        }
    }

    public static IOperation readOperation(IServiceDefinition serviceDefinition, String operationName) {
        try {
            return serviceDefinition.getPortType().getOperation(operationName);
        }
        catch (EngineException e) {
            return null;
        }
    }

    public static IOperation readOperation(IServiceDefinition serviceDefinition, int operationIndex) {
        try {
            return serviceDefinition.getPortType().getOperation(operationIndex);
        }
        catch (EngineException e) {
            return null;
        }
    }

    public static IMessage readMessage(String messageId) {
        try {
            return serviceDescriptionPersistence.readMessage(messageId);
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        try {
            InitialContext context = new InitialContext();
            coreFactory = (ICoreFactory)context.lookup("/sap.com/com.sap.caf/CoreFactory");
            dataServiceFactory = coreFactory.getDataServiceFactory();
            servicesRegistry = dataServiceFactory.getServicesRegistry();
            serviceDescriptionPersistence = dataServiceFactory.getServiceDescriptionPersistence();
            mappingService = dataServiceFactory.getMappingService();
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }
}

