/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.template.generation;

import com.sap.ide.metamodel.core.repository.IMMRepositoryObjectProvider;
import com.sap.ide.metamodel.core.repository.RepositoryServices;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.controller.ControllerEventHandler;
import com.sap.ide.metamodel.webdynpro.component.controller.ControllerMethod;
import com.sap.ide.metamodel.webdynpro.repository.MMRepositoryObjectProvider;
import com.sap.ide.tools.core.template.generation.GenerationFacade;
import com.sap.ide.tools.core.template.service.GenerationPositionEnum;
import com.sap.ide.webdynpro.controllereditor.ControllerEditorPart;
import com.sap.ide.webdynpro.controllereditor.implementation.JavaImplementationEditor;
import com.sap.ide.webdynpro.service.controllereditor.implementation.AmbiguousImportsException;
import com.sap.ide.webdynpro.service.controllereditor.implementation.ImplementationService;
import com.sap.ide.webdynpro.service.core.EditorService;
import java.util.Vector;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.ui.IEditorPart;

public class TemplateGenerationWebDynpro
extends GenerationFacade {
    public static final String METHODBEGIN = "//@@begin";
    public static final String METHODEND = "//@@end";
    public static final String SERVEREVENT = "(ServerEvent)";
    public static final String TEMPLATEBEGIN = "//$$begin";
    public static final String TEMPLATEEND = "//$$end";
    public static final String CONTROLLERINIT = "wdDoInit";
    public static final String CONTROLLEREXIT = "wdDoExit";
    public static final String NOPARAMETERS = "(";

    public boolean updateSources(String projectName) {
        try {
            ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).build(10, "com.sap.ide.webdynpro.generation.GenerationBuilder", null, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            return false;
        }
        return true;
    }

    public void insert(DevelopmentObject object, GenerationPositionEnum position, String code) {
        Controller controller = null;
        if (object instanceof ControllerEventHandler) {
            ControllerEventHandler lEventHandler = (ControllerEventHandler)object;
            controller = (Controller)lEventHandler.getMDO();
            this.addDependant((DevelopmentObject)controller);
            this.insertCodeInEventHandler(controller, lEventHandler, position, code);
        } else if (object instanceof ControllerMethod) {
            ControllerMethod lMethod = (ControllerMethod)object;
            controller = (Controller)lMethod.getMDO();
            this.addDependant((DevelopmentObject)controller);
            this.insertCodeInMethod(controller, lMethod, position, code);
        } else if (object instanceof Controller) {
            controller = (Controller)object;
            this.addDependant((DevelopmentObject)controller);
            if (position == GenerationPositionEnum.INITBEFORE || position == GenerationPositionEnum.INITAFTER) {
                this.insertCodeInControllerInit(controller, position, code);
            } else if (position == GenerationPositionEnum.EXITBEFORE || position == GenerationPositionEnum.EXITAFTER) {
                this.insertCodeInControllerExit(controller, position, code);
            }
        }
        if (controller != null) {
            ImplementationService lService = new ImplementationService(controller);
            lService.updateImplementationFromXML();
        }
    }

    private String getCodeBody(Controller controller, String name, GenerationPositionEnum position) {
        IMethod method;
        ResourcesPlugin.getWorkspace().checkpoint(false);
        String source = "";
        source = controller.getCodeBody();
        boolean bDefaultMethod = position != GenerationPositionEnum.EXITAFTER || position != GenerationPositionEnum.EXITBEFORE || position != GenerationPositionEnum.INITAFTER || position != GenerationPositionEnum.INITBEFORE;
        String lMethodBeginSignature = " " + name + NOPARAMETERS;
        if ((source == null || source.equals("") || source.indexOf(lMethodBeginSignature) == -1 && bDefaultMethod) && (method = ImplementationService.getJDTMethod((Controller)controller, (String)name, (IProgressMonitor)new NullProgressMonitor())) != null) {
            try {
                source = method.getCompilationUnit().getSource();
            }
            catch (JavaModelException e) {
                // empty catch block
            }
        }
        return source;
    }

    private void insertCodeInEventHandler(Controller controller, ControllerEventHandler eventHandler, GenerationPositionEnum position, String code) {
        String lCodeBody = this.getCodeBody(controller, eventHandler.getName(), position);
        String lSearchString = "//@@begin " + eventHandler.getName() + SERVEREVENT;
        this.insertCodeInController(controller, lSearchString, code, lCodeBody, position, this.generateId((DevelopmentObject)eventHandler, code));
    }

    private void insertCodeInMethod(Controller controller, ControllerMethod method, GenerationPositionEnum position, String code) {
        String lCodeBody = this.getCodeBody(controller, method.getName(), position);
        String lSearchString = "//@@begin " + method.getName() + NOPARAMETERS;
        this.insertCodeInController(controller, lSearchString, code, lCodeBody, position, this.generateId((DevelopmentObject)method, code));
    }

    private void insertCodeInControllerInit(Controller controller, GenerationPositionEnum position, String code) {
        String lCodeBody = this.getCodeBody(controller, CONTROLLERINIT, position);
        String lSearchString = "//@@begin wdDoInit(";
        if (position == GenerationPositionEnum.INITBEFORE) {
            this.insertCodeInController(controller, lSearchString, code, lCodeBody, GenerationPositionEnum.BEFORE, this.generateId((DevelopmentObject)controller, code));
        } else if (position == GenerationPositionEnum.INITAFTER) {
            this.insertCodeInController(controller, lSearchString, code, lCodeBody, GenerationPositionEnum.AFTER, this.generateId((DevelopmentObject)controller, code));
        }
    }

    private void insertCodeInControllerExit(Controller controller, GenerationPositionEnum position, String code) {
        String lCodeBody = this.getCodeBody(controller, CONTROLLEREXIT, position);
        String lSearchString = "//@@begin wdDoExit(";
        if (position == GenerationPositionEnum.EXITBEFORE) {
            this.insertCodeInController(controller, lSearchString, code, lCodeBody, GenerationPositionEnum.BEFORE, this.generateId((DevelopmentObject)controller, code));
        } else if (position == GenerationPositionEnum.EXITAFTER) {
            this.insertCodeInController(controller, lSearchString, code, lCodeBody, GenerationPositionEnum.AFTER, this.generateId((DevelopmentObject)controller, code));
        }
    }

    private void insertCodeInController(Controller controller, String searchString, String code, String codeBody, GenerationPositionEnum position, String id) {
        int lPos = codeBody.indexOf(searchString);
        if (lPos > -1) {
            lPos = lPos + searchString.length() + 1;
            String before = codeBody.substring(0, lPos);
            String after = codeBody.substring(lPos, codeBody.length());
            if (position == GenerationPositionEnum.AFTER && (lPos = after.indexOf(METHODEND)) > -1) {
                before = before + after.substring(0, lPos);
                after = after.substring(lPos);
            }
            String newCode = before + "\n\t" + TEMPLATEBEGIN + " " + id + "\n" + code + "\n\t" + TEMPLATEEND;
            newCode = position == GenerationPositionEnum.AFTER ? newCode + "\n" + after : newCode + after;
            controller.setCodeBody(newCode);
        }
    }

    public boolean checkWritability(MainDevelopmentObject[] mdos) {
        IMMRepositoryObjectProvider provider = MMRepositoryObjectProvider.getInstance();
        if (provider != null && mdos != null) {
            return RepositoryServices.checkWriteability((MainDevelopmentObject[])mdos, (IMMRepositoryObjectProvider)provider);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateDependant() {
        Vector mDependants = this.getDependants();
        int i = 0;
        while (i < mDependants.size()) {
            if (mDependants.get(i) instanceof Controller) {
                ImplementationService lService;
                block11: {
                    Object var9_9;
                    Controller controller = (Controller)mDependants.get(i);
                    lService = new ImplementationService(controller);
                    IEditorPart editorPart = EditorService.findDevelopmentObjectEditor((DevelopmentObject)controller);
                    JavaImplementationEditor implementationEditor = null;
                    if (editorPart instanceof ControllerEditorPart) {
                        ControllerEditorPart controllerPart = (ControllerEditorPart)editorPart;
                        implementationEditor = controllerPart.getImplementationEditor();
                    }
                    lService.setJavaEditor(implementationEditor);
                    if (implementationEditor != null) {
                        implementationEditor.setNoUpdateOfMetadata(true);
                    }
                    try {
                        try {
                            lService.organizeImports(false, null);
                        }
                        catch (AmbiguousImportsException e) {
                            var9_9 = null;
                            if (implementationEditor != null) {
                                implementationEditor.setNoUpdateOfMetadata(false);
                            }
                            break block11;
                        }
                        var9_9 = null;
                        if (implementationEditor == null) break block11;
                    }
                    catch (Throwable throwable) {
                        var9_9 = null;
                        if (implementationEditor != null) {
                            implementationEditor.setNoUpdateOfMetadata(false);
                        }
                        throw throwable;
                    }
                    implementationEditor.setNoUpdateOfMetadata(false);
                }
                lService.updateImplementationFromXML();
            }
            ++i;
        }
        return;
    }
}

