/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.wizards.newresource;

import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.dialogs.WizardNewProjectReferencePage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.MessageDialogWithToggle;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.eclipse.ui.wizards.newresource.ResourceMessages;

public class BasicNewProjectResourceWizard
extends BasicNewResourceWizard
implements IExecutableExtension {
    private WizardNewProjectCreationPage mainPage;
    private WizardNewProjectReferencePage referencePage;
    private IProject newProject;
    private IConfigurationElement configElement;
    private static String WINDOW_PROBLEMS_TITLE = ResourceMessages.getString("NewProject.errorOpeningWindow");
    private static final String FINAL_PERSPECTIVE = "finalPerspective";
    private static final String PREFERRED_PERSPECTIVES = "preferredPerspectives";

    public BasicNewProjectResourceWizard() {
        AbstractUIPlugin plugin = (AbstractUIPlugin)Platform.getPlugin((String)"org.eclipse.ui");
        IDialogSettings workbenchSettings = plugin.getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection("BasicNewProjectResourceWizard");
        if (section == null) {
            section = workbenchSettings.addNewSection("BasicNewProjectResourceWizard");
        }
        this.setDialogSettings(section);
    }

    public void addPages() {
        super.addPages();
        this.mainPage = new WizardNewProjectCreationPage("basicNewProjectPage");
        this.mainPage.setTitle(ResourceMessages.getString("NewProject.title"));
        this.mainPage.setDescription(ResourceMessages.getString("NewProject.description"));
        this.addPage((IWizardPage)this.mainPage);
        if (ResourcesPlugin.getWorkspace().getRoot().getProjects().length > 0) {
            this.referencePage = new WizardNewProjectReferencePage("basicReferenceProjectPage");
            this.referencePage.setTitle(ResourceMessages.getString("NewProject.referenceTitle"));
            this.referencePage.setDescription(ResourceMessages.getString("NewProject.referenceDescription"));
            this.addPage((IWizardPage)this.referencePage);
        }
    }

    private IProject createNewProject() {
        IProject[] refProjects;
        if (this.newProject != null) {
            return this.newProject;
        }
        final IProject newProjectHandle = this.mainPage.getProjectHandle();
        IPath newPath = null;
        if (!this.mainPage.useDefaults()) {
            newPath = this.mainPage.getLocationPath();
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final IProjectDescription description = workspace.newProjectDescription(newProjectHandle.getName());
        description.setLocation(newPath);
        if (this.referencePage != null && (refProjects = this.referencePage.getReferencedProjects()).length > 0) {
            description.setReferencedProjects(refProjects);
        }
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                BasicNewProjectResourceWizard.this.createProject(description, newProjectHandle, monitor);
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof CoreException) {
                if (((CoreException)t).getStatus().getCode() == 275) {
                    MessageDialog.openError((Shell)this.getShell(), (String)ResourceMessages.getString("NewProject.errorMessage"), (String)ResourceMessages.format("NewProject.caseVariantExistsError", new String[]{newProjectHandle.getName()}));
                } else {
                    ErrorDialog.openError((Shell)this.getShell(), (String)ResourceMessages.getString("NewProject.errorMessage"), null, (IStatus)((CoreException)t).getStatus());
                }
            } else {
                Platform.getPlugin((String)"org.eclipse.ui").getLog().log((IStatus)new Status(4, "org.eclipse.ui", 0, t.toString(), t));
                MessageDialog.openError((Shell)this.getShell(), (String)ResourceMessages.getString("NewProject.errorMessage"), (String)ResourceMessages.format("NewProject.internalError", new Object[]{t.getMessage()}));
            }
            return null;
        }
        this.newProject = newProjectHandle;
        return this.newProject;
    }

    private void createProject(IProjectDescription description, IProject projectHandle, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        try {
            monitor.beginTask("", 2000);
            projectHandle.create(description, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            projectHandle.open((IProgressMonitor)new SubProgressMonitor(monitor, 1000));
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            monitor.done();
            throw throwable;
        }
        Object var4_6 = null;
        monitor.done();
    }

    public IProject getNewProject() {
        return this.newProject;
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        super.init(workbench, currentSelection);
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(ResourceMessages.getString("NewProject.windowTitle"));
    }

    protected void initializeDefaultPageImageDescriptor() {
        String iconPath = "icons/full/";
        try {
            URL installURL = Platform.getPlugin((String)"org.eclipse.ui").getDescriptor().getInstallURL();
            URL url = new URL(installURL, String.valueOf(iconPath) + "wizban/newprj_wiz.gif");
            ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
            this.setDefaultPageImageDescriptor(desc);
        }
        catch (MalformedURLException malformedURLException) {}
    }

    private static void openInNewWindow(IPerspectiveDescriptor desc) {
        block2: {
            try {
                PlatformUI.getWorkbench().openWorkbenchWindow(desc.getId(), (IAdaptable)ResourcesPlugin.getWorkspace().getRoot());
            }
            catch (WorkbenchException e) {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window == null) break block2;
                ErrorDialog.openError((Shell)window.getShell(), (String)WINDOW_PROBLEMS_TITLE, (String)((Throwable)((Object)e)).getMessage(), (IStatus)e.getStatus());
            }
        }
    }

    public boolean performFinish() {
        this.createNewProject();
        if (this.newProject == null) {
            return false;
        }
        this.updatePerspective();
        this.selectAndReveal((IResource)this.newProject);
        return true;
    }

    private static void replaceCurrentPerspective(IPerspectiveDescriptor persp) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return;
        }
        page.setPerspective(persp);
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        this.configElement = cfig;
    }

    protected void updatePerspective() {
        BasicNewProjectResourceWizard.updatePerspective(this.configElement);
    }

    public static void updatePerspective(IConfigurationElement configElement) {
        IWorkbenchWindow window;
        if (configElement == null) {
            return;
        }
        AbstractUIPlugin uiPlugin = (AbstractUIPlugin)Platform.getPlugin((String)"org.eclipse.ui");
        String perspSetting = uiPlugin.getPreferenceStore().getString("PROJECT_OPEN_NEW_PERSPECTIVE");
        if (perspSetting.equals("NO_NEW_PERSPECTIVE")) {
            return;
        }
        String finalPerspId = configElement.getAttribute(FINAL_PERSPECTIVE);
        if (finalPerspId == null) {
            return;
        }
        IPerspectiveRegistry reg = PlatformUI.getWorkbench().getPerspectiveRegistry();
        IPerspectiveDescriptor finalPersp = reg.findPerspectiveWithId(finalPerspId);
        if (finalPersp == null) {
            WorkbenchPlugin.log("Unable to find persective " + finalPerspId + " in BasicNewProjectResourceWizard.updatePerspective");
            return;
        }
        ArrayList<String> preferredPerspIds = new ArrayList<String>();
        preferredPerspIds.add(finalPerspId);
        String preferred = configElement.getAttribute(PREFERRED_PERSPECTIVES);
        if (preferred != null) {
            StringTokenizer tok = new StringTokenizer(preferred, " \t\n\r\f,");
            while (tok.hasMoreTokens()) {
                preferredPerspIds.add(tok.nextToken());
            }
        }
        if ((window = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null) {
            IPerspectiveDescriptor currentPersp;
            IWorkbenchPage page = window.getActivePage();
            if (page != null && (currentPersp = page.getPerspective()) != null && preferredPerspIds.contains(currentPersp.getId())) {
                return;
            }
            if (!BasicNewProjectResourceWizard.confirmPerspectiveSwitch(window, finalPersp)) {
                return;
            }
        }
        if (perspSetting.equals("OPEN_PERSPECTIVE_WINDOW")) {
            BasicNewProjectResourceWizard.openInNewWindow(finalPersp);
            return;
        }
        if (perspSetting.equals("OPEN_PERSPECTIVE_REPLACE")) {
            BasicNewProjectResourceWizard.replaceCurrentPerspective(finalPersp);
            return;
        }
    }

    private static boolean confirmPerspectiveSwitch(IWorkbenchWindow window, IPerspectiveDescriptor finalPersp) {
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        String pspm = store.getString("SWITCH_PERSPECTIVE_ON_PROJECT_CREATION");
        if (!"prompt".equals(pspm)) {
            return true;
        }
        MessageDialogWithToggle dialog = MessageDialogWithToggle.openQuestion(window.getShell(), ResourceMessages.getString("NewProject.perspSwitchTitle"), ResourceMessages.format("NewProject.perspSwitchMessage", new Object[]{finalPersp.getLabel()}), null, false);
        int result = dialog.getReturnCode();
        if (result >= 0 && dialog.getToggleState()) {
            if (result == 0) {
                store.setValue("SWITCH_PERSPECTIVE_ON_PROJECT_CREATION", "always");
            } else {
                store.setValue("SWITCH_PERSPECTIVE_ON_PROJECT_CREATION", "never");
                AbstractUIPlugin uiPlugin = (AbstractUIPlugin)Platform.getPlugin((String)"org.eclipse.ui");
                uiPlugin.getPreferenceStore().setValue("PROJECT_OPEN_NEW_PERSPECTIVE", "NO_NEW_PERSPECTIVE");
            }
        }
        return result == 0;
    }
}

