/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.part;

import java.util.ArrayList;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.PopupMenuExtender;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageSelectionProvider;

public class MultiPageEditorSite
implements IEditorSite {
    private IEditorPart editor;
    private MultiPageEditorPart multiPageEditor;
    private ISelectionProvider selectionProvider = null;
    private ISelectionChangedListener selectionChangedListener = null;
    private ArrayList menuExtenders;

    public MultiPageEditorSite(MultiPageEditorPart multiPageEditor, IEditorPart editor) {
        Assert.isNotNull((Object)multiPageEditor);
        Assert.isNotNull((Object)editor);
        this.multiPageEditor = multiPageEditor;
        this.editor = editor;
    }

    public void dispose() {
        if (this.menuExtenders != null) {
            int i = 0;
            while (i < this.menuExtenders.size()) {
                ((PopupMenuExtender)this.menuExtenders.get(i)).dispose();
                ++i;
            }
            this.menuExtenders = null;
        }
    }

    public IEditorActionBarContributor getActionBarContributor() {
        return null;
    }

    public IActionBars getActionBars() {
        return this.multiPageEditor.getEditorSite().getActionBars();
    }

    public ILabelDecorator getDecoratorManager() {
        return this.getWorkbenchWindow().getWorkbench().getDecoratorManager().getLabelDecorator();
    }

    public IEditorPart getEditor() {
        return this.editor;
    }

    public String getId() {
        return "";
    }

    public IKeyBindingService getKeyBindingService() {
        return this.getMultiPageEditor().getEditorSite().getKeyBindingService();
    }

    public MultiPageEditorPart getMultiPageEditor() {
        return this.multiPageEditor;
    }

    public IWorkbenchPage getPage() {
        return this.getMultiPageEditor().getSite().getPage();
    }

    public String getPluginId() {
        return "";
    }

    public String getRegisteredName() {
        return "";
    }

    private ISelectionChangedListener getSelectionChangedListener() {
        if (this.selectionChangedListener == null) {
            this.selectionChangedListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    MultiPageEditorSite.this.handleSelectionChanged(event);
                }
            };
        }
        return this.selectionChangedListener;
    }

    public ISelectionProvider getSelectionProvider() {
        return this.selectionProvider;
    }

    public Shell getShell() {
        return this.getMultiPageEditor().getSite().getShell();
    }

    public IWorkbenchWindow getWorkbenchWindow() {
        return this.getMultiPageEditor().getSite().getWorkbenchWindow();
    }

    protected void handleSelectionChanged(SelectionChangedEvent event) {
        ISelectionProvider parentProvider = this.getMultiPageEditor().getSite().getSelectionProvider();
        if (parentProvider instanceof MultiPageSelectionProvider) {
            SelectionChangedEvent newEvent = new SelectionChangedEvent(parentProvider, event.getSelection());
            ((MultiPageSelectionProvider)parentProvider).fireSelectionChanged(newEvent);
        }
    }

    public void registerContextMenu(String menuID, MenuManager menuMgr, ISelectionProvider selProvider) {
        if (this.menuExtenders == null) {
            this.menuExtenders = new ArrayList(1);
        }
        this.menuExtenders.add(new PopupMenuExtender(menuID, menuMgr, selProvider, this.editor));
    }

    public void registerContextMenu(MenuManager menuManager, ISelectionProvider selectionProvider) {
        this.getMultiPageEditor().getSite().registerContextMenu(menuManager, selectionProvider);
    }

    public void setSelectionProvider(ISelectionProvider provider) {
        ISelectionProvider oldSelectionProvider = this.selectionProvider;
        this.selectionProvider = provider;
        if (oldSelectionProvider != null) {
            oldSelectionProvider.removeSelectionChangedListener(this.getSelectionChangedListener());
        }
        if (this.selectionProvider != null) {
            this.selectionProvider.addSelectionChangedListener(this.getSelectionChangedListener());
        }
    }
}

