/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.part;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.eclipse.ui.part.MultiPageSelectionProvider;

public abstract class MultiPageEditorPart
extends EditorPart {
    private CTabFolder container;
    private ArrayList nestedEditors = new ArrayList(3);

    protected MultiPageEditorPart() {
    }

    public int addPage(Control control) {
        this.createItem(control);
        return this.getPageCount() - 1;
    }

    public int addPage(IEditorPart editor, IEditorInput input) throws PartInitException {
        IEditorSite site = this.createSite(editor);
        editor.init(site, input);
        Composite parent2 = new Composite(this.getContainer(), 0);
        parent2.setLayout((Layout)new FillLayout());
        editor.createPartControl(parent2);
        editor.addPropertyListener(new IPropertyListener(){

            public void propertyChanged(Object source, int propertyId) {
                MultiPageEditorPart.this.handlePropertyChange(propertyId);
            }
        });
        CTabItem item = this.createItem((Control)parent2);
        item.setData((Object)editor);
        this.nestedEditors.add(editor);
        return this.getPageCount() - 1;
    }

    private CTabFolder createContainer(Composite parent) {
        final CTabFolder container = new CTabFolder(parent, 1024);
        container.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int newPageIndex = container.indexOf((CTabItem)e.item);
                MultiPageEditorPart.this.pageChange(newPageIndex);
            }
        });
        return container;
    }

    private CTabItem createItem(Control control) {
        CTabItem item = new CTabItem(this.getTabFolder(), 0);
        item.setControl(control);
        return item;
    }

    protected abstract void createPages();

    public final void createPartControl(Composite parent) {
        this.container = this.createContainer(parent);
        this.createPages();
        if (this.getActivePage() == -1) {
            this.setActivePage(0);
        }
    }

    protected IEditorSite createSite(IEditorPart editor) {
        return new MultiPageEditorSite(this, editor);
    }

    public void dispose() {
        int i = 0;
        while (i < this.nestedEditors.size()) {
            IEditorPart editor = (IEditorPart)this.nestedEditors.get(i);
            this.disposePart(editor);
            ++i;
        }
        this.nestedEditors.clear();
    }

    protected IEditorPart getActiveEditor() {
        int index = this.getActivePage();
        if (index != -1) {
            return this.getEditor(index);
        }
        return null;
    }

    protected int getActivePage() {
        CTabFolder tabFolder = this.getTabFolder();
        if (tabFolder != null && !tabFolder.isDisposed()) {
            return tabFolder.getSelectionIndex();
        }
        return -1;
    }

    protected Composite getContainer() {
        return this.container;
    }

    protected Control getControl(int pageIndex) {
        return this.getItem(pageIndex).getControl();
    }

    protected IEditorPart getEditor(int pageIndex) {
        Object data;
        CTabItem item = this.getItem(pageIndex);
        if (item != null && (data = item.getData()) instanceof IEditorPart) {
            return (IEditorPart)data;
        }
        return null;
    }

    private CTabItem getItem(int pageIndex) {
        return this.getTabFolder().getItem(pageIndex);
    }

    protected int getPageCount() {
        CTabFolder folder = this.getTabFolder();
        if (folder != null && !folder.isDisposed()) {
            return folder.getItemCount();
        }
        return 0;
    }

    protected Image getPageImage(int pageIndex) {
        return this.getItem(pageIndex).getImage();
    }

    protected String getPageText(int pageIndex) {
        return this.getItem(pageIndex).getText();
    }

    private CTabFolder getTabFolder() {
        return this.container;
    }

    protected void handlePropertyChange(int propertyId) {
        this.firePropertyChange(propertyId);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite(site);
        this.setInput(input);
        site.setSelectionProvider(new MultiPageSelectionProvider(this));
    }

    public boolean isDirty() {
        Iterator i = ((AbstractList)this.nestedEditors).iterator();
        while (i.hasNext()) {
            IEditorPart editor = (IEditorPart)i.next();
            if (!editor.isDirty()) continue;
            return true;
        }
        return false;
    }

    protected void pageChange(int newPageIndex) {
        ISelectionProvider selectionProvider;
        Control control = this.getControl(newPageIndex);
        if (control != null) {
            control.setVisible(true);
        }
        this.setFocus();
        IEditorPart activeEditor = this.getEditor(newPageIndex);
        IEditorActionBarContributor contributor = this.getEditorSite().getActionBarContributor();
        if (contributor != null && contributor instanceof MultiPageEditorActionBarContributor) {
            ((MultiPageEditorActionBarContributor)contributor).setActivePage(activeEditor);
        }
        if (activeEditor != null && (selectionProvider = activeEditor.getSite().getSelectionProvider()) != null) {
            SelectionChangedEvent event = new SelectionChangedEvent(selectionProvider, selectionProvider.getSelection());
            ((MultiPageSelectionProvider)this.getSite().getSelectionProvider()).fireSelectionChanged(event);
        }
    }

    private void disposePart(final IWorkbenchPart part) {
        Platform.run((ISafeRunnable)new SafeRunnable(){

            public void run() {
                if (part.getSite() instanceof MultiPageEditorSite) {
                    MultiPageEditorSite partSite = (MultiPageEditorSite)part.getSite();
                    partSite.dispose();
                }
                part.dispose();
            }

            public void handleException(Throwable e) {
            }
        });
    }

    public void removePage(int pageIndex) {
        Assert.isTrue((pageIndex >= 0 && pageIndex < this.getPageCount() ? 1 : 0) != 0);
        IEditorPart editor = this.getEditor(pageIndex);
        this.getItem(pageIndex).dispose();
        if (editor != null) {
            ((AbstractCollection)this.nestedEditors).remove(editor);
            this.disposePart(editor);
        }
    }

    protected void setActivePage(int pageIndex) {
        Assert.isTrue((pageIndex >= 0 && pageIndex < this.getPageCount() ? 1 : 0) != 0);
        this.getTabFolder().setSelection(pageIndex);
    }

    protected void setControl(int pageIndex, Control control) {
        this.getItem(pageIndex).setControl(control);
    }

    public void setFocus() {
        int index = this.getActivePage();
        if (index != -1) {
            this.setFocus(index);
        }
    }

    private void setFocus(int pageIndex) {
        if (pageIndex < 0 || pageIndex >= this.getPageCount()) {
            return;
        }
        IEditorPart editor = this.getEditor(pageIndex);
        if (editor != null) {
            editor.setFocus();
        } else {
            Control control = this.getControl(pageIndex);
            if (control != null) {
                control.setFocus();
            }
        }
    }

    protected void setPageImage(int pageIndex, Image image) {
        this.getItem(pageIndex).setImage(image);
    }

    protected void setPageText(int pageIndex, String text) {
        this.getItem(pageIndex).setText(text);
    }
}

