/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import java.text.Collator;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.WizardCollectionElement;
import org.eclipse.ui.internal.dialogs.WorkbenchWizardElement;
import org.eclipse.ui.internal.misc.Sorter;
import org.eclipse.ui.internal.model.AdaptableList;
import org.eclipse.ui.internal.registry.Category;
import org.eclipse.ui.internal.registry.WizardsRegistryReader;

public class NewWizardsRegistryReader
extends WizardsRegistryReader {
    private boolean projectsOnly;
    private ArrayList deferWizards = null;
    private ArrayList deferCategories = null;
    public static final String BASE_CATEGORY = "Base";
    public static final String EXAMPLES_WIZARD_CATEGORY = "Examples";
    public static final String FULL_EXAMPLES_WIZARD_CATEGORY = "org.eclipse.ui.Examples";
    private static final String TAG_CATEGORY = "category";
    private static final String UNCATEGORIZED_WIZARD_CATEGORY = "org.eclipse.ui.Other";
    private static final String UNCATEGORIZED_WIZARD_CATEGORY_LABEL = WorkbenchMessages.getString("NewWizardsRegistryReader.otherCategory");
    private static final String CATEGORY_SEPARATOR = "/";
    private static final String ATT_CATEGORY = "category";
    private static final String ATT_PROJECT = "project";
    private static final String STR_TRUE = "true";

    public NewWizardsRegistryReader() {
        this(false);
    }

    public NewWizardsRegistryReader(boolean projectsOnly) {
        super("newWizards");
        this.projectsOnly = projectsOnly;
    }

    protected void addNewElementToResult(WorkbenchWizardElement element, IConfigurationElement config, AdaptableList result) {
        this.deferWizard(element);
    }

    protected WizardCollectionElement createCollectionElement(WizardCollectionElement parent, String id, String label) {
        WizardCollectionElement newElement = new WizardCollectionElement(id, label, parent);
        parent.add(newElement);
        return newElement;
    }

    protected AdaptableList createEmptyWizardCollection() {
        return new WizardCollectionElement("root", "root", null);
    }

    protected WorkbenchWizardElement createWizardElement(IConfigurationElement element) {
        String flag;
        if (this.projectsOnly && ((flag = element.getAttribute(ATT_PROJECT)) == null || !flag.equalsIgnoreCase(STR_TRUE))) {
            return null;
        }
        return super.createWizardElement(element);
    }

    private void deferCategory(IConfigurationElement config) {
        Category category = null;
        try {
            category = new Category(config);
        }
        catch (CoreException e) {
            WorkbenchPlugin.log("Cannot create category: ", e.getStatus());
            return;
        }
        if (this.deferCategories == null) {
            this.deferCategories = new ArrayList(20);
        }
        this.deferCategories.add(category);
    }

    private void deferWizard(WorkbenchWizardElement element) {
        if (this.deferWizards == null) {
            this.deferWizards = new ArrayList(50);
        }
        this.deferWizards.add(element);
    }

    private void finishCategories() {
        if (this.deferCategories == null) {
            return;
        }
        Object[] flatArray = new CategoryNode[this.deferCategories.size()];
        int i = 0;
        while (i < this.deferCategories.size()) {
            flatArray[i] = new CategoryNode((Category)this.deferCategories.get(i));
            ++i;
        }
        Sorter sorter = new Sorter(){
            private Collator collator = Collator.getInstance();

            public boolean compare(Object o1, Object o2) {
                String s1 = ((CategoryNode)o1).getPath();
                String s2 = ((CategoryNode)o2).getPath();
                return this.collator.compare(s2, s1) > 0;
            }
        };
        Object[] sortedCategories = sorter.sort(flatArray);
        int nX = 0;
        while (nX < sortedCategories.length) {
            Category cat = ((CategoryNode)sortedCategories[nX]).getCategory();
            this.finishCategory(cat);
            ++nX;
        }
        this.deferCategories = null;
    }

    private void finishCategory(Category category) {
        WizardCollectionElement test;
        WizardCollectionElement currentResult = (WizardCollectionElement)this.wizards;
        String[] categoryPath = category.getParentPath();
        WizardCollectionElement parent = currentResult;
        if (categoryPath != null) {
            int i = 0;
            while (i < categoryPath.length) {
                WizardCollectionElement tempElement = this.getChildWithID(parent, categoryPath[i]);
                if (tempElement == null) {
                    return;
                }
                parent = tempElement;
                ++i;
            }
        }
        if ((test = this.getChildWithID(parent, category.getId())) != null) {
            return;
        }
        if (parent != null) {
            this.createCollectionElement(parent, category.getId(), category.getLabel());
        }
    }

    private void finishWizard(WorkbenchWizardElement element, IConfigurationElement config, AdaptableList result) {
        WizardCollectionElement currentResult = (WizardCollectionElement)result;
        StringTokenizer familyTokenizer = new StringTokenizer(this.getCategoryStringFor(config), CATEGORY_SEPARATOR);
        WizardCollectionElement currentCollectionElement = currentResult;
        boolean moveToOther = false;
        while (familyTokenizer.hasMoreElements()) {
            WizardCollectionElement tempCollectionElement = this.getChildWithID(currentCollectionElement, familyTokenizer.nextToken());
            if (tempCollectionElement == null) {
                moveToOther = true;
                break;
            }
            currentCollectionElement = tempCollectionElement;
        }
        if (moveToOther) {
            this.moveElementToUncategorizedCategory(currentResult, element);
        } else {
            currentCollectionElement.add(element);
        }
    }

    private void finishWizards() {
        if (this.deferWizards != null) {
            Iterator iter = ((AbstractList)this.deferWizards).iterator();
            while (iter.hasNext()) {
                WorkbenchWizardElement wizard = (WorkbenchWizardElement)iter.next();
                IConfigurationElement config = wizard.getConfigurationElement();
                this.finishWizard(wizard, config, this.wizards);
            }
            this.deferWizards = null;
        }
    }

    protected String getCategoryStringFor(IConfigurationElement config) {
        String result = config.getAttribute("category");
        if (result == null) {
            result = UNCATEGORIZED_WIZARD_CATEGORY;
        }
        return result;
    }

    protected WizardCollectionElement getChildWithID(WizardCollectionElement parent, String id) {
        Object[] children = parent.getChildren();
        int i = 0;
        while (i < children.length) {
            WizardCollectionElement currentChild = (WizardCollectionElement)children[i];
            if (currentChild.getId().equals(id)) {
                return currentChild;
            }
            ++i;
        }
        return null;
    }

    protected void moveElementToUncategorizedCategory(WizardCollectionElement root, WorkbenchWizardElement element) {
        WizardCollectionElement otherCategory = this.getChildWithID(root, UNCATEGORIZED_WIZARD_CATEGORY);
        if (otherCategory == null) {
            otherCategory = this.createCollectionElement(root, UNCATEGORIZED_WIZARD_CATEGORY, UNCATEGORIZED_WIZARD_CATEGORY_LABEL);
        }
        otherCategory.add(element);
    }

    private void pruneEmptyCategories(WizardCollectionElement parent) {
        Object[] children = parent.getChildren();
        int nX = 0;
        while (nX < children.length) {
            boolean shouldPrune;
            WizardCollectionElement child = (WizardCollectionElement)children[nX];
            this.pruneEmptyCategories(child);
            boolean bl = shouldPrune = this.projectsOnly || child.getId().equals(FULL_EXAMPLES_WIZARD_CATEGORY);
            if (child.isEmpty() && shouldPrune) {
                parent.remove(child);
            }
            ++nX;
        }
    }

    protected boolean readElement(IConfigurationElement element) {
        if (element.getName().equals("category")) {
            this.deferCategory(element);
            return true;
        }
        return super.readElement(element);
    }

    protected void readWizards() {
        super.readWizards();
        this.finishCategories();
        this.finishWizards();
        if (this.wizards != null) {
            WizardCollectionElement parent = (WizardCollectionElement)this.wizards;
            this.pruneEmptyCategories(parent);
        }
    }

    private class CategoryNode {
        private Category category;
        private String path;

        public CategoryNode(Category cat) {
            this.category = cat;
            this.path = "";
            String[] categoryPath = this.category.getParentPath();
            if (categoryPath != null) {
                int nX = 0;
                while (nX < categoryPath.length) {
                    this.path = String.valueOf(this.path) + categoryPath[nX] + '/';
                    ++nX;
                }
            }
            this.path = String.valueOf(this.path) + cat.getId();
        }

        public String getPath() {
            return this.path;
        }

        public Category getCategory() {
            return this.category;
        }
    }
}

