/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import java.io.Serializable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.program.Program;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class EditorDescriptor
implements IEditorDescriptor,
Serializable {
    private String editorName;
    private String imageFilename;
    private transient ImageDescriptor imageDesc;
    private boolean testImage = true;
    private String className;
    private String launcherName;
    private String fileName;
    private String id;
    private Program program;
    private String pluginIdentifier;
    private boolean internal = false;
    private boolean openInPlace = false;
    private transient IConfigurationElement configurationElement;
    private static String ATT_EDITOR_CONTRIBUTOR = "contributorClass";
    private static EditorDescriptor systemEditorDescriptor;

    public IEditorActionBarContributor createActionBarContributor() {
        String className = this.configurationElement.getAttribute(ATT_EDITOR_CONTRIBUTOR);
        if (className == null) {
            return null;
        }
        IEditorActionBarContributor contributor = null;
        try {
            contributor = (IEditorActionBarContributor)WorkbenchPlugin.createExtension(this.configurationElement, ATT_EDITOR_CONTRIBUTOR);
        }
        catch (CoreException e) {
            WorkbenchPlugin.log("Unable to create editor contributor: " + this.id, e.getStatus());
        }
        return contributor;
    }

    private static Program findProgram(String programName) {
        Program[] programs = Program.getPrograms();
        int i = 0;
        while (i < programs.length) {
            if (programs[i].getName().equals(programName)) {
                return programs[i];
            }
            ++i;
        }
        return null;
    }

    public String getClassName() {
        return this.className;
    }

    public IConfigurationElement getConfigurationElement() {
        return this.configurationElement;
    }

    public String getFileName() {
        if (this.program == null) {
            return this.fileName;
        }
        return this.program.getName();
    }

    public String getId() {
        if (this.program == null) {
            return this.id;
        }
        return this.program.getName();
    }

    public ImageDescriptor getImageDescriptor() {
        if (this.testImage) {
            this.testImage = false;
            if (this.imageDesc == null) {
                this.imageDesc = WorkbenchImages.getImageDescriptor("IMG_OBJ_FILE");
            } else {
                Image img = this.imageDesc.createImage(false);
                if (img == null) {
                    this.imageDesc = WorkbenchImages.getImageDescriptor("IMG_OBJ_FILE");
                } else {
                    img.dispose();
                }
            }
        }
        return this.imageDesc;
    }

    public String getImageFilename() {
        return this.imageFilename;
    }

    public String getLabel() {
        if (this.program == null) {
            return this.editorName;
        }
        return this.program.getName();
    }

    public String getLauncher() {
        return this.launcherName;
    }

    public String getPluginID() {
        return this.pluginIdentifier;
    }

    public Program getProgram() {
        return this.program;
    }

    public static EditorDescriptor getSystemEditorDescriptor() {
        if (systemEditorDescriptor == null) {
            systemEditorDescriptor = new EditorDescriptor();
            systemEditorDescriptor.setID("org.eclipse.ui.SystemEditor");
            systemEditorDescriptor.setName(WorkbenchMessages.getString("SystemEditorDescription.name"));
        }
        return systemEditorDescriptor;
    }

    public boolean isInternal() {
        return this.internal;
    }

    public boolean isOpenInPlace() {
        return this.openInPlace;
    }

    protected void loadValues(IMemento memento) {
        this.editorName = memento.getString("label");
        this.imageFilename = memento.getString("image");
        this.className = memento.getString("class");
        this.launcherName = memento.getString("launcher");
        this.fileName = memento.getString("file");
        this.id = memento.getString("id");
        this.pluginIdentifier = memento.getString("plugin");
        this.internal = new Boolean(memento.getString("internal"));
        this.openInPlace = new Boolean(memento.getString("open_in_place"));
        String programName = memento.getString("program_name");
        if (programName != null) {
            this.program = EditorDescriptor.findProgram(programName);
        }
    }

    protected void saveValues(IMemento memento) {
        memento.putString("label", this.editorName);
        memento.putString("image", this.imageFilename);
        memento.putString("class", this.className);
        memento.putString("launcher", this.launcherName);
        memento.putString("file", this.fileName);
        memento.putString("id", this.id);
        memento.putString("plugin", this.pluginIdentifier);
        memento.putString("internal", String.valueOf(this.internal));
        memento.putString("open_in_place", String.valueOf(this.openInPlace));
        if (this.program != null) {
            memento.putString("program_name", this.program.getName());
        }
    }

    public void setClassName(String newClassName) {
        this.className = newClassName;
    }

    public void setConfigurationElement(IConfigurationElement newConfigurationElement) {
        this.configurationElement = newConfigurationElement;
    }

    public void setFileName(String aFileName) {
        this.fileName = aFileName;
    }

    public void setID(String anID) {
        this.id = anID;
    }

    public void setImageDescriptor(ImageDescriptor desc) {
        this.imageDesc = desc;
        this.testImage = true;
    }

    public void setImageFilename(String aFileName) {
        this.imageFilename = aFileName;
    }

    public void setInternal(boolean newInternal) {
        this.internal = newInternal;
    }

    public void setLauncher(String newLauncher) {
        this.launcherName = newLauncher;
    }

    public void setName(String newName) {
        this.editorName = newName;
    }

    public void setOpenInPlace(boolean aBoolean) {
        this.openInPlace = aBoolean;
    }

    public void setPluginIdentifier(String anID) {
        this.pluginIdentifier = anID;
    }

    public void setProgram(Program newProgram) {
        this.program = newProgram;
        if (this.editorName == null) {
            this.setName(newProgram.getName());
        }
    }

    public String toString() {
        return "ResourceEditorDescriptor(" + this.editorName + ")";
    }
}

