/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class WorkbenchPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private IWorkbench workbench;
    private Button autoBuildButton;
    private Button autoSaveAllButton;
    private Button refreshButton;
    private Button showTasks;
    private Button exitPromptButton;
    private IntegerFieldEditor saveInterval;
    private Button doubleClickButton;
    private Button singleClickButton;
    private Button selectOnHoverButton;
    private Button openAfterDelayButton;
    private boolean openOnSingleClick;
    private boolean selectOnHover;
    private boolean openAfterDelay;

    protected Control createContents(Composite parent) {
        Font font = parent.getFont();
        WorkbenchHelp.setHelp((Control)parent, "org.eclipse.ui.workbench_preference_page_context");
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(272));
        composite.setFont(font);
        this.autoBuildButton = new Button(composite, 32);
        this.autoBuildButton.setText(WorkbenchMessages.getString("WorkbenchPreference.autobuild"));
        this.autoBuildButton.setFont(font);
        this.autoSaveAllButton = new Button(composite, 32);
        this.autoSaveAllButton.setText(WorkbenchMessages.getString("WorkbenchPreference.savePriorToBuilding"));
        this.autoSaveAllButton.setFont(font);
        this.refreshButton = new Button(composite, 32);
        this.refreshButton.setText(WorkbenchMessages.getString("WorkbenchPreference.refreshButton"));
        this.refreshButton.setFont(font);
        this.exitPromptButton = new Button(composite, 32);
        this.exitPromptButton.setText(WorkbenchMessages.getString("WorkbenchPreference.exitPromptButton"));
        this.exitPromptButton.setFont(font);
        this.showTasks = new Button(composite, 32);
        this.showTasks.setText(WorkbenchMessages.getString("WorkbenchPreference.showTasks"));
        this.showTasks.setFont(font);
        WorkbenchPreferencePage.createSpace(composite);
        this.createSaveIntervalGroup(composite);
        WorkbenchPreferencePage.createSpace(composite);
        this.createSingleClickGroup(composite);
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        this.autoBuildButton.setSelection(ResourcesPlugin.getWorkspace().isAutoBuilding());
        this.autoSaveAllButton.setSelection(store.getBoolean("SAVE_ALL_BEFORE_BUILD"));
        this.refreshButton.setSelection(store.getBoolean("REFRESH_WORKSPACE_ON_STARTUP"));
        this.exitPromptButton.setSelection(store.getBoolean("EXIT_PROMPT_ON_CLOSE_LAST_WINDOW"));
        this.showTasks.setSelection(store.getBoolean("SHOW_TASKS_ON_BUILD"));
        return composite;
    }

    private void createSingleClickGroup(Composite composite) {
        Font font = composite.getFont();
        Group buttonComposite = new Group(composite, 16384);
        GridLayout layout = new GridLayout();
        buttonComposite.setLayout((Layout)layout);
        GridData data = new GridData(768);
        buttonComposite.setLayoutData((Object)data);
        buttonComposite.setText(WorkbenchMessages.getString("WorkbenchPreference.openMode"));
        buttonComposite.setFont(font);
        String label = WorkbenchMessages.getString("WorkbenchPreference.doubleClick");
        this.doubleClickButton = WorkbenchPreferencePage.createRadioButton((Composite)buttonComposite, label);
        this.doubleClickButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkbenchPreferencePage.this.selectClickMode(WorkbenchPreferencePage.this.singleClickButton.getSelection());
            }
        });
        this.doubleClickButton.setSelection(!this.openOnSingleClick);
        label = WorkbenchMessages.getString("WorkbenchPreference.singleClick");
        this.singleClickButton = WorkbenchPreferencePage.createRadioButton((Composite)buttonComposite, label);
        this.singleClickButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkbenchPreferencePage.this.selectClickMode(WorkbenchPreferencePage.this.singleClickButton.getSelection());
            }
        });
        this.singleClickButton.setSelection(this.openOnSingleClick);
        label = WorkbenchMessages.getString("WorkbenchPreference.singleClick_SelectOnHover");
        this.selectOnHoverButton = new Button((Composite)buttonComposite, 16416);
        this.selectOnHoverButton.setText(label);
        this.selectOnHoverButton.setFont(font);
        this.selectOnHoverButton.setEnabled(this.openOnSingleClick);
        this.selectOnHoverButton.setSelection(this.selectOnHover);
        this.selectOnHoverButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkbenchPreferencePage.this.selectOnHover = WorkbenchPreferencePage.this.selectOnHoverButton.getSelection();
            }
        });
        data = new GridData();
        data.horizontalIndent = 20;
        this.selectOnHoverButton.setLayoutData((Object)data);
        label = WorkbenchMessages.getString("WorkbenchPreference.singleClick_OpenAfterDelay");
        this.openAfterDelayButton = new Button((Composite)buttonComposite, 16416);
        this.openAfterDelayButton.setText(label);
        this.openAfterDelayButton.setEnabled(this.openOnSingleClick);
        this.openAfterDelayButton.setSelection(this.openAfterDelay);
        this.openAfterDelayButton.setFont(font);
        this.openAfterDelayButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkbenchPreferencePage.this.openAfterDelay = WorkbenchPreferencePage.this.openAfterDelayButton.getSelection();
            }
        });
        data = new GridData();
        data.horizontalIndent = 20;
        this.openAfterDelayButton.setLayoutData((Object)data);
        this.createNoteComposite(font, (Composite)buttonComposite, WorkbenchMessages.getString("Preference.note"), WorkbenchMessages.getString("WorkbenchPreference.noEffectOnAllViews"));
    }

    private void selectClickMode(boolean singleClick) {
        this.openOnSingleClick = singleClick;
        this.selectOnHoverButton.setEnabled(this.openOnSingleClick);
        this.openAfterDelayButton.setEnabled(this.openOnSingleClick);
    }

    private void createSaveIntervalGroup(Composite composite) {
        Composite groupComposite = new Composite(composite, 16384);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        groupComposite.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        groupComposite.setLayoutData((Object)gd);
        groupComposite.setFont(composite.getFont());
        this.saveInterval = new IntegerFieldEditor("saveInterval", WorkbenchMessages.getString("WorkbenchPreference.saveInterval"), groupComposite);
        this.saveInterval.setPreferenceStore(WorkbenchPlugin.getDefault().getPreferenceStore());
        this.saveInterval.setPreferencePage((PreferencePage)this);
        this.saveInterval.setTextLimit(Integer.toString(9999).length());
        this.saveInterval.setErrorMessage(WorkbenchMessages.format("WorkbenchPreference.saveIntervalError", new Object[]{new Integer(9999)}));
        this.saveInterval.setValidateStrategy(0);
        this.saveInterval.setValidRange(1, 9999);
        IWorkspaceDescription description = ResourcesPlugin.getWorkspace().getDescription();
        long interval = description.getSnapshotInterval() / 60000L;
        this.saveInterval.setStringValue(Long.toString(interval));
        this.saveInterval.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("field_editor_is_valid")) {
                    WorkbenchPreferencePage.this.setValid(WorkbenchPreferencePage.this.saveInterval.isValid());
                }
            }
        });
    }

    protected static Button createRadioButton(Composite parent, String label) {
        Button button = new Button(parent, 16400);
        button.setText(label);
        button.setFont(parent.getFont());
        return button;
    }

    protected static Combo createCombo(Composite parent) {
        Combo combo = new Combo(parent, 8);
        GridData data = new GridData(768);
        data.widthHint = 200;
        combo.setLayoutData((Object)data);
        combo.setFont(parent.getFont());
        return combo;
    }

    protected static Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        label.setFont(parent.getFont());
        GridData data = new GridData();
        data.horizontalSpan = 1;
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    protected static void createSpace(Composite parent) {
        Label vfiller = new Label(parent, 16384);
        GridData gridData = new GridData();
        gridData = new GridData();
        gridData.horizontalAlignment = 1;
        gridData.grabExcessHorizontalSpace = false;
        gridData.verticalAlignment = 2;
        gridData.grabExcessVerticalSpace = false;
        vfiller.setLayoutData((Object)gridData);
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return WorkbenchPlugin.getDefault().getPreferenceStore();
    }

    public void init(IWorkbench aWorkbench) {
        this.workbench = aWorkbench;
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        this.openOnSingleClick = store.getBoolean("OPEN_ON_SINGLE_CLICK");
        this.selectOnHover = store.getBoolean("SELECT_ON_HOVER");
        this.openAfterDelay = store.getBoolean("OPEN_AFTER_DELAY");
    }

    protected void performDefaults() {
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        this.autoBuildButton.setSelection(store.getDefaultBoolean("AUTO_BUILD"));
        this.autoSaveAllButton.setSelection(store.getDefaultBoolean("SAVE_ALL_BEFORE_BUILD"));
        this.refreshButton.setSelection(store.getDefaultBoolean("REFRESH_WORKSPACE_ON_STARTUP"));
        this.exitPromptButton.setSelection(store.getDefaultBoolean("EXIT_PROMPT_ON_CLOSE_LAST_WINDOW"));
        this.showTasks.setSelection(store.getBoolean("SHOW_TASKS_ON_BUILD"));
        this.saveInterval.loadDefault();
        this.openOnSingleClick = store.getDefaultBoolean("OPEN_ON_SINGLE_CLICK");
        this.selectOnHover = store.getDefaultBoolean("SELECT_ON_HOVER");
        this.openAfterDelay = store.getDefaultBoolean("OPEN_AFTER_DELAY");
        this.singleClickButton.setSelection(this.openOnSingleClick);
        this.doubleClickButton.setSelection(!this.openOnSingleClick);
        this.selectOnHoverButton.setSelection(this.selectOnHover);
        this.openAfterDelayButton.setSelection(this.openAfterDelay);
        this.selectOnHoverButton.setEnabled(this.openOnSingleClick);
        this.openAfterDelayButton.setEnabled(this.openOnSingleClick);
        super.performDefaults();
    }

    public boolean performOk() {
        int singleClickMethod;
        IPreferenceStore store = this.getPreferenceStore();
        IWorkspaceDescription description = ResourcesPlugin.getWorkspace().getDescription();
        boolean coreAutoBuildSetting = description.isAutoBuilding();
        boolean preferenceStoreCurrentSetting = store.getBoolean("AUTO_BUILD");
        boolean newAutoBuildSetting = this.autoBuildButton.getSelection();
        if (preferenceStoreCurrentSetting && !coreAutoBuildSetting) {
            store.setValue("AUTO_BUILD", coreAutoBuildSetting);
        }
        store.setValue("AUTO_BUILD", newAutoBuildSetting);
        store.setValue("SAVE_ALL_BEFORE_BUILD", this.autoSaveAllButton.getSelection());
        store.setValue("REFRESH_WORKSPACE_ON_STARTUP", this.refreshButton.getSelection());
        store.setValue("EXIT_PROMPT_ON_CLOSE_LAST_WINDOW", this.exitPromptButton.getSelection());
        store.setValue("SHOW_TASKS_ON_BUILD", this.showTasks.getSelection());
        long oldSaveInterval = description.getSnapshotInterval() / 60000L;
        long newSaveInterval = new Long(this.saveInterval.getStringValue());
        if (oldSaveInterval != newSaveInterval) {
            try {
                description.setSnapshotInterval(newSaveInterval * 60000L);
                ResourcesPlugin.getWorkspace().setDescription(description);
                store.firePropertyChangeEvent("saveInterval", (Object)new Integer((int)oldSaveInterval), (Object)new Integer((int)newSaveInterval));
            }
            catch (CoreException e) {
                WorkbenchPlugin.log("Error changing save interval preference", e.getStatus());
            }
        }
        store.setValue("OPEN_ON_SINGLE_CLICK", this.openOnSingleClick);
        store.setValue("SELECT_ON_HOVER", this.selectOnHover);
        store.setValue("OPEN_AFTER_DELAY", this.openAfterDelay);
        int n = singleClickMethod = this.openOnSingleClick ? 1 : 0;
        if (this.openOnSingleClick) {
            if (this.selectOnHover) {
                singleClickMethod |= 2;
            }
            if (this.openAfterDelay) {
                singleClickMethod |= 4;
            }
        }
        OpenStrategy.setOpenMethod((int)singleClickMethod);
        WorkbenchPlugin.getDefault().savePluginPreferences();
        return true;
    }
}

