/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.internal.AboutInfo;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.misc.Assert;

public class WelcomeEditorInput
implements IEditorInput {
    private AboutInfo aboutInfo;
    private static final String FACTORY_ID = "org.eclipse.ui.internal.dialogs.WelcomeEditorInputFactory";
    public static final String FEATURE_ID = "featureId";

    public WelcomeEditorInput(AboutInfo info) {
        Assert.isNotNull(info);
        this.aboutInfo = info;
    }

    public boolean exists() {
        return false;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return WorkbenchMessages.getString("WelcomeEditor.title");
    }

    public IPersistableElement getPersistable() {
        return new IPersistableElement(){

            public String getFactoryId() {
                return WelcomeEditorInput.FACTORY_ID;
            }

            public void saveState(IMemento memento) {
                memento.putString(WelcomeEditorInput.FEATURE_ID, WelcomeEditorInput.this.aboutInfo.getFeatureId());
            }
        };
    }

    public AboutInfo getAboutInfo() {
        return this.aboutInfo;
    }

    public boolean equals(Object o) {
        return o != null && o instanceof WelcomeEditorInput && ((WelcomeEditorInput)o).aboutInfo.getFeatureId().equals(this.aboutInfo.getFeatureId());
    }

    public String getToolTipText() {
        return WorkbenchMessages.format("WelcomeEditor.toolTip", new Object[]{this.aboutInfo.getFeatureLabel()});
    }
}

