/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.dialogs.DialogUtil;
import org.eclipse.ui.internal.registry.ICategory;
import org.eclipse.ui.internal.registry.IViewDescriptor;
import org.eclipse.ui.internal.registry.ViewDescriptor;

public class ViewLabelProvider
extends LabelProvider {
    private HashMap images;

    Image cacheImage(ImageDescriptor desc) {
        Image image;
        if (this.images == null) {
            this.images = new HashMap(21);
        }
        if ((image = (Image)this.images.get(desc)) == null) {
            image = desc.createImage();
            this.images.put(desc, image);
        }
        return image;
    }

    public void dispose() {
        if (this.images != null) {
            Iterator i = this.images.values().iterator();
            while (i.hasNext()) {
                ((Image)i.next()).dispose();
            }
            this.images = null;
        }
        super.dispose();
    }

    public Image getImage(Object element) {
        if (element instanceof IViewDescriptor) {
            ImageDescriptor desc = ((IViewDescriptor)element).getImageDescriptor();
            if (desc != null) {
                return this.cacheImage(desc);
            }
        } else if (element instanceof ICategory) {
            ImageDescriptor desc = WorkbenchImages.getImageDescriptor("IMG_OBJ_FOLDER");
            return this.cacheImage(desc);
        }
        return null;
    }

    public String getText(Object element) {
        String label = WorkbenchMessages.getString("ViewLabel.unknown");
        if (element instanceof ICategory) {
            label = ((ICategory)element).getLabel();
        } else if (element instanceof IViewDescriptor) {
            label = ((ViewDescriptor)element).getLabel();
        }
        return DialogUtil.removeAccel(label);
    }
}

