/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;

public class PerspLabelProvider
extends LabelProvider {
    private HashMap imageCache = new HashMap(11);
    private boolean markDefault = true;

    public PerspLabelProvider() {
    }

    public PerspLabelProvider(boolean markDefault) {
        this.markDefault = markDefault;
    }

    public void dispose() {
        Iterator i = this.imageCache.values().iterator();
        while (i.hasNext()) {
            ((Image)i.next()).dispose();
        }
        this.imageCache.clear();
    }

    public Image getImage(Object element) {
        if (element instanceof IPerspectiveDescriptor) {
            Image image;
            IPerspectiveDescriptor desc = (IPerspectiveDescriptor)element;
            ImageDescriptor imageDescriptor = desc.getImageDescriptor();
            if (imageDescriptor == null) {
                imageDescriptor = WorkbenchImages.getImageDescriptor("IMG_CTOOL_DEF_PERSPECTIVE_HOVER");
            }
            if ((image = (Image)this.imageCache.get(imageDescriptor)) == null) {
                image = imageDescriptor.createImage();
                this.imageCache.put(imageDescriptor, image);
            }
            return image;
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof IPerspectiveDescriptor) {
            IPerspectiveDescriptor desc = (IPerspectiveDescriptor)element;
            String label = desc.getLabel();
            if (this.markDefault) {
                String def = PlatformUI.getWorkbench().getPerspectiveRegistry().getDefaultPerspective();
                if (desc.getId().equals(def)) {
                    label = WorkbenchMessages.format("PerspectivesPreference.defaultLabel", new Object[]{label});
                }
            }
            return label;
        }
        return WorkbenchMessages.getString("PerspectiveLabelProvider.unknown");
    }
}

