/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.ui.ICapabilityInstallWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.dialogs.WizardStep;
import org.eclipse.ui.internal.registry.Capability;

public class InstallCapabilityStep
extends WizardStep {
    private Capability capability;
    private ICapabilityInstallWizard wizard;
    private IWorkbench workbench;
    private IProjectProvider projectProvider;

    public InstallCapabilityStep(int number, Capability capability, IWorkbench workbench, IProjectProvider projectProvider) {
        super(number);
        this.capability = capability;
        this.workbench = workbench;
        this.projectProvider = projectProvider;
    }

    public String getLabel() {
        return WorkbenchMessages.format("InstallCapabilityStep.label", new Object[]{this.capability.getName()});
    }

    public String getDetails() {
        return this.capability.getInstallDetails();
    }

    public IWizard getWizard() {
        if (this.wizard == null) {
            this.wizard = this.capability.getInstallWizard();
            if (this.wizard != null) {
                this.wizard.init(this.workbench, (IStructuredSelection)StructuredSelection.EMPTY, this.projectProvider.getProject());
                this.wizard.addPages();
            }
        }
        return this.wizard;
    }

    interface IProjectProvider {
        public IProject getProject();
    }
}

