/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.net.URL;
import java.text.Collator;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.AboutInfo;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.ProductInfoDialog;

public class AboutPluginsDialog
extends ProductInfoDialog {
    private static final int TABLE_HEIGHT = 200;
    private static final String PLUGININFO = "about.html";
    private static final int MORE_ID = 1025;
    private Table vendorInfo;
    private Button moreInfo;
    private String title;
    private String message;
    private String helpContextId;
    private String[] columnTitles = new String[]{WorkbenchMessages.getString("AboutPluginsDialog.provider"), WorkbenchMessages.getString("AboutPluginsDialog.pluginName"), WorkbenchMessages.getString("AboutPluginsDialog.version"), WorkbenchMessages.getString("AboutPluginsDialog.pluginId")};
    private IPluginDescriptor[] info;
    private AboutInfo aboutInfo;
    private int lastColumnChosen = 0;
    private boolean reverseSort = false;
    private IPluginDescriptor lastSelection = null;

    public AboutPluginsDialog(Shell parentShell) {
        this(parentShell, Platform.getPluginRegistry().getPluginDescriptors(), null, null, "org.eclipse.ui.about_plugins_dialog_context");
    }

    public AboutPluginsDialog(Shell parentShell, IPluginDescriptor[] descriptors, String title, String msg) {
        this(parentShell, descriptors, title, msg, "org.eclipse.ui.about_plugins_dialog_context");
    }

    public AboutPluginsDialog(Shell parentShell, IPluginDescriptor[] descriptors, String title, String msg, String helpContextId) {
        super(parentShell);
        this.info = descriptors;
        this.title = title;
        this.message = msg;
        this.helpContextId = helpContextId;
        this.sortByProvider();
        this.aboutInfo = ((Workbench)PlatformUI.getWorkbench()).getConfigurationInfo().getAboutInfo();
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 1025: {
                this.handleMoreInfoPressed();
                return;
            }
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.title == null) {
            this.title = this.aboutInfo.getProductName();
            if (this.title != null) {
                this.title = WorkbenchMessages.format("AboutPluginsDialog.shellTitle", new Object[]{this.title});
            }
        }
        if (this.title != null) {
            newShell.setText(this.title);
        }
        WorkbenchHelp.setHelp((Control)newShell, this.helpContextId);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setLayoutData((Object)new GridData(768));
        this.moreInfo = this.createButton(parent, 1025, WorkbenchMessages.getString("AboutPluginsDialog.moreInfo"), false);
        this.moreInfo.setEnabled(this.tableHasSelection() & this.selectionHasInfo());
        Label l = new Label(parent, 0);
        l.setLayoutData((Object)new GridData(768));
        GridLayout layout = (GridLayout)parent.getLayout();
        ++layout.numColumns;
        layout.makeColumnsEqualWidth = false;
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite outer = (Composite)super.createDialogArea(parent);
        if (this.message != null) {
            Label label = new Label(outer, 0);
            label.setLayoutData((Object)new GridData(768));
            label.setFont(parent.getFont());
            label.setText(this.message);
        }
        this.createTable(outer);
        this.createColumns();
        GridData gridData = new GridData(272);
        gridData.grabExcessVerticalSpace = true;
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = this.convertVerticalDLUsToPixels(200);
        this.vendorInfo.setLayoutData((Object)gridData);
        return outer;
    }

    protected void createTable(Composite parent) {
        this.vendorInfo = new Table(parent, 68356);
        this.vendorInfo.setHeaderVisible(true);
        this.vendorInfo.setLinesVisible(true);
        this.vendorInfo.setFont(parent.getFont());
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AboutPluginsDialog.this.setMoreButtonEnablement(e.item != null);
            }
        };
        this.vendorInfo.addSelectionListener((SelectionListener)listener);
    }

    protected void createColumns() {
        int[] columnWidths = new int[]{this.convertHorizontalDLUsToPixels(120), this.convertHorizontalDLUsToPixels(180), this.convertHorizontalDLUsToPixels(70), this.convertHorizontalDLUsToPixels(70)};
        int i = 0;
        while (i < this.columnTitles.length) {
            TableColumn tableColumn = new TableColumn(this.vendorInfo, 0);
            tableColumn.setWidth(columnWidths[i]);
            tableColumn.setText(this.columnTitles[i]);
            final int columnIndex = i++;
            tableColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AboutPluginsDialog.this.sort(columnIndex);
                }
            });
        }
        i = 0;
        while (i < this.info.length) {
            String provider = this.info[i].getProviderName();
            String pluginName = this.info[i].getLabel();
            String version = this.info[i].getVersionIdentifier().toString();
            String pluginId = this.info[i].getUniqueIdentifier();
            String[] row = new String[]{provider, pluginName, version, pluginId};
            TableItem item = new TableItem(this.vendorInfo, 0);
            item.setText(row);
            ++i;
        }
    }

    protected void setMoreButtonEnablement(boolean isSelected) {
        this.moreInfo.setEnabled(isSelected && this.selectionHasInfo());
    }

    private boolean selectionHasInfo() {
        TableItem[] items = this.vendorInfo.getSelection();
        if (items.length == 0) {
            return false;
        }
        int i = this.vendorInfo.getSelectionIndex();
        IPluginDescriptor desc = this.info[i];
        URL infoURL = desc.find((IPath)new Path(PLUGININFO));
        if (infoURL == null && WorkbenchPlugin.DEBUG) {
            WorkbenchPlugin.log("Problem reading plugin info for: " + desc.getLabel());
        }
        return infoURL != null;
    }

    private boolean tableHasSelection() {
        if (this.vendorInfo == null) {
            return false;
        }
        return this.vendorInfo.getSelectionCount() > 0;
    }

    protected void handleMoreInfoPressed() {
        TableItem[] items = this.vendorInfo.getSelection();
        if (items.length == 0) {
            return;
        }
        int i = this.vendorInfo.getSelectionIndex();
        IPluginDescriptor desc = this.info[i];
        this.openMoreInfo(desc);
    }

    private void openMoreInfo(IPluginDescriptor desc) {
        URL infoURL = desc.find((IPath)new Path(PLUGININFO));
        if (infoURL == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)WorkbenchMessages.getString("AboutPluginsDialog.errorTitle"), (String)WorkbenchMessages.format("AboutPluginsDialog.unableToOpenFile", new Object[]{PLUGININFO, desc.getUniqueIdentifier()}));
            return;
        }
        this.openLink(infoURL.toString());
    }

    private void sort(int column) {
        if (this.lastColumnChosen == column) {
            this.reverseSort = !this.reverseSort;
        } else {
            this.reverseSort = false;
            this.lastColumnChosen = column;
        }
        if (this.vendorInfo.getItemCount() <= 1) {
            return;
        }
        int idx = this.vendorInfo.getSelectionIndex();
        if (idx != -1) {
            this.lastSelection = this.info[idx];
        }
        switch (column) {
            case 0: {
                this.sortByProvider();
                break;
            }
            case 1: {
                this.sortByName();
                break;
            }
            case 2: {
                this.sortByVersion();
                break;
            }
            case 3: {
                this.sortById();
            }
        }
        this.refreshTable(column);
    }

    private void refreshTable(int col) {
        TableItem[] items = this.vendorInfo.getItems();
        int idx = -1;
        int i = 0;
        while (i < items.length) {
            String provider = this.info[i].getProviderName();
            String pluginName = this.info[i].getLabel();
            String version = this.info[i].getVersionIdentifier().toString();
            String pluginId = this.info[i].getUniqueIdentifier();
            String[] row = new String[]{provider, pluginName, version, pluginId};
            items[i].setText(row);
            ++i;
        }
        if (this.lastSelection != null) {
            String oldId = this.lastSelection.getUniqueIdentifier();
            int k = 0;
            while (k < this.info.length) {
                if (oldId.equalsIgnoreCase(this.info[k].getUniqueIdentifier())) {
                    idx = k;
                }
                ++k;
            }
            this.vendorInfo.setSelection(idx);
            this.vendorInfo.showSelection();
        }
        this.moreInfo.setEnabled(this.tableHasSelection() && this.selectionHasInfo());
    }

    private void sortByProvider() {
        if (this.reverseSort) {
            List<IPluginDescriptor> infoList = Arrays.asList(this.info);
            Collections.reverse(infoList);
            int i = 0;
            while (i < this.info.length) {
                this.info[i] = infoList.get(i);
                ++i;
            }
        } else {
            Arrays.sort(this.info, new Comparator(){
                Collator coll = Collator.getInstance(Locale.getDefault());

                public int compare(Object a, Object b) {
                    IPluginDescriptor d1 = (IPluginDescriptor)a;
                    String provider1 = d1.getProviderName();
                    String name1 = d1.getLabel();
                    IPluginDescriptor d2 = (IPluginDescriptor)b;
                    String provider2 = d2.getProviderName();
                    String name2 = d2.getLabel();
                    if (provider1.equals(provider2)) {
                        return this.coll.compare(name1, name2);
                    }
                    return this.coll.compare(provider1, provider2);
                }
            });
        }
    }

    private void sortByName() {
        if (this.reverseSort) {
            List<IPluginDescriptor> infoList = Arrays.asList(this.info);
            Collections.reverse(infoList);
            int i = 0;
            while (i < this.info.length) {
                this.info[i] = infoList.get(i);
                ++i;
            }
        } else {
            Arrays.sort(this.info, new Comparator(){
                Collator coll = Collator.getInstance(Locale.getDefault());

                public int compare(Object a, Object b) {
                    IPluginDescriptor d1 = (IPluginDescriptor)a;
                    String name1 = d1.getLabel();
                    IPluginDescriptor d2 = (IPluginDescriptor)b;
                    String name2 = d2.getLabel();
                    return this.coll.compare(name1, name2);
                }
            });
        }
    }

    private void sortByVersion() {
        if (this.reverseSort) {
            List<IPluginDescriptor> infoList = Arrays.asList(this.info);
            Collections.reverse(infoList);
            int i = 0;
            while (i < this.info.length) {
                this.info[i] = infoList.get(i);
                ++i;
            }
        } else {
            Arrays.sort(this.info, new Comparator(){
                Collator coll = Collator.getInstance(Locale.getDefault());

                public int compare(Object a, Object b) {
                    IPluginDescriptor d1 = (IPluginDescriptor)a;
                    String version1 = d1.getVersionIdentifier().toString();
                    String name1 = d1.getLabel();
                    IPluginDescriptor d2 = (IPluginDescriptor)b;
                    String version2 = d2.getVersionIdentifier().toString();
                    String name2 = d2.getLabel();
                    if (version1.equals(version2)) {
                        return this.coll.compare(name1, name2);
                    }
                    return this.coll.compare(version1, version2);
                }
            });
        }
    }

    private void sortById() {
        if (this.reverseSort) {
            List<IPluginDescriptor> infoList = Arrays.asList(this.info);
            Collections.reverse(infoList);
            int i = 0;
            while (i < this.info.length) {
                this.info[i] = infoList.get(i);
                ++i;
            }
        } else {
            Arrays.sort(this.info, new Comparator(){
                Collator coll = Collator.getInstance(Locale.getDefault());

                public int compare(Object a, Object b) {
                    IPluginDescriptor d1 = (IPluginDescriptor)a;
                    String pluginId1 = d1.getUniqueIdentifier();
                    String name1 = d1.getLabel();
                    IPluginDescriptor d2 = (IPluginDescriptor)b;
                    String pluginId2 = d2.getUniqueIdentifier();
                    String name2 = d2.getLabel();
                    if (pluginId1.equals(pluginId2)) {
                        return this.coll.compare(name1, name2);
                    }
                    return this.coll.compare(pluginId1, pluginId2);
                }
            });
        }
    }
}

