/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.decorators;

import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.ui.internal.ActionExpression;
import org.eclipse.ui.internal.WorkbenchPlugin;

public abstract class DecoratorDefinition {
    private String name;
    private String description;
    private ActionExpression enablement;
    private boolean adaptable;
    protected boolean enabled;
    private boolean defaultEnabled;
    private String id;
    protected IConfigurationElement definingElement;
    protected boolean labelProviderCreationFailed = false;

    DecoratorDefinition(String identifier, String label, String decoratorDescription, ActionExpression expression, boolean isAdaptable, boolean initEnabled, IConfigurationElement element) {
        this.id = identifier;
        this.name = label;
        this.enablement = expression;
        this.adaptable = isAdaptable;
        this.description = decoratorDescription;
        this.enabled = initEnabled;
        this.defaultEnabled = initEnabled;
        this.definingElement = element;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean newState) {
        if (this.enabled != newState) {
            this.enabled = newState;
            try {
                this.refreshDecorator();
            }
            catch (CoreException exception) {
                this.handleCoreException(exception);
            }
        }
    }

    protected abstract void refreshDecorator() throws CoreException;

    protected void disposeCachedDecorator(IBaseLabelProvider disposedDecorator) {
        disposedDecorator.removeListener((ILabelProviderListener)WorkbenchPlugin.getDefault().getDecoratorManager());
        disposedDecorator.dispose();
    }

    public boolean isAdaptable() {
        return this.adaptable;
    }

    public String getId() {
        return this.id;
    }

    public boolean getDefaultValue() {
        return this.defaultEnabled;
    }

    public ActionExpression getEnablement() {
        return this.enablement;
    }

    void addListener(ILabelProviderListener listener) {
        try {
            IBaseLabelProvider currentDecorator = this.internalGetLabelProvider();
            if (currentDecorator != null) {
                currentDecorator.addListener(listener);
            }
        }
        catch (CoreException exception) {
            this.handleCoreException(exception);
        }
    }

    boolean isLabelProperty(Object element, String property) {
        try {
            IBaseLabelProvider currentDecorator = this.internalGetLabelProvider();
            if (currentDecorator != null) {
                return currentDecorator.isLabelProperty(element, property);
            }
        }
        catch (CoreException exception) {
            this.handleCoreException(exception);
            return false;
        }
        return false;
    }

    protected abstract IBaseLabelProvider internalGetLabelProvider() throws CoreException;

    protected void handleCoreException(CoreException exception) {
        InternalPlatform.getRuntimePlugin().getLog().log(exception.getStatus());
        this.enabled = false;
    }

    public abstract boolean isFull();
}

