/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class Util {
    public static final String ZERO_LENGTH_STRING = "";

    public static int compare(Comparable left, Comparable right) {
        if (left == null && right == null) {
            return 0;
        }
        if (left == null) {
            return -1;
        }
        if (right == null) {
            return 1;
        }
        return left.compareTo(right);
    }

    public static int compare(Comparable[] left, Comparable[] right) {
        if (left == null && right == null) {
            return 0;
        }
        if (left == null) {
            return -1;
        }
        if (right == null) {
            return 1;
        }
        int l = left.length;
        int r = right.length;
        if (l != r) {
            return l - r;
        }
        int i = 0;
        while (i < l) {
            int compareTo = Util.compare(left[i], right[i]);
            if (compareTo != 0) {
                return compareTo;
            }
            ++i;
        }
        return 0;
    }

    public static int compare(List left, List right) throws ClassCastException {
        int r;
        if (left == null && right == null) {
            return 0;
        }
        if (left == null) {
            return -1;
        }
        if (right == null) {
            return 1;
        }
        int l = left.size();
        if (l != (r = right.size())) {
            return l - r;
        }
        int i = 0;
        while (i < l) {
            int compareTo = ((Comparable)left.get(i)).compareTo((Comparable)right.get(i));
            if (compareTo != 0) {
                return compareTo;
            }
            ++i;
        }
        return 0;
    }

    public static boolean equals(Object left, Object right) {
        return left == null ? right == null : left.equals(right);
    }

    public static String getString(ResourceBundle resourceBundle, String key) throws IllegalArgumentException {
        if (resourceBundle == null || key == null) {
            throw new IllegalArgumentException();
        }
        String value = key;
        try {
            value = resourceBundle.getString(key);
        }
        catch (MissingResourceException eMissingResource) {
            System.err.println(eMissingResource);
        }
        return value != null ? value.trim() : null;
    }

    public static boolean isChildOf(Object[] left, Object[] right, boolean equals) {
        if (left == null || right == null) {
            return false;
        }
        int r = right.length;
        int l = left.length;
        if (r > l || !equals && r == l) {
            return false;
        }
        int i = 0;
        while (i < r) {
            if (!Util.equals(left[i], right[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isChildOf(List left, List right, boolean equals) {
        if (left == null || right == null) {
            return false;
        }
        int l = left.size();
        int r = right.size();
        if (r > l || !equals && r == l) {
            return false;
        }
        int i = 0;
        while (i < r) {
            if (!Util.equals(left.get(i), right.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static int hashCode(Object object) {
        return object != null ? object.hashCode() : 0;
    }

    public static List safeCopy(List list, Class c) throws IllegalArgumentException {
        if (list == null || c == null) {
            throw new IllegalArgumentException();
        }
        list = Collections.unmodifiableList(new ArrayList(list));
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (c.isInstance(iterator.next())) continue;
            throw new IllegalArgumentException();
        }
        return list;
    }

    private Util() {
    }
}

