/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.ui.internal.commands.CommandEnvelope;
import org.eclipse.ui.internal.commands.Sequence;
import org.eclipse.ui.internal.commands.SequenceBinding;
import org.eclipse.ui.internal.commands.State;
import org.eclipse.ui.internal.commands.Stroke;

final class SequenceNode {
    private SortedMap childMap = new TreeMap();
    private String command = null;
    private SortedMap scopeConfigurationMap = new TreeMap();

    static void add(SortedMap tree, SequenceBinding sequenceBinding, State scopeConfiguration, State platformLocale) {
        List strokes = sequenceBinding.getSequence().getStrokes();
        SortedMap root = tree;
        SequenceNode node = null;
        int i = 0;
        while (i < strokes.size()) {
            Stroke stroke = (Stroke)strokes.get(i);
            node = (SequenceNode)root.get(stroke);
            if (node == null) {
                node = new SequenceNode();
                root.put(stroke, node);
            }
            root = node.childMap;
            ++i;
        }
        if (node != null) {
            SequenceNode.add(node.scopeConfigurationMap, scopeConfiguration, new Integer(sequenceBinding.getRank()), platformLocale, sequenceBinding.getCommand());
        }
    }

    static void add(SortedMap scopeConfigurationMap, State scopeConfiguration, Integer rank, State platformLocale, String command) {
        HashSet<String> commandSet;
        TreeMap<State, HashSet<String>> platformLocaleMap;
        TreeMap rankMap = (TreeMap)scopeConfigurationMap.get(scopeConfiguration);
        if (rankMap == null) {
            rankMap = new TreeMap();
            scopeConfigurationMap.put(scopeConfiguration, rankMap);
        }
        if ((platformLocaleMap = (TreeMap<State, HashSet<String>>)rankMap.get(rank)) == null) {
            platformLocaleMap = new TreeMap<State, HashSet<String>>();
            rankMap.put(rank, platformLocaleMap);
        }
        if ((commandSet = (HashSet<String>)platformLocaleMap.get(platformLocale)) == null) {
            commandSet = new HashSet<String>();
            platformLocaleMap.put(platformLocale, commandSet);
        }
        commandSet.add(command);
    }

    static SortedMap find(SortedMap tree, Sequence prefix) {
        Iterator iterator = prefix.getStrokes().iterator();
        while (iterator.hasNext()) {
            SequenceNode node = (SequenceNode)tree.get(iterator.next());
            if (node == null) {
                return new TreeMap();
            }
            tree = node.childMap;
        }
        return tree;
    }

    static void remove(SortedMap tree, SequenceBinding sequenceBinding, State scopeConfiguration, State platformLocale) {
        List strokes = sequenceBinding.getSequence().getStrokes();
        SortedMap root = tree;
        SequenceNode node = null;
        int i = 0;
        while (i < strokes.size()) {
            Stroke stroke = (Stroke)strokes.get(i);
            node = (SequenceNode)root.get(stroke);
            if (node == null) break;
            root = node.childMap;
            ++i;
        }
        if (node != null) {
            SequenceNode.remove(node.scopeConfigurationMap, scopeConfiguration, new Integer(sequenceBinding.getRank()), platformLocale, sequenceBinding.getCommand());
        }
    }

    static void remove(SortedMap scopeConfigurationMap, State scopeConfiguration, Integer rank, State platformLocale, String command) {
        Set commandSet;
        SortedMap platformLocaleMap;
        SortedMap rankMap = (SortedMap)scopeConfigurationMap.get(scopeConfiguration);
        if (rankMap != null && (platformLocaleMap = (SortedMap)rankMap.get(rank)) != null && (commandSet = (Set)platformLocaleMap.get(platformLocale)) != null) {
            commandSet.remove(command);
            if (commandSet.isEmpty()) {
                platformLocaleMap.remove(platformLocale);
                if (platformLocaleMap.isEmpty()) {
                    rankMap.remove(rank);
                    if (rankMap.isEmpty()) {
                        scopeConfigurationMap.remove(scopeConfiguration);
                    }
                }
            }
        }
    }

    static void solve(SortedMap tree, State[] scopeConfigurations, State[] platformLocales) {
        Iterator iterator = tree.values().iterator();
        while (iterator.hasNext()) {
            SequenceNode node = (SequenceNode)iterator.next();
            CommandEnvelope commandEnvelope = SequenceNode.solveScopeConfigurationMap(node.scopeConfigurationMap, scopeConfigurations, platformLocales);
            node.command = commandEnvelope != null ? commandEnvelope.getCommand() : null;
            SequenceNode.solve(node.childMap, scopeConfigurations, platformLocales);
        }
    }

    static String solveCommandSet(Set commandSet) {
        return commandSet != null && commandSet.size() == 1 ? (String)commandSet.iterator().next() : null;
    }

    static CommandEnvelope solvePlatformLocaleMap(SortedMap platformLocaleMap, State platformLocale) {
        int bestMatch = -1;
        String bestCommand = null;
        Iterator iterator = platformLocaleMap.entrySet().iterator();
        boolean match = false;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            State testPlatformLocale = (State)entry.getKey();
            Set testCommandSet = (Set)entry.getValue();
            int testMatch = testPlatformLocale.match(platformLocale);
            if (testMatch < 0) continue;
            match = true;
            String testCommand = SequenceNode.solveCommandSet(testCommandSet);
            if (testCommand == null) continue;
            if (bestMatch == -1 || testMatch < bestMatch) {
                bestMatch = testMatch;
                bestCommand = testCommand;
            }
            if (bestMatch == 0) break;
        }
        return match ? CommandEnvelope.create(bestCommand) : null;
    }

    static CommandEnvelope solvePlatformLocaleMap(SortedMap platformLocaleMap, State[] platformLocales) {
        int i = 0;
        while (i < platformLocales.length) {
            CommandEnvelope commandEnvelope = SequenceNode.solvePlatformLocaleMap(platformLocaleMap, platformLocales[i]);
            if (commandEnvelope != null) {
                return commandEnvelope;
            }
            ++i;
        }
        return null;
    }

    static String solveRankMap(SortedMap rankMap, State[] platformLocales) {
        Iterator iterator = rankMap.values().iterator();
        while (iterator.hasNext()) {
            SortedMap platformLocaleMap = (SortedMap)iterator.next();
            CommandEnvelope commandEnvelope = SequenceNode.solvePlatformLocaleMap(platformLocaleMap, platformLocales);
            if (commandEnvelope == null) continue;
            return commandEnvelope.getCommand();
        }
        return null;
    }

    static CommandEnvelope solveScopeConfigurationMap(SortedMap scopeConfigurationMap, State scopeConfiguration, State[] platformLocales) {
        int bestMatch = -1;
        String bestCommand = null;
        Iterator iterator = scopeConfigurationMap.entrySet().iterator();
        boolean match = false;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            State testScopeConfiguration = (State)entry.getKey();
            SortedMap testRankMap = (SortedMap)entry.getValue();
            int testMatch = testScopeConfiguration.match(scopeConfiguration);
            if (testMatch < 0) continue;
            match = true;
            String testCommand = SequenceNode.solveRankMap(testRankMap, platformLocales);
            if (testCommand == null) continue;
            if (bestMatch == -1 || testMatch < bestMatch) {
                bestMatch = testMatch;
                bestCommand = testCommand;
            }
            if (bestMatch == 0) break;
        }
        return match ? CommandEnvelope.create(bestCommand) : null;
    }

    static CommandEnvelope solveScopeConfigurationMap(SortedMap scopeConfigurationMap, State[] scopeConfigurations, State[] platformLocales) {
        int i = 0;
        while (i < scopeConfigurations.length) {
            CommandEnvelope commandEnvelope = SequenceNode.solveScopeConfigurationMap(scopeConfigurationMap, scopeConfigurations[i], platformLocales);
            if (commandEnvelope != null) {
                return commandEnvelope;
            }
            ++i;
        }
        return null;
    }

    static Map toCommandMap(SortedMap sequenceMap) {
        HashMap<String, TreeSet<Sequence>> commandMap = new HashMap<String, TreeSet<Sequence>>();
        Iterator iterator = sequenceMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Sequence sequence = (Sequence)entry.getKey();
            String command = (String)entry.getValue();
            TreeSet<Sequence> sequenceSet = (TreeSet<Sequence>)commandMap.get(command);
            if (sequenceSet == null) {
                sequenceSet = new TreeSet<Sequence>();
                commandMap.put(command, sequenceSet);
            }
            sequenceSet.add(sequence);
        }
        return commandMap;
    }

    static SortedMap toSequenceMap(SortedMap tree, Sequence prefix) {
        TreeMap<Sequence, String> sequenceMap = new TreeMap<Sequence, String>();
        Iterator iterator = tree.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Stroke stroke = (Stroke)entry.getKey();
            SequenceNode node = (SequenceNode)entry.getValue();
            ArrayList<Stroke> list = new ArrayList<Stroke>(prefix.getStrokes());
            list.add(stroke);
            Sequence sequence = Sequence.create(list);
            SortedMap childSequenceMap = SequenceNode.toSequenceMap(node.childMap, sequence);
            if (childSequenceMap.size() >= 1) {
                sequenceMap.putAll(childSequenceMap);
                continue;
            }
            if (node.command == null || node.command.equals("")) continue;
            sequenceMap.put(sequence, node.command);
        }
        return sequenceMap;
    }

    private SequenceNode() {
    }
}

