/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ui.internal.commands.Stroke;
import org.eclipse.ui.internal.commands.Util;

public final class Sequence
implements Comparable {
    private static final int HASH_FACTOR = 97;
    private static final int HASH_INITIAL = 107;
    private List strokes;
    static /* synthetic */ Class class$0;

    public static Sequence create() {
        return new Sequence(Collections.EMPTY_LIST);
    }

    public static Sequence create(Stroke stroke) throws IllegalArgumentException {
        return new Sequence(Collections.singletonList(stroke));
    }

    public static Sequence create(Stroke[] strokes) throws IllegalArgumentException {
        return new Sequence(Arrays.asList(strokes));
    }

    public static Sequence create(List strokes) throws IllegalArgumentException {
        return new Sequence(strokes);
    }

    private Sequence(List strokes) throws IllegalArgumentException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.internal.commands.Stroke");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.strokes = Collections.unmodifiableList(Util.safeCopy(strokes, clazz));
    }

    public int compareTo(Object object) {
        return Util.compare(this.strokes, ((Sequence)object).strokes);
    }

    public boolean equals(Object object) {
        return object instanceof Sequence && this.strokes.equals(((Sequence)object).strokes);
    }

    public List getStrokes() {
        return this.strokes;
    }

    public int hashCode() {
        int result = 107;
        Iterator iterator = this.strokes.iterator();
        while (iterator.hasNext()) {
            result = result * 97 + ((Stroke)iterator.next()).hashCode();
        }
        return result;
    }

    public boolean isChildOf(Sequence sequence, boolean equals) {
        if (sequence == null) {
            return false;
        }
        return Util.isChildOf(this.strokes, sequence.strokes, equals);
    }
}

