/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import java.text.Collator;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.ui.internal.commands.Util;

public final class Scope
implements Comparable {
    private static final int HASH_FACTOR = 87;
    private static final int HASH_INITIAL = 97;
    private static Comparator nameComparator;
    private String description;
    private String id;
    private String name;
    private String parent;
    private String plugin;

    public static Scope create(String description, String id, String name, String parent, String plugin) throws IllegalArgumentException {
        return new Scope(description, id, name, parent, plugin);
    }

    public static Comparator nameComparator() {
        if (nameComparator == null) {
            nameComparator = new Comparator(){

                public int compare(Object left, Object right) {
                    return Collator.getInstance().compare(((Scope)left).name, ((Scope)right).name);
                }
            };
        }
        return nameComparator;
    }

    public static SortedMap sortedMapById(List scopes) throws IllegalArgumentException {
        if (scopes == null) {
            throw new IllegalArgumentException();
        }
        TreeMap<String, Scope> sortedMap = new TreeMap<String, Scope>();
        Iterator iterator = scopes.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof Scope)) {
                throw new IllegalArgumentException();
            }
            Scope scope = (Scope)object;
            sortedMap.put(scope.id, scope);
        }
        return sortedMap;
    }

    public static SortedMap sortedMapByName(List scopes) throws IllegalArgumentException {
        if (scopes == null) {
            throw new IllegalArgumentException();
        }
        TreeMap<String, Scope> sortedMap = new TreeMap<String, Scope>();
        Iterator iterator = scopes.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof Scope)) {
                throw new IllegalArgumentException();
            }
            Scope scope = (Scope)object;
            sortedMap.put(scope.name, scope);
        }
        return sortedMap;
    }

    private Scope(String description, String id, String name, String parent, String plugin) throws IllegalArgumentException {
        if (id == null || name == null) {
            throw new IllegalArgumentException();
        }
        this.description = description;
        this.id = id;
        this.name = name;
        this.parent = parent;
        this.plugin = plugin;
    }

    public int compareTo(Object object) {
        Scope item = (Scope)object;
        int compareTo = this.id.compareTo(item.id);
        if (compareTo == 0 && (compareTo = this.name.compareTo(item.name)) == 0) {
            Util.compare((Comparable)((Object)this.description), (Comparable)((Object)item.description));
            if (compareTo == 0 && (compareTo = Util.compare((Comparable)((Object)this.parent), (Comparable)((Object)item.parent))) == 0) {
                compareTo = Util.compare((Comparable)((Object)this.plugin), (Comparable)((Object)item.plugin));
            }
        }
        return compareTo;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Scope)) {
            return false;
        }
        Scope scope = (Scope)object;
        return Util.equals(this.description, scope.description) && this.id.equals(scope.id) && this.name.equals(scope.name) && Util.equals(this.parent, scope.parent) && Util.equals(this.plugin, scope.plugin);
    }

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getParent() {
        return this.parent;
    }

    public String getPlugin() {
        return this.plugin;
    }

    public int hashCode() {
        int result = 97;
        result = result * 87 + Util.hashCode(this.description);
        result = result * 87 + this.id.hashCode();
        result = result * 87 + this.name.hashCode();
        result = result * 87 + Util.hashCode(this.parent);
        result = result * 87 + Util.hashCode(this.plugin);
        return result;
    }

    public String toString() {
        return String.valueOf(this.name) + " (" + this.id + ')';
    }
}

