/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ui.internal.commands.Util;

public final class Path
implements Comparable {
    static final int MAXIMUM_PATH_ITEMS = 16;
    private static final int HASH_FACTOR = 67;
    private static final int HASH_INITIAL = 77;
    private List strings;

    static Path create() {
        return new Path(Collections.EMPTY_LIST);
    }

    static Path create(String string) throws IllegalArgumentException {
        return new Path(Collections.singletonList(string));
    }

    static Path create(String[] strings) throws IllegalArgumentException {
        return new Path(Arrays.asList(strings));
    }

    static Path create(List strings) throws IllegalArgumentException {
        return new Path(strings);
    }

    private Path(List strings) throws IllegalArgumentException {
        if (strings == null) {
            throw new IllegalArgumentException();
        }
        this.strings = Collections.unmodifiableList(new ArrayList(strings));
        if (this.strings.size() >= 16) {
            throw new IllegalArgumentException();
        }
        Iterator iterator = this.strings.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() instanceof String) continue;
            throw new IllegalArgumentException();
        }
    }

    public int compareTo(Object object) {
        return Util.compare(this.strings, ((Path)object).strings);
    }

    public boolean equals(Object object) {
        return object instanceof Path && this.strings.equals(((Path)object).strings);
    }

    public List getStrings() {
        return this.strings;
    }

    public int hashCode() {
        int result = 77;
        Iterator iterator = this.strings.iterator();
        while (iterator.hasNext()) {
            result = result * 67 + iterator.next().hashCode();
        }
        return result;
    }

    public boolean isChildOf(Path path, boolean equals) {
        if (path == null) {
            return false;
        }
        return Util.isChildOf(this.strings, path.strings, equals);
    }

    public int match(Path path) throws IllegalArgumentException {
        if (path == null) {
            throw new IllegalArgumentException();
        }
        if (path.isChildOf(this, true)) {
            return path.strings.size() - this.strings.size();
        }
        return -1;
    }

    public String toString() {
        return this.strings.toString();
    }
}

