/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeSet;
import org.eclipse.ui.internal.commands.ActiveConfiguration;
import org.eclipse.ui.internal.commands.Configuration;
import org.eclipse.ui.internal.commands.CoreRegistry;
import org.eclipse.ui.internal.commands.GestureSupport;
import org.eclipse.ui.internal.commands.KeySupport;
import org.eclipse.ui.internal.commands.LocalRegistry;
import org.eclipse.ui.internal.commands.PreferenceRegistry;
import org.eclipse.ui.internal.commands.Scope;
import org.eclipse.ui.internal.commands.Sequence;
import org.eclipse.ui.internal.commands.SequenceBinding;
import org.eclipse.ui.internal.commands.SequenceMachine;
import org.eclipse.ui.internal.commands.Stroke;

public class Manager {
    private static Manager instance;
    private SequenceMachine gestureMachine = SequenceMachine.create();
    private SequenceMachine keyMachine = SequenceMachine.create();

    public static Manager getInstance() {
        if (instance == null) {
            instance = new Manager();
        }
        return instance;
    }

    private Manager() {
        this.reset();
    }

    public SequenceMachine getGestureMachine() {
        return this.gestureMachine;
    }

    public SequenceMachine getKeyMachine() {
        return this.keyMachine;
    }

    public String getGestureTextForCommand(String command) throws IllegalArgumentException {
        String text = null;
        Sequence sequence = this.getGestureMachine().getFirstSequenceForCommand(command);
        if (sequence != null) {
            text = GestureSupport.formatSequence(sequence, true);
        }
        return text != null ? text : "";
    }

    public String getKeyTextForCommand(String command) throws IllegalArgumentException {
        String text = null;
        Sequence sequence = this.getKeyMachine().getFirstSequenceForCommand(command);
        if (sequence != null) {
            text = KeySupport.formatSequence(sequence, true);
        }
        return text != null ? text : "";
    }

    public void reset() {
        String activeKeyConfigurationId;
        String activeGestureConfigurationId;
        CoreRegistry coreRegistry = CoreRegistry.getInstance();
        LocalRegistry localRegistry = LocalRegistry.getInstance();
        PreferenceRegistry preferenceRegistry = PreferenceRegistry.getInstance();
        try {
            coreRegistry.load();
        }
        catch (IOException iOException) {}
        try {
            localRegistry.load();
        }
        catch (IOException iOException) {}
        try {
            preferenceRegistry.load();
        }
        catch (IOException iOException) {}
        ArrayList activeGestureConfigurations = new ArrayList();
        activeGestureConfigurations.addAll(coreRegistry.getActiveGestureConfigurations());
        activeGestureConfigurations.addAll(localRegistry.getActiveGestureConfigurations());
        activeGestureConfigurations.addAll(preferenceRegistry.getActiveGestureConfigurations());
        if (activeGestureConfigurations.size() == 0) {
            activeGestureConfigurationId = "";
        } else {
            ActiveConfiguration activeGestureConfiguration = (ActiveConfiguration)activeGestureConfigurations.get(activeGestureConfigurations.size() - 1);
            activeGestureConfigurationId = activeGestureConfiguration.getValue();
        }
        ArrayList activeKeyConfigurations = new ArrayList();
        activeKeyConfigurations.addAll(coreRegistry.getActiveKeyConfigurations());
        activeKeyConfigurations.addAll(localRegistry.getActiveKeyConfigurations());
        activeKeyConfigurations.addAll(preferenceRegistry.getActiveKeyConfigurations());
        if (activeKeyConfigurations.size() == 0) {
            activeKeyConfigurationId = "";
        } else {
            ActiveConfiguration activeKeyConfiguration = (ActiveConfiguration)activeKeyConfigurations.get(activeKeyConfigurations.size() - 1);
            activeKeyConfigurationId = activeKeyConfiguration.getValue();
        }
        TreeSet gestureBindingSet = new TreeSet();
        gestureBindingSet.addAll(coreRegistry.getGestureBindings());
        gestureBindingSet.addAll(localRegistry.getGestureBindings());
        gestureBindingSet.addAll(preferenceRegistry.getGestureBindings());
        Manager.validateSequenceBindings(gestureBindingSet);
        ArrayList gestureConfigurations = new ArrayList();
        gestureConfigurations.addAll(coreRegistry.getGestureConfigurations());
        gestureConfigurations.addAll(localRegistry.getGestureConfigurations());
        gestureConfigurations.addAll(preferenceRegistry.getGestureConfigurations());
        SortedMap gestureConfigurationMap = SequenceMachine.buildPathMapForConfigurationMap(Configuration.sortedMapById(gestureConfigurations));
        TreeSet keyBindingSet = new TreeSet();
        keyBindingSet.addAll(coreRegistry.getKeyBindings());
        keyBindingSet.addAll(localRegistry.getKeyBindings());
        keyBindingSet.addAll(preferenceRegistry.getKeyBindings());
        Manager.validateSequenceBindings(keyBindingSet);
        ArrayList keyConfigurations = new ArrayList();
        keyConfigurations.addAll(coreRegistry.getKeyConfigurations());
        keyConfigurations.addAll(localRegistry.getKeyConfigurations());
        keyConfigurations.addAll(preferenceRegistry.getKeyConfigurations());
        SortedMap keyConfigurationMap = SequenceMachine.buildPathMapForConfigurationMap(Configuration.sortedMapById(keyConfigurations));
        ArrayList scopes = new ArrayList();
        scopes.addAll(coreRegistry.getScopes());
        scopes.addAll(localRegistry.getScopes());
        scopes.addAll(preferenceRegistry.getScopes());
        SortedMap scopeMap = SequenceMachine.buildPathMapForScopeMap(Scope.sortedMapById(scopes));
        this.gestureMachine.setConfiguration(activeGestureConfigurationId);
        this.gestureMachine.setConfigurationMap(Collections.unmodifiableSortedMap(gestureConfigurationMap));
        this.gestureMachine.setScopeMap(Collections.unmodifiableSortedMap(scopeMap));
        this.gestureMachine.setBindingSet(Collections.unmodifiableSortedSet(gestureBindingSet));
        this.keyMachine.setConfiguration(activeKeyConfigurationId);
        this.keyMachine.setConfigurationMap(Collections.unmodifiableSortedMap(keyConfigurationMap));
        this.keyMachine.setScopeMap(Collections.unmodifiableSortedMap(scopeMap));
        this.keyMachine.setBindingSet(Collections.unmodifiableSortedSet(keyBindingSet));
    }

    static boolean validateStroke(Stroke stroke) {
        return stroke.getValue() != 0;
    }

    static boolean validateSequence(Sequence sequence) {
        List strokes = sequence.getStrokes();
        int size = strokes.size();
        if (size == 0) {
            return false;
        }
        int i = 0;
        while (i < size) {
            Stroke stroke = (Stroke)strokes.get(i);
            if (!Manager.validateStroke(stroke)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    static void validateSequenceBindings(Collection sequenceBindings) {
        Iterator iterator = sequenceBindings.iterator();
        while (iterator.hasNext()) {
            SequenceBinding sequenceBinding = (SequenceBinding)iterator.next();
            if (Manager.validateSequence(sequenceBinding.getSequence())) continue;
            iterator.remove();
        }
    }
}

