/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.eclipse.ui.internal.commands.Sequence;
import org.eclipse.ui.internal.commands.Stroke;
import org.eclipse.ui.internal.commands.Util;

public final class KeySupport {
    private static final ResourceBundle resourceBundle;
    private static final String ALT = "Alt";
    private static final String COMMAND = "Command";
    private static final String CTRL = "Ctrl";
    private static final String MODIFIER_SEPARATOR = "+";
    private static final String SHIFT = "Shift";
    private static final String STROKE_SEPARATOR = " ";
    private static Map localizedStringToValueMap;
    private static Map stringToValueMap;
    private static Map valueToLocalizedStringMap;
    private static Map valueToStringMap;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.internal.commands.KeySupport");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        resourceBundle = ResourceBundle.getBundle(clazz.getName());
        localizedStringToValueMap = new TreeMap();
        stringToValueMap = new TreeMap();
        valueToLocalizedStringMap = new TreeMap();
        valueToStringMap = new TreeMap();
        localizedStringToValueMap.put(KeySupport.u(KeySupport.l("Backspace")), new Integer(8));
        localizedStringToValueMap.put(KeySupport.u(KeySupport.l("Tab")), new Integer(9));
        localizedStringToValueMap.put(KeySupport.u(KeySupport.l("Return")), new Integer(13));
        localizedStringToValueMap.put(KeySupport.u(KeySupport.l("Enter")), new Integer(13));
        localizedStringToValueMap.put(KeySupport.u(KeySupport.l("Escape")), new Integer(27));
        localizedStringToValueMap.put(KeySupport.u(KeySupport.l("Esc")), new Integer(27));
        localizedStringToValueMap.put(KeySupport.u(KeySupport.l("Delete")), new Integer(127));
        localizedStringToValueMap.put(KeySupport.u(KeySupport.l("Space")), new Integer(32));
        localizedStringToValueMap.put(KeySupport.u(KeySupport.l("Arrow_Up")), new Integer(0x1000001));
        localizedStringToValueMap.put(KeySupport.u(KeySupport.l("Arrow_Down")), new Integer(0x1000002));
        localizedStringToValueMap.put(KeySupport.u(KeySupport.l("Arrow_Left")), new Integer(0x1000003));
        localizedStringToValueMap.put(KeySupport.u(KeySupport.l("Arrow_Right")), new Integer(0x1000004));
        localizedStringToValueMap.put(KeySupport.u(KeySupport.l("Page_Up")), new Integer(0x1000005));
        localizedStringToValueMap.put(KeySupport.u(KeySupport.l("Page_Down")), new Integer(0x1000006));
        localizedStringToValueMap.put(KeySupport.u(KeySupport.l("Home")), new Integer(0x1000007));
        localizedStringToValueMap.put(KeySupport.u(KeySupport.l("End")), new Integer(0x1000008));
        localizedStringToValueMap.put(KeySupport.u(KeySupport.l("Insert")), new Integer(0x1000009));
        localizedStringToValueMap.put(KeySupport.u(KeySupport.l("F1")), new Integer(0x100000A));
        localizedStringToValueMap.put(KeySupport.u(KeySupport.l("F2")), new Integer(0x100000B));
        localizedStringToValueMap.put(KeySupport.u(KeySupport.l("F3")), new Integer(0x100000C));
        localizedStringToValueMap.put(KeySupport.u(KeySupport.l("F4")), new Integer(0x100000D));
        localizedStringToValueMap.put(KeySupport.u(KeySupport.l("F5")), new Integer(0x100000E));
        localizedStringToValueMap.put(KeySupport.u(KeySupport.l("F6")), new Integer(0x100000F));
        localizedStringToValueMap.put(KeySupport.u(KeySupport.l("F7")), new Integer(0x1000010));
        localizedStringToValueMap.put(KeySupport.u(KeySupport.l("F8")), new Integer(0x1000011));
        localizedStringToValueMap.put(KeySupport.u(KeySupport.l("F9")), new Integer(0x1000012));
        localizedStringToValueMap.put(KeySupport.u(KeySupport.l("F10")), new Integer(0x1000013));
        localizedStringToValueMap.put(KeySupport.u(KeySupport.l("F11")), new Integer(0x1000014));
        localizedStringToValueMap.put(KeySupport.u(KeySupport.l("F12")), new Integer(0x1000015));
        stringToValueMap.put(KeySupport.u("Backspace"), new Integer(8));
        stringToValueMap.put(KeySupport.u("Tab"), new Integer(9));
        stringToValueMap.put(KeySupport.u("Return"), new Integer(13));
        stringToValueMap.put(KeySupport.u("Enter"), new Integer(13));
        stringToValueMap.put(KeySupport.u("Escape"), new Integer(27));
        stringToValueMap.put(KeySupport.u("Esc"), new Integer(27));
        stringToValueMap.put(KeySupport.u("Delete"), new Integer(127));
        stringToValueMap.put(KeySupport.u("Space"), new Integer(32));
        stringToValueMap.put(KeySupport.u("Arrow_Up"), new Integer(0x1000001));
        stringToValueMap.put(KeySupport.u("Arrow_Down"), new Integer(0x1000002));
        stringToValueMap.put(KeySupport.u("Arrow_Left"), new Integer(0x1000003));
        stringToValueMap.put(KeySupport.u("Arrow_Right"), new Integer(0x1000004));
        stringToValueMap.put(KeySupport.u("Page_Up"), new Integer(0x1000005));
        stringToValueMap.put(KeySupport.u("Page_Down"), new Integer(0x1000006));
        stringToValueMap.put(KeySupport.u("Home"), new Integer(0x1000007));
        stringToValueMap.put(KeySupport.u("End"), new Integer(0x1000008));
        stringToValueMap.put(KeySupport.u("Insert"), new Integer(0x1000009));
        stringToValueMap.put(KeySupport.u("F1"), new Integer(0x100000A));
        stringToValueMap.put(KeySupport.u("F2"), new Integer(0x100000B));
        stringToValueMap.put(KeySupport.u("F3"), new Integer(0x100000C));
        stringToValueMap.put(KeySupport.u("F4"), new Integer(0x100000D));
        stringToValueMap.put(KeySupport.u("F5"), new Integer(0x100000E));
        stringToValueMap.put(KeySupport.u("F6"), new Integer(0x100000F));
        stringToValueMap.put(KeySupport.u("F7"), new Integer(0x1000010));
        stringToValueMap.put(KeySupport.u("F8"), new Integer(0x1000011));
        stringToValueMap.put(KeySupport.u("F9"), new Integer(0x1000012));
        stringToValueMap.put(KeySupport.u("F10"), new Integer(0x1000013));
        stringToValueMap.put(KeySupport.u("F11"), new Integer(0x1000014));
        stringToValueMap.put(KeySupport.u("F12"), new Integer(0x1000015));
        valueToLocalizedStringMap.put(new Integer(8), KeySupport.l("Backspace"));
        valueToLocalizedStringMap.put(new Integer(9), KeySupport.l("Tab"));
        valueToLocalizedStringMap.put(new Integer(13), KeySupport.l("Return"));
        valueToLocalizedStringMap.put(new Integer(13), KeySupport.l("Enter"));
        valueToLocalizedStringMap.put(new Integer(27), KeySupport.l("Escape"));
        valueToLocalizedStringMap.put(new Integer(27), KeySupport.l("Esc"));
        valueToLocalizedStringMap.put(new Integer(127), KeySupport.l("Delete"));
        valueToLocalizedStringMap.put(new Integer(32), KeySupport.l("Space"));
        valueToLocalizedStringMap.put(new Integer(0x1000001), KeySupport.l("Arrow_Up"));
        valueToLocalizedStringMap.put(new Integer(0x1000002), KeySupport.l("Arrow_Down"));
        valueToLocalizedStringMap.put(new Integer(0x1000003), KeySupport.l("Arrow_Left"));
        valueToLocalizedStringMap.put(new Integer(0x1000004), KeySupport.l("Arrow_Right"));
        valueToLocalizedStringMap.put(new Integer(0x1000005), KeySupport.l("Page_Up"));
        valueToLocalizedStringMap.put(new Integer(0x1000006), KeySupport.l("Page_Down"));
        valueToLocalizedStringMap.put(new Integer(0x1000007), KeySupport.l("Home"));
        valueToLocalizedStringMap.put(new Integer(0x1000008), KeySupport.l("End"));
        valueToLocalizedStringMap.put(new Integer(0x1000009), KeySupport.l("Insert"));
        valueToLocalizedStringMap.put(new Integer(0x100000A), KeySupport.l("F1"));
        valueToLocalizedStringMap.put(new Integer(0x100000B), KeySupport.l("F2"));
        valueToLocalizedStringMap.put(new Integer(0x100000C), KeySupport.l("F3"));
        valueToLocalizedStringMap.put(new Integer(0x100000D), KeySupport.l("F4"));
        valueToLocalizedStringMap.put(new Integer(0x100000E), KeySupport.l("F5"));
        valueToLocalizedStringMap.put(new Integer(0x100000F), KeySupport.l("F6"));
        valueToLocalizedStringMap.put(new Integer(0x1000010), KeySupport.l("F7"));
        valueToLocalizedStringMap.put(new Integer(0x1000011), KeySupport.l("F8"));
        valueToLocalizedStringMap.put(new Integer(0x1000012), KeySupport.l("F9"));
        valueToLocalizedStringMap.put(new Integer(0x1000013), KeySupport.l("F10"));
        valueToLocalizedStringMap.put(new Integer(0x1000014), KeySupport.l("F11"));
        valueToLocalizedStringMap.put(new Integer(0x1000015), KeySupport.l("F12"));
        valueToStringMap.put(new Integer(8), "Backspace");
        valueToStringMap.put(new Integer(9), "Tab");
        valueToStringMap.put(new Integer(13), "Return");
        valueToStringMap.put(new Integer(13), "Enter");
        valueToStringMap.put(new Integer(27), "Escape");
        valueToStringMap.put(new Integer(27), "Esc");
        valueToStringMap.put(new Integer(127), "Delete");
        valueToStringMap.put(new Integer(32), "Space");
        valueToStringMap.put(new Integer(0x1000001), "Arrow_Up");
        valueToStringMap.put(new Integer(0x1000002), "Arrow_Down");
        valueToStringMap.put(new Integer(0x1000003), "Arrow_Left");
        valueToStringMap.put(new Integer(0x1000004), "Arrow_Right");
        valueToStringMap.put(new Integer(0x1000005), "Page_Up");
        valueToStringMap.put(new Integer(0x1000006), "Page_Down");
        valueToStringMap.put(new Integer(0x1000007), "Home");
        valueToStringMap.put(new Integer(0x1000008), "End");
        valueToStringMap.put(new Integer(0x1000009), "Insert");
        valueToStringMap.put(new Integer(0x100000A), "F1");
        valueToStringMap.put(new Integer(0x100000B), "F2");
        valueToStringMap.put(new Integer(0x100000C), "F3");
        valueToStringMap.put(new Integer(0x100000D), "F4");
        valueToStringMap.put(new Integer(0x100000E), "F5");
        valueToStringMap.put(new Integer(0x100000F), "F6");
        valueToStringMap.put(new Integer(0x1000010), "F7");
        valueToStringMap.put(new Integer(0x1000011), "F8");
        valueToStringMap.put(new Integer(0x1000012), "F9");
        valueToStringMap.put(new Integer(0x1000013), "F10");
        valueToStringMap.put(new Integer(0x1000014), "F11");
        valueToStringMap.put(new Integer(0x1000015), "F12");
    }

    private static String l(String string) {
        return Util.getString(resourceBundle, string);
    }

    private static String u(String string) {
        return string.toUpperCase();
    }

    public static String formatSequence(Sequence sequence, boolean localized) throws IllegalArgumentException {
        if (sequence == null) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        Iterator iterator = sequence.getStrokes().iterator();
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            if (i != 0) {
                stringBuffer.append(STROKE_SEPARATOR);
            }
            stringBuffer.append(KeySupport.formatStroke((Stroke)iterator.next(), localized));
            ++i;
        }
        return stringBuffer.toString();
    }

    public static String formatStroke(Stroke stroke, boolean localized) throws IllegalArgumentException {
        String string;
        if (stroke == null) {
            throw new IllegalArgumentException();
        }
        StringBuffer stringBuffer = new StringBuffer();
        int value = stroke.getValue();
        if ((value & 0x40000) != 0) {
            stringBuffer.append(localized ? KeySupport.l(CTRL) : CTRL);
        }
        if ((value & 0x10000) != 0) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(MODIFIER_SEPARATOR);
            }
            stringBuffer.append(localized ? KeySupport.l(ALT) : ALT);
        }
        if ((value & 0x20000) != 0) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(MODIFIER_SEPARATOR);
            }
            stringBuffer.append(localized ? KeySupport.l(SHIFT) : SHIFT);
        }
        if ((value & 0x400000) != 0) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(MODIFIER_SEPARATOR);
            }
            stringBuffer.append(localized ? KeySupport.l(COMMAND) : COMMAND);
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.append(MODIFIER_SEPARATOR);
        }
        String string2 = string = localized ? (String)valueToLocalizedStringMap.get(new Integer(value)) : (String)valueToStringMap.get(new Integer(value &= 0xFFB8FFFF));
        if (string != null) {
            stringBuffer.append(string);
        } else {
            stringBuffer.append(Character.toUpperCase((char)value));
        }
        return stringBuffer.toString();
    }

    public static Sequence parseSequence(String string, boolean localized) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<Stroke> strokes = new ArrayList<Stroke>();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            strokes.add(KeySupport.parseStroke(stringTokenizer.nextToken(), localized));
        }
        return Sequence.create(strokes);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Stroke parseStroke(String string, boolean localized) throws IllegalArgumentException {
        Integer integer;
        if (string == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, MODIFIER_SEPARATOR, true);
        while (stringTokenizer.hasMoreTokens()) {
            list.add(stringTokenizer.nextToken());
        }
        int size = list.size();
        int value = 0;
        if (size % 2 != 1) return Stroke.create(value);
        String token = (String)list.get(size - 1);
        Integer n = integer = localized ? (Integer)localizedStringToValueMap.get(KeySupport.u(token)) : (Integer)stringToValueMap.get(KeySupport.u(token));
        if (integer != null) {
            value = integer;
        } else if (token.length() == 1) {
            value = KeySupport.u(token).charAt(0);
        }
        if (value == 0) return Stroke.create(value);
        int i = 0;
        while (i < size - 1) {
            token = (String)list.get(i);
            if (i % 2 == 0) {
                if (token.equalsIgnoreCase(localized ? KeySupport.l(CTRL) : CTRL)) {
                    if ((value & 0x40000) != 0) {
                        return Stroke.create(0);
                    }
                    value |= 0x40000;
                } else if (token.equalsIgnoreCase(localized ? KeySupport.l(ALT) : ALT)) {
                    if ((value & 0x10000) != 0) {
                        return Stroke.create(0);
                    }
                    value |= 0x10000;
                } else if (token.equalsIgnoreCase(localized ? KeySupport.l(SHIFT) : SHIFT)) {
                    if ((value & 0x20000) != 0) {
                        return Stroke.create(0);
                    }
                    value |= 0x20000;
                } else {
                    if (!token.equalsIgnoreCase(localized ? KeySupport.l(COMMAND) : COMMAND)) return Stroke.create(0);
                    if ((value & 0x400000) != 0) {
                        return Stroke.create(0);
                    }
                    value |= 0x400000;
                }
            } else if (!MODIFIER_SEPARATOR.equals(token)) {
                return Stroke.create(0);
            }
            ++i;
        }
        return Stroke.create(value);
    }

    private KeySupport() {
    }
}

