/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.internal.commands.AbstractRegistry;
import org.eclipse.ui.internal.commands.ActiveConfiguration;
import org.eclipse.ui.internal.commands.Category;
import org.eclipse.ui.internal.commands.Command;
import org.eclipse.ui.internal.commands.Configuration;
import org.eclipse.ui.internal.commands.ConfigurationElementMemento;
import org.eclipse.ui.internal.commands.KeySupport;
import org.eclipse.ui.internal.commands.Persistence;
import org.eclipse.ui.internal.commands.Scope;
import org.eclipse.ui.internal.commands.Sequence;
import org.eclipse.ui.internal.commands.SequenceBinding;

public final class CoreRegistry
extends AbstractRegistry {
    private static CoreRegistry instance;
    private boolean loaded;

    public static CoreRegistry getInstance() {
        if (instance == null) {
            instance = new CoreRegistry();
        }
        return instance;
    }

    private CoreRegistry() {
    }

    public void load() throws IOException {
        if (!this.loaded) {
            new RegistryReader(Platform.getPluginRegistry());
            this.loaded = true;
        }
    }

    private final class RegistryReader
    extends org.eclipse.ui.internal.registry.RegistryReader {
        private static final String DEPRECATED_KEY_SEQUENCE_SEPARATOR = "||";
        private static final String DEPRECATED_TAG_ACCELERATOR = "accelerator";
        private static final String DEPRECATED_TAG_ACCELERATOR_CONFIGURATION = "acceleratorConfiguration";
        private static final String DEPRECATED_TAG_ACCELERATOR_CONFIGURATIONS = "acceleratorConfigurations";
        private static final String DEPRECATED_TAG_ACCELERATOR_SCOPE = "acceleratorScope";
        private static final String DEPRECATED_TAG_ACCELERATOR_SCOPES = "acceleratorScopes";
        private static final String DEPRECATED_TAG_ACCELERATOR_SET = "acceleratorSet";
        private static final String DEPRECATED_TAG_ACCELERATOR_SETS = "acceleratorSets";
        private static final String DEPRECATED_TAG_ACTION_DEFINITION = "actionDefinition";
        private static final String DEPRECATED_TAG_ACTION_DEFINITIONS = "actionDefinitions";
        private static final String DEPRECATED_TAG_CONFIGURATION_ID = "configurationId";
        private static final String DEPRECATED_TAG_KEY = "key";
        private static final String DEPRECATED_TAG_SCOPE_ID = "scopeId";
        private static final int RANK_CORE = 2;
        private static final String TAG_ROOT = "commands";
        private List activeGestureConfigurations = new ArrayList();
        private List activeKeyConfigurations = new ArrayList();
        private List categories = new ArrayList();
        private List commands = new ArrayList();
        private List gestureBindings = new ArrayList();
        private List gestureConfigurations = new ArrayList();
        private List keyBindings = new ArrayList();
        private String keyConfiguration;
        private List keyConfigurations = new ArrayList();
        private String scope;
        private List scopes = new ArrayList();

        RegistryReader(IPluginRegistry pluginRegistry) {
            if (pluginRegistry != null) {
                this.readRegistry(pluginRegistry, "org.eclipse.ui", DEPRECATED_TAG_ACCELERATOR_CONFIGURATIONS);
                this.readRegistry(pluginRegistry, "org.eclipse.ui", DEPRECATED_TAG_ACCELERATOR_SCOPES);
                this.readRegistry(pluginRegistry, "org.eclipse.ui", DEPRECATED_TAG_ACCELERATOR_SETS);
                this.readRegistry(pluginRegistry, "org.eclipse.ui", DEPRECATED_TAG_ACTION_DEFINITIONS);
                this.readRegistry(pluginRegistry, "org.eclipse.ui", TAG_ROOT);
            }
            CoreRegistry.this.activeGestureConfigurations = Collections.unmodifiableList(this.activeGestureConfigurations);
            CoreRegistry.this.activeKeyConfigurations = Collections.unmodifiableList(this.activeKeyConfigurations);
            CoreRegistry.this.categories = Collections.unmodifiableList(this.categories);
            CoreRegistry.this.commands = Collections.unmodifiableList(this.commands);
            CoreRegistry.this.gestureBindings = Collections.unmodifiableList(this.gestureBindings);
            CoreRegistry.this.gestureConfigurations = Collections.unmodifiableList(this.gestureConfigurations);
            CoreRegistry.this.keyBindings = Collections.unmodifiableList(this.keyBindings);
            CoreRegistry.this.keyConfigurations = Collections.unmodifiableList(this.keyConfigurations);
            CoreRegistry.this.scopes = Collections.unmodifiableList(this.scopes);
        }

        protected boolean readElement(IConfigurationElement element) {
            String name = element.getName();
            if (DEPRECATED_TAG_ACCELERATOR.equals(name) || DEPRECATED_TAG_ACCELERATOR_SET.equals(name)) {
                if (DEPRECATED_TAG_ACCELERATOR.equals(name)) {
                    return this.readDeprecatedAccelerator(element);
                }
                return this.readDeprecatedAcceleratorSet(element);
            }
            if (DEPRECATED_TAG_ACCELERATOR_CONFIGURATION.equals(name)) {
                return this.readKeyConfiguration(element);
            }
            if (DEPRECATED_TAG_ACCELERATOR_SCOPE.equals(name)) {
                return this.readScope(element);
            }
            if (DEPRECATED_TAG_ACTION_DEFINITION.equals(name)) {
                return this.readCommand(element);
            }
            if ("activeGestureConfiguration".equals(name)) {
                return this.readActiveGestureConfiguration(element);
            }
            if ("activeKeyConfiguration".equals(name)) {
                return this.readActiveKeyConfiguration(element);
            }
            if ("category".equals(name)) {
                return this.readCategory(element);
            }
            if ("command".equals(name)) {
                return this.readCommand(element);
            }
            if ("gestureBinding".equals(name)) {
                return this.readGestureBinding(element);
            }
            if ("gestureConfiguration".equals(name)) {
                return this.readGestureConfiguration(element);
            }
            if ("keyBinding".equals(name)) {
                return this.readKeyBinding(element);
            }
            if ("keyConfiguration".equals(name)) {
                return this.readKeyConfiguration(element);
            }
            if ("scope".equals(name)) {
                return this.readScope(element);
            }
            return false;
        }

        private String getPlugin(IConfigurationElement element) {
            IPluginDescriptor pluginDescriptor;
            IExtension extension;
            String plugin = null;
            if (element != null && (extension = element.getDeclaringExtension()) != null && (pluginDescriptor = extension.getDeclaringPluginDescriptor()) != null) {
                plugin = pluginDescriptor.getUniqueIdentifier();
            }
            return plugin;
        }

        private boolean readActiveGestureConfiguration(IConfigurationElement element) {
            ActiveConfiguration activeGestureConfiguration = Persistence.readActiveConfiguration(ConfigurationElementMemento.create(element), this.getPlugin(element));
            if (activeGestureConfiguration != null) {
                this.activeGestureConfigurations.add(activeGestureConfiguration);
            }
            return true;
        }

        private boolean readActiveKeyConfiguration(IConfigurationElement element) {
            ActiveConfiguration activeKeyConfiguration = Persistence.readActiveConfiguration(ConfigurationElementMemento.create(element), this.getPlugin(element));
            if (activeKeyConfiguration != null) {
                this.activeKeyConfigurations.add(activeKeyConfiguration);
            }
            return true;
        }

        private boolean readCategory(IConfigurationElement element) {
            Category category = Persistence.readCategory(ConfigurationElementMemento.create(element), this.getPlugin(element));
            if (category != null) {
                this.categories.add(category);
            }
            return true;
        }

        private boolean readCommand(IConfigurationElement element) {
            Command command = Persistence.readCommand(ConfigurationElementMemento.create(element), this.getPlugin(element));
            if (command != null) {
                this.commands.add(command);
            }
            return true;
        }

        private boolean readDeprecatedAccelerator(IConfigurationElement element) {
            if (this.keyConfiguration == null || this.scope == null) {
                return false;
            }
            String id = element.getAttribute("id");
            String key = element.getAttribute(DEPRECATED_TAG_KEY);
            if (key != null) {
                ArrayList<Sequence> sequences = new ArrayList<Sequence>();
                StringTokenizer orTokenizer = new StringTokenizer(key, DEPRECATED_KEY_SEQUENCE_SEPARATOR);
                while (orTokenizer.hasMoreTokens()) {
                    try {
                        Sequence sequence = KeySupport.parseSequence(orTokenizer.nextToken(), false);
                        if (sequence.getStrokes().size() < 1) continue;
                        sequences.add(sequence);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
                if (sequences.size() >= 1) {
                    String platform;
                    String locale = element.getAttribute("locale");
                    if (locale == null) {
                        locale = "";
                    }
                    if ((platform = element.getAttribute("platform")) == null) {
                        platform = "";
                    }
                    String plugin = this.getPlugin(element);
                    Iterator iterator = sequences.iterator();
                    while (iterator.hasNext()) {
                        Sequence sequence = (Sequence)iterator.next();
                        this.keyBindings.add(SequenceBinding.create(this.keyConfiguration, id, locale, platform, plugin, 2, this.scope, sequence));
                    }
                }
            }
            return true;
        }

        private boolean readDeprecatedAcceleratorSet(IConfigurationElement element) {
            this.keyConfiguration = element.getAttribute(DEPRECATED_TAG_CONFIGURATION_ID);
            this.scope = element.getAttribute(DEPRECATED_TAG_SCOPE_ID);
            if (this.keyConfiguration != null && this.scope != null) {
                this.readElementChildren(element);
            }
            this.keyConfiguration = null;
            this.scope = null;
            return true;
        }

        private boolean readGestureBinding(IConfigurationElement element) {
            SequenceBinding gestureBinding = Persistence.readBinding(ConfigurationElementMemento.create(element), this.getPlugin(element), 2);
            if (gestureBinding != null) {
                this.gestureBindings.add(gestureBinding);
            }
            return true;
        }

        private boolean readGestureConfiguration(IConfigurationElement element) {
            Configuration gestureConfiguration = Persistence.readConfiguration(ConfigurationElementMemento.create(element), this.getPlugin(element));
            if (gestureConfiguration != null) {
                this.gestureConfigurations.add(gestureConfiguration);
            }
            return true;
        }

        private boolean readKeyBinding(IConfigurationElement element) {
            SequenceBinding keyBinding = Persistence.readBinding(ConfigurationElementMemento.create(element), this.getPlugin(element), 2);
            if (keyBinding != null) {
                this.keyBindings.add(keyBinding);
            }
            return true;
        }

        private boolean readKeyConfiguration(IConfigurationElement element) {
            Configuration keyConfiguration = Persistence.readConfiguration(ConfigurationElementMemento.create(element), this.getPlugin(element));
            if (keyConfiguration != null) {
                this.keyConfigurations.add(keyConfiguration);
            }
            return true;
        }

        private boolean readScope(IConfigurationElement element) {
            Scope scope = Persistence.readScope(ConfigurationElementMemento.create(element), this.getPlugin(element));
            if (scope != null) {
                this.scopes.add(scope);
            }
            return true;
        }
    }
}

