/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import java.text.Collator;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.ui.internal.commands.Util;

public final class Command
implements Comparable {
    private static final int HASH_FACTOR = 47;
    private static final int HASH_INITIAL = 57;
    private static Comparator nameComparator;
    private String category;
    private String description;
    private String id;
    private String name;
    private String plugin;

    public static Command create(String category, String description, String id, String name, String plugin) throws IllegalArgumentException {
        return new Command(category, description, id, name, plugin);
    }

    public static Comparator nameComparator() {
        if (nameComparator == null) {
            nameComparator = new Comparator(){

                public int compare(Object left, Object right) {
                    return Collator.getInstance().compare(((Command)left).name, ((Command)right).name);
                }
            };
        }
        return nameComparator;
    }

    public static SortedMap sortedMapById(List commands) throws IllegalArgumentException {
        if (commands == null) {
            throw new IllegalArgumentException();
        }
        TreeMap<String, Command> sortedMap = new TreeMap<String, Command>();
        Iterator iterator = commands.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof Command)) {
                throw new IllegalArgumentException();
            }
            Command command = (Command)object;
            sortedMap.put(command.id, command);
        }
        return sortedMap;
    }

    public static SortedMap sortedMapByName(List commands) throws IllegalArgumentException {
        if (commands == null) {
            throw new IllegalArgumentException();
        }
        TreeMap<String, Command> sortedMap = new TreeMap<String, Command>();
        Iterator iterator = commands.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof Command)) {
                throw new IllegalArgumentException();
            }
            Command command = (Command)object;
            sortedMap.put(command.name, command);
        }
        return sortedMap;
    }

    private Command(String category, String description, String id, String name, String plugin) throws IllegalArgumentException {
        if (id == null || name == null) {
            throw new IllegalArgumentException();
        }
        this.category = category;
        this.description = description;
        this.id = id;
        this.name = name;
        this.plugin = plugin;
    }

    public int compareTo(Object object) {
        Command command = (Command)object;
        int compareTo = Util.compare((Comparable)((Object)this.category), (Comparable)((Object)command.category));
        if (compareTo == 0 && (compareTo = Util.compare((Comparable)((Object)this.description), (Comparable)((Object)command.description))) == 0 && (compareTo = this.id.compareTo(command.id)) == 0 && (compareTo = this.name.compareTo(command.name)) == 0) {
            compareTo = Util.compare((Comparable)((Object)this.plugin), (Comparable)((Object)command.plugin));
        }
        return compareTo;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Command)) {
            return false;
        }
        Command command = (Command)object;
        return Util.equals(this.category, command.category) && Util.equals(this.description, command.description) && this.id.equals(command.id) && this.name.equals(command.name) && Util.equals(this.plugin, command.plugin);
    }

    public String getCategory() {
        return this.category;
    }

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getPlugin() {
        return this.plugin;
    }

    public int hashCode() {
        int result = 57;
        result = result * 47 + Util.hashCode(this.category);
        result = result * 47 + Util.hashCode(this.description);
        result = result * 47 + this.id.hashCode();
        result = result * 47 + this.name.hashCode();
        result = result * 47 + Util.hashCode(this.plugin);
        return result;
    }

    public String toString() {
        return String.valueOf(this.name) + " (" + this.id + ')';
    }
}

