/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import java.text.Collator;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.ui.internal.commands.Util;

public final class Category
implements Comparable {
    private static final int HASH_FACTOR = 37;
    private static final int HASH_INITIAL = 47;
    private static Comparator nameComparator;
    private String description;
    private String id;
    private String name;
    private String plugin;

    public static Category create(String description, String id, String name, String plugin) throws IllegalArgumentException {
        return new Category(description, id, name, plugin);
    }

    public static Comparator nameComparator() {
        if (nameComparator == null) {
            nameComparator = new Comparator(){

                public int compare(Object left, Object right) {
                    return Collator.getInstance().compare(((Category)left).name, ((Category)right).name);
                }
            };
        }
        return nameComparator;
    }

    public static SortedMap sortedMapById(List categories) throws IllegalArgumentException {
        if (categories == null) {
            throw new IllegalArgumentException();
        }
        TreeMap<String, Category> sortedMap = new TreeMap<String, Category>();
        Iterator iterator = categories.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof Category)) {
                throw new IllegalArgumentException();
            }
            Category category = (Category)object;
            sortedMap.put(category.id, category);
        }
        return sortedMap;
    }

    public static SortedMap sortedMapByName(List categories) throws IllegalArgumentException {
        if (categories == null) {
            throw new IllegalArgumentException();
        }
        TreeMap<String, Category> sortedMap = new TreeMap<String, Category>();
        Iterator iterator = categories.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof Category)) {
                throw new IllegalArgumentException();
            }
            Category category = (Category)object;
            sortedMap.put(category.name, category);
        }
        return sortedMap;
    }

    private Category(String description, String id, String name, String plugin) throws IllegalArgumentException {
        if (id == null || name == null) {
            throw new IllegalArgumentException();
        }
        this.description = description;
        this.id = id;
        this.name = name;
        this.plugin = plugin;
    }

    public int compareTo(Object object) {
        Category category = (Category)object;
        int compareTo = Util.compare((Comparable)((Object)this.description), (Comparable)((Object)category.description));
        if (compareTo == 0 && (compareTo = this.id.compareTo(category.id)) == 0 && (compareTo = this.name.compareTo(category.name)) == 0) {
            compareTo = Util.compare((Comparable)((Object)this.plugin), (Comparable)((Object)category.plugin));
        }
        return compareTo;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Category)) {
            return false;
        }
        Category category = (Category)object;
        return Util.equals(this.description, category.description) && this.id.equals(category.id) && this.name.equals(category.name) && Util.equals(this.plugin, category.plugin);
    }

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getPlugin() {
        return this.plugin;
    }

    public int hashCode() {
        int result = 47;
        result = result * 37 + Util.hashCode(this.description);
        result = result * 37 + this.id.hashCode();
        result = result * 37 + this.name.hashCode();
        result = result * 37 + Util.hashCode(this.plugin);
        return result;
    }

    public String toString() {
        return String.valueOf(this.name) + " (" + this.id + ')';
    }
}

