/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.actions;

import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.INullSelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.PartEventAction;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.dialogs.PropertyDialog;
import org.eclipse.ui.internal.dialogs.PropertyPageContributorManager;
import org.eclipse.ui.internal.dialogs.PropertyPageManager;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class ProjectPropertyDialogAction
extends PartEventAction
implements INullSelectionListener {
    private IWorkbenchWindow window;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public ProjectPropertyDialogAction(IWorkbenchWindow window) {
        super(new String());
        this.window = window;
        this.setText(WorkbenchMessages.getString("Workbench.projectProperties"));
        this.setToolTipText(WorkbenchMessages.getString("Workbench.projectPropertiesToolTip"));
        WorkbenchHelp.setHelp((IAction)this, "org.eclipse.ui.project_property_dialog_action_context");
        window.getSelectionService().addSelectionListener(this);
    }

    private String getName(IAdaptable element) {
        IWorkbenchAdapter adapter;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adapter = (IWorkbenchAdapter)element.getAdapter((Class)clazz)) != null) {
            return adapter.getLabel(element);
        }
        return "";
    }

    public void run() {
        IProject project = this.getProject();
        if (project == null) {
            return;
        }
        PropertyPageManager pageManager = new PropertyPageManager();
        String title = "";
        PropertyPageContributorManager.getManager().contribute(pageManager, (IAdaptable)project);
        Iterator pages = pageManager.getElements(0).iterator();
        String name = this.getName((IAdaptable)project);
        if (!pages.hasNext()) {
            MessageDialog.openInformation((Shell)this.window.getShell(), (String)WorkbenchMessages.getString("PropertyDialog.messageTitle"), (String)WorkbenchMessages.format("PropertyDialog.noPropertyMessage", new Object[]{name}));
            return;
        }
        title = WorkbenchMessages.format("PropertyDialog.propertyMessage", new Object[]{name});
        PropertyDialog propertyDialog = new PropertyDialog(this.window.getShell(), pageManager, (ISelection)new StructuredSelection((Object)project));
        propertyDialog.create();
        propertyDialog.getShell().setText(title);
        WorkbenchHelp.setHelp((Control)propertyDialog.getShell(), "org.eclipse.ui.property_dialog_context");
        propertyDialog.open();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection sel) {
        this.setEnabled(this.getProject() != null);
    }

    public void partActivated(IWorkbenchPart part) {
        super.partActivated(part);
        this.setEnabled(this.getProject() != null);
    }

    private IProject getProject() {
        IResource resource;
        IWorkbenchPart part = this.getActivePart();
        Object selection = null;
        if (part instanceof IEditorPart) {
            selection = ((IEditorPart)part).getEditorInput();
        } else {
            ISelection sel = this.window.getSelectionService().getSelection();
            if (sel != null && sel instanceof IStructuredSelection) {
                selection = ((IStructuredSelection)sel).getFirstElement();
            }
        }
        if (selection == null) {
            return null;
        }
        if (!(selection instanceof IAdaptable)) {
            return null;
        }
        IAdaptable iAdaptable = (IAdaptable)selection;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((resource = (IResource)iAdaptable.getAdapter((Class)clazz)) == null) {
            return null;
        }
        return resource.getProject();
    }
}

