/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ExportResourcesAction;
import org.eclipse.ui.actions.GlobalBuildAction;
import org.eclipse.ui.actions.ImportResourcesAction;
import org.eclipse.ui.actions.LabelRetargetAction;
import org.eclipse.ui.actions.NewWizardAction;
import org.eclipse.ui.actions.NewWizardMenu;
import org.eclipse.ui.actions.OpenInNewWindowAction;
import org.eclipse.ui.actions.RetargetAction;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.AboutAction;
import org.eclipse.ui.internal.AboutInfo;
import org.eclipse.ui.internal.ActivateEditorAction;
import org.eclipse.ui.internal.ChangeToPerspectiveMenu;
import org.eclipse.ui.internal.CloseAllAction;
import org.eclipse.ui.internal.CloseAllPerspectivesAction;
import org.eclipse.ui.internal.CloseAllSavedAction;
import org.eclipse.ui.internal.CloseEditorAction;
import org.eclipse.ui.internal.ClosePerspectiveAction;
import org.eclipse.ui.internal.CoolBarContributionItem;
import org.eclipse.ui.internal.CoolBarManager;
import org.eclipse.ui.internal.CoolItemToolBarManager;
import org.eclipse.ui.internal.CycleEditorAction;
import org.eclipse.ui.internal.CyclePartAction;
import org.eclipse.ui.internal.CyclePerspectiveAction;
import org.eclipse.ui.internal.EditActionSetsAction;
import org.eclipse.ui.internal.IInternalPerspectiveListener;
import org.eclipse.ui.internal.LockToolBarAction;
import org.eclipse.ui.internal.NavigationHistoryAction;
import org.eclipse.ui.internal.NewWizardDropDownAction;
import org.eclipse.ui.internal.OpenPreferencesAction;
import org.eclipse.ui.internal.PerspectiveContributionItem;
import org.eclipse.ui.internal.PinEditorAction;
import org.eclipse.ui.internal.QuickStartAction;
import org.eclipse.ui.internal.QuitAction;
import org.eclipse.ui.internal.ReopenEditorMenu;
import org.eclipse.ui.internal.ResetPerspectiveAction;
import org.eclipse.ui.internal.SaveAction;
import org.eclipse.ui.internal.SaveAllAction;
import org.eclipse.ui.internal.SaveAsAction;
import org.eclipse.ui.internal.SavePerspectiveAction;
import org.eclipse.ui.internal.ShowFastViewContribution;
import org.eclipse.ui.internal.ShowInMenu;
import org.eclipse.ui.internal.ShowPartPaneMenuAction;
import org.eclipse.ui.internal.ShowViewMenu;
import org.eclipse.ui.internal.ShowViewMenuAction;
import org.eclipse.ui.internal.SwitchToWindowMenu;
import org.eclipse.ui.internal.TipsAndTricksAction;
import org.eclipse.ui.internal.ToggleEditorsVisibilityAction;
import org.eclipse.ui.internal.WWinKeyBindingService;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchEditorsAction;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.actions.ProjectPropertyDialogAction;

public class WorkbenchActionBuilder {
    private static final String saveActionDefId = "org.eclipse.ui.file.save";
    private static final String saveAllActionDefId = "org.eclipse.ui.file.saveAll";
    private static final String closeActionDefId = "org.eclipse.ui.file.close";
    private static final String closeAllActionDefId = "org.eclipse.ui.file.closeAll";
    private static final String closeAllSavedActionDefId = "org.eclipse.ui.file.closeAllSaved";
    private static final String deleteActionDefId = "org.eclipse.ui.edit.delete";
    private static final String showViewMenuActionDefId = "org.eclipse.ui.window.showViewMenu";
    private static final String showPartPaneMenuActionDefId = "org.eclipse.ui.window.showSystemMenu";
    private static final String nextEditorActionDefId = "org.eclipse.ui.window.nextEditor";
    private static final String prevEditorActionDefId = "org.eclipse.ui.window.previousEditor";
    private static final String nextPartActionDefId = "org.eclipse.ui.window.nextView";
    private static final String prevPartActionDefId = "org.eclipse.ui.window.previousView";
    private static final String nextPerspectiveActionDefId = "org.eclipse.ui.window.nextPerspective";
    private static final String prevPerspectiveActionDefId = "org.eclipse.ui.window.previousPerspective";
    private static final String activateEditorActionDefId = "org.eclipse.ui.window.activateEditor";
    private static final String workbenchEditorsActionDefId = "org.eclipse.ui.window.switchToEditor";
    private static final String buildAllActionDefId = "org.eclipse.ui.project.buildAll";
    private static final String rebuildAllActionDefId = "org.eclipse.ui.project.rebuildAll";
    private static final String backwardHistoryActionDefId = "org.eclipse.ui.navigate.backwardHistory";
    private static final String forwardHistoryActionDefId = "org.eclipse.ui.navigate.forwardHistory";
    private static final String projectPropertiesActionDefId = "org.eclipse.ui.project.properties";
    private final WorkbenchWindow window;
    private final IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            WorkbenchActionBuilder.this.handlePropertyChange(event);
        }
    };
    private NewWizardAction newWizardAction;
    private NewWizardDropDownAction newWizardDropDownAction;
    private NewWizardMenu newWizardMenu;
    private CloseEditorAction closeAction;
    private CloseAllAction closeAllAction;
    private CloseAllSavedAction closeAllSavedAction;
    private ImportResourcesAction importResourcesAction;
    private ExportResourcesAction exportResourcesAction;
    private GlobalBuildAction rebuildAllAction;
    private GlobalBuildAction buildAllAction;
    private SaveAction saveAction;
    private SaveAllAction saveAllAction;
    private AboutAction aboutAction;
    private OpenPreferencesAction openPreferencesAction;
    private QuickStartAction quickStartAction;
    private TipsAndTricksAction tipsAndTricksAction;
    private SaveAsAction saveAsAction;
    private ToggleEditorsVisibilityAction hideShowEditorAction;
    private SavePerspectiveAction savePerspectiveAction;
    private ResetPerspectiveAction resetPerspectiveAction;
    private EditActionSetsAction editActionSetAction;
    private ClosePerspectiveAction closePerspAction;
    private LockToolBarAction lockToolBarAction;
    private CloseAllPerspectivesAction closeAllPerspsAction;
    private PinEditorAction pinEditorAction;
    private ShowViewMenuAction showViewMenuAction;
    private ShowPartPaneMenuAction showPartPaneMenuAction;
    private CyclePartAction nextPartAction;
    private CyclePartAction prevPartAction;
    private CycleEditorAction nextEditorAction;
    private CycleEditorAction prevEditorAction;
    private CyclePerspectiveAction nextPerspectiveAction;
    private CyclePerspectiveAction prevPerspectiveAction;
    private ActivateEditorAction activateEditorAction;
    private WorkbenchEditorsAction workbenchEditorsAction;
    private RetargetAction undoAction;
    private RetargetAction redoAction;
    private RetargetAction cutAction;
    private RetargetAction copyAction;
    private RetargetAction pasteAction;
    private RetargetAction deleteAction;
    private RetargetAction selectAllAction;
    private RetargetAction findAction;
    private RetargetAction addBookmarkAction;
    private RetargetAction addTaskAction;
    private RetargetAction printAction;
    private RetargetAction revertAction;
    private RetargetAction refreshAction;
    private RetargetAction propertiesAction;
    private RetargetAction moveAction;
    private RetargetAction renameAction;
    private RetargetAction goIntoAction;
    private RetargetAction backAction;
    private RetargetAction forwardAction;
    private RetargetAction upAction;
    private RetargetAction nextAction;
    private RetargetAction previousAction;
    private RetargetAction buildProjectAction;
    private RetargetAction rebuildProjectAction;
    private RetargetAction openProjectAction;
    private RetargetAction closeProjectAction;
    private ProjectPropertyDialogAction projectPropertyDialogAction;
    private NavigationHistoryAction backwardHistoryAction;
    private NavigationHistoryAction forwardHistoryAction;

    public WorkbenchActionBuilder(IWorkbenchWindow window) {
        this.window = (WorkbenchWindow)window;
    }

    protected WorkbenchWindow getWindow() {
        return this.window;
    }

    public void buildActions() {
        this.makeActions();
        this.fillMenuBar();
        this.fillToolBar();
        this.fillShortcutBar();
        this.hookListeners();
    }

    private void hookListeners() {
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        store.addPropertyChangeListener(this.propertyChangeListener);
        this.getWindow().addPageListener(new IPageListener(){

            public void pageActivated(IWorkbenchPage page) {
                WorkbenchActionBuilder.this.enableActions(page.getPerspective() != null);
            }

            public void pageClosed(IWorkbenchPage page) {
                IWorkbenchPage pg = WorkbenchActionBuilder.this.getWindow().getActivePage();
                WorkbenchActionBuilder.this.enableActions(pg != null && pg.getPerspective() != null);
            }

            public void pageOpened(IWorkbenchPage page) {
            }
        });
        this.getWindow().getPerspectiveService().addPerspectiveListener(new IInternalPerspectiveListener(){

            public void perspectiveClosed(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
                WorkbenchActionBuilder.this.enableActions(page.getPerspective() != null);
            }

            public void perspectiveOpened(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
            }

            public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
                WorkbenchActionBuilder.this.enableActions(true);
            }

            public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
            }
        });
        this.getWindow().getSelectionService().addSelectionListener(new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                if (selection instanceof IStructuredSelection) {
                    IStructuredSelection structured = (IStructuredSelection)selection;
                    WorkbenchActionBuilder.this.importResourcesAction.selectionChanged(structured);
                    WorkbenchActionBuilder.this.exportResourcesAction.selectionChanged(structured);
                }
            }
        });
    }

    private void enableActions(boolean value) {
        this.hideShowEditorAction.setEnabled(value);
        this.savePerspectiveAction.setEnabled(value);
        this.lockToolBarAction.setEnabled(value);
        this.resetPerspectiveAction.setEnabled(value);
        this.editActionSetAction.setEnabled(value);
        this.closePerspAction.setEnabled(value);
        this.closeAllPerspsAction.setEnabled(value);
        this.newWizardMenu.setEnabled(value);
        this.newWizardDropDownAction.setEnabled(value);
        this.importResourcesAction.setEnabled(value);
        this.exportResourcesAction.setEnabled(value);
    }

    private void fillMenuBar() {
        MenuManager menubar = this.getWindow().getMenuBarManager();
        menubar.add((IContributionItem)this.createFileMenu());
        menubar.add((IContributionItem)this.createEditMenu());
        menubar.add((IContributionItem)this.createNavigateMenu());
        menubar.add((IContributionItem)this.createProjectMenu());
        menubar.add((IContributionItem)new GroupMarker("additions"));
        menubar.add((IContributionItem)this.createWindowMenu());
        menubar.add((IContributionItem)this.createHelpMenu());
    }

    private MenuManager createFileMenu() {
        MenuManager menu = new MenuManager(WorkbenchMessages.getString("Workbench.file"), "file");
        menu.add((IContributionItem)new GroupMarker("fileStart"));
        this.newWizardMenu = new NewWizardMenu(this.window);
        MenuManager newMenu = new MenuManager(WorkbenchMessages.getString("Workbench.new"));
        newMenu.add((IContributionItem)this.newWizardMenu);
        menu.add((IContributionItem)newMenu);
        menu.add((IContributionItem)new GroupMarker("new.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.closeAction);
        menu.add((IAction)this.closeAllAction);
        menu.add((IContributionItem)new GroupMarker("close.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.saveAction);
        menu.add((IAction)this.saveAsAction);
        menu.add((IAction)this.saveAllAction);
        menu.add((IAction)this.revertAction);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.moveAction);
        menu.add((IAction)this.renameAction);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.refreshAction);
        menu.add((IContributionItem)new GroupMarker("save.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.printAction);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.importResourcesAction);
        menu.add((IAction)this.exportResourcesAction);
        menu.add((IContributionItem)new GroupMarker("import.ext"));
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.propertiesAction);
        menu.add((IContributionItem)new ReopenEditorMenu(this.window, ((Workbench)this.getWindow().getWorkbench()).getEditorHistory(), true));
        menu.add((IContributionItem)new GroupMarker("mru"));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)new QuitAction(this.getWindow().getWorkbench()));
        menu.add((IContributionItem)new GroupMarker("fileEnd"));
        return menu;
    }

    private MenuManager createEditMenu() {
        MenuManager menu = new MenuManager(WorkbenchMessages.getString("Workbench.edit"), "edit");
        menu.add((IContributionItem)new GroupMarker("editStart"));
        menu.add((IAction)this.undoAction);
        menu.add((IAction)this.redoAction);
        menu.add((IContributionItem)new GroupMarker("undo.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.cutAction);
        menu.add((IAction)this.copyAction);
        menu.add((IAction)this.pasteAction);
        menu.add((IContributionItem)new GroupMarker("cut.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.deleteAction);
        menu.add((IAction)this.selectAllAction);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.findAction);
        menu.add((IContributionItem)new GroupMarker("cut.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.addBookmarkAction);
        menu.add((IAction)this.addTaskAction);
        menu.add((IContributionItem)new GroupMarker("add.ext"));
        menu.add((IContributionItem)new GroupMarker("editEnd"));
        menu.add((IContributionItem)new Separator("additions"));
        return menu;
    }

    private MenuManager createNavigateMenu() {
        MenuManager menu = new MenuManager(WorkbenchMessages.getString("Workbench.navigate"), "navigate");
        menu.add((IContributionItem)new GroupMarker("navStart"));
        menu.add((IAction)this.goIntoAction);
        MenuManager goToSubMenu = new MenuManager(WorkbenchMessages.getString("Workbench.goTo"), "goTo");
        menu.add((IContributionItem)goToSubMenu);
        goToSubMenu.add((IAction)this.backAction);
        goToSubMenu.add((IAction)this.forwardAction);
        goToSubMenu.add((IAction)this.upAction);
        goToSubMenu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator("open.ext"));
        int i = 2;
        while (i < 5) {
            menu.add((IContributionItem)new Separator("open.ext" + i));
            ++i;
        }
        menu.add((IContributionItem)new Separator("show.ext"));
        MenuManager showInSubMenu = new MenuManager(WorkbenchMessages.getString("Workbench.showIn"));
        showInSubMenu.add((IContributionItem)new ShowInMenu(this.window));
        menu.add((IContributionItem)showInSubMenu);
        i = 2;
        while (i < 5) {
            menu.add((IContributionItem)new Separator("show.ext" + i));
            ++i;
        }
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.nextAction);
        menu.add((IAction)this.previousAction);
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new GroupMarker("navEnd"));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.backwardHistoryAction);
        menu.add((IAction)this.forwardHistoryAction);
        return menu;
    }

    private MenuManager createProjectMenu() {
        boolean autoBuild = ResourcesPlugin.getWorkspace().isAutoBuilding();
        MenuManager menu = new MenuManager(WorkbenchMessages.getString("Workbench.project"), "project");
        menu.add((IContributionItem)new Separator("projStart"));
        menu.add((IAction)this.openProjectAction);
        menu.add((IAction)this.closeProjectAction);
        menu.add((IContributionItem)new GroupMarker("open.ext"));
        menu.add((IContributionItem)new Separator());
        if (!autoBuild) {
            menu.add((IAction)this.buildProjectAction);
        }
        menu.add((IAction)this.rebuildProjectAction);
        if (!autoBuild) {
            menu.add((IAction)this.buildAllAction);
        }
        menu.add((IAction)this.rebuildAllAction);
        menu.add((IContributionItem)new GroupMarker("build.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new GroupMarker("additions"));
        menu.add((IContributionItem)new GroupMarker("projEnd"));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.projectPropertyDialogAction);
        return menu;
    }

    private MenuManager createWindowMenu() {
        MenuManager menu = new MenuManager(WorkbenchMessages.getString("Workbench.window"), "window");
        OpenInNewWindowAction action = new OpenInNewWindowAction(this.window);
        action.setText(WorkbenchMessages.getString("Workbench.openNewWindow"));
        menu.add((IAction)action);
        menu.add((IContributionItem)new Separator());
        this.addPerspectiveActions(menu);
        menu.add((IContributionItem)new Separator());
        this.addKeyboardShortcuts(menu);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.workbenchEditorsAction);
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator("additionsend"));
        menu.add((IAction)this.openPreferencesAction);
        menu.add((IContributionItem)new SwitchToWindowMenu(this.window, true));
        return menu;
    }

    private void addPerspectiveActions(MenuManager menu) {
        String openText = WorkbenchMessages.getString("Workbench.openPerspective");
        MenuManager changePerspMenuMgr = new MenuManager(openText);
        ChangeToPerspectiveMenu changePerspMenuItem = new ChangeToPerspectiveMenu(this.window);
        changePerspMenuMgr.add((IContributionItem)changePerspMenuItem);
        menu.add((IContributionItem)changePerspMenuMgr);
        MenuManager showViewMenuMgr = new MenuManager(WorkbenchMessages.getString("Workbench.showView"));
        ShowViewMenu showViewMenu = new ShowViewMenu(this.window);
        showViewMenuMgr.add((IContributionItem)showViewMenu);
        menu.add((IContributionItem)showViewMenuMgr);
        menu.add((IAction)this.hideShowEditorAction);
        menu.add((IAction)this.lockToolBarAction);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.editActionSetAction);
        menu.add((IAction)this.savePerspectiveAction);
        menu.add((IAction)this.resetPerspectiveAction);
        menu.add((IAction)this.closePerspAction);
        menu.add((IAction)this.closeAllPerspsAction);
    }

    private void addKeyboardShortcuts(MenuManager menu) {
        MenuManager subMenu = new MenuManager(WorkbenchMessages.getString("Workbench.shortcuts"));
        menu.add((IContributionItem)subMenu);
        subMenu.add((IAction)this.showPartPaneMenuAction);
        subMenu.add((IAction)this.showViewMenuAction);
        subMenu.add((IContributionItem)new Separator());
        subMenu.add((IAction)this.activateEditorAction);
        subMenu.add((IAction)this.nextEditorAction);
        subMenu.add((IAction)this.prevEditorAction);
        subMenu.add((IContributionItem)new Separator());
        subMenu.add((IAction)this.nextPartAction);
        subMenu.add((IAction)this.prevPartAction);
        subMenu.add((IContributionItem)new Separator());
        subMenu.add((IAction)this.nextPerspectiveAction);
        subMenu.add((IAction)this.prevPerspectiveAction);
    }

    private MenuManager createHelpMenu() {
        MenuManager menu = new MenuManager(WorkbenchMessages.getString("Workbench.help"), "help");
        if (this.quickStartAction != null) {
            menu.add((IAction)this.quickStartAction);
        }
        if (this.tipsAndTricksAction != null) {
            menu.add((IAction)this.tipsAndTricksAction);
        }
        menu.add((IContributionItem)new GroupMarker("helpStart"));
        menu.add((IContributionItem)new GroupMarker("helpEnd"));
        menu.add((IContributionItem)new GroupMarker("additions"));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.aboutAction);
        return menu;
    }

    private void fillToolBar() {
        CoolBarManager cBarMgr = this.getWindow().getCoolBarManager();
        CoolBarContributionItem coolBarItem = new CoolBarContributionItem(cBarMgr, "org.eclipse.ui.workbench.file");
        cBarMgr.add((IContributionItem)coolBarItem);
        coolBarItem.setVisible(true);
        IContributionManager toolsManager = (IContributionManager)coolBarItem.getToolBarManager();
        cBarMgr.addToMenu(new ActionContributionItem((IAction)this.lockToolBarAction));
        cBarMgr.addToMenu(new ActionContributionItem((IAction)this.editActionSetAction));
        CoolItemToolBarManager tBarMgr = (CoolItemToolBarManager)toolsManager;
        tBarMgr.addBaseGroup("new.group", true);
        tBarMgr.add((IAction)this.newWizardDropDownAction);
        tBarMgr.addBaseGroup("new.ext", false);
        tBarMgr.addBaseGroup("save.group", false);
        tBarMgr.add((IAction)this.saveAction);
        tBarMgr.add((IAction)this.saveAsAction);
        tBarMgr.addBaseGroup("save.ext", false);
        tBarMgr.add((IAction)this.printAction);
        tBarMgr.addBaseGroup("build.group", true);
        tBarMgr.addBaseGroup("build.ext", false);
        tBarMgr.addBaseGroup("additions", true);
        if (!ResourcesPlugin.getWorkspace().isAutoBuilding()) {
            this.addManualIncrementalBuildToolAction();
        }
        this.addHistoryNavigateActions();
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        if (store.getBoolean("REUSE_OPEN_EDITORS_BOOLEAN")) {
            this.addPinEditorAction();
        }
    }

    private void fillShortcutBar() {
        ToolBarManager shortcutBar = this.getWindow().getShortcutBar();
        shortcutBar.add((IContributionItem)new PerspectiveContributionItem(this.window));
        shortcutBar.add((IContributionItem)new Separator("pages"));
        shortcutBar.add((IContributionItem)new Separator("perspectives"));
        shortcutBar.add((IContributionItem)new Separator("fastViews"));
        shortcutBar.add((IContributionItem)new ShowFastViewContribution(this.window));
    }

    public void dispose() {
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        store.removePropertyChangeListener(this.propertyChangeListener);
    }

    public boolean isContainerMenu(String menuId) {
        if (menuId.equals("file")) {
            return true;
        }
        if (menuId.equals("view")) {
            return true;
        }
        if (menuId.equals("workbench")) {
            return true;
        }
        return menuId.equals("window");
    }

    public boolean isWorkbenchCoolItemId(String id) {
        if ("org.eclipse.ui.workbench.file".equalsIgnoreCase(id)) {
            return true;
        }
        return "org.eclipse.ui.workbench.navigate".equalsIgnoreCase(id);
    }

    private void makeActions() {
        IPartService partService = this.getWindow().getPartService();
        WWinKeyBindingService keyBindingService = this.getWindow().getKeyBindingService();
        IWorkbench workbench = this.getWindow().getWorkbench();
        this.newWizardAction = new NewWizardAction(this.getWindow());
        keyBindingService.registerGlobalAction((IAction)this.newWizardAction);
        ISharedImages sharedImages = workbench.getSharedImages();
        this.newWizardDropDownAction = new NewWizardDropDownAction(this.window, this.newWizardAction);
        this.newWizardDropDownAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_NEW_WIZARD"));
        this.newWizardDropDownAction.setHoverImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_NEW_WIZARD_HOVER"));
        this.newWizardDropDownAction.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_NEW_WIZARD_DISABLED"));
        this.importResourcesAction = new ImportResourcesAction(this.getWindow());
        this.importResourcesAction.setImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_CTOOL_IMPORT_WIZ"));
        this.importResourcesAction.setHoverImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_CTOOL_IMPORT_WIZ_HOVER"));
        this.importResourcesAction.setDisabledImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_CTOOL_IMPORT_WIZ_DISABLED"));
        this.exportResourcesAction = new ExportResourcesAction(this.getWindow(), WorkbenchMessages.getString("ExportResourcesAction.fileMenuText"));
        this.exportResourcesAction.setImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_CTOOL_EXPORT_WIZ"));
        this.exportResourcesAction.setHoverImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_CTOOL_EXPORT_WIZ_HOVER"));
        this.exportResourcesAction.setDisabledImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_CTOOL_EXPORT_WIZ_DISABLED"));
        this.rebuildAllAction = new GlobalBuildAction(this.window, 6);
        this.rebuildAllAction.setActionDefinitionId(rebuildAllActionDefId);
        keyBindingService.registerGlobalAction((IAction)this.rebuildAllAction);
        this.buildAllAction = new GlobalBuildAction(this.window, 10);
        this.buildAllAction.setImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_CTOOL_BUILD_EXEC"));
        this.buildAllAction.setHoverImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_CTOOL_BUILD_EXEC_HOVER"));
        this.buildAllAction.setDisabledImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_CTOOL_BUILD_EXEC_DISABLED"));
        this.buildAllAction.setActionDefinitionId(buildAllActionDefId);
        keyBindingService.registerGlobalAction((IAction)this.buildAllAction);
        this.saveAction = new SaveAction(this.window);
        this.saveAction.setImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_CTOOL_SAVE_EDIT"));
        this.saveAction.setHoverImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_CTOOL_SAVE_EDIT_HOVER"));
        this.saveAction.setDisabledImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_CTOOL_SAVE_EDIT_DISABLED"));
        partService.addPartListener(this.saveAction);
        this.saveAction.setActionDefinitionId(saveActionDefId);
        keyBindingService.registerGlobalAction((IAction)this.saveAction);
        this.saveAsAction = new SaveAsAction(this.window);
        this.saveAsAction.setImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_CTOOL_SAVEAS_EDIT"));
        this.saveAsAction.setHoverImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_CTOOL_SAVEAS_EDIT_HOVER"));
        this.saveAsAction.setDisabledImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_CTOOL_SAVEAS_EDIT_DISABLED"));
        partService.addPartListener(this.saveAsAction);
        this.saveAllAction = new SaveAllAction(this.window);
        this.saveAllAction.setImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_CTOOL_SAVEALL_EDIT"));
        this.saveAllAction.setHoverImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_CTOOL_SAVEALL_EDIT_HOVER"));
        this.saveAllAction.setDisabledImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_CTOOL_SAVEALL_EDIT_DISABLED"));
        partService.addPartListener(this.saveAllAction);
        this.saveAllAction.setActionDefinitionId(saveAllActionDefId);
        keyBindingService.registerGlobalAction((IAction)this.saveAllAction);
        this.undoAction = this.createGlobalAction("undo", "edit", true);
        this.undoAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_UNDO"));
        this.undoAction.setHoverImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_UNDO_HOVER"));
        this.undoAction.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_UNDO_DISABLED"));
        this.redoAction = this.createGlobalAction("redo", "edit", true);
        this.redoAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_REDO"));
        this.redoAction.setHoverImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_REDO_HOVER"));
        this.redoAction.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_REDO_DISABLED"));
        this.cutAction = this.createGlobalAction("cut", "edit", false);
        this.cutAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_CUT"));
        this.cutAction.setHoverImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_CUT_HOVER"));
        this.cutAction.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_CUT_DISABLED"));
        this.copyAction = this.createGlobalAction("copy", "edit", false);
        this.copyAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.copyAction.setHoverImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY_HOVER"));
        this.copyAction.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        this.pasteAction = this.createGlobalAction("paste", "edit", false);
        this.pasteAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE"));
        this.pasteAction.setHoverImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE_HOVER"));
        this.pasteAction.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
        this.printAction = this.createGlobalAction("print", "file", false);
        this.printAction.setImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_CTOOL_PRINT_EDIT"));
        this.printAction.setHoverImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_CTOOL_PRINT_EDIT_HOVER"));
        this.printAction.setDisabledImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_CTOOL_PRINT_EDIT_DISABLED"));
        this.selectAllAction = this.createGlobalAction("selectAll", "edit", false);
        this.findAction = this.createGlobalAction("find", "findReplace", "edit", "findReplace", false);
        this.closeAction = new CloseEditorAction(this.window);
        partService.addPartListener(this.closeAction);
        this.closeAction.setActionDefinitionId(closeActionDefId);
        keyBindingService.registerGlobalAction((IAction)this.closeAction);
        this.closeAllAction = new CloseAllAction(this.window);
        partService.addPartListener(this.closeAllAction);
        this.closeAllAction.setActionDefinitionId(closeAllActionDefId);
        keyBindingService.registerGlobalAction((IAction)this.closeAllAction);
        this.closeAllSavedAction = new CloseAllSavedAction(this.window);
        partService.addPartListener(this.closeAllSavedAction);
        this.closeAllSavedAction.setActionDefinitionId(closeAllSavedActionDefId);
        keyBindingService.registerGlobalAction((IAction)this.closeAllSavedAction);
        this.pinEditorAction = new PinEditorAction(this.window);
        partService.addPartListener(this.pinEditorAction);
        this.pinEditorAction.setImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_CTOOL_PIN_EDITOR"));
        this.pinEditorAction.setHoverImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_CTOOL_PIN_EDITOR_HOVER"));
        this.pinEditorAction.setDisabledImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_CTOOL_PIN_EDITOR_DISABLED"));
        this.aboutAction = new AboutAction(this.window);
        this.aboutAction.setImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_OBJS_DEFAULT_PROD"));
        keyBindingService.registerGlobalAction((IAction)this.aboutAction);
        this.openPreferencesAction = new OpenPreferencesAction(this.window);
        this.addBookmarkAction = this.createGlobalAction("bookmark", "addBookMark", "edit", "addBookmark", false);
        this.addTaskAction = this.createGlobalAction("addTask", "edit", false);
        this.deleteAction = new RetargetAction("delete", WorkbenchMessages.getString("Workbench.delete"));
        this.deleteAction.setToolTipText(WorkbenchMessages.getString("Workbench.deleteToolTip"));
        this.deleteAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.deleteAction.setHoverImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE_HOVER"));
        this.deleteAction.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.deleteAction.enableAccelerator(false);
        WorkbenchHelp.setHelp((IAction)this.deleteAction, "org.eclipse.ui.delete_retarget_action_context");
        partService.addPartListener(this.deleteAction);
        this.deleteAction.setActionDefinitionId(deleteActionDefId);
        AboutInfo[] infos = ((Workbench)workbench).getConfigurationInfo().getFeaturesInfo();
        int i = 0;
        while (i < infos.length) {
            if (infos[i].getWelcomePageURL() != null) {
                this.quickStartAction = new QuickStartAction(this.window);
                keyBindingService.registerGlobalAction((IAction)this.quickStartAction);
                break;
            }
            ++i;
        }
        i = 0;
        while (i < infos.length) {
            if (infos[i].getTipsAndTricksHref() != null) {
                this.tipsAndTricksAction = new TipsAndTricksAction(this.window);
                keyBindingService.registerGlobalAction((IAction)this.tipsAndTricksAction);
                break;
            }
            ++i;
        }
        this.showViewMenuAction = new ShowViewMenuAction(this.window);
        this.showViewMenuAction.setActionDefinitionId(showViewMenuActionDefId);
        keyBindingService.registerGlobalAction((IAction)this.showViewMenuAction);
        this.showPartPaneMenuAction = new ShowPartPaneMenuAction(this.window);
        this.showPartPaneMenuAction.setActionDefinitionId(showPartPaneMenuActionDefId);
        keyBindingService.registerGlobalAction((IAction)this.showPartPaneMenuAction);
        this.nextEditorAction = new CycleEditorAction(this.window, true);
        this.nextEditorAction.setActionDefinitionId(nextEditorActionDefId);
        keyBindingService.registerGlobalAction((IAction)this.nextEditorAction);
        this.nextEditorAction.commandForward = nextEditorActionDefId;
        this.nextEditorAction.commandBackward = prevEditorActionDefId;
        this.prevEditorAction = new CycleEditorAction(this.window, false);
        this.prevEditorAction.setActionDefinitionId(prevEditorActionDefId);
        keyBindingService.registerGlobalAction((IAction)this.prevEditorAction);
        this.prevEditorAction.commandForward = nextEditorActionDefId;
        this.prevEditorAction.commandBackward = prevEditorActionDefId;
        this.nextPartAction = new CyclePartAction(this.window, true);
        this.nextPartAction.setActionDefinitionId(nextPartActionDefId);
        keyBindingService.registerGlobalAction((IAction)this.nextPartAction);
        this.nextPartAction.commandForward = nextPartActionDefId;
        this.nextPartAction.commandBackward = prevPartActionDefId;
        this.prevPartAction = new CyclePartAction(this.window, false);
        this.prevPartAction.setActionDefinitionId(prevPartActionDefId);
        keyBindingService.registerGlobalAction((IAction)this.prevPartAction);
        this.prevPartAction.commandForward = nextPartActionDefId;
        this.prevPartAction.commandBackward = prevPartActionDefId;
        this.nextPerspectiveAction = new CyclePerspectiveAction(this.window, true);
        this.nextPerspectiveAction.setActionDefinitionId(nextPerspectiveActionDefId);
        keyBindingService.registerGlobalAction((IAction)this.nextPerspectiveAction);
        this.nextPerspectiveAction.commandForward = nextPerspectiveActionDefId;
        this.nextPerspectiveAction.commandBackward = prevPerspectiveActionDefId;
        this.prevPerspectiveAction = new CyclePerspectiveAction(this.window, false);
        this.prevPerspectiveAction.setActionDefinitionId(prevPerspectiveActionDefId);
        keyBindingService.registerGlobalAction((IAction)this.prevPerspectiveAction);
        this.prevPerspectiveAction.commandForward = nextPerspectiveActionDefId;
        this.prevPerspectiveAction.commandBackward = prevPerspectiveActionDefId;
        this.activateEditorAction = new ActivateEditorAction(this.window);
        this.activateEditorAction.setActionDefinitionId(activateEditorActionDefId);
        keyBindingService.registerGlobalAction((IAction)this.activateEditorAction);
        this.workbenchEditorsAction = new WorkbenchEditorsAction(this.window);
        this.workbenchEditorsAction.setActionDefinitionId(workbenchEditorsActionDefId);
        keyBindingService.registerGlobalAction((IAction)this.workbenchEditorsAction);
        this.hideShowEditorAction = new ToggleEditorsVisibilityAction(this.window);
        this.savePerspectiveAction = new SavePerspectiveAction(this.window);
        this.editActionSetAction = new EditActionSetsAction(this.window);
        this.lockToolBarAction = new LockToolBarAction(this.window);
        this.resetPerspectiveAction = new ResetPerspectiveAction(this.window);
        this.closePerspAction = new ClosePerspectiveAction(this.window);
        this.closeAllPerspsAction = new CloseAllPerspectivesAction(this.window);
        this.backwardHistoryAction = new NavigationHistoryAction(this.window, false);
        this.backwardHistoryAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_BACK"));
        this.backwardHistoryAction.setHoverImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_BACK_HOVER"));
        this.backwardHistoryAction.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_BACK_DISABLED"));
        this.backwardHistoryAction.setActionDefinitionId(backwardHistoryActionDefId);
        keyBindingService.registerGlobalAction((IAction)this.backwardHistoryAction);
        this.forwardHistoryAction = new NavigationHistoryAction(this.window, true);
        this.forwardHistoryAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_FORWARD"));
        this.forwardHistoryAction.setHoverImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_FORWARD_HOVER"));
        this.forwardHistoryAction.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_FORWARD_DISABLED"));
        this.forwardHistoryAction.setActionDefinitionId(forwardHistoryActionDefId);
        keyBindingService.registerGlobalAction((IAction)this.forwardHistoryAction);
        this.revertAction = this.createGlobalAction("revert", "file", false);
        this.refreshAction = this.createGlobalAction("refresh", "file", false);
        this.propertiesAction = this.createGlobalAction("properties", "file", false);
        this.moveAction = this.createGlobalAction("move", "edit", false);
        this.renameAction = this.createGlobalAction("rename", "edit", false);
        this.goIntoAction = this.createGlobalAction("goInto", "navigate", false);
        this.backAction = this.createGlobalAction("back", "navigate", true);
        this.forwardAction = this.createGlobalAction("forward", "navigate", true);
        this.upAction = this.createGlobalAction("up", "navigate", true);
        this.nextAction = this.createGlobalAction("next", "navigate", true);
        this.nextAction.setImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_CTOOL_NEXT_NAV"));
        this.previousAction = this.createGlobalAction("previous", "navigate", true);
        this.previousAction.setImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_CTOOL_PREVIOUS_NAV"));
        this.buildProjectAction = this.createGlobalAction("buildProject", "project", false);
        this.rebuildProjectAction = this.createGlobalAction("rebuildProject", "project", false);
        this.openProjectAction = this.createGlobalAction("openProject", "project", false);
        this.closeProjectAction = this.createGlobalAction("closeProject", "project", false);
        this.projectPropertyDialogAction = new ProjectPropertyDialogAction(this.window);
        this.projectPropertyDialogAction.setActionDefinitionId(projectPropertiesActionDefId);
        partService.addPartListener(this.projectPropertyDialogAction);
        keyBindingService.registerGlobalAction((IAction)this.projectPropertyDialogAction);
    }

    private RetargetAction createGlobalAction(String id, String actionDefPrefix, boolean labelRetarget) {
        return this.createGlobalAction(id, id, actionDefPrefix, id, labelRetarget);
    }

    private RetargetAction createGlobalAction(String id, String messageId, String actionDefPrefix, String actionDefSuffix, boolean labelRetarget) {
        String text = WorkbenchMessages.getString("Workbench." + messageId);
        String toolTipText = WorkbenchMessages.getString("Workbench." + messageId + "ToolTip");
        RetargetAction action = labelRetarget ? new LabelRetargetAction(id, text) : new RetargetAction(id, text);
        action.setToolTipText(toolTipText);
        this.getWindow().getPartService().addPartListener(action);
        action.setActionDefinitionId("org.eclipse.ui." + actionDefPrefix + "." + actionDefSuffix);
        this.getWindow().getKeyBindingService().registerGlobalAction((IAction)action);
        return action;
    }

    private void handlePropertyChange(PropertyChangeEvent event) {
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        if (event.getProperty().equals("REUSE_OPEN_EDITORS_BOOLEAN")) {
            if (store.getBoolean("REUSE_OPEN_EDITORS_BOOLEAN")) {
                this.addPinEditorAction();
            } else {
                this.removePinEditorAction();
            }
        } else if (event.getProperty().equals("REUSE_OPEN_EDITORS")) {
            this.pinEditorAction.updateState();
        } else if (event.getProperty().equals("RECENT_FILES")) {
            Workbench wb = (Workbench)this.getWindow().getWorkbench();
            int newValue = store.getInt("RECENT_FILES");
            wb.getEditorHistory().reset(newValue);
            if (newValue == 0) {
                this.getWindow().updateActionBars();
            }
        }
    }

    private void addHistoryNavigateActions() {
        CoolBarManager cBarMgr = this.getWindow().getCoolBarManager();
        CoolBarContributionItem coolBarItem = new CoolBarContributionItem(cBarMgr, "org.eclipse.ui.workbench.navigate");
        CoolBarContributionItem refItem = cBarMgr.findSubId("group.editor");
        if (refItem == null) {
            cBarMgr.add((IContributionItem)coolBarItem);
        } else {
            cBarMgr.insertBefore(refItem.getId(), (IContributionItem)coolBarItem);
        }
        coolBarItem.setVisible(true);
        CoolItemToolBarManager tBarMgr = coolBarItem.getToolBarManager();
        tBarMgr.addBaseGroup("history.group", true);
        tBarMgr.add((IAction)this.backwardHistoryAction);
        tBarMgr.add((IAction)this.forwardHistoryAction);
        tBarMgr.addBaseGroup("pin.group", true);
        cBarMgr.update(true);
    }

    private void addPinEditorAction() {
        CoolBarManager cBarMgr = this.getWindow().getCoolBarManager();
        CoolBarContributionItem coolBarItem = (CoolBarContributionItem)cBarMgr.find("org.eclipse.ui.workbench.navigate");
        if (coolBarItem == null) {
            WorkbenchPlugin.log("Navigate toolbar is missing");
            return;
        }
        CoolItemToolBarManager tBarMgr = coolBarItem.getToolBarManager();
        tBarMgr.appendToGroup("pin.group", (IAction)this.pinEditorAction);
        tBarMgr.update(true);
        this.pinEditorAction.setVisible(true);
    }

    private void removePinEditorAction() {
        CoolBarManager cBarMgr = this.getWindow().getCoolBarManager();
        CoolBarContributionItem coolBarItem = (CoolBarContributionItem)cBarMgr.find("org.eclipse.ui.workbench.navigate");
        if (coolBarItem != null) {
            CoolItemToolBarManager tBarMgr = coolBarItem.getToolBarManager();
            try {
                this.pinEditorAction.setVisible(false);
                tBarMgr.remove(this.pinEditorAction.getId());
                tBarMgr.update(true);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    protected void addManualIncrementalBuildAction() {
        MenuManager menubar = this.getWindow().getMenuBarManager();
        IMenuManager manager = menubar.findMenuUsingPath("project");
        if (manager != null) {
            try {
                manager.insertBefore("rebuildProject", (IAction)this.buildProjectAction);
                manager.insertBefore("rebuildAll", (IAction)this.buildAllAction);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        this.addManualIncrementalBuildToolAction();
    }

    protected void addManualIncrementalBuildToolAction() {
        CoolBarManager cBarMgr = this.getWindow().getCoolBarManager();
        CoolBarContributionItem coolBarItem = (CoolBarContributionItem)cBarMgr.find("org.eclipse.ui.workbench.file");
        if (coolBarItem == null) {
            WorkbenchPlugin.log("File toolbar is missing");
            return;
        }
        CoolItemToolBarManager tBarMgr = coolBarItem.getToolBarManager();
        tBarMgr.appendToGroup("build.group", (IAction)this.buildAllAction);
        tBarMgr.update(true);
    }

    protected void removeManualIncrementalBuildAction() {
        MenuManager menubar = this.getWindow().getMenuBarManager();
        IMenuManager manager = menubar.findMenuUsingPath("project");
        if (manager != null) {
            try {
                manager.remove("build");
                manager.remove("buildProject");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        this.removeManualIncrementalBuildToolAction();
    }

    protected void removeManualIncrementalBuildToolAction() {
        CoolBarManager cBarMgr = this.getWindow().getCoolBarManager();
        CoolBarContributionItem coolBarItem = (CoolBarContributionItem)cBarMgr.find("org.eclipse.ui.workbench.file");
        if (coolBarItem != null) {
            CoolItemToolBarManager tBarMgr = coolBarItem.getToolBarManager();
            try {
                tBarMgr.remove("build");
                tBarMgr.update(true);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }
}

