/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.boot.IPlatformRunnable;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceLock;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.window.Window;
import org.eclipse.jface.window.WindowManager;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Synchronizer;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IMarkerHelpRegistry;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.actions.GlobalBuildAction;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.internal.AboutInfo;
import org.eclipse.ui.internal.EditorHistory;
import org.eclipse.ui.internal.EditorManager;
import org.eclipse.ui.internal.ExceptionHandler;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.PerspectiveHistory;
import org.eclipse.ui.internal.UISynchronizer;
import org.eclipse.ui.internal.UIWorkspaceLock;
import org.eclipse.ui.internal.WWinKeyBindingService;
import org.eclipse.ui.internal.WWinPluginAction;
import org.eclipse.ui.internal.WorkbenchActionBuilder;
import org.eclipse.ui.internal.WorkbenchColors;
import org.eclipse.ui.internal.WorkbenchConfigurationInfo;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.decorators.DecoratorManager;
import org.eclipse.ui.internal.dialogs.WelcomeEditorInput;
import org.eclipse.ui.internal.fonts.FontDefinition;
import org.eclipse.ui.internal.misc.Assert;
import org.eclipse.ui.internal.misc.Policy;
import org.eclipse.ui.internal.misc.UIStats;
import org.eclipse.ui.internal.model.WorkbenchAdapterBuilder;
import org.eclipse.update.core.SiteManager;

public class Workbench
implements IWorkbench,
IPlatformRunnable,
IExecutableExtension {
    private WindowManager windowManager;
    private WorkbenchWindow activatedWindow;
    private EditorHistory editorHistory;
    private PerspectiveHistory perspHistory;
    private boolean runEventLoop;
    private boolean isStarting = true;
    private boolean isClosing = false;
    private boolean autoBuild;
    private Object returnCode;
    private WorkbenchConfigurationInfo configurationInfo;
    private ListenerList windowListeners = new ListenerList();
    private String[] commandLineArgs;
    private final IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            Workbench.this.handlePropertyChange(event);
        }
    };
    private static final String[] VERSION_STRING = new String[]{"0.046", "2.0"};
    private static final String DEFAULT_WORKBENCH_STATE_FILENAME = "workbench.xml";
    private static final int RESTORE_CODE_OK = 0;
    private static final int RESTORE_CODE_RESET = 1;
    private static final int RESTORE_CODE_EXIT = 2;
    protected static final String WELCOME_EDITOR_ID = "org.eclipse.ui.internal.dialogs.WelcomeEditor";
    private static final String TASK_LIST_ID = String.valueOf(WorkbenchPlugin.PI_WORKBENCH) + ".views.TaskList";

    public Workbench() {
        WorkbenchPlugin.getDefault().setWorkbench(this);
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.getShowTasksChangeListener(), 1);
    }

    private IResourceChangeListener getShowTasksChangeListener() {
        return new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                IMarker error;
                IPreferenceStore store = Workbench.this.getPreferenceStore();
                if (store.getBoolean("SHOW_TASKS_ON_BUILD") && (error = Workbench.this.findProblemToShow(event)) != null) {
                    Display.getDefault().asyncExec(new Runnable(this){
                        private final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            try {
                                IWorkbenchPage page;
                                IWorkbenchWindow window = 2.access$0(this.this$1).getActiveWorkbenchWindow();
                                if (window != null && !window.getShell().isDisposed() && (page = window.getActivePage()) != null) {
                                    IViewPart tasksView = page.findView(Workbench.access$2());
                                    if (tasksView == null) {
                                        IWorkbenchPart activePart = page.getActivePart();
                                        page.showView(Workbench.access$2());
                                        page.activate(activePart);
                                    } else {
                                        page.bringToTop(tasksView);
                                    }
                                }
                            }
                            catch (PartInitException e) {
                                WorkbenchPlugin.log("Error bringing Tasks view to front", e.getStatus());
                            }
                        }
                    });
                }
            }

            static /* synthetic */ Workbench access$0(2 var0) {
                return var0.Workbench.this;
            }
        };
    }

    private IMarker findProblemToShow(IResourceChangeEvent event) {
        IMarkerDelta[] markerDeltas = event.findMarkerDeltas("org.eclipse.core.resources.problemmarker", true);
        int i = 0;
        while (i < markerDeltas.length) {
            int sev;
            IMarkerDelta markerDelta = markerDeltas[i];
            if (markerDelta.getKind() == 1 && ((sev = markerDelta.getAttribute("severity", -1)) == 2 || sev == 1)) {
                return markerDelta.getMarker();
            }
            ++i;
        }
        return null;
    }

    public void addWindowListener(IWindowListener l) {
        this.windowListeners.add((Object)l);
    }

    public void removeWindowListener(IWindowListener l) {
        this.windowListeners.remove((Object)l);
    }

    protected void fireWindowOpened(IWorkbenchWindow window) {
        Object[] list = this.windowListeners.getListeners();
        int i = 0;
        while (i < list.length) {
            ((IWindowListener)list[i]).windowOpened(window);
            ++i;
        }
    }

    protected void fireWindowClosed(IWorkbenchWindow window) {
        if (this.activatedWindow == window) {
            this.activatedWindow = null;
        }
        Object[] list = this.windowListeners.getListeners();
        int i = 0;
        while (i < list.length) {
            ((IWindowListener)list[i]).windowClosed(window);
            ++i;
        }
    }

    protected void fireWindowActivated(IWorkbenchWindow window) {
        Object[] list = this.windowListeners.getListeners();
        int i = 0;
        while (i < list.length) {
            ((IWindowListener)list[i]).windowActivated(window);
            ++i;
        }
    }

    protected void fireWindowDeactivated(IWorkbenchWindow window) {
        Object[] list = this.windowListeners.getListeners();
        int i = 0;
        while (i < list.length) {
            ((IWindowListener)list[i]).windowDeactivated(window);
            ++i;
        }
    }

    private void addAdapters() {
        WorkbenchAdapterBuilder builder = new WorkbenchAdapterBuilder();
        builder.registerAdapters();
    }

    private boolean busyClose(final boolean force) {
        this.isClosing = this.saveAllEditors(!force);
        if (!this.isClosing && !force) {
            return false;
        }
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        boolean closeEditors = store.getBoolean("CLOSE_EDITORS_ON_EXIT");
        if (closeEditors) {
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    IWorkbenchWindow[] windows = Workbench.this.getWorkbenchWindows();
                    int i = 0;
                    while (i < windows.length) {
                        IWorkbenchPage[] pages = windows[i].getPages();
                        int j = 0;
                        while (j < pages.length) {
                            Workbench.this.isClosing = Workbench.this.isClosing && pages[j].closeAllEditors(false);
                            ++j;
                        }
                        ++i;
                    }
                }
            });
            if (!this.isClosing && !force) {
                return false;
            }
        }
        Platform.run((ISafeRunnable)new SafeRunnable(){

            public void run() {
                XMLMemento mem = Workbench.this.recordWorkbenchState();
                Workbench.this.saveWorkbenchState(mem);
            }

            public void handleException(Throwable e) {
                String message = e.getMessage() == null ? WorkbenchMessages.getString("ErrorClosingNoArg") : WorkbenchMessages.format("ErrorClosingOneArg", new Object[]{e.getMessage()});
                if (!MessageDialog.openQuestion(null, (String)WorkbenchMessages.getString("Error"), (String)message)) {
                    Workbench.this.isClosing = false;
                }
            }
        });
        if (!this.isClosing && !force) {
            return false;
        }
        Platform.run((ISafeRunnable)new SafeRunnable(WorkbenchMessages.getString("ErrorClosing")){

            public void run() {
                if (Workbench.this.isClosing || force) {
                    Workbench.this.isClosing = Workbench.this.windowManager.close();
                }
            }
        });
        if (!this.isClosing && !force) {
            return false;
        }
        if (WorkbenchPlugin.getPluginWorkspace() != null) {
            this.disconnectFromWorkspace();
        }
        this.runEventLoop = false;
        return true;
    }

    public boolean saveAllEditors(boolean confirm) {
        final boolean finalConfirm = confirm;
        final boolean[] result = new boolean[]{true};
        Platform.run((ISafeRunnable)new SafeRunnable(WorkbenchMessages.getString("ErrorClosing")){

            public void run() {
                ArrayList<IEditorPart> dirtyEditors = new ArrayList<IEditorPart>();
                ArrayList<IEditorInput> dirtyEditorsInput = new ArrayList<IEditorInput>();
                IWorkbenchWindow[] windows = Workbench.this.getWorkbenchWindows();
                int i = 0;
                while (i < windows.length) {
                    IWorkbenchPage[] pages = windows[i].getPages();
                    int j = 0;
                    while (j < pages.length) {
                        WorkbenchPage page = (WorkbenchPage)pages[j];
                        IEditorPart[] editors = page.getDirtyEditors();
                        int k = 0;
                        while (k < editors.length) {
                            IEditorPart editor = editors[k];
                            if (editor.isDirty() && !dirtyEditorsInput.contains(editor.getEditorInput())) {
                                dirtyEditors.add(editor);
                                dirtyEditorsInput.add(editor.getEditorInput());
                            }
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
                if (dirtyEditors.size() > 0) {
                    IWorkbenchWindow w = Workbench.this.getActiveWorkbenchWindow();
                    if (w == null) {
                        w = windows[0];
                    }
                    result[0] = EditorManager.saveAll(dirtyEditors, finalConfirm, w);
                }
            }
        });
        return result[0];
    }

    private IWorkbenchWindow busyOpenWorkbenchWindow(String perspID, IAdaptable input) throws WorkbenchException {
        WorkbenchWindow newWindow = this.newWorkbenchWindow();
        newWindow.create();
        this.windowManager.add((Window)newWindow);
        newWindow.busyOpenPage(perspID, input);
        newWindow.open();
        return newWindow;
    }

    private void checkUpdates(String[] commandLineArgs) {
        boolean newUpdates = false;
        int i = 0;
        while (i < commandLineArgs.length) {
            if (commandLineArgs[i].equalsIgnoreCase("-newUpdates")) {
                newUpdates = true;
                break;
            }
            ++i;
        }
        if (newUpdates) {
            try {
                SiteManager.handleNewChanges();
            }
            catch (CoreException ex) {
                WorkbenchPlugin.log("Problem opening update manager", ex.getStatus());
            }
        }
    }

    public boolean close() {
        return this.close(IPlatformRunnable.EXIT_OK);
    }

    public boolean close(Object returnCode) {
        return this.close(returnCode, false);
    }

    public boolean close(Object returnCode, final boolean force) {
        this.returnCode = returnCode;
        final boolean[] ret = new boolean[1];
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            public void run() {
                ret[0] = Workbench.this.busyClose(force);
            }
        });
        return ret[0];
    }

    protected WorkbenchActionBuilder createActionBuilder(IWorkbenchWindow window) {
        return new WorkbenchActionBuilder(window);
    }

    private void connectToWorkspace() {
    }

    private void disableAutoBuild() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription description = workspace.getDescription();
        this.autoBuild = description.isAutoBuilding();
        if (this.autoBuild) {
            IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
            store.setValue("AUTO_BUILD", false);
            description.setAutoBuilding(false);
            try {
                workspace.setDescription(description);
            }
            catch (CoreException coreException) {
                MessageDialog.openError(null, (String)WorkbenchMessages.getString("Workspace.problemsTitle"), (String)WorkbenchMessages.getString("Restoring_Problem"));
            }
        }
    }

    private void disconnectFromWorkspace() {
        final MultiStatus status = new MultiStatus(WorkbenchPlugin.PI_WORKBENCH, 1, WorkbenchMessages.getString("ProblemSavingWorkbench"), null);
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                try {
                    status.merge(ResourcesPlugin.getWorkspace().save(true, monitor));
                }
                catch (CoreException e) {
                    status.merge(e.getStatus());
                }
            }
        };
        try {
            new ProgressMonitorDialog(null).run(false, false, runnable);
        }
        catch (InvocationTargetException e) {
            status.merge((IStatus)new Status(4, WorkbenchPlugin.PI_WORKBENCH, 1, WorkbenchMessages.getString("InternalError"), e.getTargetException()));
        }
        catch (InterruptedException e) {
            status.merge((IStatus)new Status(4, WorkbenchPlugin.PI_WORKBENCH, 1, WorkbenchMessages.getString("InternalError"), (Throwable)e));
        }
        ErrorDialog.openError(null, (String)WorkbenchMessages.getString("ProblemsSavingWorkspace"), null, (IStatus)status, (int)6);
        if (!status.isOK()) {
            WorkbenchPlugin.log(WorkbenchMessages.getString("ProblemsSavingWorkspace"), (IStatus)status);
        }
    }

    private void enableAutoBuild() {
        if (this.autoBuild) {
            IWorkbenchWindow[] windows = this.getWorkbenchWindows();
            Shell shell = windows[windows.length - 1].getShell();
            try {
                WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                    protected void execute(IProgressMonitor monitor) throws CoreException {
                        monitor.setTaskName(WorkbenchMessages.getString("Workbench.autoBuild"));
                        IWorkspace workspace = ResourcesPlugin.getWorkspace();
                        IWorkspaceDescription description = workspace.getDescription();
                        description.setAutoBuilding(true);
                        workspace.setDescription(description);
                    }
                };
                IWorkbenchWindow window = this.getActiveWorkbenchWindow();
                if (window != null) {
                    window.run(true, true, op);
                } else {
                    new ProgressMonitorDialog(shell).run(true, true, (IRunnableWithProgress)op);
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                MessageDialog.openError((Shell)shell, (String)WorkbenchMessages.getString("Workspace.problemsTitle"), (String)WorkbenchMessages.getString("Workspace.problemAutoBuild"));
            }
            IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
            store.setValue("AUTO_BUILD", true);
            this.updateBuildActions(true);
        }
    }

    public IWorkbenchWindow getActiveWorkbenchWindow() {
        Display display = Display.getCurrent();
        if (display == null) {
            return null;
        }
        Shell shell = display.getActiveShell();
        while (shell != null) {
            Object data = shell.getData();
            if (data instanceof IWorkbenchWindow) {
                return (IWorkbenchWindow)data;
            }
            shell = shell.getParent();
        }
        WorkbenchWindow win = this.getActivatedWindow();
        if (win != null) {
            return win;
        }
        Shell[] shells = display.getShells();
        int i = 0;
        while (i < shells.length) {
            Object data = shells[i].getData();
            if (data instanceof IWorkbenchWindow) {
                return (IWorkbenchWindow)data;
            }
            ++i;
        }
        return null;
    }

    public String[] getCommandLineArgs() {
        return this.commandLineArgs;
    }

    public EditorHistory getEditorHistory() {
        if (this.editorHistory == null) {
            IPreferenceStore store = this.getPreferenceStore();
            this.editorHistory = new EditorHistory(store.getInt("RECENT_FILES"));
        }
        return this.editorHistory;
    }

    public PerspectiveHistory getPerspectiveHistory() {
        if (this.perspHistory == null) {
            this.perspHistory = new PerspectiveHistory(this.getPerspectiveRegistry());
        }
        return this.perspHistory;
    }

    public IEditorRegistry getEditorRegistry() {
        return WorkbenchPlugin.getDefault().getEditorRegistry();
    }

    protected int getNewWindowNumber() {
        Window[] windows = this.windowManager.getWindows();
        int count = windows.length;
        boolean[] checkArray = new boolean[count];
        int nX = 0;
        while (nX < count) {
            WorkbenchWindow ww;
            int index;
            if (windows[nX] instanceof WorkbenchWindow && (index = (ww = (WorkbenchWindow)windows[nX]).getNumber() - 1) >= 0 && index < count) {
                checkArray[index] = true;
            }
            ++nX;
        }
        int index = 0;
        while (index < count) {
            if (!checkArray[index]) {
                return index + 1;
            }
            ++index;
        }
        return count + 1;
    }

    public IPerspectiveRegistry getPerspectiveRegistry() {
        return WorkbenchPlugin.getDefault().getPerspectiveRegistry();
    }

    public PreferenceManager getPreferenceManager() {
        return WorkbenchPlugin.getDefault().getPreferenceManager();
    }

    public IPreferenceStore getPreferenceStore() {
        return WorkbenchPlugin.getDefault().getPreferenceStore();
    }

    public ISharedImages getSharedImages() {
        return WorkbenchPlugin.getDefault().getSharedImages();
    }

    public IMarkerHelpRegistry getMarkerHelpRegistry() {
        return WorkbenchPlugin.getDefault().getMarkerHelpRegistry();
    }

    protected WindowManager getWindowManager() {
        return this.windowManager;
    }

    public WorkbenchConfigurationInfo getConfigurationInfo() {
        if (this.configurationInfo == null) {
            this.configurationInfo = new WorkbenchConfigurationInfo();
        }
        return this.configurationInfo;
    }

    private File getWorkbenchStateFile() {
        IPath path = WorkbenchPlugin.getDefault().getStateLocation();
        path = path.append(DEFAULT_WORKBENCH_STATE_FILENAME);
        return path.toFile();
    }

    public int getWorkbenchWindowCount() {
        return this.windowManager.getWindows().length;
    }

    public IWorkbenchWindow[] getWorkbenchWindows() {
        Window[] windows = this.windowManager.getWindows();
        IWorkbenchWindow[] dwindows = new IWorkbenchWindow[windows.length];
        System.arraycopy(windows, 0, dwindows, 0, windows.length);
        return dwindows;
    }

    public IWorkingSetManager getWorkingSetManager() {
        return WorkbenchPlugin.getDefault().getWorkingSetManager();
    }

    public void updateActiveKeyBindingService() {
        WWinKeyBindingService wWinKeyBindingService;
        IWorkbenchWindow workbenchWindow = this.getActiveWorkbenchWindow();
        if (workbenchWindow != null && workbenchWindow instanceof WorkbenchWindow && (wWinKeyBindingService = ((WorkbenchWindow)workbenchWindow).getKeyBindingService()) != null) {
            IWorkbenchPart activePart;
            IWorkbenchPage activePage = workbenchWindow.getActivePage();
            if (activePage != null && (activePart = activePage.getActivePart()) != null) {
                wWinKeyBindingService.update(activePart);
                return;
            }
            wWinKeyBindingService.clear();
        }
    }

    private void handlePropertyChange(PropertyChangeEvent event) {
        boolean newAutoBuildSetting;
        IWorkspaceDescription description;
        boolean autoBuildSetting;
        if (event.getProperty().equals("AUTO_BUILD") && (autoBuildSetting = (description = ResourcesPlugin.getWorkspace().getDescription()).isAutoBuilding()) != (newAutoBuildSetting = this.getPreferenceStore().getBoolean("AUTO_BUILD"))) {
            description.setAutoBuilding(newAutoBuildSetting);
            autoBuildSetting = newAutoBuildSetting;
            try {
                ResourcesPlugin.getWorkspace().setDescription(description);
            }
            catch (CoreException e) {
                WorkbenchPlugin.log("Error changing auto build preference setting.", e.getStatus());
            }
            if (newAutoBuildSetting) {
                GlobalBuildAction action = new GlobalBuildAction(this.getActiveWorkbenchWindow(), 10);
                action.doBuild();
            }
            this.updateBuildActions(newAutoBuildSetting);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean init(String[] commandLineArgs) {
        Object var5_8;
        this.commandLineArgs = commandLineArgs;
        if (WorkbenchPlugin.getDefault().isDebugging()) {
            WorkbenchPlugin.DEBUG = true;
            ModalContext.setDebugMode((boolean)true);
        }
        this.initializeProductImage();
        this.connectToWorkspace();
        this.addAdapters();
        this.windowManager = new WindowManager();
        WorkbenchColors.startup();
        boolean useColorIcons = this.getPreferenceStore().getBoolean("COLOR_ICONS");
        ActionContributionItem.setUseColorIconsInToolbars((boolean)useColorIcons);
        this.initializeFonts();
        this.initializeSingleClickOption();
        boolean avoidDeadlock = true;
        int i = 0;
        while (i < commandLineArgs.length) {
            if (commandLineArgs[i].equalsIgnoreCase("-allowDeadlock")) {
                avoidDeadlock = false;
            }
            ++i;
        }
        if (avoidDeadlock) {
            try {
                Display display = Display.getCurrent();
                UIWorkspaceLock uiLock = new UIWorkspaceLock(WorkbenchPlugin.getPluginWorkspace(), display);
                WorkbenchPlugin.getPluginWorkspace().setWorkspaceLock((WorkspaceLock)uiLock);
                display.setSynchronizer((Synchronizer)new UISynchronizer(display, uiLock));
            }
            catch (CoreException e) {
                e.printStackTrace(System.out);
            }
        }
        try {
            UIStats.start(UIStats.RESTORE_WORKBENCH, "Workbench");
            this.disableAutoBuild();
            int restoreCode = this.openPreviousWorkbenchState();
            if (restoreCode == 2) {
                var5_8 = null;
                UIStats.end(UIStats.RESTORE_WORKBENCH, "Workbench");
                return false;
            }
            if (restoreCode == 1) {
                this.openFirstTimeWindow();
            }
        }
        catch (Throwable throwable) {
            var5_8 = null;
            UIStats.end(UIStats.RESTORE_WORKBENCH, "Workbench");
            throw throwable;
        }
        var5_8 = null;
        UIStats.end(UIStats.RESTORE_WORKBENCH, "Workbench");
        this.refreshFromLocal(commandLineArgs);
        this.enableAutoBuild();
        this.getPreferenceStore().addPropertyChangeListener(this.propertyChangeListener);
        this.forceOpenPerspective(commandLineArgs);
        this.getConfigurationInfo().openWelcomeEditors(this.getActiveWorkbenchWindow());
        this.isStarting = false;
        return true;
    }

    private void refreshFromLocal(String[] commandLineArgs) {
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        boolean refresh = store.getBoolean("REFRESH_WORKSPACE_ON_STARTUP");
        if (!refresh) {
            return;
        }
        int i = 0;
        while (i < commandLineArgs.length) {
            if (commandLineArgs[i].equalsIgnoreCase("-refresh")) {
                return;
            }
            ++i;
        }
        IWorkbenchWindow[] windows = this.getWorkbenchWindows();
        Shell shell = windows[windows.length - 1].getShell();
        ProgressMonitorDialog dlg = new ProgressMonitorDialog(shell);
        final CoreException[] ex = new CoreException[1];
        try {
            dlg.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                        root.refreshLocal(2, monitor);
                    }
                    catch (CoreException e) {
                        ex[0] = e;
                    }
                }
            });
            if (ex[0] != null) {
                String errorTitle = WorkbenchMessages.getString("Workspace.problemsTitle");
                String msg = WorkbenchMessages.getString("Workspace.problemMessage");
                ErrorDialog.openError((Shell)shell, (String)errorTitle, (String)msg, (IStatus)ex[0].getStatus());
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            String msg = "InvocationTargetException refreshing from local on startup";
            WorkbenchPlugin.log(msg, (IStatus)new Status(4, "org.eclipse.ui", 0, msg, e.getTargetException()));
        }
    }

    private void forceOpenPerspective(String[] commandLineArgs) {
        if (this.getWorkbenchWindowCount() == 0) {
            return;
        }
        String perspId = null;
        int i = 0;
        while (i < commandLineArgs.length - 1) {
            if (commandLineArgs[i].equalsIgnoreCase("-perspective")) {
                perspId = commandLineArgs[i + 1];
                break;
            }
            ++i;
        }
        if (perspId == null) {
            return;
        }
        IPerspectiveDescriptor desc = this.getPerspectiveRegistry().findPerspectiveWithId(perspId);
        if (desc == null) {
            return;
        }
        IWorkbenchWindow win = this.getActiveWorkbenchWindow();
        if (win == null) {
            win = this.getWorkbenchWindows()[0];
        }
        try {
            this.showPerspective(perspId, win);
        }
        catch (WorkbenchException e) {
            String msg = "Workbench exception showing specified command line perspective on startup.";
            WorkbenchPlugin.log(msg, (IStatus)new Status(4, "org.eclipse.ui", 0, msg, (Throwable)((Object)e)));
        }
    }

    private void initializeSingleClickOption() {
        int singleClickMethod;
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        boolean openOnSingleClick = store.getBoolean("OPEN_ON_SINGLE_CLICK");
        boolean selectOnHover = store.getBoolean("SELECT_ON_HOVER");
        boolean openAfterDelay = store.getBoolean("OPEN_AFTER_DELAY");
        int n = singleClickMethod = openOnSingleClick ? 1 : 0;
        if (openOnSingleClick) {
            if (selectOnHover) {
                singleClickMethod |= 2;
            }
            if (openAfterDelay) {
                singleClickMethod |= 4;
            }
        }
        OpenStrategy.setOpenMethod((int)singleClickMethod);
    }

    private void initializeFonts() {
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        FontRegistry registry = JFaceResources.getFontRegistry();
        FontDefinition[] definitions = FontDefinition.getDefinitions();
        ArrayList<FontDefinition> fontsToSet = new ArrayList<FontDefinition>();
        int i = 0;
        while (i < definitions.length) {
            FontDefinition definition = definitions[i];
            String fontKey = definition.getId();
            this.initializeFont(fontKey, registry, store);
            String defaultsTo = definitions[i].getDefaultsTo();
            if (defaultsTo != null) {
                PreferenceConverter.setDefault((IPreferenceStore)store, (String)definition.getId(), (FontData[])PreferenceConverter.getDefaultFontDataArray((IPreferenceStore)store, (String)defaultsTo));
                if (!registry.hasValueFor(fontKey)) {
                    fontsToSet.add(definition);
                }
            }
            ++i;
        }
        Iterator updateIterator = ((AbstractList)fontsToSet).iterator();
        while (updateIterator.hasNext()) {
            FontDefinition update = (FontDefinition)updateIterator.next();
            registry.put(update.getId(), registry.getFontData(update.getDefaultsTo()));
        }
    }

    private void initializeFont(String fontKey, FontRegistry registry, IPreferenceStore store) {
        if (store.isDefault(fontKey)) {
            return;
        }
        FontData[] font = PreferenceConverter.getFontDataArray((IPreferenceStore)store, (String)fontKey);
        registry.put(fontKey, font);
    }

    private void initializeProductImage() {
        ImageDescriptor descriptor = this.getConfigurationInfo().getAboutInfo().getWindowImage();
        if (descriptor != null) {
            WorkbenchImages.getImageRegistry().put("IMG_OBJS_DEFAULT_PROD", descriptor);
            Image image = WorkbenchImages.getImage("IMG_OBJS_DEFAULT_PROD");
            if (image != null) {
                Window.setDefaultImage((Image)image);
            }
        } else {
            WorkbenchImages.getImageRegistry().put("IMG_OBJS_DEFAULT_PROD", ImageDescriptor.getMissingImageDescriptor());
        }
    }

    public boolean isClosing() {
        return this.isClosing;
    }

    public boolean isStarting() {
        return this.isStarting;
    }

    protected WorkbenchWindow newWorkbenchWindow() {
        return new WorkbenchWindow(this, this.getNewWindowNumber());
    }

    private void openFirstTimeWindow() {
        WorkbenchWindow newWindow = this.newWorkbenchWindow();
        newWindow.create();
        this.windowManager.add((Window)newWindow);
        try {
            IWorkspaceRoot root = WorkbenchPlugin.getPluginWorkspace().getRoot();
            newWindow.openPage(this.getPerspectiveRegistry().getDefaultPerspective(), (IAdaptable)root);
        }
        catch (WorkbenchException e) {
            ErrorDialog.openError((Shell)newWindow.getShell(), (String)WorkbenchMessages.getString("Problems_Opening_Page"), (String)((Throwable)((Object)e)).getMessage(), (IStatus)e.getStatus());
        }
        newWindow.open();
    }

    private int openPreviousWorkbenchState() {
        final File stateFile = this.getWorkbenchStateFile();
        if (!stateFile.exists()) {
            return 1;
        }
        final int[] result = new int[1];
        Platform.run((ISafeRunnable)new SafeRunnable(WorkbenchMessages.getString("ErrorReadingState")){

            public void run() throws Exception {
                FileInputStream input = new FileInputStream(stateFile);
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)input, "utf-8"));
                XMLMemento memento = XMLMemento.createReadRoot(reader);
                String version = memento.getString("version");
                boolean valid = false;
                int i = 0;
                while (i < VERSION_STRING.length) {
                    if (VERSION_STRING[i].equals(version)) {
                        valid = true;
                        break;
                    }
                    ++i;
                }
                if (!valid) {
                    reader.close();
                    MessageDialog.openError(null, (String)WorkbenchMessages.getString("Restoring_Problems"), (String)WorkbenchMessages.getString("Invalid_workbench_state_ve"));
                    stateFile.delete();
                    result[0] = 1;
                    return;
                }
                if (VERSION_STRING[0].equals(version)) {
                    boolean ignoreSavedState;
                    reader.close();
                    boolean bl = ignoreSavedState = new MessageDialog(null, WorkbenchMessages.getString("Workbench.incompatibleUIState"), null, WorkbenchMessages.getString("Workbench.incompatibleSavedStateVersion"), 4, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0).open() == 0;
                    if (ignoreSavedState) {
                        stateFile.delete();
                        result[0] = 1;
                    } else {
                        result[0] = 2;
                    }
                    return;
                }
                IStatus restoreResult = Workbench.this.restoreState(memento);
                reader.close();
                if (restoreResult.getSeverity() == 4) {
                    ErrorDialog.openError(null, (String)WorkbenchMessages.getString("Workspace.problemsTitle"), (String)WorkbenchMessages.getString("Workbench.problemsRestoringMsg"), (IStatus)restoreResult);
                }
            }

            public void handleException(Throwable e) {
                super.handleException(e);
                result[0] = 1;
                stateFile.delete();
            }
        });
        if (result[0] == 0 && this.windowManager.getWindows().length == 0) {
            result[0] = 1;
        }
        return result[0];
    }

    public IWorkbenchWindow openWorkbenchWindow(IAdaptable input) throws WorkbenchException {
        return this.openWorkbenchWindow(this.getPerspectiveRegistry().getDefaultPerspective(), input);
    }

    public IWorkbenchWindow openWorkbenchWindow(final String perspID, final IAdaptable input) throws WorkbenchException {
        final Object[] result = new Object[1];
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            public void run() {
                try {
                    result[0] = Workbench.this.busyOpenWorkbenchWindow(perspID, input);
                }
                catch (WorkbenchException e) {
                    result[0] = e;
                }
            }
        });
        if (result[0] instanceof IWorkbenchWindow) {
            return (IWorkbenchWindow)result[0];
        }
        if (result[0] instanceof WorkbenchException) {
            throw (WorkbenchException)((Object)result[0]);
        }
        throw new WorkbenchException(WorkbenchMessages.getString("Abnormal_Workbench_Conditi"));
    }

    private XMLMemento recordWorkbenchState() {
        XMLMemento memento = XMLMemento.createWriteRoot("workbench");
        IStatus status = this.saveState(memento);
        if (status.getSeverity() != 0) {
            ErrorDialog.openError(null, (String)WorkbenchMessages.getString("Workbench.problemsSaving"), (String)WorkbenchMessages.getString("Workbench.problemsSavingMsg"), (IStatus)status);
        }
        return memento;
    }

    public boolean restart() {
        return this.close(IPlatformRunnable.EXIT_RESTART);
    }

    private IStatus restoreState(IMemento memento) {
        IMemento childMem;
        MultiStatus result = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.getString("Workbench.problemsRestoring"), null);
        try {
            UIStats.start(UIStats.RESTORE_WORKBENCH, "PerspectiveHistory");
            childMem = memento.getChild("perspHistory");
            if (childMem != null) {
                result.add(this.getPerspectiveHistory().restoreState(childMem));
            }
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            UIStats.end(UIStats.RESTORE_WORKBENCH, "PerspectiveHistory");
            throw throwable;
        }
        Object var4_8 = null;
        UIStats.end(UIStats.RESTORE_WORKBENCH, "PerspectiveHistory");
        try {
            UIStats.start(UIStats.RESTORE_WORKBENCH, "MRUList");
            IMemento mruMemento = memento.getChild("mruList");
            if (mruMemento != null) {
                result.add(this.getEditorHistory().restoreState(mruMemento));
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            UIStats.end(UIStats.RESTORE_WORKBENCH, "MRUList");
            throw throwable;
        }
        Object var5_6 = null;
        UIStats.end(UIStats.RESTORE_WORKBENCH, "MRUList");
        IMemento[] children = memento.getChildren("window");
        IPerspectiveRegistry reg = WorkbenchPlugin.getDefault().getPerspectiveRegistry();
        AboutInfo[] newFeaturesWithPerspectives = this.getConfigurationInfo().collectNewFeaturesWithPerspectives();
        int x = 0;
        while (x < children.length) {
            childMem = children[x];
            WorkbenchWindow newWindow = this.newWorkbenchWindow();
            newWindow.create();
            IPerspectiveDescriptor desc = null;
            if (x < newFeaturesWithPerspectives.length) {
                desc = reg.findPerspectiveWithId(newFeaturesWithPerspectives[x].getWelcomePerspective());
            }
            result.merge(newWindow.restoreState(childMem, desc));
            if (desc != null) {
                IWorkbenchPage[] pages;
                IWorkbenchPage page = newWindow.getActivePage();
                if (page == null && (pages = newWindow.getPages()) != null && pages.length > 0) {
                    page = pages[0];
                }
                if (page == null) {
                    IWorkspaceRoot root = WorkbenchPlugin.getPluginWorkspace().getRoot();
                    try {
                        page = (WorkbenchPage)newWindow.openPage(newFeaturesWithPerspectives[x].getWelcomePerspective(), (IAdaptable)root);
                    }
                    catch (WorkbenchException e) {
                        result.add(e.getStatus());
                    }
                } else {
                    page.setPerspective(desc);
                }
                newWindow.setActivePage(page);
                try {
                    page.openEditor(new WelcomeEditorInput(newFeaturesWithPerspectives[x]), WELCOME_EDITOR_ID, true);
                }
                catch (PartInitException e) {
                    result.add(e.getStatus());
                }
            }
            this.windowManager.add((Window)newWindow);
            newWindow.open();
            ++x;
        }
        return result;
    }

    public IPluginDescriptor[] getEarlyActivatedPlugins() {
        IPluginRegistry registry = Platform.getPluginRegistry();
        String pluginId = "org.eclipse.ui";
        String extensionPoint = "startup";
        IExtensionPoint point = registry.getExtensionPoint(pluginId, extensionPoint);
        IExtension[] extensions = point.getExtensions();
        IPluginDescriptor[] result = new IPluginDescriptor[extensions.length];
        int i = 0;
        while (i < extensions.length) {
            result[i] = extensions[i].getDeclaringPluginDescriptor();
            ++i;
        }
        return result;
    }

    protected void startPlugins() {
        Runnable work = new Runnable(){
            IPreferenceStore store;
            final String pref;
            {
                this.store = Workbench.this.getPreferenceStore();
                this.pref = this.store.getString("PLUGINS_NOT_ACTIVATED_ON_STARTUP");
            }

            public void run() {
                IPluginDescriptor[] descriptors = Workbench.this.getEarlyActivatedPlugins();
                int i = 0;
                while (i < descriptors.length) {
                    IPluginDescriptor pluginDescriptor = descriptors[i];
                    SafeRunnable code = new SafeRunnable(this, pluginDescriptor){
                        private final /* synthetic */ IPluginDescriptor val$pluginDescriptor;
                        private final /* synthetic */ 14 this$1;
                        {
                            this.this$1 = var1_1;
                            this.val$pluginDescriptor = iPluginDescriptor;
                        }

                        public void run() throws Exception {
                            String id = String.valueOf(this.val$pluginDescriptor.getUniqueIdentifier()) + ';';
                            if (this.this$1.pref.indexOf(id) < 0) {
                                Plugin plugin = this.val$pluginDescriptor.getPlugin();
                                IStartup startup = (IStartup)plugin;
                                startup.earlyStartup();
                            }
                        }

                        public void handleException(Throwable exception) {
                            WorkbenchPlugin.log("Unhandled Exception", (IStatus)new Status(4, "org.eclipse.ui", 0, "Unhandled Exception", exception));
                        }
                    };
                    Platform.run((ISafeRunnable)code);
                    ++i;
                }
            }
        };
        Thread thread = new Thread(work);
        thread.start();
    }

    public Object run(Object arg) {
        block10: {
            UIStats.start(UIStats.START_WORKBENCH, "Workbench");
            String[] commandLineArgs = new String[]{};
            if (arg != null && arg instanceof String[]) {
                commandLineArgs = (String[])arg;
            }
            if (!this.getConfigurationInfo().readInfo()) {
                return null;
            }
            String appName = this.getConfigurationInfo().getAboutInfo().getAppName();
            if (appName != null) {
                Display.setAppName((String)appName);
            }
            Display display = null;
            if (Policy.DEBUG_SWT_GRAPHICS) {
                DeviceData data = new DeviceData();
                data.tracking = true;
                display = new Display(data);
            } else {
                display = new Display();
            }
            display.setWarnings(false);
            display.addListener(21, new Listener(){

                public void handleEvent(Event event) {
                    event.doit = Workbench.this.close();
                }
            });
            try {
                ExceptionHandler handler = new ExceptionHandler(this);
                Window.setExceptionHandler((Window.IExceptionHandler)handler);
                boolean initOK = this.init(commandLineArgs);
                Platform.endSplash();
                this.runEventLoop = true;
                if (initOK) {
                    this.checkUpdates(commandLineArgs);
                }
                if (initOK && this.runEventLoop) {
                    this.startPlugins();
                    display.asyncExec(new Runnable(){

                        public void run() {
                            UIStats.end(UIStats.START_WORKBENCH, "Workbench");
                        }
                    });
                    this.runEventLoop(handler);
                }
                this.shutdown();
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (!display.isDisposed()) {
                    display.dispose();
                }
                throw throwable;
            }
            Object var7_9 = null;
            if (display.isDisposed()) break block10;
            display.dispose();
        }
        return this.returnCode;
    }

    protected void runEventLoop(Window.IExceptionHandler handler) {
        Display display = Display.getCurrent();
        this.runEventLoop = true;
        while (this.runEventLoop) {
            try {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            catch (Throwable t) {
                handler.handleException(t);
            }
        }
    }

    private IStatus saveState(IMemento memento) {
        MultiStatus result = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.getString("Workbench.problemsSaving"), null);
        memento.putString("version", VERSION_STRING[1]);
        IWorkbenchWindow[] windows = this.getWorkbenchWindows();
        int nX = 0;
        while (nX < windows.length) {
            WorkbenchWindow window = (WorkbenchWindow)windows[nX];
            IMemento childMem = memento.createChild("window");
            result.merge(window.saveState(childMem));
            ++nX;
        }
        result.add(this.getEditorHistory().saveState(memento.createChild("mruList")));
        result.add(this.getPerspectiveHistory().saveState(memento.createChild("perspHistory")));
        return result;
    }

    private boolean saveWorkbenchState(XMLMemento memento) {
        File stateFile = this.getWorkbenchStateFile();
        try {
            FileOutputStream stream = new FileOutputStream(stateFile);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, "utf-8");
            memento.save(writer);
            writer.close();
        }
        catch (IOException iOException) {
            stateFile.delete();
            MessageDialog.openError(null, (String)WorkbenchMessages.getString("SavingProblem"), (String)WorkbenchMessages.getString("ProblemSavingState"));
            return false;
        }
        return true;
    }

    public void setInitializationData(IConfigurationElement configElement, String propertyName, Object data) {
    }

    public IWorkbenchPage showPerspective(String perspectiveId, IWorkbenchWindow window) throws WorkbenchException {
        Object persp;
        int i;
        WorkbenchPage page;
        Assert.isNotNull(perspectiveId);
        WorkbenchWindow win = (WorkbenchWindow)window;
        if (win != null && (page = win.getActiveWorkbenchPage()) != null) {
            IPerspectiveDescriptor[] perspectives = page.getOpenedPerspectives();
            i = 0;
            while (i < perspectives.length) {
                IPerspectiveDescriptor persp2 = perspectives[i];
                if (perspectiveId.equals(persp2.getId())) {
                    win.getShell().open();
                    page.setPerspective(persp2);
                    return page;
                }
                ++i;
            }
        }
        IWorkspaceRoot input = WorkbenchPlugin.getPluginWorkspace().getRoot();
        IWorkbenchWindow[] windows = this.getWorkbenchWindows();
        i = 0;
        while (i < windows.length) {
            WorkbenchPage page2;
            win = (WorkbenchWindow)windows[i];
            if (window != win && (page2 = win.getActiveWorkbenchPage()) != null) {
                boolean inputSame = false;
                inputSame = input == null ? page2.getInput() == null : input.equals(page2.getInput());
                if (inputSame && perspectiveId.equals(((Perspective)(persp = page2.getActivePerspective())).getDesc().getId())) {
                    Shell shell = win.getShell();
                    shell.open();
                    if (shell.getMinimized()) {
                        shell.setMinimized(false);
                    }
                    return page2;
                }
            }
            ++i;
        }
        win = (WorkbenchWindow)window;
        if (win != null) {
            IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
            int mode = store.getInt("OPEN_PERSPECTIVE_MODE");
            IWorkbenchPage page3 = win.getActiveWorkbenchPage();
            persp = null;
            if (page3 != null) {
                persp = page3.getPerspective();
            }
            if (2 == mode && persp != null) {
                IWorkbenchWindow newWindow = this.openWorkbenchWindow(perspectiveId, (IAdaptable)input);
                return newWindow.getActivePage();
            }
            IPerspectiveDescriptor desc = this.getPerspectiveRegistry().findPerspectiveWithId(perspectiveId);
            if (desc == null) {
                throw new WorkbenchException(WorkbenchMessages.getString("WorkbenchPage.ErrorRecreatingPerspective"));
            }
            win.getShell().open();
            if (page3 == null) {
                page3 = win.openPage(perspectiveId, (IAdaptable)input);
            } else {
                page3.setPerspective(desc);
            }
            return page3;
        }
        throw new WorkbenchException(WorkbenchMessages.format("Workbench.showPerspectiveError", new Object[]{perspectiveId}));
    }

    public IWorkbenchPage showPerspective(String perspectiveId, IWorkbenchWindow window, IAdaptable input) throws WorkbenchException {
        IPreferenceStore store;
        int mode;
        Object persp;
        WorkbenchPage page;
        Assert.isNotNull(perspectiveId);
        boolean inputSameAsWindow = false;
        WorkbenchWindow win = (WorkbenchWindow)window;
        if (win != null && (page = win.getActiveWorkbenchPage()) != null) {
            boolean inputSame = false;
            inputSame = input == null ? page.getInput() == null : input.equals(page.getInput());
            if (inputSame) {
                inputSameAsWindow = true;
                IPerspectiveDescriptor[] perspectives = page.getOpenedPerspectives();
                int i = 0;
                while (i < perspectives.length) {
                    persp = perspectives[i];
                    if (perspectiveId.equals(persp.getId())) {
                        win.getShell().open();
                        page.setPerspective((IPerspectiveDescriptor)persp);
                        return page;
                    }
                    ++i;
                }
            }
        }
        IWorkbenchWindow[] windows = this.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            WorkbenchPage page2;
            win = (WorkbenchWindow)windows[i];
            if (window != win && (page2 = win.getActiveWorkbenchPage()) != null) {
                boolean inputSame = false;
                inputSame = input == null ? page2.getInput() == null : input.equals(page2.getInput());
                if (inputSame && perspectiveId.equals(((Perspective)(persp = page2.getActivePerspective())).getDesc().getId())) {
                    win.getShell().open();
                    return page2;
                }
            }
            ++i;
        }
        win = (WorkbenchWindow)window;
        if (inputSameAsWindow && win != null && 2 != (mode = (store = WorkbenchPlugin.getDefault().getPreferenceStore()).getInt("OPEN_PERSPECTIVE_MODE"))) {
            IWorkbenchPage page3 = win.getActiveWorkbenchPage();
            IPerspectiveDescriptor desc = this.getPerspectiveRegistry().findPerspectiveWithId(perspectiveId);
            if (desc == null) {
                throw new WorkbenchException(WorkbenchMessages.getString("WorkbenchPage.ErrorRecreatingPerspective"));
            }
            win.getShell().open();
            if (page3 == null) {
                page3 = win.openPage(perspectiveId, input);
            } else {
                page3.setPerspective(desc);
            }
            return page3;
        }
        if (win != null) {
            IWorkbenchPage page4 = win.getActiveWorkbenchPage();
            IPerspectiveDescriptor persp2 = null;
            if (page4 != null) {
                persp2 = page4.getPerspective();
            }
            if (persp2 == null) {
                IPerspectiveDescriptor desc = this.getPerspectiveRegistry().findPerspectiveWithId(perspectiveId);
                if (desc == null) {
                    throw new WorkbenchException(WorkbenchMessages.getString("WorkbenchPage.ErrorRecreatingPerspective"));
                }
                win.getShell().open();
                if (page4 == null) {
                    page4 = win.openPage(perspectiveId, input);
                } else {
                    page4.setPerspective(desc);
                }
                return page4;
            }
        }
        IWorkbenchWindow newWindow = this.openWorkbenchWindow(perspectiveId, input);
        return newWindow.getActivePage();
    }

    private void shutdown() {
        WorkbenchColors.shutdown();
        JFaceColors.disposeColors();
        if (this.getDecoratorManager() != null) {
            ((DecoratorManager)this.getDecoratorManager()).shutdown();
        }
    }

    public void refreshPluginActions(String pluginId) {
        WWinPluginAction.refreshActionList();
    }

    public IDecoratorManager getDecoratorManager() {
        return WorkbenchPlugin.getDefault().getDecoratorManager();
    }

    protected final WorkbenchWindow getActivatedWindow() {
        Shell shell;
        if (this.activatedWindow != null && (shell = this.activatedWindow.getShell()) != null && !shell.isDisposed()) {
            return this.activatedWindow;
        }
        return null;
    }

    protected final void setActivatedWindow(WorkbenchWindow window) {
        this.activatedWindow = window;
    }

    private void updateBuildActions(boolean autoBuildSetting) {
        Window[] wins = this.windowManager.getWindows();
        int i = 0;
        while (i < wins.length) {
            if (autoBuildSetting) {
                ((WorkbenchWindow)wins[i]).getActionBuilder().removeManualIncrementalBuildAction();
            } else {
                ((WorkbenchWindow)wins[i]).getActionBuilder().addManualIncrementalBuildAction();
            }
            ++i;
        }
    }

    static /* synthetic */ String access$2() {
        return TASK_LIST_ID;
    }
}

