/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.StatusLineLayoutData;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.AcceleratorMenu;
import org.eclipse.ui.internal.KeyBindingService;
import org.eclipse.ui.internal.PluginActionSet;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.commands.KeySupport;
import org.eclipse.ui.internal.commands.Manager;
import org.eclipse.ui.internal.commands.Sequence;
import org.eclipse.ui.internal.commands.SequenceMachine;
import org.eclipse.ui.internal.commands.Stroke;
import org.eclipse.ui.internal.registry.IActionSet;

final class WWinKeyBindingService {
    private final KeyModeContributionItem keyModeContributionItem = new KeyModeContributionItem("KeyModeContribution");
    private final IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart workbenchPart) {
            WWinKeyBindingService.this.update(workbenchPart);
        }

        public void partBroughtToTop(IWorkbenchPart workbenchPart) {
        }

        public void partClosed(IWorkbenchPart workbenchPart) {
            WWinKeyBindingService.this.clear();
        }

        public void partDeactivated(IWorkbenchPart workbenchPart) {
            WWinKeyBindingService.this.clear();
        }

        public void partOpened(IWorkbenchPart workbenchPart) {
            WWinKeyBindingService.this.clear();
        }
    };
    private final ShellListener shellListener = new ShellAdapter(){

        public void shellActivated(ShellEvent e) {
            WWinKeyBindingService.this.update(WWinKeyBindingService.this.workbenchWindow.getPartService().getActivePart());
        }

        public void shellDeactivated(ShellEvent e) {
            WWinKeyBindingService.this.clear();
        }
    };
    private final VerifyListener verifyListener = new VerifyListener(){

        public void verifyText(VerifyEvent event) {
            event.doit = false;
            WWinKeyBindingService.this.clear();
        }
    };
    private AcceleratorMenu acceleratorMenu;
    private SortedMap actionSetsCommandIdToActionMap = new TreeMap();
    private KeyBindingService activeKeyBindingService;
    private SortedMap globalActionsCommandIdToActionMap = new TreeMap();
    private WorkbenchWindow workbenchWindow;

    WWinKeyBindingService(WorkbenchWindow workbenchWindow) {
        this.workbenchWindow = workbenchWindow;
        workbenchWindow.getStatusLineManager().add((IContributionItem)this.keyModeContributionItem);
        workbenchWindow.getPartService().addPartListener(this.partListener);
        final WorkbenchWindow finalWorkbenchWindow = this.workbenchWindow;
        this.workbenchWindow.addPageListener(new IPageListener(){

            public void pageActivated(IWorkbenchPage page) {
            }

            public void pageClosed(IWorkbenchPage page) {
            }

            public void pageOpened(IWorkbenchPage page) {
                page.addPartListener(WWinKeyBindingService.this.partListener);
                WWinKeyBindingService.this.update(page.getActivePart());
                Shell shell = finalWorkbenchWindow.getShell();
                shell.removeShellListener(WWinKeyBindingService.this.shellListener);
                shell.addShellListener(WWinKeyBindingService.this.shellListener);
            }
        });
    }

    void clear() {
        Manager.getInstance().getKeyMachine().setMode(Sequence.create());
        this.keyModeContributionItem.setText("");
        this.updateAccelerators();
        MenuManager menuManager = this.workbenchWindow.getMenuManager();
        menuManager.update("text");
    }

    IAction getAction(String command) {
        IAction action = null;
        if (this.activeKeyBindingService != null) {
            action = this.activeKeyBindingService.getAction(command);
        }
        if (action == null && (action = (IAction)this.actionSetsCommandIdToActionMap.get(command)) == null) {
            action = (IAction)this.globalActionsCommandIdToActionMap.get(command);
        }
        return action;
    }

    void pressed(Stroke stroke, Event event) {
        Manager manager = Manager.getInstance();
        SequenceMachine keyMachine = manager.getKeyMachine();
        ArrayList<Stroke> strokes = new ArrayList<Stroke>(keyMachine.getMode().getStrokes());
        strokes.add(stroke);
        Sequence childMode = Sequence.create(strokes);
        SortedMap sequenceMapForMode = keyMachine.getSequenceMapForMode();
        keyMachine.setMode(childMode);
        SortedMap childSequenceMapForMode = keyMachine.getSequenceMapForMode();
        if (childSequenceMapForMode.isEmpty()) {
            IAction action;
            this.clear();
            String command = (String)sequenceMapForMode.get(childMode);
            if (command != null && this.activeKeyBindingService != null && (action = this.getAction(command)) != null && action.isEnabled()) {
                action.runWithEvent(event);
            }
        } else {
            this.keyModeContributionItem.setText(KeySupport.formatSequence(childMode, true));
            this.updateAccelerators();
            MenuManager menuManager = this.workbenchWindow.getMenuManager();
            menuManager.update("text");
        }
    }

    void registerActionSets(IActionSet[] actionSets) {
        this.actionSetsCommandIdToActionMap.clear();
        int i = 0;
        while (i < actionSets.length) {
            if (actionSets[i] instanceof PluginActionSet) {
                PluginActionSet pluginActionSet = (PluginActionSet)actionSets[i];
                IAction[] pluginActions = pluginActionSet.getPluginActions();
                int j = 0;
                while (j < pluginActions.length) {
                    IAction pluginAction = pluginActions[j];
                    String command = pluginAction.getActionDefinitionId();
                    if (command != null) {
                        this.actionSetsCommandIdToActionMap.put(command, pluginAction);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    void registerGlobalAction(IAction globalAction) {
        String command = globalAction.getActionDefinitionId();
        if (command != null) {
            this.globalActionsCommandIdToActionMap.put(command, globalAction);
        }
    }

    void update(IWorkbenchPart workbenchPart) {
        String[] scopes = new String[]{""};
        if (workbenchPart != null) {
            this.activeKeyBindingService = (KeyBindingService)workbenchPart.getSite().getKeyBindingService();
            if (this.activeKeyBindingService != null) {
                scopes = this.activeKeyBindingService.getScopes();
            }
        }
        try {
            Manager.getInstance().getKeyMachine().setScopes(scopes);
        }
        catch (IllegalArgumentException eIllegalArgument) {
            System.err.println(eIllegalArgument);
        }
        this.clear();
    }

    private void updateAccelerators() {
        SequenceMachine keyMachine = Manager.getInstance().getKeyMachine();
        Sequence mode = keyMachine.getMode();
        List strokes = mode.getStrokes();
        int size = strokes.size();
        SortedMap sequenceMapForMode = keyMachine.getSequenceMapForMode();
        TreeSet strokeSetForMode = new TreeSet();
        Iterator iterator = sequenceMapForMode.entrySet().iterator();
        if (this.activeKeyBindingService != null) {
            while (iterator.hasNext()) {
                IAction action;
                Map.Entry entry = iterator.next();
                Sequence sequence = (Sequence)entry.getKey();
                String command = (String)entry.getValue();
                if (!sequence.isChildOf(mode, false) || (action = this.getAction(command)) == null) continue;
                strokeSetForMode.add(sequence.getStrokes().get(size));
            }
        }
        iterator = strokeSetForMode.iterator();
        int[] accelerators = new int[strokeSetForMode.size()];
        int i = 0;
        while (iterator.hasNext()) {
            accelerators[i++] = ((Stroke)((Object)iterator.next())).getValue();
        }
        if (this.acceleratorMenu == null || this.acceleratorMenu.isDisposed()) {
            Menu parent = this.workbenchWindow.getShell().getMenuBar();
            if (parent == null || parent.getItemCount() < 1) {
                return;
            }
            MenuItem parentItem = parent.getItem(parent.getItemCount() - 1);
            parent = parentItem.getMenu();
            if (this.acceleratorMenu != null) {
                this.acceleratorMenu.dispose();
            }
            this.acceleratorMenu = new AcceleratorMenu(parent);
        }
        this.acceleratorMenu.setAccelerators(accelerators);
        this.acceleratorMenu.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Event event = new Event();
                event.item = selectionEvent.item;
                event.detail = selectionEvent.detail;
                event.x = selectionEvent.x;
                event.y = selectionEvent.y;
                event.width = selectionEvent.width;
                event.height = selectionEvent.height;
                event.stateMask = selectionEvent.stateMask;
                event.doit = selectionEvent.doit;
                event.data = selectionEvent.data;
                event.display = selectionEvent.display;
                event.time = selectionEvent.time;
                event.widget = selectionEvent.widget;
                WWinKeyBindingService.this.pressed(Stroke.create(selectionEvent.detail), event);
            }
        });
        if (size == 0) {
            this.acceleratorMenu.removeVerifyListener(this.verifyListener);
        } else {
            this.acceleratorMenu.addVerifyListener(this.verifyListener);
        }
    }

    private static class KeyModeContributionItem
    extends ContributionItem {
        private int fixedWidth = -1;
        private String text;
        private CLabel label;

        KeyModeContributionItem(String id) {
            super(id);
        }

        void setText(String msg) {
            this.text = msg;
            if (this.label != null && !this.label.isDisposed()) {
                this.label.setText(this.text);
            }
            if (this.text == null || this.text.length() < 1) {
                if (this.isVisible()) {
                    this.setVisible(false);
                    this.getParent().update(true);
                }
            } else if (!this.isVisible()) {
                this.setVisible(true);
                this.getParent().update(true);
            }
        }

        public void fill(Composite parent) {
            this.label = new CLabel(parent, 4);
            StatusLineLayoutData data = new StatusLineLayoutData();
            if (this.fixedWidth < 0) {
                GC gc = new GC((Drawable)parent);
                gc.setFont(parent.getFont());
                this.fixedWidth = gc.getFontMetrics().getAverageCharWidth() * 40;
                gc.dispose();
            }
            data.widthHint = this.fixedWidth;
            this.label.setLayoutData((Object)data);
            if (this.text != null) {
                this.label.setText(this.text);
            }
        }
    }
}

