/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.help.IHelp;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.PartEventAction;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.AboutInfo;
import org.eclipse.ui.internal.FeatureSelectionDialog;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class TipsAndTricksAction
extends PartEventAction {
    private IWorkbenchWindow window;

    public TipsAndTricksAction(IWorkbenchWindow window) {
        super(WorkbenchMessages.getString("TipsAndTricks.text"));
        this.setToolTipText(WorkbenchMessages.getString("TipsAndTricks.toolTip"));
        WorkbenchHelp.setHelp((IAction)this, "org.eclipse.ui.tips_and_tricks_action_context");
        this.setActionDefinitionId("org.eclipse.ui.help.tipsAndTricksAction");
        this.window = window;
    }

    public void run() {
        AboutInfo[] features = ((Workbench)this.window.getWorkbench()).getConfigurationInfo().getFeaturesInfo();
        ArrayList<AboutInfo> tipsAndTricksFeatures = new ArrayList<AboutInfo>();
        int i = 0;
        while (i < features.length) {
            if (features[i].getTipsAndTricksHref() != null) {
                tipsAndTricksFeatures.add(features[i]);
            }
            ++i;
        }
        if (this.window == null) {
            return;
        }
        Shell shell = this.window.getShell();
        if (tipsAndTricksFeatures.size() == 0) {
            MessageDialog.openInformation((Shell)shell, (String)WorkbenchMessages.getString("TipsAndTricksMessageDialog.title"), (String)WorkbenchMessages.getString("TipsAndTricksMessageDialog.message"));
            return;
        }
        features = new AboutInfo[tipsAndTricksFeatures.size()];
        tipsAndTricksFeatures.toArray(features);
        AboutInfo primaryFeature = ((Workbench)this.window.getWorkbench()).getConfigurationInfo().getAboutInfo();
        FeatureSelectionDialog d = new FeatureSelectionDialog(shell, features, primaryFeature, "TipsAndTricksPageSelectionDialog.title", "TipsAndTricksPageSelectionDialog.message", "org.eclipse.ui.tips_and_tricks_page_selection_dialog");
        if (d.open() != 0 || d.getResult().length != 1) {
            return;
        }
        AboutInfo feature = (AboutInfo)d.getResult()[0];
        if (feature != null) {
            final String href = feature.getTipsAndTricksHref();
            if (href != null) {
                BusyIndicator.showWhile((Display)shell.getDisplay(), (Runnable)new Runnable(){

                    public void run() {
                        IHelp helpSupport = WorkbenchHelp.getHelpSupport();
                        if (helpSupport != null) {
                            helpSupport.displayHelpResource(href);
                        }
                    }
                });
            } else {
                Status status = new Status(4, WorkbenchPlugin.PI_WORKBENCH, 1, WorkbenchMessages.getString("TipsAndTricksAction.hrefNotDefined"), null);
                ErrorDialog.openError((Shell)shell, (String)WorkbenchMessages.getString("TipsAndTricksErrorDialog.title"), (String)WorkbenchMessages.getString("TipsAndTricksErrorDialog.noHref"), (IStatus)status);
            }
        } else {
            Status status = new Status(4, WorkbenchPlugin.PI_WORKBENCH, 1, WorkbenchMessages.getString("TipsAndTricksAction.hrefNotDefined"), null);
            ErrorDialog.openError((Shell)shell, (String)WorkbenchMessages.getString("TipsAndTricksErrorDialog.title"), (String)WorkbenchMessages.getString("TipsAndTricksErrorDialog.noFeatures"), (IStatus)status);
        }
    }
}

