/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.WorkbenchMessages;

public class ResetPerspectiveAction
extends Action {
    private IWorkbenchWindow window;

    public ResetPerspectiveAction() {
        this(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
    }

    public ResetPerspectiveAction(IWorkbenchWindow window) {
        super(WorkbenchMessages.getString("ResetPerspective.text"));
        this.setToolTipText(WorkbenchMessages.getString("ResetPerspective.toolTip"));
        this.setEnabled(false);
        WorkbenchHelp.setHelp((IAction)this, "org.eclipse.ui.reset_perspective_action_context");
        this.window = window;
    }

    public void run() {
        IWorkbenchPage page = this.window.getActivePage();
        if (page != null && page.getPerspective() != null) {
            String message = WorkbenchMessages.format("ResetPerspective.message", new Object[]{page.getPerspective().getLabel()});
            String[] buttons = new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL};
            MessageDialog d = new MessageDialog(this.window.getShell(), WorkbenchMessages.getString("ResetPerspective.title"), null, message, 3, buttons, 0);
            if (d.open() == 0) {
                page.resetPerspective();
            }
        }
    }
}

