/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.actions.PartEventAction;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.AboutInfo;
import org.eclipse.ui.internal.FeatureSelectionDialog;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.WelcomeEditorInput;

public class QuickStartAction
extends PartEventAction {
    private static final String EDITOR_ID = "org.eclipse.ui.internal.dialogs.WelcomeEditor";
    private IWorkbenchWindow window;

    public QuickStartAction() {
        this(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
    }

    public QuickStartAction(IWorkbenchWindow window) {
        super(WorkbenchMessages.getString("QuickStart.text"));
        this.setToolTipText(WorkbenchMessages.getString("QuickStart.toolTip"));
        WorkbenchHelp.setHelp((IAction)this, "org.eclipse.ui.quick_start_action_context");
        this.setActionDefinitionId("org.eclipse.ui.help.quickStartAction");
        this.window = window;
    }

    public void run() {
        AboutInfo[] features = ((Workbench)this.window.getWorkbench()).getConfigurationInfo().getFeaturesInfo();
        ArrayList<AboutInfo> welcomeFeatures = new ArrayList<AboutInfo>();
        int i = 0;
        while (i < features.length) {
            if (features[i].getWelcomePageURL() != null) {
                welcomeFeatures.add(features[i]);
            }
            ++i;
        }
        if (this.window == null) {
            return;
        }
        Shell shell = this.window.getShell();
        if (welcomeFeatures.size() == 0) {
            MessageDialog.openInformation((Shell)shell, (String)WorkbenchMessages.getString("QuickStartMessageDialog.title"), (String)WorkbenchMessages.getString("QuickStartMessageDialog.message"));
            return;
        }
        features = new AboutInfo[welcomeFeatures.size()];
        welcomeFeatures.toArray(features);
        AboutInfo primaryFeature = ((Workbench)this.window.getWorkbench()).getConfigurationInfo().getAboutInfo();
        FeatureSelectionDialog d = new FeatureSelectionDialog(shell, features, primaryFeature, "WelcomePageSelectionDialog.title", "WelcomePageSelectionDialog.message", "org.eclipse.ui.welcome_page_selection_dialog");
        if (d.open() != 0 || d.getResult().length != 1) {
            return;
        }
        AboutInfo feature = (AboutInfo)d.getResult()[0];
        IWorkbenchPage page = null;
        String perspectiveId = feature.getWelcomePerspective();
        if (perspectiveId == null && ((page = this.window.getActivePage()) == null || page.getPerspective() == null)) {
            perspectiveId = WorkbenchPlugin.getDefault().getPerspectiveRegistry().getDefaultPerspective();
        }
        if (perspectiveId != null) {
            try {
                page = (WorkbenchPage)this.window.getWorkbench().showPerspective(perspectiveId, this.window);
            }
            catch (WorkbenchException workbenchException) {
                return;
            }
        }
        page.setEditorAreaVisible(true);
        WelcomeEditorInput input = new WelcomeEditorInput(feature);
        IEditorPart editor = page.findEditor(input);
        if (editor != null) {
            page.activate(editor);
            return;
        }
        try {
            page.openEditor(input, EDITOR_ID);
        }
        catch (PartInitException e) {
            Status status = new Status(4, WorkbenchPlugin.PI_WORKBENCH, 1, WorkbenchMessages.getString("QuickStartAction.openEditorException"), (Throwable)((Object)e));
            ErrorDialog.openError((Shell)this.window.getShell(), (String)WorkbenchMessages.getString("Workbench.openEditorErrorDialogTitle"), (String)WorkbenchMessages.getString("Workbench.openEditorErrorDialogMessage"), (IStatus)status);
        }
    }
}

