/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.action.AbstractGroupMarker;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.ActionDescriptor;
import org.eclipse.ui.internal.ActionSetActionBars;
import org.eclipse.ui.internal.ActionSetSeparator;
import org.eclipse.ui.internal.CoolBarContributionItem;
import org.eclipse.ui.internal.CoolBarManager;
import org.eclipse.ui.internal.CoolItemToolBarManager;
import org.eclipse.ui.internal.IActionSetContributionItem;
import org.eclipse.ui.internal.PluginAction;
import org.eclipse.ui.internal.PluginActionBuilder;
import org.eclipse.ui.internal.PluginActionCoolBarContributionItem;
import org.eclipse.ui.internal.PluginActionSet;
import org.eclipse.ui.internal.WWinPluginAction;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;

public class PluginActionSetBuilder
extends PluginActionBuilder {
    public static final String TAG_ACTION_SET = "actionSet";
    public static final String ATT_PULLDOWN = "pulldown";
    private PluginActionSet actionSet;
    private IWorkbenchWindow window;
    private ArrayList adjunctContributions = new ArrayList(0);

    protected ActionDescriptor createActionDescriptor(IConfigurationElement element) {
        String pulldown;
        boolean pullDownStyle = false;
        String style = element.getAttribute("style");
        pullDownStyle = style != null ? style.equals(ATT_PULLDOWN) : (pulldown = element.getAttribute(ATT_PULLDOWN)) != null && pulldown.equals("true");
        ActionDescriptor desc = null;
        desc = pullDownStyle ? new ActionDescriptor(element, 5, this.window) : new ActionDescriptor(element, 3, this.window);
        WWinPluginAction action = (WWinPluginAction)desc.getAction();
        action.setActionSetId(this.actionSet.getDesc().getId());
        this.actionSet.addPluginAction(action);
        return desc;
    }

    protected PluginActionBuilder.BasicContribution createContribution() {
        return new ActionSetContribution(this.actionSet.getDesc().getId(), this.window);
    }

    public static IContributionItem findInsertionPoint(String startId, String sortId, IContributionManager mgr, boolean startVsEnd) {
        IContributionItem[] items = mgr.getItems();
        int insertIndex = 0;
        while (insertIndex < items.length) {
            if (startId.equals(items[insertIndex].getId())) break;
            ++insertIndex;
        }
        if (insertIndex >= items.length) {
            return null;
        }
        int compareMetric = 0;
        if (startVsEnd) {
            compareMetric = 1;
        }
        int nX = insertIndex + 1;
        while (nX < items.length) {
            String testId;
            IContributionItem item = items[nX];
            if (item.isSeparator() || item.isGroupMarker() || !(item instanceof IActionSetContributionItem) || sortId != null && sortId.compareTo(testId = ((IActionSetContributionItem)item).getActionSetId()) < compareMetric) break;
            insertIndex = nX++;
        }
        return items[insertIndex];
    }

    static void processActionSets(ArrayList pluginActionSets, WorkbenchWindow window) {
        PluginActionSetBuilder[] builders = new PluginActionSetBuilder[pluginActionSets.size()];
        int i = 0;
        while (i < pluginActionSets.size()) {
            PluginActionSet set = (PluginActionSet)pluginActionSets.get(i);
            PluginActionSetBuilder builder = new PluginActionSetBuilder();
            builder.readActionExtensions(set, window);
            builders[i] = builder;
            ++i;
        }
        i = 0;
        while (i < builders.length) {
            PluginActionSetBuilder builder = builders[i];
            builder.processAdjunctContributions();
            ++i;
        }
    }

    protected void processAdjunctContributions() {
        int i = 0;
        while (i < this.adjunctContributions.size()) {
            ActionSetContribution contribution = (ActionSetContribution)this.adjunctContributions.get(i);
            ActionSetActionBars bars = this.actionSet.getBars();
            int j = 0;
            while (j < contribution.adjunctActions.size()) {
                ActionDescriptor adjunctAction = (ActionDescriptor)contribution.adjunctActions.get(j);
                contribution.contributeAdjunctCoolbarAction(adjunctAction, bars);
                ++j;
            }
            ++i;
        }
    }

    protected void readActionExtensions(PluginActionSet set, IWorkbenchWindow window) {
        this.actionSet = set;
        this.window = window;
        this.cache = null;
        this.currentContribution = null;
        this.targetID = null;
        this.targetContributionTag = TAG_ACTION_SET;
        this.readElements(new IConfigurationElement[]{set.getConfigElement()});
        if (this.cache != null) {
            int i = 0;
            while (i < this.cache.size()) {
                ActionSetContribution contribution = (ActionSetContribution)this.cache.get(i);
                contribution.contribute(this.actionSet.getBars(), true, true);
                if (contribution.isAdjunctContributor()) {
                    this.adjunctContributions.add(contribution);
                }
                ++i;
            }
        } else {
            WorkbenchPlugin.log("Action Set is empty: " + set.getDesc().getId());
        }
    }

    private static class ActionSetContribution
    extends PluginActionBuilder.BasicContribution {
        private String actionSetId;
        private WorkbenchWindow window;
        private ArrayList adjunctActions = new ArrayList(0);

        public ActionSetContribution(String id, IWorkbenchWindow window) {
            this.actionSetId = id;
            this.window = (WorkbenchWindow)window;
        }

        protected void addGroup(IContributionManager mgr, String name) {
            IContributionItem refItem = PluginActionSetBuilder.findInsertionPoint("additions", this.actionSetId, mgr, true);
            ActionSetSeparator group = new ActionSetSeparator(name, this.actionSetId);
            if (refItem == null) {
                mgr.add((IContributionItem)group);
            } else {
                mgr.insertAfter(refItem.getId(), (IContributionItem)group);
            }
        }

        public void contribute(IActionBars bars, boolean menuAppendIfMissing, boolean toolAppendIfMissing) {
            boolean isCoolBarContribution;
            IMenuManager menuMgr = bars.getMenuManager();
            IToolBarManager toolBarMgr = bars.getToolBarManager();
            if (this.menus != null && menuMgr != null) {
                int i = 0;
                while (i < this.menus.size()) {
                    IConfigurationElement menuElement = (IConfigurationElement)this.menus.get(i);
                    this.contributeMenu(menuElement, menuMgr, menuAppendIfMissing);
                    ++i;
                }
            }
            boolean bl = isCoolBarContribution = toolBarMgr != null && toolBarMgr instanceof CoolItemToolBarManager;
            if (this.actions != null) {
                int i = 0;
                while (i < this.actions.size()) {
                    ActionDescriptor ad = (ActionDescriptor)this.actions.get(i);
                    if (menuMgr != null) {
                        this.contributeMenuAction(ad, menuMgr, menuAppendIfMissing);
                    }
                    if (toolBarMgr != null) {
                        if (isCoolBarContribution) {
                            this.contributeCoolbarAction(ad, (ActionSetActionBars)bars);
                        } else {
                            this.contributeToolbarAction(ad, toolBarMgr, toolAppendIfMissing);
                        }
                    }
                    ++i;
                }
            }
        }

        protected void contributeAdjunctCoolbarAction(ActionDescriptor ad, ActionSetActionBars bars) {
            CoolItemToolBarManager activeManager;
            IContributionItem groupMarker;
            String toolBarId = ad.getToolbarId();
            String toolGroupId = ad.getToolbarGroupId();
            String contributingId = bars.getActionSetId();
            CoolBarManager coolBarMgr = ((CoolItemToolBarManager)bars.getToolBarManager()).getParentManager();
            PluginAction action = ad.getAction();
            PluginActionCoolBarContributionItem actionContribution = new PluginActionCoolBarContributionItem(action);
            bars.addAdjunctContribution((ContributionItem)actionContribution);
            CoolBarContributionItem cbItem = (CoolBarContributionItem)coolBarMgr.find(toolBarId);
            if (cbItem == null) {
                cbItem = new CoolBarContributionItem(coolBarMgr, toolBarId);
                cbItem.setVisible(true);
                IContributionItem refItem = this.findCoolItemInsertionPoint(toolBarId, coolBarMgr);
                if (refItem == null) {
                    coolBarMgr.add((IContributionItem)cbItem);
                } else {
                    coolBarMgr.insertAfter(refItem.getId(), (IContributionItem)cbItem);
                }
            }
            if ((groupMarker = (activeManager = cbItem.getToolBarManager()).find(toolGroupId)) == null) {
                activeManager.addAdjunctGroup(toolGroupId, contributingId);
            }
            activeManager.addAdjunctItemToGroup(toolGroupId, contributingId, (IContributionItem)actionContribution);
        }

        protected void contributeCoolbarAction(ActionDescriptor ad, ActionSetActionBars bars) {
            IContributionItem groupMarker;
            CoolItemToolBarManager activeManager;
            String toolBarId = ad.getToolbarId();
            String toolGroupId = ad.getToolbarGroupId();
            if (toolBarId == null && toolGroupId == null) {
                return;
            }
            String contributingId = bars.getActionSetId();
            CoolBarManager coolBarMgr = ((CoolItemToolBarManager)bars.getToolBarManager()).getParentManager();
            if (toolBarId == null || toolBarId.equals("Normal") || toolBarId.equals("")) {
                toolBarId = contributingId;
            }
            if (!toolBarId.equals(contributingId)) {
                if (!coolBarMgr.isValidCoolItemId(toolBarId, this.window)) {
                    toolBarId = contributingId;
                } else {
                    this.adjunctActions.add(ad);
                    return;
                }
            }
            PluginAction action = ad.getAction();
            PluginActionCoolBarContributionItem actionContribution = new PluginActionCoolBarContributionItem(action);
            CoolBarContributionItem cbItem = (CoolBarContributionItem)coolBarMgr.find(toolBarId);
            if (cbItem == null) {
                activeManager = (CoolItemToolBarManager)bars.getToolBarManager();
                cbItem = activeManager.getCoolBarItem();
                cbItem.setVisible(true);
                IContributionItem refItem = this.findCoolItemInsertionPoint(toolBarId, coolBarMgr);
                if (refItem == null) {
                    coolBarMgr.add((IContributionItem)cbItem);
                } else {
                    coolBarMgr.insertAfter(refItem.getId(), (IContributionItem)cbItem);
                }
            }
            if ((groupMarker = (activeManager = cbItem.getToolBarManager()).find(toolGroupId)) == null) {
                activeManager.addBaseGroup(toolGroupId, true);
            }
            activeManager.addBaseItemToGroup(toolGroupId, (IContributionItem)actionContribution);
        }

        protected void insertMenuGroup(IMenuManager menu, AbstractGroupMarker marker) {
            if (this.actionSetId != null) {
                IContributionItem[] items = menu.getItems();
                int i = 0;
                while (i < items.length) {
                    String testId;
                    IContributionItem item = items[i];
                    if ((item.isSeparator() || item.isGroupMarker()) && item instanceof IActionSetContributionItem && this.actionSetId.compareTo(testId = ((IActionSetContributionItem)item).getActionSetId()) < 0) {
                        menu.insertBefore(items[i].getId(), (IContributionItem)marker);
                        return;
                    }
                    ++i;
                }
            }
            menu.add((IContributionItem)marker);
        }

        public IContributionItem findCoolItemInsertionPoint(String sortId, CoolBarManager mgr) {
            IContributionItem[] items = mgr.getItems();
            String startId = "additions";
            int insertIndex = 0;
            while (insertIndex < items.length) {
                CoolBarContributionItem item = (CoolBarContributionItem)items[insertIndex];
                IContributionItem foundItem = item.getToolBarManager().find(startId);
                if (foundItem != null) break;
                ++insertIndex;
            }
            if (insertIndex >= items.length) {
                return null;
            }
            int i = insertIndex + 1;
            while (i < items.length) {
                CoolBarContributionItem item = (CoolBarContributionItem)items[i];
                String testId = item.getId();
                if (this.window != null && this.window.isWorkbenchCoolItemId(testId) || sortId != null && sortId.compareTo(testId) < 1) break;
                insertIndex = i++;
            }
            return items[insertIndex];
        }

        public boolean isAdjunctContributor() {
            return this.adjunctActions.size() > 0;
        }

        protected void insertAfter(IContributionManager mgr, String refId, IContributionItem item) {
            IContributionItem refItem = PluginActionSetBuilder.findInsertionPoint(refId, this.actionSetId, mgr, true);
            if (refItem != null) {
                mgr.insertAfter(refItem.getId(), item);
            } else {
                WorkbenchPlugin.log("Reference item " + refId + " not found for action " + item.getId());
            }
        }
    }
}

