/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.ActionDescriptor;
import org.eclipse.ui.internal.ActionExpression;
import org.eclipse.ui.internal.IObjectActionContributor;
import org.eclipse.ui.internal.ObjectFilterTest;
import org.eclipse.ui.internal.ObjectPluginAction;
import org.eclipse.ui.internal.PluginActionBuilder;
import org.eclipse.ui.internal.SelectionEnabler;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class ObjectActionContributor
extends PluginActionBuilder
implements IObjectActionContributor {
    private static final String ATT_NAME_FILTER = "nameFilter";
    private static final String ATT_ADAPTABLE = "adaptable";
    private static final String P_TRUE = "true";
    private IConfigurationElement config;
    private boolean configRead = false;
    private boolean adaptable = false;
    static /* synthetic */ Class class$0;

    public ObjectActionContributor(IConfigurationElement config) {
        this.config = config;
        this.adaptable = P_TRUE.equalsIgnoreCase(config.getAttribute(ATT_ADAPTABLE));
    }

    public boolean canAdapt() {
        return this.adaptable;
    }

    public void contributeObjectActionIdOverrides(List actionIdOverrides) {
        if (!this.configRead) {
            this.readConfigElement();
        }
        if (this.currentContribution.actions != null) {
            int i = 0;
            while (i < this.currentContribution.actions.size()) {
                ActionDescriptor ad = (ActionDescriptor)this.currentContribution.actions.get(i);
                String id = ad.getAction().getOverrideActionId();
                if (id != null) {
                    actionIdOverrides.add(id);
                }
                ++i;
            }
        }
    }

    public boolean contributeObjectActions(IWorkbenchPart part, IMenuManager menu, ISelectionProvider selProv, List actionIdOverrides) {
        if (!this.configRead) {
            this.readConfigElement();
        }
        if (this.currentContribution.actions == null) {
            return false;
        }
        ISelection sel = selProv.getSelection();
        if (sel == null || !(sel instanceof IStructuredSelection)) {
            return false;
        }
        IStructuredSelection selection = (IStructuredSelection)sel;
        int i = 0;
        while (i < this.currentContribution.actions.size()) {
            ActionDescriptor ad = (ActionDescriptor)this.currentContribution.actions.get(i);
            if (!actionIdOverrides.contains(ad.getId())) {
                this.currentContribution.contributeMenuAction(ad, menu, true);
                if (ad.getAction() instanceof ObjectPluginAction) {
                    ObjectPluginAction action = (ObjectPluginAction)ad.getAction();
                    action.setActivePart(part);
                    action.selectionChanged((ISelection)selection);
                }
            }
            ++i;
        }
        return true;
    }

    public boolean contributeObjectMenus(IMenuManager menu, ISelectionProvider selProv) {
        if (!this.configRead) {
            this.readConfigElement();
        }
        if (this.currentContribution.menus == null) {
            return false;
        }
        ISelection sel = selProv.getSelection();
        if (sel == null || !(sel instanceof IStructuredSelection)) {
            return false;
        }
        int i = 0;
        while (i < this.currentContribution.menus.size()) {
            IConfigurationElement menuElement = (IConfigurationElement)this.currentContribution.menus.get(i);
            this.currentContribution.contributeMenu(menuElement, menu, true);
            ++i;
        }
        return true;
    }

    protected ActionDescriptor createActionDescriptor(IConfigurationElement element) {
        return new ActionDescriptor(element, 1);
    }

    protected PluginActionBuilder.BasicContribution createContribution() {
        return new ObjectContribution();
    }

    public boolean isApplicableTo(Object object) {
        if (!this.configRead) {
            this.readConfigElement();
        }
        if (!this.testName(object)) {
            return false;
        }
        return ((ObjectContribution)this.currentContribution).isApplicableTo(object);
    }

    private void readConfigElement() {
        this.currentContribution = this.createContribution();
        this.readElementChildren(this.config);
        this.configRead = true;
    }

    protected boolean readElement(IConfigurationElement element) {
        String tag = element.getName();
        if (tag.equals("visibility")) {
            ((ObjectContribution)this.currentContribution).setVisibilityTest(element);
            return true;
        }
        if (tag.equals("filter")) {
            ((ObjectContribution)this.currentContribution).addFilterTest(element);
            return true;
        }
        return super.readElement(element);
    }

    private boolean testName(Object object) {
        String nameFilter = this.config.getAttribute(ATT_NAME_FILTER);
        if (nameFilter == null) {
            return true;
        }
        String objectName = null;
        if (object instanceof IAdaptable) {
            IWorkbenchAdapter de;
            IAdaptable element = (IAdaptable)object;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((de = (IWorkbenchAdapter)element.getAdapter((Class)clazz)) != null) {
                objectName = de.getLabel(element);
            }
        }
        if (objectName == null) {
            objectName = object.toString();
        }
        return SelectionEnabler.verifyNameMatch(objectName, nameFilter);
    }

    private static class ObjectContribution
    extends PluginActionBuilder.BasicContribution {
        private ObjectFilterTest filterTest;
        private ActionExpression visibilityTest;

        ObjectContribution() {
        }

        public void addFilterTest(IConfigurationElement element) {
            if (this.filterTest == null) {
                this.filterTest = new ObjectFilterTest();
            }
            this.filterTest.addFilterElement(element);
        }

        public void setVisibilityTest(IConfigurationElement element) {
            this.visibilityTest = new ActionExpression(element);
        }

        public boolean isApplicableTo(Object object) {
            if (this.visibilityTest != null) {
                return this.visibilityTest.isEnabledFor(object);
            }
            if (this.filterTest != null) {
                return this.filterTest.matches(object, true);
            }
            return true;
        }
    }
}

