/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.internal.ActionDescriptor;
import org.eclipse.ui.internal.EditorActionBuilder;
import org.eclipse.ui.internal.EditorSite;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.PluginAction;
import org.eclipse.ui.internal.commands.Manager;

final class KeyBindingService
implements IKeyBindingService {
    private SortedMap commandIdToActionMap = new TreeMap();
    private String[] scopes = new String[]{"org.eclipse.ui.globalScope"};

    KeyBindingService(PartSite partSite) {
        EditorActionBuilder.ExternalContributor contributor;
        if (partSite instanceof EditorSite && (contributor = (EditorActionBuilder.ExternalContributor)((EditorSite)partSite).getExtensionActionBarContributor()) != null) {
            this.registerExtendedActions(contributor.getExtendedActions());
        }
    }

    IAction getAction(String command) {
        return (IAction)this.commandIdToActionMap.get(command);
    }

    void registerExtendedActions(ActionDescriptor[] actionDescriptors) {
        if (actionDescriptors != null) {
            int i = 0;
            while (i < actionDescriptors.length) {
                PluginAction action;
                ActionDescriptor actionDescriptor = actionDescriptors[i];
                if (actionDescriptor != null && (action = actionDescriptors[i].getAction()) != null && action.getActionDefinitionId() != null) {
                    this.registerAction((IAction)action);
                }
                ++i;
            }
        }
    }

    public String[] getScopes() {
        return (String[])this.scopes.clone();
    }

    public void setScopes(String[] scopes) throws IllegalArgumentException {
        if (scopes == null || scopes.length < 1) {
            throw new IllegalArgumentException();
        }
        this.scopes = (String[])scopes.clone();
        int i = 0;
        while (i < scopes.length) {
            if (scopes[i] == null) {
                throw new IllegalArgumentException();
            }
            ++i;
        }
    }

    public void registerAction(IAction action) {
        String command = action.getActionDefinitionId();
        if (command != null) {
            this.commandIdToActionMap.put(command, action);
        }
    }

    public void unregisterAction(IAction action) {
        String command = action.getActionDefinitionId();
        if (command != null) {
            this.commandIdToActionMap.remove(command);
        }
    }

    public String getActiveAcceleratorConfigurationId() {
        return Manager.getInstance().getKeyMachine().getConfiguration();
    }

    public String getActiveAcceleratorScopeId() {
        return this.getScopes()[0];
    }

    public void setActiveAcceleratorScopeId(String scopeId) throws IllegalArgumentException {
        this.setScopes(new String[]{scopeId});
    }

    public boolean processKey(KeyEvent event) {
        return false;
    }

    public void enable(boolean enable) {
    }
}

