/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.boot.IPlatformRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.InternalErrorDialog;
import org.eclipse.ui.internal.misc.Policy;

class ExceptionHandler
implements Window.IExceptionHandler {
    private int exceptionCount = 0;
    private InternalErrorDialog dialog;
    private Shell defaultParent = new Shell();
    private boolean closing = false;
    private Workbench workbench;
    private static String MSG_UNHANDLED_EXCEPTION = WorkbenchMessages.getString("Unhandled_exception");
    private static String MSG_OutOfMemoryError = WorkbenchMessages.getString("FatalError_OutOfMemoryError");
    private static String MSG_StackOverflowError = WorkbenchMessages.getString("FatalError_StackOverflowError");
    private static String MSG_VirtualMachineError = WorkbenchMessages.getString("FatalError_VirtualMachineError");
    private static String MSG_SWTError = WorkbenchMessages.getString("FatalError_SWTError");
    private static String MSG_FATAL_ERROR = WorkbenchMessages.getString("FatalError");
    private static String MSG_FATAL_ERROR_Recursive = WorkbenchMessages.getString("FatalError_RecursiveError");
    private static String MSG_FATAL_ERROR_RecursiveTitle = WorkbenchMessages.getString("Internal_error");

    public ExceptionHandler(Workbench w) {
        this.workbench = w;
    }

    public void handleException(Throwable t) {
        try {
            ++this.exceptionCount;
            if (this.exceptionCount > 2) {
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw (Error)t;
            }
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            if (this.exceptionCount == 2) {
                if (this.closing) {
                    Object var5_2 = null;
                    --this.exceptionCount;
                    return;
                }
                this.log(t);
                Shell parent = this.defaultParent;
                if (this.dialog != null && this.dialog.getShell() != null && !this.dialog.getShell().isDisposed()) {
                    parent = this.dialog.getShell();
                }
                MessageBox box = new MessageBox(parent, 131265);
                box.setText(MSG_FATAL_ERROR_RecursiveTitle);
                box.setMessage(String.valueOf(MSG_FATAL_ERROR_Recursive) + MSG_FATAL_ERROR);
                int result = box.open();
                if (result == 64 && !this.closing) {
                    this.closeWorkbench();
                }
            } else {
                this.log(t);
                if (this.openQuestionDialog(t) && !this.closing) {
                    this.closeWorkbench();
                }
            }
        }
        catch (Throwable throwable) {
            Object var5_3 = null;
            --this.exceptionCount;
            throw throwable;
        }
        Object var5_4 = null;
        --this.exceptionCount;
    }

    private void closeWorkbench() {
        try {
            this.closing = true;
            if (this.dialog != null && this.dialog.getShell() != null && !this.dialog.getShell().isDisposed()) {
                this.dialog.close();
            }
            this.workbench.close(IPlatformRunnable.EXIT_OK, true);
        }
        catch (RuntimeException th) {
            System.err.println("Another fatal error happened while closing the workbench.");
            th.printStackTrace();
            throw th;
        }
        catch (Error th) {
            System.err.println("Another fatal error happened while closing the workbench.");
            th.printStackTrace();
            throw th;
        }
    }

    private void log(Throwable t) {
        try {
            String msg = t.getMessage() == null ? t.toString() : t.getMessage();
            WorkbenchPlugin.log(MSG_UNHANDLED_EXCEPTION, (IStatus)new Status(4, "org.eclipse.ui", 0, msg, t));
            Throwable nested = null;
            if (t instanceof SWTException) {
                nested = ((SWTException)t).throwable;
            } else if (t instanceof SWTError) {
                nested = ((SWTError)t).throwable;
            }
            if (nested != null) {
                msg = nested.getMessage() == null ? nested.toString() : nested.getMessage();
                WorkbenchPlugin.log("\n*** Stack trace of contained exception ***", (IStatus)new Status(4, "org.eclipse.ui", 0, msg, nested));
            }
            if (WorkbenchPlugin.DEBUG) {
                t.printStackTrace();
            }
        }
        catch (Throwable th) {
            System.err.println("A fatal error happened while logging a fatal error.");
            t.printStackTrace();
            System.err.println("New exception.");
            th.printStackTrace();
        }
    }

    private boolean openQuestionDialog(Throwable internalError) {
        try {
            String msg = null;
            if (internalError instanceof OutOfMemoryError) {
                msg = MSG_OutOfMemoryError;
            } else if (internalError instanceof StackOverflowError) {
                msg = MSG_StackOverflowError;
            } else if (internalError instanceof VirtualMachineError) {
                msg = MSG_VirtualMachineError;
            } else if (internalError instanceof SWTError) {
                msg = MSG_SWTError;
            } else {
                msg = internalError.getMessage() == null ? WorkbenchMessages.getString("InternalErrorNoArg") : WorkbenchMessages.format("InternalErrorOneArg", new Object[]{internalError.getMessage()});
                if (Policy.DEBUG_OPEN_ERROR_DIALOG) {
                    return this.openQuestion(null, WorkbenchMessages.getString("Internal_error"), msg, internalError, 1);
                }
                return false;
            }
            Throwable detail = internalError;
            if (!Policy.DEBUG_OPEN_ERROR_DIALOG) {
                detail = null;
            }
            return InternalErrorDialog.openQuestion(null, WorkbenchMessages.getString("Internal_error"), String.valueOf(msg) + MSG_FATAL_ERROR, detail, 1);
        }
        catch (Throwable th) {
            System.err.println("A fatal error happened while informing the user about a fatal error.");
            internalError.printStackTrace();
            System.err.println("New exception.");
            th.printStackTrace();
            return true;
        }
    }

    private boolean openQuestion(Shell parent, String title, String message, Throwable detail, int defaultIndex) {
        String[] labels = detail == null ? new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL} : new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.SHOW_DETAILS_LABEL};
        this.dialog = new InternalErrorDialog(parent, title, null, message, detail, 3, labels, defaultIndex);
        if (detail != null) {
            this.dialog.setDetailButton(2);
        }
        boolean result = this.dialog.open() == 0;
        this.dialog = null;
        return result;
    }
}

