/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.AbstractCollection;
import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.internal.EditorArea;
import org.eclipse.ui.internal.EditorPane;
import org.eclipse.ui.internal.EditorSite;
import org.eclipse.ui.internal.EditorWorkbook;
import org.eclipse.ui.internal.ILayoutContainer;
import org.eclipse.ui.internal.IPartDropListener;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.MultiEditorInnerPane;
import org.eclipse.ui.internal.MultiEditorOuterPane;
import org.eclipse.ui.internal.PartDropEvent;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.part.MultiEditor;

public class EditorPresentation {
    private WorkbenchPage page;
    private ArrayList editorTable = new ArrayList(4);
    private EditorArea editorArea;

    public EditorPresentation(WorkbenchPage page) {
        IPartDropListener partDropListener = new IPartDropListener(){

            public void dragOver(PartDropEvent e) {
                EditorPresentation.this.onPartDragOver(e);
            }

            public void drop(PartDropEvent e) {
                EditorPresentation.this.onPartDrop(e);
            }
        };
        this.page = page;
        this.editorArea = new EditorArea("org.eclipse.ui.editorss", partDropListener, page);
    }

    public void closeAllEditors() {
        this.editorArea.removeAllEditors();
        ArrayList editorsToDispose = (ArrayList)this.editorTable.clone();
        this.editorTable.clear();
        int i = 0;
        while (i < editorsToDispose.size()) {
            ((EditorPane)editorsToDispose.get(i)).dispose();
            ++i;
        }
    }

    public void closeEditor(IEditorReference ref) {
        EditorPane pane = (EditorPane)((WorkbenchPartReference)((Object)ref)).getPane();
        this.closeEditor(pane);
    }

    public void closeEditor(IEditorPart part) {
        EditorPane pane = (EditorPane)((PartSite)((Object)part.getEditorSite())).getPane();
        this.closeEditor(pane);
    }

    private void closeEditor(EditorPane pane) {
        if (pane != null) {
            if (!(pane instanceof MultiEditorInnerPane)) {
                this.editorArea.removeEditor(pane);
            }
            ((AbstractCollection)this.editorTable).remove(pane);
            pane.dispose();
        }
    }

    private void derefPart(LayoutPart part) {
        LayoutPart parent;
        ILayoutContainer parentContainer;
        ILayoutContainer oldContainer = part.getContainer();
        part.reparent(this.editorArea.getParent());
        if (oldContainer == null) {
            return;
        }
        oldContainer.remove(part);
        LayoutPart[] children = oldContainer.getChildren();
        if ((children == null || children.length == 0) && oldContainer instanceof LayoutPart && (parentContainer = (parent = (LayoutPart)((Object)oldContainer)).getContainer()) != null) {
            parentContainer.remove(parent);
            parent.dispose();
        }
    }

    public void dispose() {
        if (this.editorArea != null) {
            this.editorArea.dispose();
        }
    }

    public String getActiveEditorWorkbookID() {
        return this.editorArea.getActiveWorkbookID();
    }

    public IEditorReference[] getEditors() {
        int nSize = this.editorTable.size();
        IEditorReference[] retArray = new IEditorReference[nSize];
        int i = 0;
        while (i < retArray.length) {
            retArray[i] = ((EditorPane)this.editorTable.get(i)).getEditorReference();
            ++i;
        }
        return retArray;
    }

    public LayoutPart getLayoutPart() {
        return this.editorArea;
    }

    public IEditorReference getVisibleEditor() {
        EditorWorkbook activeWorkbook = this.editorArea.getActiveWorkbook();
        EditorPane pane = activeWorkbook.getVisibleEditor();
        if (pane != null) {
            IEditorReference result = pane.getEditorReference();
            IEditorPart editorPart = (IEditorPart)result.getPart(false);
            if (editorPart != null && editorPart instanceof MultiEditor) {
                editorPart = ((MultiEditor)editorPart).getActiveEditor();
                EditorSite site = (EditorSite)editorPart.getSite();
                result = (IEditorReference)site.getPane().getPartReference();
            }
            return result;
        }
        return null;
    }

    public void fixVisibleEditor() {
        IEditorReference result;
        IEditorPart editorPart;
        LayoutPart[] editors;
        EditorWorkbook activeWorkbook = this.editorArea.getActiveWorkbook();
        EditorPane pane = activeWorkbook.getVisibleEditor();
        if (pane == null && (editors = activeWorkbook.getChildren()).length > 0) {
            pane = (EditorPane)editors[0];
        }
        if (pane != null && (editorPart = (IEditorPart)(result = pane.getEditorReference()).getPart(true)) != null) {
            activeWorkbook.setVisibleEditor(pane);
        }
    }

    public void moveEditor(IEditorPart part, int position) {
        EditorPane pane = (EditorPane)((EditorSite)part.getSite()).getPane();
        pane.getWorkbook().reorderTab(pane, position);
    }

    private void movePart(LayoutPart part, int position, EditorWorkbook relativePart) {
        EditorArea sashContainer = relativePart.getEditorArea();
        if (sashContainer == null) {
            return;
        }
        this.derefPart(part);
        int relativePosition = 1;
        if (position == 2) {
            relativePosition = 2;
        } else if (position == 3) {
            relativePosition = 3;
        } else if (position == 4) {
            relativePosition = 4;
        }
        if (part instanceof EditorWorkbook) {
            sashContainer.add(part, relativePosition, 0.5f, relativePart);
            ((EditorWorkbook)part).becomeActiveWorkbook(true);
        } else {
            EditorWorkbook newWorkbook = new EditorWorkbook(this.editorArea);
            sashContainer.add(newWorkbook, relativePosition, 0.5f, relativePart);
            newWorkbook.add(part);
            newWorkbook.becomeActiveWorkbook(true);
        }
    }

    private void onPartDragOver(PartDropEvent e) {
        if (e.dragSource != null && e.dropTarget != null && e.dragSource.getWorkbenchWindow() != e.dropTarget.getWorkbenchWindow()) {
            e.relativePosition = 0;
            return;
        }
        if (e.relativePosition == 6) {
            e.relativePosition = 0;
            return;
        }
        if (!(e.dropTarget instanceof EditorWorkbook)) {
            e.relativePosition = 0;
            return;
        }
        if (e.dragSource instanceof EditorPane) {
            EditorWorkbook sourceWorkbook = ((EditorPane)e.dragSource).getWorkbook();
            if (sourceWorkbook == e.dropTarget && sourceWorkbook.getItemCount() == 1) {
                e.relativePosition = 0;
                return;
            }
            EditorWorkbook targetWorkbook = (EditorWorkbook)e.dropTarget;
            if (sourceWorkbook.getEditorArea() != targetWorkbook.getEditorArea()) {
                e.relativePosition = 0;
                return;
            }
            return;
        }
        if (e.dragSource instanceof EditorWorkbook) {
            if (e.dragSource == e.dropTarget) {
                e.relativePosition = 0;
                return;
            }
            EditorWorkbook sourceWorkbook = (EditorWorkbook)e.dragSource;
            EditorWorkbook targetWorkbook = (EditorWorkbook)e.dropTarget;
            if (sourceWorkbook.getEditorArea() != targetWorkbook.getEditorArea()) {
                e.relativePosition = 0;
                return;
            }
            return;
        }
        e.relativePosition = 0;
    }

    private void onPartDrop(PartDropEvent e) {
        switch (e.relativePosition) {
            case 6: {
                break;
            }
            case 5: {
                EditorWorkbook sourceWorkbook;
                if (e.dragSource instanceof EditorPane && (sourceWorkbook = ((EditorPane)e.dragSource).getWorkbook()) == e.dropTarget) {
                    sourceWorkbook.reorderTab((EditorPane)e.dragSource, e.cursorX, e.cursorY);
                    break;
                }
                this.stack(e.dragSource, (EditorWorkbook)e.dropTarget);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                if (this.page.isZoomed()) {
                    this.page.zoomOut();
                }
                this.movePart(e.dragSource, e.relativePosition, (EditorWorkbook)e.dropTarget);
            }
        }
    }

    public void openEditor(IEditorReference ref, IEditorReference[] innerEditors, boolean setVisible) {
        MultiEditorOuterPane pane = new MultiEditorOuterPane(ref, this.page, this.editorArea.getActiveWorkbook());
        this.initPane(pane, ref);
        int i = 0;
        while (i < innerEditors.length) {
            MultiEditorInnerPane innerPane = new MultiEditorInnerPane(pane, innerEditors[i], this.page, this.editorArea.getActiveWorkbook());
            this.initPane(innerPane, innerEditors[i]);
            ++i;
        }
        this.editorArea.addEditor(pane);
        if (setVisible) {
            this.setVisibleEditor(ref, true);
        }
    }

    public void openEditor(IEditorReference ref, boolean setVisible) {
        EditorPane pane = new EditorPane(ref, this.page, this.editorArea.getActiveWorkbook());
        this.initPane(pane, ref);
        this.editorArea.addEditor(pane);
        if (setVisible) {
            this.setVisibleEditor(ref, true);
        }
    }

    private EditorPane initPane(EditorPane pane, IEditorReference ref) {
        ((WorkbenchPartReference)((Object)ref)).setPane(pane);
        this.editorTable.add(pane);
        return pane;
    }

    public IStatus restoreState(IMemento memento) {
        return this.editorArea.restoreState(memento);
    }

    public IStatus saveState(IMemento memento) {
        return this.editorArea.saveState(memento);
    }

    public void setActiveEditorWorkbookFromID(String id) {
        this.editorArea.setActiveWorkbookFromID(id);
    }

    public void showVisibleEditor() {
        EditorWorkbook activeWorkbook = this.editorArea.getActiveWorkbook();
        if (activeWorkbook != null) {
            activeWorkbook.showVisibleEditor();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setVisibleEditor(IEditorReference ref, boolean setFocus) {
        IEditorReference visibleEditor = this.getVisibleEditor();
        if (ref == visibleEditor) return false;
        IEditorPart part = (IEditorPart)ref.getPart(true);
        EditorPane pane = null;
        if (part != null) {
            pane = (EditorPane)((PartSite)((Object)part.getEditorSite())).getPane();
        }
        if (pane == null) return false;
        if (pane instanceof MultiEditorInnerPane) {
            EditorPane parentPane = ((MultiEditorInnerPane)pane).getParentPane();
            EditorWorkbook activeWorkbook = parentPane.getWorkbook();
            EditorPane activePane = activeWorkbook.getVisibleEditor();
            if (activePane == parentPane) return false;
            parentPane.getWorkbook().setVisibleEditor(parentPane);
        } else {
            pane.getWorkbook().setVisibleEditor(pane);
        }
        if (!setFocus) return true;
        part.setFocus();
        return true;
    }

    private void stack(LayoutPart newPart, EditorWorkbook refPart) {
        this.editorArea.getControl().setRedraw(false);
        if (newPart instanceof EditorWorkbook) {
            EditorPane visibleEditor = ((EditorWorkbook)newPart).getVisibleEditor();
            LayoutPart[] children = ((EditorWorkbook)newPart).getChildren();
            int i = 0;
            while (i < children.length) {
                this.stackEditor((EditorPane)children[i], refPart);
                ++i;
            }
            if (visibleEditor != null) {
                visibleEditor.setFocus();
                refPart.becomeActiveWorkbook(true);
                refPart.setVisibleEditor(visibleEditor);
            }
        } else {
            this.stackEditor((EditorPane)newPart, refPart);
            newPart.setFocus();
            refPart.becomeActiveWorkbook(true);
            refPart.setVisibleEditor((EditorPane)newPart);
        }
        this.editorArea.getControl().setRedraw(true);
    }

    private void stackEditor(EditorPane newPart, EditorWorkbook refPart) {
        this.derefPart(newPart);
        newPart.reparent(refPart.getParent());
        refPart.add(newPart);
    }

    public ArrayList getWorkbooks() {
        return this.editorArea.getEditorWorkbooks();
    }

    public void openEditorList() {
        this.editorArea.getActiveWorkbook().openEditorList();
    }
}

