/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManagerOverrides;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.SubMenuManager;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.action.SubToolBarManager;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.SubActionBars;
import org.eclipse.ui.actions.RetargetAction;
import org.eclipse.ui.internal.CoolBarManager;
import org.eclipse.ui.internal.CoolItemMultiToolBarManager;
import org.eclipse.ui.internal.EditorMenuManager;

public class EditorActionBars
extends SubActionBars {
    private String type;
    private int refCount;
    private IEditorActionBarContributor editorContributor;
    private IEditorActionBarContributor extensionContributor;
    private CoolItemMultiToolBarManager coolItemToolBarMgr;
    private boolean enabledAllowed = true;

    public EditorActionBars(IActionBars parent, String type) {
        super(parent);
        this.type = type;
    }

    public void activate(boolean forceVisibility) {
        this.setActive(true, forceVisibility);
    }

    public void addRef() {
        ++this.refCount;
    }

    protected SubMenuManager createSubMenuManager(IMenuManager parent) {
        return new EditorMenuManager(parent);
    }

    protected SubToolBarManager createSubToolBarManager(IToolBarManager parent) {
        return null;
    }

    public void deactivate(boolean forceVisibility) {
        this.setActive(false, forceVisibility);
    }

    public void dispose() {
        super.dispose();
        if (this.editorContributor != null) {
            this.editorContributor.dispose();
        }
        if (this.extensionContributor != null) {
            this.extensionContributor.dispose();
        }
        if (this.coolItemToolBarMgr != null) {
            this.coolItemToolBarMgr.removeAll();
        }
    }

    public IEditorActionBarContributor getEditorContributor() {
        return this.editorContributor;
    }

    public IEditorActionBarContributor getExtensionContributor() {
        return this.extensionContributor;
    }

    public String getEditorType() {
        return this.type;
    }

    public IToolBarManager getToolBarManager() {
        IToolBarManager parentMgr = this.getParent().getToolBarManager();
        if (parentMgr == null) {
            return null;
        }
        if (this.coolItemToolBarMgr == null) {
            CoolBarManager cBarMgr = (CoolBarManager)parentMgr;
            this.coolItemToolBarMgr = new CoolItemMultiToolBarManager(cBarMgr, this.type, this.getActive());
            this.coolItemToolBarMgr.setParentMgr(cBarMgr);
            this.coolItemToolBarMgr.setOverrides(new Overrides());
        }
        return this.coolItemToolBarMgr;
    }

    public int getRef() {
        return this.refCount;
    }

    private boolean isVisible() {
        if (this.coolItemToolBarMgr != null) {
            return this.coolItemToolBarMgr.isVisible();
        }
        return false;
    }

    public void partChanged(IWorkbenchPart part) {
        super.partChanged(part);
        if (part instanceof IEditorPart) {
            IEditorPart editor = (IEditorPart)part;
            if (this.editorContributor != null) {
                this.editorContributor.setActiveEditor(editor);
            }
            if (this.extensionContributor != null) {
                this.extensionContributor.setActiveEditor(editor);
            }
        }
    }

    public void removeRef() {
        --this.refCount;
    }

    private void setActive(boolean set, boolean forceVisibility) {
        this.basicSetActive(set);
        if (this.isSubMenuManagerCreated()) {
            ((EditorMenuManager)this.getMenuManager()).setVisible(set, forceVisibility);
        }
        if (this.isSubStatusLineManagerCreated()) {
            ((SubStatusLineManager)this.getStatusLineManager()).setVisible(set);
        }
        this.setVisible(set, forceVisibility);
    }

    public void setEditorContributor(IEditorActionBarContributor c) {
        this.editorContributor = c;
    }

    public void setExtensionContributor(IEditorActionBarContributor c) {
        this.extensionContributor = c;
    }

    private void setVisible(boolean visible) {
        if (this.coolItemToolBarMgr != null) {
            this.coolItemToolBarMgr.setVisible(visible);
        }
    }

    private void setVisible(boolean visible, boolean forceVisibility) {
        if (visible) {
            if (forceVisibility) {
                if (!this.enabledAllowed) {
                    this.setEnabledAllowed(true);
                }
            } else if (this.enabledAllowed) {
                this.setEnabledAllowed(false);
            }
            if (!this.isVisible()) {
                this.setVisible(true);
            }
        } else if (forceVisibility) {
            this.setVisible(false);
        } else {
            this.setEnabledAllowed(false);
        }
        if (this.coolItemToolBarMgr != null) {
            this.coolItemToolBarMgr.setVisible(visible, forceVisibility);
        }
    }

    private void setEnabledAllowed(boolean enabledAllowed) {
        if (this.enabledAllowed == enabledAllowed) {
            return;
        }
        this.enabledAllowed = enabledAllowed;
        if (this.coolItemToolBarMgr != null) {
            IContributionItem[] items = this.coolItemToolBarMgr.getItems();
            int i = 0;
            while (i < items.length) {
                IContributionItem item = items[i];
                item.update("enabled");
                ++i;
            }
        }
    }

    private class Overrides
    implements IContributionManagerOverrides {
        Overrides() {
        }

        public Boolean getEnabled(IContributionItem item) {
            if (item instanceof ActionContributionItem && ((ActionContributionItem)item).getAction() instanceof RetargetAction || EditorActionBars.this.enabledAllowed) {
                return null;
            }
            return Boolean.FALSE;
        }

        public Integer getAccelerator(IContributionItem item) {
            return null;
        }

        public String getAcceleratorText(IContributionItem item) {
            return null;
        }

        public String getText(IContributionItem item) {
            return null;
        }
    }
}

