/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.internal.CoolBarContributionItem;
import org.eclipse.ui.internal.CoolItemPosition;

public class CoolBarLayout {
    public Point[] itemSizes = new Point[0];
    public int[] itemWrapIndices = new int[0];
    ArrayList items = new ArrayList(0);
    ArrayList rememberedPositions = new ArrayList();

    public CoolBarLayout() {
    }

    public CoolBarLayout(CoolBar coolBar) {
        this();
        this.initialize(coolBar);
    }

    void initialize(CoolBar coolBar) {
        int i;
        CoolItem[] coolItems = coolBar.getItems();
        ArrayList<String> newItems = new ArrayList<String>(coolItems.length);
        int i2 = 0;
        while (i2 < coolItems.length) {
            CoolBarContributionItem item = (CoolBarContributionItem)((Object)coolItems[i2].getData());
            if (item != null) {
                newItems.add(item.getId());
            }
            ++i2;
        }
        this.items = newItems;
        this.itemSizes = coolBar.getItemSizes();
        this.itemWrapIndices = this.getAdjustedWrapIndices(coolBar.getWrapIndices());
        int count = coolBar.getItemCount();
        int[] lastIndices = coolBar.getWrapIndices();
        int n = lastIndices.length;
        if (n == 0) {
            lastIndices = count == 0 ? new int[]{} : new int[]{count - 1};
        } else {
            i = 0;
            while (i < n - 1) {
                lastIndices[i] = lastIndices[i + 1] - 1;
                ++i;
            }
            lastIndices[n - 1] = count - 1;
        }
        i = 0;
        while (i < lastIndices.length) {
            int lastIndex = lastIndices[i];
            if (lastIndex >= 0 && lastIndex < coolItems.length) {
                CoolItem lastItem = coolItems[lastIndex];
                this.itemSizes[lastIndex] = lastItem.getPreferredSize();
            }
            ++i;
        }
    }

    public CoolBarLayout(ArrayList items, int[] itemWrapIndices, Point[] itemSizes, ArrayList rememberedPositions) {
        this.items = items;
        this.itemWrapIndices = itemWrapIndices;
        this.itemSizes = itemSizes;
        this.rememberedPositions = rememberedPositions;
    }

    int[] wrapsForNewItem(int rowIndex, int itemIndex) {
        int[] newWraps = null;
        int rowStartIndex = this.getStartIndexOfRow(rowIndex);
        if (itemIndex == rowStartIndex) {
            newWraps = new int[this.itemWrapIndices.length];
            System.arraycopy(this.itemWrapIndices, 0, newWraps, 0, this.itemWrapIndices.length);
            newWraps[rowIndex] = itemIndex;
            int i = rowIndex + 1;
            while (i < newWraps.length) {
                int n = i++;
                newWraps[n] = newWraps[n] + 1;
            }
        }
        return newWraps;
    }

    int[] wrapsForNewRow(int rowIndex, int itemIndex) {
        int[] newWraps = new int[this.itemWrapIndices.length + 1];
        int j = 0;
        while (j < rowIndex) {
            newWraps[j] = this.itemWrapIndices[j];
            ++j;
        }
        newWraps[rowIndex] = itemIndex;
        j = rowIndex;
        while (j < this.itemWrapIndices.length) {
            newWraps[j + 1] = this.itemWrapIndices[j] + 1;
            ++j;
        }
        return newWraps;
    }

    private int[] getAdjustedWrapIndices(int[] wraps) {
        int[] adjustedWrapIndices;
        if (wraps.length == 0) {
            adjustedWrapIndices = new int[1];
        } else if (wraps[0] != 0) {
            adjustedWrapIndices = new int[wraps.length + 1];
            adjustedWrapIndices[0] = 0;
            int i = 0;
            while (i < wraps.length) {
                adjustedWrapIndices[i + 1] = wraps[i];
                ++i;
            }
        } else {
            adjustedWrapIndices = wraps;
        }
        return adjustedWrapIndices;
    }

    int getNumberOfRows() {
        return this.itemWrapIndices.length;
    }

    int getRowOfIndex(int index) {
        int row = -1;
        row = 0;
        while (row < this.itemWrapIndices.length) {
            if (this.itemWrapIndices[row] > index) break;
            ++row;
        }
        if (row > 0) {
            --row;
        }
        return row;
    }

    int getStartIndexOfRow(int rowIndex) {
        if (rowIndex > this.itemWrapIndices.length - 1) {
            return -1;
        }
        return this.itemWrapIndices[rowIndex];
    }

    boolean isOnRowAlone(int itemIndex) {
        int row = this.getRowOfIndex(itemIndex);
        int rowStart = this.getStartIndexOfRow(row);
        int nextRowStart = this.getStartIndexOfRow(row + 1);
        if (nextRowStart == -1) {
            nextRowStart = rowStart;
        }
        return rowStart == itemIndex && nextRowStart - rowStart <= 1;
    }

    boolean isDerivativeOf(CoolBarLayout otherLayout) {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        int i = 0;
        while (i < this.items.size()) {
            String itemId = (String)this.items.get(i);
            int index = otherLayout.items.indexOf(itemId);
            if (index != -1) {
                indexes.add(new Integer(index));
            }
            ++i;
        }
        int previous = -1;
        int i2 = 0;
        while (i2 < indexes.size()) {
            int value = (Integer)indexes.get(i2);
            if (value <= previous) {
                return false;
            }
            previous = value;
            ++i2;
        }
        return true;
    }

    public boolean restoreState(IMemento memento) {
        Integer newLayout = memento.getInteger("actionSet");
        if (newLayout == null) {
            return false;
        }
        IMemento[] sizes = memento.getChildren("itemSize");
        if (sizes == null) {
            return false;
        }
        this.itemSizes = new Point[sizes.length];
        int i = 0;
        while (i < sizes.length) {
            IMemento sizeMem = sizes[i];
            Integer x = sizeMem.getInteger("x");
            if (x == null) {
                return false;
            }
            Integer y = sizeMem.getInteger("y");
            if (y == null) {
                return false;
            }
            this.itemSizes[i] = new Point(x.intValue(), y.intValue());
            ++i;
        }
        IMemento[] wraps = memento.getChildren("wrapIndex");
        if (wraps == null) {
            return false;
        }
        this.itemWrapIndices = new int[wraps.length];
        int i2 = 0;
        while (i2 < wraps.length) {
            IMemento wrapMem = wraps[i2];
            Integer index = wrapMem.getInteger("index");
            if (index == null) {
                return false;
            }
            this.itemWrapIndices[i2] = index;
            ++i2;
        }
        IMemento[] savedItems = memento.getChildren("item");
        if (savedItems == null) {
            return false;
        }
        this.items = new ArrayList(savedItems.length);
        int i3 = 0;
        while (i3 < savedItems.length) {
            IMemento savedMem = savedItems[i3];
            String id = savedMem.getString("id");
            if (id == null) {
                return false;
            }
            this.items.add(id);
            ++i3;
        }
        IMemento[] savedPositions = memento.getChildren("position");
        this.rememberedPositions = new ArrayList(savedPositions.length);
        int i4 = 0;
        while (i4 < savedPositions.length) {
            CoolItemPosition position = new CoolItemPosition();
            IMemento savedPos = savedPositions[i4];
            position.id = savedPos.getString("id");
            if (position.id == null) {
                return false;
            }
            Integer pos = savedPos.getInteger("added");
            if (pos == null) {
                return false;
            }
            int added = pos;
            position.added = added == 1;
            position.layout = new CoolBarLayout();
            IMemento layoutMemento = savedPos.getChild("layout");
            if (layoutMemento == null) {
                return false;
            }
            position.layout.restoreState(layoutMemento);
            this.rememberedPositions.add(position);
            ++i4;
        }
        return true;
    }

    public IStatus saveState(IMemento memento) {
        IMemento child;
        memento.putInteger("actionSet", 1);
        int i = 0;
        while (i < this.itemSizes.length) {
            child = memento.createChild("itemSize");
            Point pt = this.itemSizes[i];
            child.putInteger("x", pt.x);
            child.putInteger("y", pt.y);
            ++i;
        }
        i = 0;
        while (i < this.itemWrapIndices.length) {
            child = memento.createChild("wrapIndex");
            child.putInteger("index", this.itemWrapIndices[i]);
            ++i;
        }
        Iterator iter = ((AbstractList)this.items).iterator();
        while (iter.hasNext()) {
            child = memento.createChild("item");
            String item = (String)iter.next();
            child.putString("id", item);
        }
        iter = ((AbstractList)this.rememberedPositions).iterator();
        while (iter.hasNext()) {
            child = memento.createChild("position");
            CoolItemPosition position = (CoolItemPosition)iter.next();
            child.putString("id", position.id);
            int value = 0;
            if (position.added) {
                value = 1;
            }
            child.putInteger("added", value);
            IMemento layout = child.createChild("layout");
            position.layout.saveState(layout);
        }
        return new Status(0, "org.eclipse.ui", 0, "", null);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(20);
        buffer.append("items ");
        int i = 0;
        while (i < this.items.size()) {
            String item = (String)this.items.get(i);
            buffer.append(String.valueOf(item) + " ");
            ++i;
        }
        buffer.append('\n');
        buffer.append("item wrap indices ");
        i = 0;
        while (i < this.itemWrapIndices.length) {
            buffer.append(String.valueOf(this.itemWrapIndices[i]) + " ");
            ++i;
        }
        buffer.append('\n');
        buffer.append("item sizes ");
        i = 0;
        while (i < this.itemSizes.length) {
            buffer.append(this.itemSizes[i] + " ");
            ++i;
        }
        buffer.append('\n');
        return buffer.toString();
    }
}

