/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.actions.PerspectiveMenu;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class ChangeToPerspectiveMenu
extends PerspectiveMenu {
    public ChangeToPerspectiveMenu(IWorkbenchWindow window) {
        super(window, "ChangeToPerspectiveMenu");
        this.showActive(true);
    }

    protected void run(IPerspectiveDescriptor desc) {
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        int mode = store.getInt("OPEN_PERSPECTIVE_MODE");
        IWorkbenchPage page = this.getWindow().getActivePage();
        IPerspectiveDescriptor persp = null;
        if (page != null) {
            persp = page.getPerspective();
        }
        if (2 == mode && persp != null) {
            try {
                IWorkspaceRoot input = WorkbenchPlugin.getPluginWorkspace().getRoot();
                IWorkbench workbench = this.getWindow().getWorkbench();
                workbench.openWorkbenchWindow(desc.getId(), (IAdaptable)input);
            }
            catch (WorkbenchException e) {
                this.handleWorkbenchException(e);
            }
        } else if (page != null) {
            page.setPerspective(desc);
        } else {
            try {
                IWorkspaceRoot input = WorkbenchPlugin.getPluginWorkspace().getRoot();
                this.getWindow().openPage(desc.getId(), (IAdaptable)input);
            }
            catch (WorkbenchException e) {
                this.handleWorkbenchException(e);
            }
        }
    }

    private void handleWorkbenchException(WorkbenchException e) {
        ErrorDialog.openError((Shell)this.getWindow().getShell(), (String)WorkbenchMessages.getString("ChangeToPerspectiveMenu.errorTitle"), (String)((Throwable)((Object)e)).getMessage(), (IStatus)e.getStatus());
    }
}

