/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.SubActionBars;
import org.eclipse.ui.internal.ActionSetActionBars;
import org.eclipse.ui.internal.PluginActionSet;
import org.eclipse.ui.internal.PluginActionSetBuilder;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.registry.IActionSet;
import org.eclipse.ui.internal.registry.IActionSetDescriptor;

public class ActionPresentation {
    private WorkbenchWindow window;
    private HashMap mapDescToRec = new HashMap(3);

    public ActionPresentation(WorkbenchWindow window) {
        this.window = window;
    }

    public void clearActionSets() {
        List oldList = this.copyActionSets();
        Iterator iter = oldList.iterator();
        while (iter.hasNext()) {
            IActionSetDescriptor desc = (IActionSetDescriptor)iter.next();
            this.removeActionSet(desc);
        }
    }

    private List copyActionSets() {
        Set keys = this.mapDescToRec.keySet();
        ArrayList list = new ArrayList(keys.size());
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        return list;
    }

    public void removeActionSet(IActionSetDescriptor desc) {
        SetRec rec = (SetRec)this.mapDescToRec.get(desc);
        if (rec != null) {
            this.mapDescToRec.remove(desc);
            IActionSet set = rec.set;
            SubActionBars bars = rec.bars;
            bars.dispose();
            set.dispose();
        }
    }

    public void setActionSets(IActionSetDescriptor[] newArray) {
        List<IActionSetDescriptor> newList = Arrays.asList(newArray);
        List oldList = this.copyActionSets();
        Iterator<Object> iter = oldList.iterator();
        while (iter.hasNext()) {
            IActionSetDescriptor desc = (IActionSetDescriptor)iter.next();
            if (newList.contains(desc)) continue;
            this.removeActionSet(desc);
        }
        iter = newList.iterator();
        ArrayList<IActionSet> sets = new ArrayList<IActionSet>();
        while (iter.hasNext()) {
            IActionSetDescriptor desc = (IActionSetDescriptor)iter.next();
            if (this.mapDescToRec.containsKey(desc)) continue;
            try {
                IActionSet set = desc.createActionSet();
                ActionSetActionBars bars = new ActionSetActionBars(this.window.getActionBars(), desc.getId());
                SetRec rec = new SetRec(desc, set, bars);
                this.mapDescToRec.put(desc, rec);
                set.init(this.window, bars);
                sets.add(set);
            }
            catch (CoreException coreException) {
                WorkbenchPlugin.log("Unable to create ActionSet: " + desc.getId());
            }
        }
        PluginActionSetBuilder.processActionSets(sets, this.window);
        iter = ((AbstractList)sets).iterator();
        while (iter.hasNext()) {
            PluginActionSet set = (PluginActionSet)iter.next();
            set.getBars().activate();
        }
    }

    public IActionSet[] getActionSets() {
        Collection setRecCollection = this.mapDescToRec.values();
        IActionSet[] result = new IActionSet[setRecCollection.size()];
        int i = 0;
        Iterator iterator = setRecCollection.iterator();
        while (iterator.hasNext()) {
            result[i] = ((SetRec)iterator.next()).set;
            ++i;
        }
        return result;
    }

    private class SetRec {
        public IActionSetDescriptor desc;
        public IActionSet set;
        public SubActionBars bars;

        public SetRec(IActionSetDescriptor desc, IActionSet set, SubActionBars bars) {
            this.desc = desc;
            this.set = set;
            this.bars = bars;
        }
    }
}

