/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.FileSystemElement;
import org.eclipse.ui.dialogs.TypeFilteringDialog;
import org.eclipse.ui.dialogs.WizardDataTransferPage;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.DialogUtil;
import org.eclipse.ui.internal.dialogs.IElementFilter;
import org.eclipse.ui.internal.dialogs.ResourceTreeAndListGroup;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.model.WorkbenchViewerSorter;

public abstract class WizardResourceImportPage
extends WizardDataTransferPage {
    private IResource currentResourceSelection = null;
    private String initialContainerFieldValue;
    protected List selectedTypes = new ArrayList();
    private Text containerNameField;
    private Button containerBrowseButton;
    protected ResourceTreeAndListGroup selectionGroup;
    private static final String EMPTY_FOLDER_MESSAGE = WorkbenchMessages.getString("WizardImportPage.specifyFolder");
    private static final String INACCESSABLE_FOLDER_MESSAGE = WorkbenchMessages.getString("WizardImportPage.folderMustExist");
    static /* synthetic */ Class class$0;

    protected WizardResourceImportPage(String name, IStructuredSelection selection) {
        super(name);
        Object firstElement;
        if (selection.size() == 1 && (firstElement = selection.getFirstElement()) instanceof IAdaptable) {
            Object resource;
            IAdaptable iAdaptable = (IAdaptable)firstElement;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((resource = iAdaptable.getAdapter((Class)clazz)) != null) {
                this.currentResourceSelection = (IResource)resource;
            }
        }
        if (this.currentResourceSelection != null) {
            if (this.currentResourceSelection.getType() == 1) {
                this.currentResourceSelection = this.currentResourceSelection.getParent();
            }
            if (!this.currentResourceSelection.isAccessible()) {
                this.currentResourceSelection = null;
            }
        }
    }

    protected boolean allowNewContainerName() {
        return true;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        composite.setSize(composite.computeSize(-1, -1));
        composite.setFont(parent.getFont());
        this.createSourceGroup(composite);
        this.createDestinationGroup(composite);
        this.createOptionsGroup(composite);
        this.restoreWidgetValues();
        this.updateWidgetEnablements();
        this.setPageComplete(this.determinePageCompletion());
        this.setControl((Control)composite);
    }

    protected final void createDestinationGroup(Composite parent) {
        Composite containerGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        containerGroup.setLayout((Layout)layout);
        containerGroup.setLayoutData((Object)new GridData(768));
        containerGroup.setFont(parent.getFont());
        Label resourcesLabel = new Label(containerGroup, 0);
        resourcesLabel.setText(WorkbenchMessages.getString("WizardImportPage.folder"));
        resourcesLabel.setFont(parent.getFont());
        this.containerNameField = new Text(containerGroup, 2052);
        this.containerNameField.addListener(24, (Listener)this);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.containerNameField.setLayoutData((Object)data);
        this.containerNameField.setFont(parent.getFont());
        this.containerBrowseButton = new Button(containerGroup, 8);
        this.containerBrowseButton.setText(WorkbenchMessages.getString("WizardImportPage.browse2"));
        this.containerBrowseButton.setLayoutData((Object)new GridData(256));
        this.containerBrowseButton.addListener(13, (Listener)this);
        this.containerBrowseButton.setFont(parent.getFont());
        this.setButtonLayoutData(this.containerBrowseButton);
        this.initialPopulateContainerField();
    }

    protected void createFileSelectionGroup(Composite parent) {
        this.selectionGroup = new ResourceTreeAndListGroup(parent, new FileSystemElement("Dummy", null, true), this.getFolderProvider(), (ILabelProvider)new WorkbenchLabelProvider(), (IStructuredContentProvider)this.getFileProvider(), (ILabelProvider)new WorkbenchLabelProvider(), 0, DialogUtil.inRegularFontMode(parent));
        ICheckStateListener listener = new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                WizardResourceImportPage.this.updateWidgetEnablements();
            }
        };
        WorkbenchViewerSorter sorter = new WorkbenchViewerSorter();
        this.selectionGroup.setTreeSorter(sorter);
        this.selectionGroup.setListSorter(sorter);
        this.selectionGroup.addCheckStateListener(listener);
    }

    protected abstract void createSourceGroup(Composite var1);

    protected String getErrorDialogTitle() {
        return WorkbenchMessages.getString("WizardImportPage.errorDialogTitle");
    }

    protected IPath getContainerFullPath() {
        IWorkspace workspace = WorkbenchPlugin.getPluginWorkspace();
        IPath testPath = this.getResourcePath();
        if (testPath.equals((Object)workspace.getRoot().getFullPath())) {
            return testPath;
        }
        IStatus result = workspace.validatePath(testPath.toString(), 14);
        if (result.isOK()) {
            return testPath;
        }
        return null;
    }

    protected abstract ITreeContentProvider getFileProvider();

    protected abstract ITreeContentProvider getFolderProvider();

    protected IPath getResourcePath() {
        return this.getPathFromText(this.containerNameField);
    }

    protected List getSelectedResources() {
        return this.selectionGroup.getAllCheckedListItems();
    }

    protected void getSelectedResources(IElementFilter filter, IProgressMonitor monitor) throws InterruptedException {
        this.selectionGroup.getAllCheckedListItems(filter, monitor);
    }

    protected IContainer getSpecifiedContainer() {
        IWorkspace workspace = WorkbenchPlugin.getPluginWorkspace();
        IPath path = this.getContainerFullPath();
        if (workspace.getRoot().exists(path)) {
            return (IContainer)workspace.getRoot().findMember(path);
        }
        return null;
    }

    protected List getTypesToImport() {
        return this.selectedTypes;
    }

    protected void handleContainerBrowseButtonPressed() {
        IPath containerPath = this.queryForContainer(this.getSpecifiedContainer(), WorkbenchMessages.getString("WizardImportPage.selectFolderLabel"), WorkbenchMessages.getString("WizardImportPage.selectFolderTitle"));
        if (containerPath != null) {
            this.setErrorMessage(null);
            this.containerNameField.setText(containerPath.makeRelative().toString());
        }
    }

    public void handleEvent(Event event) {
        Widget source = event.widget;
        if (source == this.containerBrowseButton) {
            this.handleContainerBrowseButtonPressed();
        }
        this.updateWidgetEnablements();
    }

    protected void handleTypesEditButtonPressed() {
        TypeFilteringDialog dialog = new TypeFilteringDialog(this.getContainer().getShell(), this.getTypesToImport());
        dialog.open();
        Object[] newSelectedTypes = dialog.getResult();
        if (newSelectedTypes != null) {
            this.selectedTypes = new ArrayList(newSelectedTypes.length);
            int i = 0;
            while (i < newSelectedTypes.length) {
                this.selectedTypes.add(newSelectedTypes[i]);
                ++i;
            }
            this.setupSelectionsBasedOnSelectedTypes();
        }
    }

    protected final void initialPopulateContainerField() {
        if (this.initialContainerFieldValue != null) {
            this.containerNameField.setText(this.initialContainerFieldValue);
        } else if (this.currentResourceSelection != null) {
            this.containerNameField.setText(this.currentResourceSelection.getFullPath().makeRelative().toString());
        }
    }

    protected void setAllSelections(boolean value) {
        this.selectionGroup.setAllSelections(value);
    }

    public void setContainerFieldValue(String value) {
        if (this.containerNameField == null) {
            this.initialContainerFieldValue = value;
        } else {
            this.containerNameField.setText(value);
        }
    }

    protected void setupSelectionsBasedOnSelectedTypes() {
    }

    protected void updateSelections(final Map map) {
        Runnable runnable = new Runnable(){

            public void run() {
                WizardResourceImportPage.this.selectionGroup.updateSelections(map);
            }
        };
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)runnable);
    }

    protected void updateWidgetEnablements() {
        boolean pageComplete = this.determinePageCompletion();
        this.setPageComplete(pageComplete);
        if (pageComplete) {
            this.setMessage(null);
        }
        super.updateWidgetEnablements();
    }

    protected final boolean validateDestinationGroup() {
        IPath containerPath = this.getContainerFullPath();
        if (containerPath == null) {
            this.setMessage(EMPTY_FOLDER_MESSAGE);
            return false;
        }
        IContainer container = this.getSpecifiedContainer();
        if (container == null) {
            IWorkspace workspace = WorkbenchPlugin.getPluginWorkspace();
            IPath projectPath = containerPath.removeLastSegments(containerPath.segmentCount() - 1);
            if (workspace.getRoot().exists(projectPath)) {
                return true;
            }
            this.setErrorMessage(WorkbenchMessages.getString("WizardImportPage.projectNotExist"));
            return false;
        }
        if (!container.isAccessible()) {
            this.setErrorMessage(INACCESSABLE_FOLDER_MESSAGE);
            return false;
        }
        if (container.getLocation() == null) {
            if (container.isLinked()) {
                this.setErrorMessage(WorkbenchMessages.getString("WizardImportPage.undefinedPathVariable"));
            } else {
                this.setErrorMessage(WorkbenchMessages.getString("WizardImportPage.containerNotExist"));
            }
            return false;
        }
        if (this.sourceConflictsWithDestination(containerPath)) {
            this.setErrorMessage(this.getSourceConflictMessage());
            return false;
        }
        return true;
    }

    protected final String getSourceConflictMessage() {
        return WorkbenchMessages.getString("WizardImportPage.importOnReceiver");
    }

    protected boolean sourceConflictsWithDestination(IPath sourcePath) {
        return false;
    }

    protected boolean determinePageCompletion() {
        if (this.noOpenProjects()) {
            this.setErrorMessage(WorkbenchMessages.getString("WizardImportPage.noOpenProjects"));
            return false;
        }
        return super.determinePageCompletion();
    }

    private boolean noOpenProjects() {
        IProject[] projects = WorkbenchPlugin.getPluginWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            if (projects[i].isOpen()) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

