/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class WizardNewProjectCreationPage
extends WizardPage {
    private boolean useDefaults = true;
    private String initialProjectFieldValue;
    private String initialLocationFieldValue;
    private String customLocationFieldValue;
    private Text projectNameField;
    private Text locationPathField;
    private Label locationLabel;
    private Button browseButton;
    private Listener nameModifyListener = new Listener(){

        public void handleEvent(Event e) {
            WizardNewProjectCreationPage.this.setLocationForSelection();
            WizardNewProjectCreationPage.this.setPageComplete(WizardNewProjectCreationPage.this.validatePage());
        }
    };
    private Listener locationModifyListener = new Listener(){

        public void handleEvent(Event e) {
            WizardNewProjectCreationPage.this.setPageComplete(WizardNewProjectCreationPage.this.validatePage());
        }
    };
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;

    public WizardNewProjectCreationPage(String pageName) {
        super(pageName);
        this.setPageComplete(false);
        this.customLocationFieldValue = "";
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        this.initializeDialogUnits((Control)parent);
        WorkbenchHelp.setHelp((Control)composite, "org.eclipse.ui.new_project_wizard_page_context");
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.createProjectNameGroup(composite);
        this.createProjectLocationGroup(composite);
        this.setPageComplete(this.validatePage());
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
    }

    private final void createProjectLocationGroup(Composite parent) {
        Font font = parent.getFont();
        Group projectGroup = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        projectGroup.setFont(font);
        projectGroup.setText(WorkbenchMessages.getString("WizardNewProjectCreationPage.projectContentsGroupLabel"));
        final Button useDefaultsButton = new Button((Composite)projectGroup, 131104);
        useDefaultsButton.setText(WorkbenchMessages.getString("WizardNewProjectCreationPage.useDefaultLabel"));
        useDefaultsButton.setSelection(this.useDefaults);
        useDefaultsButton.setFont(font);
        GridData buttonData = new GridData();
        buttonData.horizontalSpan = 3;
        useDefaultsButton.setLayoutData((Object)buttonData);
        this.createUserSpecifiedProjectLocationGroup((Composite)projectGroup, !this.useDefaults);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardNewProjectCreationPage.this.useDefaults = useDefaultsButton.getSelection();
                WizardNewProjectCreationPage.this.browseButton.setEnabled(!WizardNewProjectCreationPage.this.useDefaults);
                WizardNewProjectCreationPage.this.locationPathField.setEnabled(!WizardNewProjectCreationPage.this.useDefaults);
                WizardNewProjectCreationPage.this.locationLabel.setEnabled(!WizardNewProjectCreationPage.this.useDefaults);
                if (WizardNewProjectCreationPage.this.useDefaults) {
                    WizardNewProjectCreationPage.this.customLocationFieldValue = WizardNewProjectCreationPage.this.locationPathField.getText();
                    WizardNewProjectCreationPage.this.setLocationForSelection();
                } else {
                    WizardNewProjectCreationPage.this.locationPathField.setText(WizardNewProjectCreationPage.this.customLocationFieldValue);
                }
            }
        };
        useDefaultsButton.addSelectionListener((SelectionListener)listener);
    }

    private final void createProjectNameGroup(Composite parent) {
        Composite projectGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        Label projectLabel = new Label(projectGroup, 0);
        projectLabel.setText(WorkbenchMessages.getString("WizardNewProjectCreationPage.nameLabel"));
        projectLabel.setFont(parent.getFont());
        this.projectNameField = new Text(projectGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.projectNameField.setLayoutData((Object)data);
        this.projectNameField.setFont(parent.getFont());
        if (this.initialProjectFieldValue != null) {
            this.projectNameField.setText(this.initialProjectFieldValue);
        }
        this.projectNameField.addListener(24, this.nameModifyListener);
    }

    private void createUserSpecifiedProjectLocationGroup(Composite projectGroup, boolean enabled) {
        Font font = projectGroup.getFont();
        this.locationLabel = new Label(projectGroup, 0);
        this.locationLabel.setText(WorkbenchMessages.getString("WizardNewProjectCreationPage.locationLabel"));
        this.locationLabel.setEnabled(enabled);
        this.locationLabel.setFont(font);
        this.locationPathField = new Text(projectGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.locationPathField.setLayoutData((Object)data);
        this.locationPathField.setEnabled(enabled);
        this.locationPathField.setFont(font);
        this.browseButton = new Button(projectGroup, 8);
        this.browseButton.setText(WorkbenchMessages.getString("WizardNewProjectCreationPage.browseLabel"));
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                WizardNewProjectCreationPage.this.handleLocationBrowseButtonPressed();
            }
        });
        this.browseButton.setEnabled(enabled);
        this.browseButton.setFont(font);
        this.setButtonLayoutData(this.browseButton);
        if (this.initialLocationFieldValue == null) {
            this.locationPathField.setText(Platform.getLocation().toOSString());
        } else {
            this.locationPathField.setText(this.initialLocationFieldValue);
        }
        this.locationPathField.addListener(24, this.locationModifyListener);
    }

    public IPath getLocationPath() {
        if (this.useDefaults) {
            return Platform.getLocation();
        }
        return new Path(this.getProjectLocationFieldValue());
    }

    public IProject getProjectHandle() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName());
    }

    public String getProjectName() {
        if (this.projectNameField == null) {
            return this.initialProjectFieldValue;
        }
        return this.getProjectNameFieldValue();
    }

    private String getProjectNameFieldValue() {
        if (this.projectNameField == null) {
            return "";
        }
        return this.projectNameField.getText().trim();
    }

    private String getProjectLocationFieldValue() {
        if (this.locationPathField == null) {
            return "";
        }
        return this.locationPathField.getText().trim();
    }

    private void handleLocationBrowseButtonPressed() {
        String selectedDirectory;
        File path;
        DirectoryDialog dialog = new DirectoryDialog(this.locationPathField.getShell());
        dialog.setMessage(WorkbenchMessages.getString("WizardNewProjectCreationPage.directoryLabel"));
        String dirName = this.getProjectLocationFieldValue();
        if (!dirName.equals("") && (path = new File(dirName)).exists()) {
            dialog.setFilterPath(new Path(dirName).toOSString());
        }
        if ((selectedDirectory = dialog.open()) != null) {
            this.customLocationFieldValue = selectedDirectory;
            this.locationPathField.setText(this.customLocationFieldValue);
        }
    }

    public void setInitialProjectName(String name) {
        if (name == null) {
            this.initialProjectFieldValue = null;
        } else {
            this.initialProjectFieldValue = name.trim();
            this.initialLocationFieldValue = this.getDefaultLocationForName(this.initialProjectFieldValue);
        }
    }

    private void setLocationForSelection() {
        if (this.useDefaults) {
            this.locationPathField.setText(this.getDefaultLocationForName(this.getProjectNameFieldValue()));
        }
    }

    private String getDefaultLocationForName(String nameValue) {
        IPath defaultPath = Platform.getLocation().append(nameValue);
        return defaultPath.toOSString();
    }

    protected boolean validatePage() {
        IStatus locationStatus;
        IWorkspace workspace = WorkbenchPlugin.getPluginWorkspace();
        String projectFieldContents = this.getProjectNameFieldValue();
        if (projectFieldContents.equals("")) {
            this.setErrorMessage(null);
            this.setMessage(WorkbenchMessages.getString("WizardNewProjectCreationPage.projectNameEmpty"));
            return false;
        }
        IStatus nameStatus = workspace.validateName(projectFieldContents, 4);
        if (!nameStatus.isOK()) {
            this.setErrorMessage(nameStatus.getMessage());
            return false;
        }
        String locationFieldContents = this.getProjectLocationFieldValue();
        if (locationFieldContents.equals("")) {
            this.setErrorMessage(null);
            this.setMessage(WorkbenchMessages.getString("WizardNewProjectCreationPage.projectLocationEmpty"));
            return false;
        }
        Path path = new Path("");
        if (!path.isValidPath(locationFieldContents)) {
            this.setErrorMessage(WorkbenchMessages.getString("WizardNewProjectCreationPage.locationError"));
            return false;
        }
        Path projectPath = new Path(locationFieldContents);
        if (!this.useDefaults && Platform.getLocation().isPrefixOf((IPath)projectPath)) {
            this.setErrorMessage(WorkbenchMessages.getString("WizardNewProjectCreationPage.defaultLocationError"));
            return false;
        }
        IProject handle = this.getProjectHandle();
        if (handle.exists()) {
            this.setErrorMessage(WorkbenchMessages.getString("WizardNewProjectCreationPage.projectExistsMessage"));
            return false;
        }
        if (!this.useDefaults() && !(locationStatus = workspace.validateProjectLocation(handle, (IPath)projectPath)).isOK()) {
            this.setErrorMessage(locationStatus.getMessage());
            return false;
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.projectNameField.setFocus();
        }
    }

    public boolean useDefaults() {
        return this.useDefaults;
    }
}

